/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.checknfeemailcte;

import com.touchcomp.basementor.constants.enums.namespaces.ConstEnumNamespace;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorxml.model.XMLNFeCTe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFeCTe;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class UtilCTeXMLNFeReceive {
    private static final TLogger logger = TLogger.get(UtilCTeXMLNFeReceive.class);
    private final String FOLDER_EMAIL_READ = "EmailsLidosMentor";
    private final ServiceXMLNFeCTe serviceXMLNFeCTe = (ServiceXMLNFeCTe)ConfApplicationContext.getBean(ServiceXMLNFeCTe.class);
    private final TaskProcessResult result;

    public UtilCTeXMLNFeReceive(TaskProcessResult result) {
        this.result = result;
    }

    public Object readXMLNFeCTeFromEmail(String senhaEmail, String email, String lerQtsMsgSt, String servidorEntrada, String pastaEntrada) throws ExceptionJDom, ExceptionIO, ExceptionEmail {
        try {
            Properties props = new Properties();
            props.put("mail.imaps.ssl.trust", "*");
            Session session = Session.getDefaultInstance((Properties)props);
            session.setDebug(false);
            Integer lerQtsMsg = 0;
            if (lerQtsMsgSt != null && lerQtsMsgSt.trim().length() > 0) {
                lerQtsMsg = Integer.valueOf(lerQtsMsgSt);
            }
            Store store = session.getStore("imaps");
            store.connect(servidorEntrada, email, senhaEmail);
            store.getPersonalNamespaces();
            Folder folder = store.getFolder(pastaEntrada);
            Folder folderToCopy = store.getFolder("EmailsLidosMentor");
            if (folderToCopy == null || !folderToCopy.exists()) {
                folderToCopy.create(1);
            }
            folder.open(2);
            Message[] messages = this.getMessages(folder, lerQtsMsg);
            this.readProcessMessages(messages);
            this.cutMessages(folder, folderToCopy, messages);
            folder.close(true);
            store.close();
            return Boolean.TRUE;
        }
        catch (NoSuchProviderException ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionEmail((Exception)((Object)ex), new Object[]{ex.getMessage()});
        }
        catch (MessagingException ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionEmail((Exception)((Object)ex), new Object[]{ex.getMessage()});
        }
    }

    private void verificarMultipart(Object msgObj) throws MessagingException, IOException, ExceptionJDom {
        if (!(msgObj instanceof Multipart)) {
            return;
        }
        Multipart multipart = (Multipart)msgObj;
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart part = multipart.getBodyPart(i);
            String contentType = part.getContentType();
            logger.info("Content: " + contentType);
            System.out.println("Content: " + contentType);
            if (contentType.startsWith("text/plain")) {
                logger.info("Content: " + contentType);
                System.out.println("Content: " + contentType);
                continue;
            }
            this.validarXML((Part)part);
        }
    }

    private void validarXML(Part part) throws IOException, MessagingException, ExceptionJDom {
        String fileName = ToolString.clearSpecialCharacXML((String)part.getFileName());
        if (fileName == null) {
            return;
        }
        if (!fileName.toLowerCase().endsWith("xml")) {
            return;
        }
        InputStream obj = part.getInputStream();
        if (!(obj instanceof InputStream)) {
            return;
        }
        InputStream is = obj;
        this.processSaveFile(is);
        logger.info("Lendo xml: " + fileName);
    }

    private Message[] getMessages(Folder folder, Integer lerQtsMsg) throws MessagingException {
        Message[] messages = null;
        if (lerQtsMsg != null && lerQtsMsg > 0) {
            if (folder.getMessageCount() < lerQtsMsg) {
                lerQtsMsg = folder.getMessageCount() - 1;
            }
            messages = folder.getMessages(folder.getMessageCount() - lerQtsMsg, folder.getMessageCount());
        } else {
            messages = folder.getMessages();
        }
        return messages;
    }

    private void cutMessages(Folder folder, Folder dfolder, Message[] msgs) throws MessagingException {
        if (msgs.length != 0) {
            folder.copyMessages(msgs, dfolder);
            folder.setFlags(msgs, new Flags(Flags.Flag.DELETED), true);
            for (int i = 0; i < msgs.length; ++i) {
                if (msgs[i].isSet(Flags.Flag.DELETED)) continue;
                System.out.println("Message # " + String.valueOf(msgs[i]) + " not deleted");
            }
        }
    }

    private void readProcessMessages(Message[] messages) throws MessagingException {
        for (int i = 0; i < messages.length; ++i) {
            Message message = messages[i];
            try {
                if (!message.getContentType().equals("APPLICATION/XML")) {
                    Object msgObj = message.getContent();
                    this.verificarMultipart(msgObj);
                    continue;
                }
                InputStream inputStream = message.getDataHandler().getDataSource().getInputStream();
                logger.info(message.getContentType());
                this.processSaveFile(inputStream);
                continue;
            }
            catch (ExceptionJDom | IOException | MessagingException e) {
                this.result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "Erro ao ler a mensagem " + message.getSubject() + ": " + e.getMessage());
            }
        }
    }

    private boolean processSaveFile(InputStream f) throws ExceptionJDom, IOException {
        Date base = new Date();
        Namespace nNFe = Namespace.getNamespace((String)ConstEnumNamespace.NAMESPACE_NFE.namespace);
        Namespace nCTe = Namespace.getNamespace((String)ConstEnumNamespace.NAMESPACE_CTE.namespace);
        String conteudoXML = ToolString.clearSpecialCharacXML((String)this.getXMLFromFile(f));
        Element root = ToolJdom.getRootElement((String)conteudoXML);
        String chave = null;
        String cnpjTranspAgregado = null;
        if (root.getName().equalsIgnoreCase("nfeProc")) {
            Element infNfe;
            Element nNfe = root.getChild("NFe", nNFe);
            if (nNfe == null) {
                nNfe = root.getChild("NFe");
            }
            if ((infNfe = nNfe.getChild("infNFe", nNFe)) == null) {
                infNfe = nNfe.getChild("infNFe");
            }
            chave = infNfe.getAttributeValue("Id").substring(3);
        } else if (root.getName().equalsIgnoreCase("cteProc")) {
            Element infCte;
            Element nCte = root.getChild("CTe", nCTe);
            if (nCte == null) {
                nCte = root.getChild("CTe");
            }
            if ((infCte = nCte.getChild("infCte", nCTe)) == null) {
                infCte = nCte.getChild("infCte");
            }
            chave = infCte.getAttributeValue("Id").substring(3);
            if (infCte.getChild("compl", nCTe) != null && infCte.getChild("compl", nCTe).getChild("xCaracAd", nCTe) != null) {
                String xCaracAd;
                cnpjTranspAgregado = xCaracAd = infCte.getChild("compl", nCTe).getChild("xCaracAd", nCTe).getText();
            }
        } else {
            return false;
        }
        XMLNFeCTe x = this.serviceXMLNFeCTe.getXMlNfeCTeChaveNFe(chave);
        if (x == null) {
            x = new XMLNFeCTe();
            x.setChaveNFe(chave);
            x.setConteudoXML(conteudoXML);
            x.setDataChegada(base);
            x.setCnpjTranspAgregado(cnpjTranspAgregado);
            x.setDataAtualizacao(new Timestamp(base.getTime()));
            x.setFlag(Integer.valueOf(0));
            this.serviceXMLNFeCTe.saveOrUpdate((Object)x);
            return true;
        }
        return false;
    }

    private String getXMLFromFile(InputStream f) throws IOException {
        StringBuilder linhatotal = new StringBuilder();
        BufferedReader b = new BufferedReader(new InputStreamReader(f));
        String linha = "";
        do {
            if (b != null) {
                linha = b.readLine();
            }
            if (linha == null) continue;
            linhatotal.append(linha.trim());
        } while (linha != null);
        b.close();
        return linhatotal.toString();
    }
}

