/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.ctf;

import com.touchcomp.basementor.constants.enums.opcoesmanutencaoativos.EnumConstTipoMovimentoConsumo;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.ItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.OpcoesCtf;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtfPessoa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.Veiculo;
import com.touchcomp.basementorclientwebservices.components.DocCtf;
import com.touchcomp.basementorexceptions.exceptions.impl.ctf.EnumCTF;
import com.touchcomp.basementorexceptions.exceptions.impl.ctf.ExceptionCTF;
import com.touchcomp.basementorexceptions.exceptions.impl.database.ExceptionDatabase;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorservice.helpers.impl.fornecedor.HelperFornecedor;
import com.touchcomp.basementorservice.helpers.impl.requisicao.HelperRequisicao;
import com.touchcomp.basementorservice.service.impl.consumoativo.ServiceConsumoAtivoImpl;
import com.touchcomp.basementorservice.service.impl.fornecedor.ServiceFornecedorImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceConsumoAtivo;
import com.touchcomp.basementorservice.service.interfaces.ServiceGradeCor;
import com.touchcomp.basementorservice.service.interfaces.ServiceLoteFabricacao;
import com.touchcomp.basementorservice.service.interfaces.ServiceOpcoesCtf;
import com.touchcomp.basementorservice.service.interfaces.ServiceOpcoesManutencEquip;
import com.touchcomp.basementorservice.service.interfaces.ServiceParametrizacaoCtfPessoa;
import com.touchcomp.basementorservice.service.interfaces.ServicePessoa;
import com.touchcomp.basementorservice.service.interfaces.ServiceProduto;
import com.touchcomp.basementorservice.service.interfaces.ServiceUnidadeFatFornecedor;
import com.touchcomp.basementorservice.service.interfaces.ServiceVeiculo;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Element;

public class AuxGeraConsumoAtivoCtf {
    private final ServiceFornecedorImpl serviceFornecedor = (ServiceFornecedorImpl)ConfApplicationContext.getBean(ServiceFornecedorImpl.class);
    private final ServicePessoa servicePessoa = (ServicePessoa)ConfApplicationContext.getBean(ServicePessoa.class);
    private final ServiceOpcoesCtf serviceOpcoesCtf = (ServiceOpcoesCtf)ConfApplicationContext.getBean(ServiceOpcoesCtf.class);
    private final ServiceConsumoAtivo serviceConsumoAtivo = (ServiceConsumoAtivo)ConfApplicationContext.getBean(ServiceConsumoAtivo.class);
    private final ServiceVeiculo serviceVeiculo = (ServiceVeiculo)ConfApplicationContext.getBean(ServiceVeiculo.class);
    private final ServiceUnidadeFatFornecedor serviceUnidadeFatFornecedor = (ServiceUnidadeFatFornecedor)ConfApplicationContext.getBean(ServiceUnidadeFatFornecedor.class);
    private final ServiceProduto serviceProduto = (ServiceProduto)ConfApplicationContext.getBean(ServiceProduto.class);
    private final ServiceGradeCor serviceGradeCor = (ServiceGradeCor)ConfApplicationContext.getBean(ServiceGradeCor.class);
    private final ServiceOpcoesManutencEquip serviceOpcoesManutencEquip = (ServiceOpcoesManutencEquip)ConfApplicationContext.getBean(ServiceOpcoesManutencEquip.class);
    private final ServiceParametrizacaoCtfPessoa serviceParametrizacaoCtfPessoa = (ServiceParametrizacaoCtfPessoa)ConfApplicationContext.getBean(ServiceParametrizacaoCtfPessoa.class);
    private final ServiceLoteFabricacao serviceLoteFabricacao = (ServiceLoteFabricacao)ConfApplicationContext.getBean(ServiceLoteFabricacao.class);
    private final DocCtf docCtfWebService = (DocCtf)ConfApplicationContext.getBean(DocCtf.class);
    private HelperRequisicao helperRequisicao = (HelperRequisicao)ConfApplicationContext.getBean(HelperRequisicao.class);

    synchronized void gerarFornecedorConsumoAtivoCtf() throws ExceptionJDom, ExceptionIO, ExceptionCTF, ExceptionParamCtbRequisicao, ExceptionWebService {
        List opcoesCtf = this.serviceOpcoesCtf.getOpcoesCtfSincronizacao();
        for (OpcoesCtf opcoes : opcoesCtf) {
            this.comunicacaoFornecedorConsumoAtivo(opcoes);
        }
    }

    private void comunicacaoFornecedorConsumoAtivo(OpcoesCtf opcoesCtf) throws ExceptionJDom, ExceptionIO, ExceptionCTF, ExceptionParamCtbRequisicao, ExceptionWebService {
        this.criarGerarPosto(opcoesCtf, this.docCtfWebService.conexaoWebServiceCtf(opcoesCtf.getLogin(), opcoesCtf.getSenha(), opcoesCtf.getCodigoCopiaPosto(), opcoesCtf.getPonteiroPosto(), opcoesCtf.getQuantRegistroPosto()));
        this.conexaoWebServiceCtfAbastecimento(opcoesCtf);
    }

    private void conexaoWebServiceCtfAbastecimento(OpcoesCtf opcoesCtf) throws ExceptionJDom, ExceptionIO, ExceptionCTF, ExceptionParamCtbRequisicao, ExceptionWebService {
        Boolean b = true;
        while (b.booleanValue()) {
            Long ultimoPonteiro = this.serviceOpcoesCtf.getUltimoPonteiro(opcoesCtf);
            String xml = this.docCtfWebService.conexaoWebServiceCtf(opcoesCtf.getLogin(), opcoesCtf.getSenha(), opcoesCtf.getCodigoCopiaAbastecimento(), ultimoPonteiro, opcoesCtf.getQuantRegistroAbastecimento());
            b = this.criarGerarAbastecimento(opcoesCtf, xml, ultimoPonteiro);
        }
    }

    private void criarGerarPosto(OpcoesCtf opcoesCtf, String xmlPosto) throws ExceptionJDom, ExceptionIO {
        List posto = ToolJdom.getRootElement((String)xmlPosto).getChildren();
        for (Element e : posto) {
            this.buscarDadosXmlPosto(e, opcoesCtf);
        }
    }

    private void buscarDadosXmlPosto(Element e, OpcoesCtf opcoesCtf) throws ExceptionDatabase {
        String razao = e.getChildText("RAZAO");
        String fantasia = e.getChildText("FANTASIA");
        String contato = e.getChildText("CONTATO");
        String cep = e.getChildText("CEP");
        String endereco = e.getChildText("ENDERECO");
        String bairro = e.getChildText("BAIRRO");
        String fax = e.getChildText("FAX");
        String cgc = e.getChildText("CGC");
        String inscrEst = e.getChildText("IE");
        String email = e.getChildText("EMAIL");
        this.pesquisarPessoaFornedor(opcoesCtf, razao, fantasia, contato, cep, endereco, bairro, fax, cgc, inscrEst, email);
    }

    private void pesquisarPessoaFornedor(OpcoesCtf opcoesCtf, String razao, String fantasia, String contato, String cep, String endereco, String bairro, String fax, String cgc, String inscrEst, String email) throws ExceptionDatabase {
        List fornecedor = this.serviceFornecedor.getByCNPJCPF(cgc);
        if (fornecedor == null || fornecedor.isEmpty()) {
            Pessoa p = this.servicePessoa.getByCPFCNPJAtiva(cgc);
            if (p == null) {
                p = this.criarPessoa(razao, fantasia, contato, cep, endereco, bairro, fax, cgc, inscrEst, email);
            }
            this.criarFornecer(p, opcoesCtf);
        }
    }

    private Pessoa criarPessoa(String razao, String fantasia, String contato, String cep, String endereco, String bairro, String fax, String cgc, String inscrEst, String email) throws ExceptionDatabase {
        Pessoa p = new Pessoa();
        p.setAtivo(Short.valueOf((short)0));
        p.setDataCadastro(new Date());
        p.setDataInicioRelacionamento(new Date());
        p.setNome(razao);
        p.setNomeFantasia(fantasia);
        p.setPessoaContato(contato);
        p.setEndereco(this.criarEndereco(cep, endereco, bairro));
        p.setComplemento(this.criarComplemento(fax, cgc, inscrEst, email, razao, p.getAtivo()));
        return (Pessoa)this.servicePessoa.saveOrUpdate((InterfaceVO)p);
    }

    private Endereco criarEndereco(String cep, String endereco, String bairro) {
        Endereco e = new Endereco();
        e.setCep(cep);
        e.setLogradouro(endereco);
        e.setNumero("SN");
        e.setBairro(bairro);
        return e;
    }

    private Complemento criarComplemento(String fax, String cgc, String inscrEst, String email, String razao, Short ativo) {
        Complemento c = new Complemento();
        c.setAtivo(ativo);
        c.setFone1(this.refina(fax));
        c.setCnpj(this.refina(cgc));
        c.setInscEst(this.refina(inscrEst));
        c.setTipoPessoa(this.getPessoaFisicaJuridica(c.getCnpj()));
        if (email != null && email.length() > 0) {
            c.setEmails(this.criarEmails(c, email, razao));
        }
        return c;
    }

    private List<EmailPessoa> criarEmails(Complemento c, String email, String razao) {
        ArrayList<EmailPessoa> emailpessoa = new ArrayList<EmailPessoa>();
        EmailPessoa e = new EmailPessoa();
        e.setAtivo(Short.valueOf((short)1));
        e.setComplemento(c);
        e.setDescricao(razao);
        e.setEmail(email);
        emailpessoa.add(e);
        return emailpessoa;
    }

    private void criarFornecer(Pessoa p, OpcoesCtf opcoesCtf) throws ExceptionDatabase {
        Fornecedor f = new Fornecedor();
        f.setDataCadastro(new Date());
        f.setEmpresa(opcoesCtf.getEmpresa());
        f.setPessoa(p);
        f.setTipoEpp(Short.valueOf((short)0));
        f.setTipo(Short.valueOf((short)0));
        f.setCategoriaPessoa(opcoesCtf.getCategoriaPessoaFornec());
        f.setUnidadesFatForn(this.criarUnidadeFatFornecedor(f));
        this.serviceFornecedor.saveOrUpdate((InterfaceVO)f);
    }

    private List<UnidadeFatFornecedor> criarUnidadeFatFornecedor(Fornecedor f) {
        ArrayList<UnidadeFatFornecedor> unidadeFatFornecedor = new ArrayList<UnidadeFatFornecedor>();
        HelperFornecedor comp = (HelperFornecedor)ConfApplicationContext.getBean(HelperFornecedor.class);
        UnidadeFatFornecedor u = comp.criarUnidadeFatPadrao(f);
        u.setFornecedor(f);
        unidadeFatFornecedor.add(u);
        return unidadeFatFornecedor;
    }

    private boolean criarGerarAbastecimento(OpcoesCtf opcoesCtf, String xmlAbastecimento, Long ultimoPonteiro) throws ExceptionJDom, ExceptionIO, ExceptionCTF, ExceptionParamCtbRequisicao {
        Element e = ToolJdom.getRootElement((String)xmlAbastecimento);
        List abastecimento = e.getChildren();
        if (abastecimento != null && !abastecimento.isEmpty()) {
            ultimoPonteiro = Long.valueOf(e.getAttributeValue("ULTIMO_PONTEIRO"));
            this.criarConsumo(abastecimento, opcoesCtf);
            opcoesCtf.setPonteiroAbastecimento(ultimoPonteiro);
            this.serviceOpcoesCtf.saveOrUpdate((InterfaceVO)opcoesCtf);
            return true;
        }
        return false;
    }

    private void criarConsumo(List<Element> elements, OpcoesCtf opcoesCtf) throws ExceptionCTF, ExceptionParamCtbRequisicao {
        for (Element element : elements) {
            this.buscarDadosXmlAbastecimento(element, opcoesCtf);
        }
    }

    private void buscarDadosXmlAbastecimento(Element e, OpcoesCtf opcoesCtf) throws ExceptionCTF, ExceptionParamCtbRequisicao {
        String cgc = e.getChildText("CGC");
        String dataAbastecimento = e.getChildText("DATA_ABASTECIMENTO");
        String indice = e.getChildText("INDICE");
        String numeroAbastecimento = e.getChildText("NUMABAST");
        String placa = e.getChildText("PLACA");
        String quilometragem = e.getChildText("KM");
        String tipoCombustivel = e.getChildText("C");
        String quantidadeLitros = e.getChildText("QTD");
        String precoDesconto = e.getChildText("PUBRAD");
        String precoTotal = e.getChildText("TOTAL");
        this.criarConsumoAtivo(opcoesCtf, cgc, dataAbastecimento, indice, numeroAbastecimento, placa, quilometragem, tipoCombustivel, quantidadeLitros, precoDesconto, precoTotal);
    }

    private void criarConsumoAtivo(OpcoesCtf opcoesCtf, String cgc, String dataAbastecimento, String indice, String numeroAbastecimento, String placa, String quilometragem, String tipoCombustivel, String quantidadeLitros, String precoDesconto, String precoTotal) throws ExceptionCTF, ExceptionParamCtbRequisicao {
        ConsumoAtivo c = new ConsumoAtivo();
        c.setDataCadastro(new Date());
        c.setEmpresa(opcoesCtf.getEmpresa());
        c.setDataMovimentacao(this.formatarData(dataAbastecimento));
        c.setDataConsumo(this.formatarData(dataAbastecimento));
        c.setObservacao("Consumo gerado a partir dos XML do CTF - Abastecimento Inteligente!");
        c.setNrDocOrigem(Long.valueOf(Long.parseLong(indice)));
        c.setHodometro(Double.valueOf(Double.parseDouble(quilometragem)));
        c.setHodometroAnterior(((ServiceConsumoAtivoImpl)Context.get(ServiceConsumoAtivoImpl.class)).getHodometroAnterior(placa, c.getDataConsumo(), c.getIdentificador()));
        c.setCodigoCTF(numeroAbastecimento);
        c.setEquipamento(this.pesquisarEquipamento(placa));
        c.setItemConsumoAtivo(this.criarItemConsumoAtivo(c, opcoesCtf, cgc, tipoCombustivel, precoDesconto, precoTotal, quantidadeLitros));
        c.setRequisicao(this.criarRequisicao(c));
        if (opcoesCtf.getCriarColeta().equals((short)1) && opcoesCtf.getTipoPontoControleColeta() != null && c.getHodometro() > 0.0) {
            c.setGerarColeta(Short.valueOf((short)1));
            c.setTipoPontoControleColeta(opcoesCtf.getTipoPontoControleColeta());
            c.setDataHoraColeta(ToolDate.toTimestamp((Date)c.getDataMovimentacao()));
            c.setValorColeta(Integer.valueOf(c.getHodometro().intValue()));
            c.setColeta(this.criarColeta(c));
        }
        this.serviceConsumoAtivo.saveOrUpdate((InterfaceVO)c);
    }

    private Date formatarData(String dataAbastecimento) throws ExceptionCTF {
        try {
            SimpleDateFormat s = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            return s.parse(dataAbastecimento);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new ExceptionCTF(EnumCTF.ERRO_COVERTER_DATA, new Object[]{dataAbastecimento});
        }
    }

    private Equipamento pesquisarEquipamento(String placa) throws ExceptionCTF {
        Veiculo found = this.serviceVeiculo.getByPlaca(placa);
        if (found == null) {
            throw new ExceptionCTF(EnumCTF.VEICULO_PLACA_NAO_CADASTRADO, new Object[]{placa});
        }
        return found.getEquipamento();
    }

    private List<ItemConsumoAtivo> criarItemConsumoAtivo(ConsumoAtivo consumoAtivo, OpcoesCtf opcoesCtf, String cgc, String tipoCombustivel, String precoDesconto, String precoTotal, String quantidadeLitros) throws ExceptionCTF {
        UnidadeFatFornecedor u = this.pesquisarUnidadeFatFornecedor(cgc);
        ArrayList<ItemConsumoAtivo> itemConsumoAtivo = new ArrayList<ItemConsumoAtivo>();
        ItemConsumoAtivo i = new ItemConsumoAtivo();
        i.setConsumoAtivo(consumoAtivo);
        i.setMovInterno(this.verificarMovimento(opcoesCtf, u));
        i.setUnidadeFatFornecedor(this.verificarUnidadeFatFornecedor(i, u));
        i.setCentroCusto(this.verificarCentroCusto(consumoAtivo.getEquipamento()));
        i.setProduto(this.pesquisarProduto(tipoCombustivel));
        i.setNaturezaRequisicao(this.pesquisarNaturezaRequisicao(u));
        i.setCentroEstoque(this.pesquisarCentroEstoque(opcoesCtf.getEmpresa()));
        i.setValorUnitario(this.converterStringDouble(precoDesconto));
        i.setValorDesconto(Double.valueOf(0.0));
        i.setValorTotal(this.converterStringDouble(precoTotal));
        i.setQuantidadeTotal(this.converterStringDouble(quantidadeLitros));
        i.setGradeItemConsumoAtivo(this.criarGradeItemConsumo(i, consumoAtivo.getEmpresa(), quantidadeLitros));
        itemConsumoAtivo.add(i);
        return itemConsumoAtivo;
    }

    private UnidadeFatFornecedor pesquisarUnidadeFatFornecedor(String cgc) {
        UnidadeFatFornecedor unid = this.serviceUnidadeFatFornecedor.getFirstByCnpjCPF(cgc);
        return unid;
    }

    private Short verificarMovimento(OpcoesCtf opcoesCtf, UnidadeFatFornecedor unidadeFatFornecedor) {
        if (this.refina(opcoesCtf.getEmpresa().getPessoa().getComplemento().getCnpj()).equals(this.refina(unidadeFatFornecedor.getFornecedor().getPessoa().getComplemento().getCnpj()))) {
            return EnumConstTipoMovimentoConsumo.CONSUMO_INTERNO.getValue();
        }
        return EnumConstTipoMovimentoConsumo.CONSUMO_EXTERNO.getValue();
    }

    private UnidadeFatFornecedor verificarUnidadeFatFornecedor(ItemConsumoAtivo itemConsumoAtivo, UnidadeFatFornecedor unidadeFatFornecedor) {
        if (ToolMethods.isEquals((Object)itemConsumoAtivo.getMovInterno(), (Object)EnumConstTipoMovimentoConsumo.CONSUMO_EXTERNO.getValue())) {
            return unidadeFatFornecedor;
        }
        return null;
    }

    private CentroCusto verificarCentroCusto(Equipamento equipamento) throws ExceptionCTF {
        if (equipamento.getCentroCusto() == null) {
            throw new ExceptionCTF(EnumCTF.EQUIPAMENTO_SEM_CENTRO_CUSTO, new Object[]{equipamento});
        }
        return equipamento.getCentroCusto();
    }

    private Produto pesquisarProduto(String tipoCombustivel) throws ExceptionCTF {
        Produto produto = this.serviceProduto.getByCodigoAuxiliar(tipoCombustivel);
        if (produto == null) {
            throw new ExceptionCTF(EnumCTF.NENHUM_PROD_COMBUSTIVEL_ENC_COD_AUX, new Object[]{tipoCombustivel});
        }
        return produto;
    }

    private NaturezaRequisicao pesquisarNaturezaRequisicao(UnidadeFatFornecedor unidadeFatFornecedor) throws ExceptionCTF {
        ParametrizacaoCtfPessoa para = this.serviceParametrizacaoCtfPessoa.get(unidadeFatFornecedor.getFornecedor().getPessoa());
        if (para == null || para.getNaturezaRequisicao() == null) {
            throw new ExceptionCTF(EnumCTF.NAT_REQ_NAO_ENCONTRADA_FOR, new Object[]{unidadeFatFornecedor});
        }
        return para.getNaturezaRequisicao();
    }

    private CentroEstoque pesquisarCentroEstoque(Empresa empresa) throws ExceptionCTF {
        OpcoesManutencEquip op = this.serviceOpcoesManutencEquip.get(empresa);
        if (op == null || op.getCentroEstoque() == null) {
            throw new ExceptionCTF(EnumCTF.OPCOES_MAN_CENTRO_EST_INFORMADO, new Object[]{empresa});
        }
        return op.getCentroEstoque();
    }

    private Double converterStringDouble(String valor) {
        return Double.parseDouble(valor.replace(".", "").replace(",", "."));
    }

    private List<GradeItemConsumoAtivo> criarGradeItemConsumo(ItemConsumoAtivo itemConsumoAtivo, Empresa empresa, String quantidadeLitros) throws ExceptionDatabase {
        List grades = this.serviceGradeCor.get(itemConsumoAtivo.getProduto());
        LinkedList<GradeItemConsumoAtivo> gradeItemConsumoAtivo = new LinkedList<GradeItemConsumoAtivo>();
        for (GradeCor gc : grades) {
            GradeItemConsumoAtivo g = new GradeItemConsumoAtivo();
            g.setItemConsumoAtivo(itemConsumoAtivo);
            g.setGradeCor(gc);
            g.setDataCadastro(new Date());
            g.setEmpresa(empresa);
            g.setQuantidade(this.converterStringDouble(quantidadeLitros));
            if (ToolMethods.isEquals((Object)g.getItemConsumoAtivo().getMovInterno(), (Object)EnumConstTipoMovimentoConsumo.CONSUMO_INTERNO.getValue())) {
                g.setLoteFabricacao(this.pesquisarLoteUnico(itemConsumoAtivo.getProduto()));
            }
            gradeItemConsumoAtivo.add(g);
        }
        return gradeItemConsumoAtivo;
    }

    private LoteFabricacao pesquisarLoteUnico(Produto produto) throws ExceptionDatabase {
        LoteFabricacao loteFabricacao = this.serviceLoteFabricacao.findOrCreateLoteUnico(produto);
        return loteFabricacao;
    }

    private Requisicao criarRequisicao(ConsumoAtivo c) throws ExceptionCTF, ExceptionParamCtbRequisicao {
        Requisicao vo = this.helperRequisicao.gerarRequisicaoConsumoAtivo(c);
        return vo;
    }

    private String refina(String str) {
        return ToolString.refina((String)str);
    }

    private Short getPessoaFisicaJuridica(String cnpj) {
        if (cnpj != null && cnpj.trim().length() == 14) {
            return EnumConstTipoPessoaComplementar.JURIDICA.getEnumId();
        }
        return EnumConstTipoPessoaComplementar.FISICA.getEnumId();
    }

    private Coleta criarColeta(ConsumoAtivo c) {
        Coleta coleta = new Coleta();
        coleta.setDataCadastro(c.getDataCadastro());
        coleta.setEmpresa(c.getEmpresa());
        coleta.setAtivo(c.getEquipamento());
        coleta.setTipoPontoControle(c.getTipoPontoControleColeta());
        coleta.setDataHoraColeta(c.getDataHoraColeta());
        coleta.setValorColeta(c.getValorColeta());
        coleta.setDescricao("Nova coleta para Ativo: " + c.getEquipamento().getIdentificador() + "-" + c.getEquipamento().getNome());
        return coleta;
    }
}

