/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.distribuicaoxmlnfe;

import com.touchcomp.basementor.constants.enums.configservicos.EnumConstConfigServicos;
import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsCienciaAutoNFe;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.eventonfe.NFeConstStatusEventoNFe;
import com.touchcomp.basementor.constants.enums.eventonfe.NFeConstTipoManifestoDestNFe;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestDocsDist;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EvtNFeManifestoDest;
import com.touchcomp.basementor.model.vo.TipoEventoManifestoNFe;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.distribuicaoxmlnfecte.CompDistribuicaoXMLNFeCTe;
import com.touchcomp.basementorservice.components.empresa.CompEmpresa;
import com.touchcomp.basementorservice.components.evtmanifestodest.CompEvtManifestoDest;
import com.touchcomp.basementorservice.components.nfe.consultanfedoc.CompStatusConsNFeDoc;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.helpers.impl.evtnfemanifestodest.HelperEvtNFeManifestoDest;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.configservicos.ServiceConfigServicosImpl;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.consultanfedestdocsdist.ServiceConsultaNFeDestDocsDistImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.evtnfemanifestodest.ServiceEvtNFeManifestoDestImpl;
import com.touchcomp.basementorservice.service.impl.tipoeventomanifestonfe.ServiceTipoEventoManifestoNFeImpl;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorxml.service.impl.xmlnfecteevt.ServiceXMLNFeCTeEvtImpl;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTASKCienciaAutoNFeImpl {
    @Autowired
    ServiceConfigServicosImpl serviceConfigServicos;
    @Autowired
    HelperConfigServicos helperConfigServicos = new HelperConfigServicos();
    @Autowired
    ServiceConfiguracaoCertificadoImpl serviceConfigCertificado;
    @Autowired
    ServiceTipoEventoManifestoNFeImpl serviceTipoEventoManifesto;
    @Autowired
    ServiceEvtNFeManifestoDestImpl serviceEvtNFeManifestoDestImpl;
    @Autowired
    HelperConfiguracaoCertificado helperConfigCertificado;
    @Autowired
    ServiceConsultaNFeDestDocsDistImpl serviceConsultaNFeDestDocImpl;
    @Autowired
    ServiceEmpresaImpl serviceEmpresaImpl;
    @Autowired
    CompEmpresa compEmpresa;
    @Autowired
    HelperEvtNFeManifestoDest helperEvtNFeManifestoDest;
    @Autowired
    CompEvtManifestoDest compEvtManifestoDest;
    @Autowired
    ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt;
    @Autowired
    CompDistribuicaoXMLNFeCTe compDistribuicaoXMLNFeCTe;
    @Autowired
    CompStatusConsNFeDoc compStatusConsDoc;
    private final Integer MAX_REG_PER_TIME = 50;

    public void cienciaAutomaticaNFe(String idConfigTerc, TaskProcessResult result) throws Exception {
        String[] ids;
        if (!ToolMethods.isStrWithData((String)idConfigTerc)) {
            System.out.println("ConfigServicos nao encontrada " + idConfigTerc);
            result.addError("E.TSK.0023.001", new Object[0]);
            return;
        }
        for (String idStr : ids = ToolString.splitString((String)idConfigTerc, (char[])new char[0])) {
            idStr = ToolString.onlyNumbers((String)idStr);
            this.cienciaAutomaticaNFeEmp(idStr, result);
        }
    }

    private void cienciaAutomaticaNFeEmp(String idStr, TaskProcessResult result) {
        ConfigServicos config = (ConfigServicos)this.serviceConfigServicos.get(idStr);
        if (config == null) {
            System.out.println("ConfigServicos nao encontrada " + idStr);
            result.addError("E.TSK.0023.001", new Object[0]);
            return;
        }
        if (!TMethods.isEquals((Object)EnumConstConfigServicos.get((Object)config.getChave()), (Object)EnumConstConfigServicos.CIENCIA_AUTOMATICA_NFE)) {
            System.out.println("ConfigServicos nao encontrada " + idStr);
            result.addError("E.TSK.0023.006", new Object[]{EnumConstConfigServicos.CIENCIA_AUTOMATICA_NFE.getChave(), config.getChave()});
            return;
        }
        String idEmpresas = this.helperConfigServicos.build(config).getValue(ConstantsCienciaAutoNFe.ID_EMPRESA.getChave());
        String tipoCiencia = this.helperConfigServicos.build(config).getValue(ConstantsCienciaAutoNFe.TIPO_CIENCIA.getChave());
        tipoCiencia = ToolString.onlyNumbers((String)tipoCiencia);
        List empresas = this.compEmpresa.getEmpresas(idEmpresas, result);
        String idCertificados = this.helperConfigServicos.build(config).getValue(ConstantsCienciaAutoNFe.ID_CONFIGURACAO_CERTIFICADO.getChave());
        for (Empresa empresa : empresas) {
            Long idCertificadoEmpresa = this.compDistribuicaoXMLNFeCTe.getIdCertificado(empresa, idCertificados);
            ConfiguracaoCertificado configCert = (ConfiguracaoCertificado)this.serviceConfigCertificado.get((Serializable)idCertificadoEmpresa);
            if (configCert == null) {
                System.out.println("ConfiguracaoCertificado nao encontrada " + idCertificadoEmpresa);
                result.addError("E.TSK.0023.002", new Object[0]);
                return;
            }
            this.efetuarCiencia(configCert, empresa, ConstantsTipoCiencia.get(tipoCiencia), result);
        }
    }

    private void efetuarCiencia(ConfiguracaoCertificado configCert, Empresa empresa, ConstantsTipoCiencia tipoCiencia, TaskProcessResult result) {
        int count = 0;
        int page = 0;
        Date dataIn = TDate.previousDays((Date)new Date(), (int)10);
        do {
            List docs;
            switch (tipoCiencia.ordinal()) {
                case 1: {
                    docs = this.serviceConsultaNFeDestDocImpl.getAllDocsEfetuarCiencia(dataIn, empresa, Integer.valueOf(page), this.MAX_REG_PER_TIME);
                    break;
                }
                case 2: {
                    docs = this.serviceConsultaNFeDestDocImpl.getDocsCienciaFornCadastrados(dataIn, empresa, Integer.valueOf(page), this.MAX_REG_PER_TIME);
                    break;
                }
                case 3: {
                    docs = this.serviceConsultaNFeDestDocImpl.getDocsCienciaOCAbertas(dataIn, empresa, Integer.valueOf(page), this.MAX_REG_PER_TIME);
                    break;
                }
                case 0: {
                    result.addError("E.TSK.0023.002", new Object[]{tipoCiencia.descricao});
                    return;
                }
                default: {
                    result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0023.004", tipoCiencia.descricao);
                    return;
                }
            }
            this.efetuarCienciaDocs(docs, configCert, empresa, result);
            count = docs.size();
            page += this.MAX_REG_PER_TIME.intValue();
        } while (count > 0);
    }

    private void efetuarCienciaDocs(List<ConsultaNFeDestDocsDist> docs, ConfiguracaoCertificado configCert, Empresa empresa, TaskProcessResult result) {
        TipoEventoManifestoNFe tipoEvento = this.serviceTipoEventoManifesto.get(NFeConstTipoManifestoDestNFe.CIENCIA_DA_EMISSAO);
        ParamsCertificado params = this.helperConfigCertificado.build(configCert).getParamsCertificado(ConstAmbiente.PRODUCAO);
        for (ConsultaNFeDestDocsDist doc : docs) {
            EvtNFeManifestoDest ret = this.getEventoManAutorizado(doc);
            if (ret == null) {
                ret = this.helperEvtNFeManifestoDest.getNovoEvento(doc, empresa, tipoEvento);
                ret.setConsultaNFeDestDocDist(doc);
            }
            if (!this.verificaEEnvia(doc, ret, params, empresa, result)) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ServiceTASKCienciaAutoNFeImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void atualizaConsultaStatDoc(ConsultaNFeDestDocsDist consulta, EvtNFeManifestoDest ev) {
        this.compStatusConsDoc.definirStatusConsultaDoc(consulta, ev.getStatus(), ev.getMotivo());
        this.serviceConsultaNFeDestDocImpl.saveOrUpdateFlush((InterfaceVO)consulta);
        this.serviceEvtNFeManifestoDestImpl.saveOrUpdateFlush((InterfaceVO)ev);
    }

    private EvtNFeManifestoDest getEventoManAutorizado(ConsultaNFeDestDocsDist doc) {
        Optional<EvtNFeManifestoDest> found = doc.getEvtNFeManifestoDest().stream().filter(i -> ToolMethods.isEquals((Object)i.getTipoEvento().getCodEvento(), (Object)NFeConstTipoManifestoDestNFe.CIENCIA_DA_EMISSAO.getCodigo()) && NFeConstStatusEventoNFe.isEventoValido((Short)i.getStatus())).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verificaEEnvia(ConsultaNFeDestDocsDist consulta, EvtNFeManifestoDest ev, ParamsCertificado params, Empresa empresa, TaskProcessResult result) {
        try {
            ev = this.compEvtManifestoDest.manifestarNFeEnviarEvento(ev, params);
            ev.setConsultaNFeDestDocDist(consulta);
            if (!NFeConstStatusEventoNFe.isStatusFinal((Short)ev.getStatus())) {
                result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0023.005", new Object[]{ev.getChave(), ev.getMotivo()});
            } else {
                result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0023.001", new Object[]{ev.getEmpresa(), ev.getChave()});
            }
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0023.005", new Object[]{ev.getChave(), ex.getMessage()});
            boolean bl = false;
            return bl;
        }
        finally {
            this.atualizaConsultaStatDoc(consulta, ev);
        }
        return true;
    }

    public static enum ConstantsTipoCiencia {
        NAO_EFETUAR_CIENCIA_AUTO("0", "Nao efetuar Ciencia Automaticamente"),
        EFETUAR_CIENCIA_TODOS_DOCS("1", "Efetuar Ciencia de Todos os Documentos"),
        EFETUAR_CIENCIA_FORN_CADASTRADOS("2", "Efetuar Ciencia, desde que fornecedor esteja cadastrado"),
        EFETUAR_CIENCIA_FORN_OCS_ABERTAS("3", "Efetuar Ciencia somente Fornecedores com Ordens em Aberto");

        private final String chave;
        private final String descricao;

        private ConstantsTipoCiencia(String chave, String descricao) {
            this.chave = chave;
            this.descricao = descricao;
        }

        public static ConstantsTipoCiencia get(Object value) {
            for (ConstantsTipoCiencia value1 : ConstantsTipoCiencia.values()) {
                if (!String.valueOf(value).equalsIgnoreCase(String.valueOf(value1.chave))) continue;
                return value1;
            }
            return NAO_EFETUAR_CIENCIA_AUTO;
        }
    }
}

