/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.distribuicaoxmlnfe;

import com.touchcomp.basementor.constants.enums.configservicos.EnumConstConfigServicos;
import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsConfirmacaoAutoNFe;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.eventonfe.NFeConstStatusEventoNFe;
import com.touchcomp.basementor.constants.enums.eventonfe.NFeConstTipoManifestoDestNFe;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestDocsDist;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EvtNFeManifestoDest;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.TipoEventoManifestoNFe;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.distribuicaoxmlnfecte.CompDistribuicaoXMLNFeCTe;
import com.touchcomp.basementorservice.components.empresa.CompEmpresa;
import com.touchcomp.basementorservice.components.evtmanifestodest.CompEvtManifestoDest;
import com.touchcomp.basementorservice.components.nfe.consultanfedoc.CompStatusConsNFeDoc;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.helpers.impl.evtnfemanifestodest.HelperEvtNFeManifestoDest;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.configservicos.ServiceConfigServicosImpl;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.consultanfedestdocsdist.ServiceConsultaNFeDestDocsDistImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.evtnfemanifestodest.ServiceEvtNFeManifestoDestImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.tipoeventomanifestonfe.ServiceTipoEventoManifestoNFeImpl;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.PersistenceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTASKConfOperacaoAutoNFeImpl {
    @Autowired
    ServiceConfigServicosImpl serviceConfigServicos;
    @Autowired
    HelperConfigServicos helperConfigServicos = new HelperConfigServicos();
    @Autowired
    ServiceConfiguracaoCertificadoImpl serviceConfigCertificado;
    @Autowired
    ServiceTipoEventoManifestoNFeImpl serviceTipoEventoManifesto;
    @Autowired
    ServiceEvtNFeManifestoDestImpl serviceEvtNFeManifestoDestImpl;
    @Autowired
    CompEmpresa compEmpresa;
    @Autowired
    HelperConfiguracaoCertificado helperConfigCertificado;
    @Autowired
    ServiceConsultaNFeDestDocsDistImpl serviceConsultaNFeDestDocImpl;
    @Autowired
    ServiceEmpresaImpl serviceEmpresaImpl;
    @Autowired
    ServiceNotaFiscalTerceirosImpl serviceNotaTerceiros;
    @Autowired
    CompEvtManifestoDest compEvtManifestoDest;
    @Autowired
    CompStatusConsNFeDoc compStatusConsDoc;
    @Autowired
    CompDistribuicaoXMLNFeCTe compDistribuicaoXMLNFeCTe;
    @Autowired
    HelperEvtNFeManifestoDest helperEvtNFeManifestoDest;
    private final Integer MAX_REGS_PER_TIME = 3;

    public void confirmacaoAutomaticaNFe(String idConfigTerc, TaskProcessResult result) throws Exception {
        String[] ids;
        if (!ToolMethods.isStrWithData((String)idConfigTerc)) {
            result.addError("E.TSK.0024.001", new Object[]{idConfigTerc});
            return;
        }
        for (String idStr : ids = ToolString.splitString((String)idConfigTerc, (char[])new char[0])) {
            idStr = ToolString.onlyNumbers((String)idStr);
            this.confirmacaoAutomaticaNFeInternal(idStr, result);
        }
    }

    private void confirmacaoAutomaticaNFeInternal(String idStr, TaskProcessResult result) {
        ConfigServicos config = (ConfigServicos)this.serviceConfigServicos.get(idStr);
        if (config == null) {
            result.addError("E.TSK.0024.001", new Object[]{idStr});
            return;
        }
        if (!TMethods.isEquals((Object)EnumConstConfigServicos.get((Object)config.getChave()), (Object)EnumConstConfigServicos.CONFIRMACAO_AUTOMATICA_NFE)) {
            result.addError("E.TSK.0023.006", new Object[]{EnumConstConfigServicos.CONFIRMACAO_AUTOMATICA_NFE.getChave(), config.getChave()});
            return;
        }
        String idEmpresas = this.helperConfigServicos.build(config).getValue(ConstantsConfirmacaoAutoNFe.ID_EMPRESA.getChave());
        String delayDiasLancamento = this.helperConfigServicos.build(config).getValue(ConstantsConfirmacaoAutoNFe.DELAY_DIAS_LANCAMENTO.getChave());
        String somenteNotasConf = this.helperConfigServicos.build(config).getValue(ConstantsConfirmacaoAutoNFe.SOMENTE_NOTAS_LIBERADAS.getChave());
        String dataBaseS = this.helperConfigServicos.build(config).getValue(ConstantsConfirmacaoAutoNFe.DATA_BASE.getChave());
        delayDiasLancamento = ToolString.onlyNumbers((String)delayDiasLancamento);
        somenteNotasConf = ToolString.onlyNumbers((String)somenteNotasConf);
        if (!ToolMethods.isStrWithData((String)dataBaseS)) {
            result.addError("E.TSK.0024.005", new Object[]{dataBaseS});
            return;
        }
        Date dataBase = ToolDate.strToDate((String)dataBaseS);
        if (dataBase.before(TDate.previousDays((Date)new Date(), (int)180))) {
            dataBase = TDate.previousDays((Date)new Date(), (int)180);
        }
        Integer delayDiasLanc = 0;
        if (ToolMethods.isStrWithData((String)ToolString.onlyNumbers((String)delayDiasLancamento))) {
            delayDiasLanc = Integer.valueOf(ToolString.onlyNumbers((String)delayDiasLancamento));
        }
        Short somenteNFConf = 0;
        if (ToolMethods.isStrWithData((String)ToolString.onlyNumbers((String)somenteNotasConf))) {
            somenteNFConf = Short.valueOf(ToolString.onlyNumbers((String)somenteNotasConf));
        }
        List empresas = this.compEmpresa.getEmpresas(idEmpresas, result);
        String idCertificados = this.helperConfigServicos.build(config).getValue(ConstantsConfirmacaoAutoNFe.ID_CONFIGURACAO_CERTIFICADO.getChave());
        for (Empresa empresa : empresas) {
            Long idCertificadoEmpresa = this.compDistribuicaoXMLNFeCTe.getIdCertificado(empresa, idCertificados);
            ConfiguracaoCertificado configCert = (ConfiguracaoCertificado)this.serviceConfigCertificado.get((Serializable)idCertificadoEmpresa);
            if (configCert == null) {
                System.out.println("ConfiguracaoCertificado nao encontrada " + idCertificadoEmpresa);
                result.addError("E.TSK.0024.002", new Object[0]);
                return;
            }
            this.efetuarConfirmacao(configCert, dataBase, empresa, result, delayDiasLanc, somenteNFConf);
        }
    }

    private void efetuarConfirmacao(ConfiguracaoCertificado configCert, Date dataBase, Empresa empresa, TaskProcessResult result, Integer delayDiasLancamento, Short somenteNotasConf) {
        int count = 0;
        int page = 0;
        do {
            List docs = ToolMethods.isAffirmative((Number)somenteNotasConf) ? this.serviceNotaTerceiros.getNotasSemConfirmarOperacaoLiberadas(empresa, dataBase, delayDiasLancamento, this.MAX_REGS_PER_TIME, Integer.valueOf(page)) : this.serviceNotaTerceiros.getNotasSemConfirmarOperacao(empresa, dataBase, delayDiasLancamento, this.MAX_REGS_PER_TIME, Integer.valueOf(page));
            count = docs.size();
            this.efetuarConfirmacao(docs, configCert, empresa, result);
            page += this.MAX_REGS_PER_TIME.intValue();
        } while (count > 0);
    }

    private void efetuarConfirmacao(List<NotaFiscalTerceiros> docs, ConfiguracaoCertificado configCert, Empresa empresa, TaskProcessResult result) {
        TipoEventoManifestoNFe tipoEvento = this.serviceTipoEventoManifesto.get(NFeConstTipoManifestoDestNFe.CONFIRMACAO_DA_OPERACAO);
        ParamsCertificado params = this.helperConfigCertificado.build(configCert).getParamsCertificado(ConstAmbiente.PRODUCAO);
        for (NotaFiscalTerceiros nfTerceiros : docs) {
            if (!ToolMethods.isStrWithData((String)nfTerceiros.getChaveNFE())) continue;
            ConsultaNFeDestDocsDist consulta = this.getConsultaDoc(nfTerceiros, empresa);
            EvtNFeManifestoDest ret = this.getEventoManAutorizado(consulta);
            if (ret == null) {
                ret = this.getEventoPrepEnvioRecente(consulta);
            }
            if (ret == null) {
                ret = this.helperEvtNFeManifestoDest.getNovoEvento(consulta, empresa, tipoEvento);
                ret.setConsultaNFeDestDocDist(consulta);
            }
            if (!this.verificaEEnvia(consulta, ret, params, empresa, result)) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ServiceTASKConfOperacaoAutoNFeImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void atualizaConsultaStatDoc(ConsultaNFeDestDocsDist consulta, EvtNFeManifestoDest ev) {
        this.compStatusConsDoc.definirStatusConsultaDoc(consulta, ev.getStatus(), ev.getMotivo());
        this.serviceConsultaNFeDestDocImpl.saveOrUpdateFlush((InterfaceVO)consulta);
        this.serviceEvtNFeManifestoDestImpl.saveOrUpdateFlush((InterfaceVO)ev);
    }

    private EvtNFeManifestoDest getEventoManAutorizado(ConsultaNFeDestDocsDist doc) {
        Optional<EvtNFeManifestoDest> found = doc.getEvtNFeManifestoDest().stream().filter(i -> i.getTipoEvento() != null && ToolMethods.isEquals((Object)i.getTipoEvento().getCodEvento(), (Object)NFeConstTipoManifestoDestNFe.CONFIRMACAO_DA_OPERACAO.getCodigo()) && NFeConstStatusEventoNFe.isEventoValido((Short)i.getStatus())).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        return null;
    }

    private EvtNFeManifestoDest getEventoPrepEnvioRecente(ConsultaNFeDestDocsDist doc) {
        Optional<EvtNFeManifestoDest> found = doc.getEvtNFeManifestoDest().stream().filter(i -> ToolMethods.isEquals((Object)i.getTipoEvento().getCodEvento(), (Object)NFeConstTipoManifestoDestNFe.CONFIRMACAO_DA_OPERACAO.getCodigo()) && ToolDate.difBetweenDatesInDays((Date)new Date(), (Date)i.getDataEvento()) <= 2L).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean verificaEEnvia(ConsultaNFeDestDocsDist consulta, EvtNFeManifestoDest ev, ParamsCertificado params, Empresa empresa, TaskProcessResult result) {
        block16: {
            block15: {
                ev = this.compEvtManifestoDest.manifestarNFeEnviarEvento(ev, params);
                ev.setConsultaNFeDestDocDist(consulta);
                if (!NFeConstStatusEventoNFe.isStatusFinal((Short)ev.getStatus())) {
                    result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0024.004", new Object[]{empresa, ev.getChave(), ev.getMotivo()});
                    break block15;
                }
                result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0024.001", new Object[]{ev.getEmpresa(), ev.getChave()});
            }
            try {
                this.atualizaConsultaStatDoc(consulta, ev);
            }
            catch (PersistenceException e) {
                TLogger.get(this.getClass()).error((Throwable)e);
                result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"E.TSK.0024.004", (Object[])new Object[]{ev.getChave(), e.getMessage()}) + ": " + String.valueOf(empresa), new Object[0]);
            }
            break block16;
            catch (PersistenceException e) {
                TLogger.get(this.getClass()).error((Throwable)e);
                result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"E.TSK.0024.004", (Object[])new Object[]{ev.getChave(), e.getMessage()}) + ": " + String.valueOf(empresa), new Object[0]);
                try {
                    this.atualizaConsultaStatDoc(consulta, ev);
                }
                catch (PersistenceException e2) {
                    TLogger.get(this.getClass()).error((Throwable)e2);
                    result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"E.TSK.0024.004", (Object[])new Object[]{ev.getChave(), e2.getMessage()}) + ": " + String.valueOf(empresa), new Object[0]);
                }
            }
            catch (Exception ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"E.TSK.0024.004", (Object[])new Object[]{ev.getChave(), ex.getMessage()}) + ": " + String.valueOf(empresa), new Object[0]);
                boolean bl = false;
                {
                    catch (Throwable throwable) {
                        try {
                            this.atualizaConsultaStatDoc(consulta, ev);
                        }
                        catch (PersistenceException e2) {
                            TLogger.get(this.getClass()).error((Throwable)e2);
                            result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"E.TSK.0024.004", (Object[])new Object[]{ev.getChave(), e2.getMessage()}) + ": " + String.valueOf(empresa), new Object[0]);
                        }
                        throw throwable;
                    }
                }
                try {
                    this.atualizaConsultaStatDoc(consulta, ev);
                }
                catch (PersistenceException e3) {
                    TLogger.get(this.getClass()).error((Throwable)e3);
                    result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"E.TSK.0024.004", (Object[])new Object[]{ev.getChave(), e3.getMessage()}) + ": " + String.valueOf(empresa), new Object[0]);
                }
                return bl;
            }
        }
        return true;
    }

    private ConsultaNFeDestDocsDist getConsultaDoc(NotaFiscalTerceiros nfTerceiros, Empresa emp) {
        ConsultaNFeDestDocsDist consulta = nfTerceiros.getConsultaNFeDestDocDist();
        if (consulta != null) {
            return consulta;
        }
        consulta = this.serviceConsultaNFeDestDocImpl.getByChave(nfTerceiros.getChaveNFE());
        if (consulta == null) {
            consulta = new ConsultaNFeDestDocsDist();
            consulta.setStatusSefaz(Short.valueOf(EnumConstNFeStatus.AUTORIZADA.getValue().shortValue()));
        }
        consulta.setEmpresa(emp);
        consulta.setUnidadeFatFornecedor(nfTerceiros.getUnidadeFatFornecedor());
        consulta.setChave(nfTerceiros.getChaveNFE());
        consulta.setCnpjEmitente(nfTerceiros.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj());
        consulta.setInscricaoEstadualDestinatario(nfTerceiros.getUnidadeFatFornecedor().getPessoa().getComplemento().getInscEst());
        consulta.setCnpjDestinatarioTomador(emp.getPessoa().getComplemento().getCnpj());
        consulta.setNotaFiscalTerceiros(nfTerceiros);
        nfTerceiros.setConsultaNFeDestDocDist(consulta);
        consulta.setNotaFiscalTerceiros(nfTerceiros);
        this.compStatusConsDoc.definirStatusConsultaDoc(consulta);
        consulta = (ConsultaNFeDestDocsDist)this.serviceConsultaNFeDestDocImpl.saveOrUpdateFlush((InterfaceVO)consulta);
        return consulta;
    }
}

