/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.distribuicaoxmlnfe;

import com.touchcomp.basementor.constants.enums.configservicos.EnumConstConfigServicos;
import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsDownloadXMLAutoNFe;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorservice.components.distribuicaoxmlnfecte.CompDistribuicaoXMLNFeCTe;
import com.touchcomp.basementorservice.components.empresa.CompEmpresa;
import com.touchcomp.basementorservice.components.nfe.consultanfedoc.CompConsultaNFeDownloadXMLDoc;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.configservicos.ServiceConfigServicosImpl;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTASKDownloadXMLAutoNFeImpl {
    @Autowired
    ServiceConfigServicosImpl serviceConfigServicos;
    @Autowired
    CompEmpresa compEmpresa;
    @Autowired
    HelperConfigServicos helperConfigServicos = new HelperConfigServicos();
    @Autowired
    ServiceConfiguracaoCertificadoImpl serviceConfigCertificado;
    @Autowired
    ServiceEmpresaImpl serviceEmpresaImpl;
    @Autowired
    CompDistribuicaoXMLNFeCTe compDistribuicaoXMLNFeCTe;
    @Autowired
    CompConsultaNFeDownloadXMLDoc compConsultaNFeDoc;
    private final Integer DEFAULT_DELAY_APOS_CONFIRMACAO_HORAS = 1;

    public void downloadAutomaticoNFe(String idConfigTerc, TaskProcessResult result) throws Exception {
        String[] ids;
        if (!ToolMethods.isStrWithData((String)idConfigTerc)) {
            result.addError("E.TSK.0025.001", new Object[]{idConfigTerc});
            return;
        }
        for (String idStr : ids = ToolString.splitString((String)idConfigTerc, (char[])new char[0])) {
            this.downloadXMLInternal(idStr, result);
        }
    }

    public TaskProcessResult downloadAutomaticoNFe(ConfigServicos config) {
        TaskProcessResult result = new TaskProcessResult();
        this.downloadXMLInternal(config, result);
        return result;
    }

    private void downloadXMLInternal(String idStr, TaskProcessResult result) {
        ConfigServicos config = (ConfigServicos)this.serviceConfigServicos.get(idStr);
        if (config == null) {
            result.addError("E.TSK.0025.001", new Object[]{idStr});
            return;
        }
        if (!TMethods.isEquals((Object)EnumConstConfigServicos.get((Object)config.getChave()), (Object)EnumConstConfigServicos.DOWNLOAD_AUTOMATICO_NFE)) {
            System.out.println("ConfigServicos nao encontrada " + idStr);
            result.addError("E.TSK.0023.006", new Object[]{EnumConstConfigServicos.DOWNLOAD_AUTOMATICO_NFE.getChave(), config.getChave()});
            return;
        }
        this.downloadXMLInternal(config, result);
    }

    private void downloadXMLInternal(ConfigServicos config, TaskProcessResult result) {
        String idEmpresas = this.helperConfigServicos.build(config).getValue(ConstantsDownloadXMLAutoNFe.ID_EMPRESA.getChave());
        String delayAposConfirmacaoStr = this.helperConfigServicos.build(config).getValue(ConstantsDownloadXMLAutoNFe.DELAY_APOS_CIENCIA_OU_CONFIRMACAO.getChave());
        delayAposConfirmacaoStr = ToolString.onlyNumbers((String)delayAposConfirmacaoStr);
        String idCertificados = this.helperConfigServicos.build(config).getValue(ConstantsDownloadXMLAutoNFe.ID_CONFIGURACAO_CERTIFICADO.getChave());
        Integer delayAposCiencia = this.DEFAULT_DELAY_APOS_CONFIRMACAO_HORAS;
        if (!ToolMethods.isStrWithData((String)ToolString.onlyNumbers((String)delayAposConfirmacaoStr))) {
            delayAposCiencia = Integer.valueOf(ToolString.onlyNumbers((String)delayAposConfirmacaoStr));
        }
        List empresas = this.compEmpresa.getEmpresas(idEmpresas, result);
        for (Empresa empresa : empresas) {
            Long idCertificadoEmpresa = this.compDistribuicaoXMLNFeCTe.getIdCertificado(empresa, idCertificados);
            ConfiguracaoCertificado configCert = (ConfiguracaoCertificado)this.serviceConfigCertificado.get((Serializable)idCertificadoEmpresa);
            if (configCert == null) {
                System.out.println("ConfiguracaoCertificado nao encontrada " + idCertificadoEmpresa);
                result.addError("E.TSK.0025.002", new Object[0]);
                return;
            }
            this.compConsultaNFeDoc.consultaERealizaDownloadXMLPendentes(configCert, empresa, result, delayAposCiencia);
        }
    }
}

