/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.ecommerceapiary;

import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementor.constants.enums.configservicosterceiros.impl.ConstantsWebEcommerceApiary;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CategoriaProdProduto;
import com.touchcomp.basementor.model.vo.CategoriaProduto;
import com.touchcomp.basementor.model.vo.CodigoBarras;
import com.touchcomp.basementor.model.vo.ConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.Cor;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.LogSincronizacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoInfoEcommerce;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.WebLojaIntegrada;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.categorias.DTOLojaIntegAlterCategoria;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.categorias.DTOLojaIntegCategoria;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.estoque.DTOLojaIntegEstoque;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.grades.DTOLojaIntegGrade;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.grades.DTOLojaIntegGradeRes;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.marcas.DTOLojaIntegAlterMarca;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.marcas.DTOLojaIntegMarca;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.marcas.DTOLojaIntegMarcaRes;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.produtos.DTOLojaIntegAlterProduto;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.produtos.DTOLojaIntegProduto;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.produtos.DTOLojaIntegProdutoRes;
import com.touchcomp.basementorclientwebservices.ecommercelojaintegrada.tabelaprecos.DTOLojaIntegTabelaPrecos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.helpers.impl.configservicosterceiros.HelperConfigServicosTerceiros;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.categoriaproduto.ServiceCategoriaProdutoImpl;
import com.touchcomp.basementorservice.service.impl.configservicosterceiros.ServiceConfigServicosTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.cor.ServiceCorImpl;
import com.touchcomp.basementorservice.service.impl.fabricante.ServiceFabricanteImpl;
import com.touchcomp.basementorservice.service.impl.logsincronizacao.ServiceLogSincronizacaoImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.produtoinfoecommerce.ServiceProdutoInfoEcommerceImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.subespecie.ServiceSubEspecieImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseProdutoImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServiceTASKEcommerceLojaIntegrada
extends ServiceGenericImpl {
    @Autowired
    ServiceCategoriaProdutoImpl serviceCategoriaProdutos;
    @Autowired
    ServiceSubEspecieImpl serviceSubEspecie;
    @Autowired
    ServiceFabricanteImpl serviceFabricante;
    @Autowired
    ServiceTabelaPrecoBaseProdutoImpl serviceTabPrecoBaseProd;
    @Autowired
    ServiceTabelaPrecoBaseImpl serviceTabPrecoBase;
    @Autowired
    ServiceProdutoImpl serviceProduto;
    @Autowired
    ServiceCorImpl serviceCorImpl;
    @Autowired
    ServiceLogSincronizacaoImpl serviceLogSincronizacaoImpl;
    @Autowired
    ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    @Autowired
    HelperConfigServicosTerceiros helperConfigServicosTerceiros;
    @Autowired
    ServiceConfigServicosTerceirosImpl serviceConfig;

    public void sincronizaInformacoes(Long idConfTerceiros, TaskProcessResult result) throws ExceptionIO, ExceptionValidacaoDados {
        ConfigServicosTerceiros conf = (ConfigServicosTerceiros)this.serviceConfig.get((Serializable)idConfTerceiros);
        if (conf == null) {
            result.addError("E.TSK.0021.001", new Object[0]);
            return;
        }
        this.helperConfigServicosTerceiros.build(conf);
        String chaveApi = this.helperConfigServicosTerceiros.getValue(ConstantsWebEcommerceApiary.CHAVE_API.getChave());
        String aplicacaoAPI = this.helperConfigServicosTerceiros.getValue(ConstantsWebEcommerceApiary.APLICACACAO_API.getChave());
        String idTabPrecoBaseStr = this.helperConfigServicosTerceiros.getValue(ConstantsWebEcommerceApiary.ID_TAB_PRECO_BASE.getChave());
        String diasEnvioStr = this.helperConfigServicosTerceiros.getValue(ConstantsWebEcommerceApiary.DIAS_ENVIO.getChave());
        String diasEnvioSemEstStr = this.helperConfigServicosTerceiros.getValue(ConstantsWebEcommerceApiary.DIAS_ENVIO_SEM_EST.getChave());
        String idCentroEstoqueStr = this.helperConfigServicosTerceiros.getValue(ConstantsWebEcommerceApiary.ID_CENTRO_ESTOQUE.getChave());
        String idEmpresaStr = this.helperConfigServicosTerceiros.getValue(ConstantsWebEcommerceApiary.ID_EMPRESA.getChave());
        String codItensSincronizacao = this.helperConfigServicosTerceiros.getValue(ConstantsWebEcommerceApiary.COD_ITENS_SINCRONIZACAO.getChave());
        if (!ToolMethods.isStrWithData((String)chaveApi)) {
            result.addError("E.TSK.0021.005", new Object[0]);
            return;
        }
        if (!ToolMethods.isStrWithData((String)aplicacaoAPI)) {
            result.addError("E.TSK.0021.006", new Object[0]);
            return;
        }
        if (!ToolMethods.isStrWithData((String)idTabPrecoBaseStr)) {
            result.addError("E.TSK.0021.002", new Object[0]);
            return;
        }
        if (!ToolMethods.isStrWithData((String)idEmpresaStr)) {
            result.addError("E.TSK.0021.003", new Object[0]);
            return;
        }
        if (!ToolMethods.isStrWithData((String)idCentroEstoqueStr)) {
            result.addError("E.TSK.0021.004", new Object[0]);
            return;
        }
        if (!ToolMethods.isStrWithData((String)idCentroEstoqueStr)) {
            result.addError("E.TSK.0021.004", new Object[0]);
            return;
        }
        if (!ToolMethods.isStrWithData((String)diasEnvioStr)) {
            diasEnvioStr = "0";
        }
        if (!ToolMethods.isStrWithData((String)diasEnvioSemEstStr)) {
            diasEnvioSemEstStr = "0";
        }
        Long idTabPrecoBase = Long.valueOf(idTabPrecoBaseStr);
        Long idCentroEstoque = Long.valueOf(idCentroEstoqueStr);
        Long idEmpresa = Long.valueOf(idEmpresaStr);
        Integer diasEnvio = Integer.valueOf(diasEnvioStr);
        Integer diasEnvioSemEst = Integer.valueOf(diasEnvioSemEstStr);
        Integer maxRegs = 500;
        TabelaPrecoBase tab = (TabelaPrecoBase)this.serviceTabPrecoBase.get((Serializable)idTabPrecoBase);
        if (tab == null) {
            result.addError("E.TSK.0021.002", new Object[0]);
            return;
        }
        Date atualSinc = new Date();
        Date lastSinc = this.getLastSinc();
        String baseURL = "https://api.awsli.com.br/v1/";
        WebLojaIntegrada webLoja = new WebLojaIntegrada();
        WebLojaIntegrada.Parametros paramsConexao = new WebLojaIntegrada.Parametros(chaveApi, aplicacaoAPI, baseURL);
        webLoja.setParamsConexao(paramsConexao);
        if (ToolMethods.isStrWithData((String)codItensSincronizacao) && codItensSincronizacao.contains("10;")) {
            this.enviaCategoriasProdutosAlteradas(webLoja, lastSinc, tab, maxRegs, result);
        }
        if (ToolMethods.isStrWithData((String)codItensSincronizacao) && codItensSincronizacao.contains("20;")) {
            this.enviaMarcasFabricantes(webLoja, lastSinc, tab, maxRegs, result);
        }
        if (ToolMethods.isStrWithData((String)codItensSincronizacao) && codItensSincronizacao.contains("30;")) {
            this.enviaProdutos(webLoja, lastSinc, tab, maxRegs, result);
        }
        if (ToolMethods.isStrWithData((String)codItensSincronizacao) && codItensSincronizacao.contains("40;")) {
            this.enviaPrecos(webLoja, lastSinc, tab, maxRegs, result);
        }
        if (ToolMethods.isStrWithData((String)codItensSincronizacao) && codItensSincronizacao.contains("50;")) {
            this.enviaEstoque(webLoja, diasEnvio, diasEnvioSemEst, new Date(), lastSinc, idCentroEstoque, idEmpresa, idTabPrecoBase, result);
        }
        LogSincronizacao l = new LogSincronizacao();
        l.setChaveSincronizacao(EnumConstConfigServicosTerceiros.ECOMMERCE_LOJA_INTEGRADA.getChave());
        l.setDataSincronizacao(lastSinc);
        l.setDataSincronizacao(atualSinc);
        this.serviceLogSincronizacaoImpl.saveOrUpdateFlush((InterfaceVO)l);
    }

    private void enviaCategoriasProdutosAlteradas(WebLojaIntegrada webLoja, Date lastSinc, TabelaPrecoBase tabBase, Integer maxRegs, TaskProcessResult result) throws ExceptionIO, ExceptionValidacaoDados {
        int firstRes = 0;
        List categorias = null;
        LinkedList<CategoriaProduto> categoriasSaved = new LinkedList<CategoriaProduto>();
        do {
            categorias = this.serviceCategoriaProdutos.getAltCriaVincProdTabBase(lastSinc, tabBase, firstRes, maxRegs.intValue());
            int nrErros = 0;
            for (CategoriaProduto esp : categorias) {
                block9: {
                    try {
                        if (ToolMethods.isStrWithData((String)esp.getCodigoSincronizacao())) {
                            dto = new DTOLojaIntegAlterCategoria();
                            dto.setNome(esp.getDescricao());
                            if (esp.getCategoriaPai() != null) {
                                dto.setCategoria_pai(esp.getCategoriaPai().getResourceURI());
                            }
                            res = webLoja.alterarCategoria(esp.getCodigoSincronizacao(), dto);
                            esp.setCodigoSincronizacao(String.valueOf(res.getId()));
                            esp.setResourceURI(res.getResource_uri());
                            categoriasSaved.add((CategoriaProduto)this.serviceCategoriaProdutos.saveOrUpdateFlush((InterfaceVO)esp));
                        } else {
                            dto = new DTOLojaIntegCategoria();
                            dto.setDescricao(esp.getDescricao());
                            dto.setId_externo(esp.getIdentificador());
                            dto.setNome(esp.getDescricao());
                            if (esp.getCategoriaPai() != null && ToolMethods.isStrWithData((String)esp.getCategoriaPai().getResourceURI())) {
                                dto.setCategoria_pai(esp.getCategoriaPai().getResourceURI());
                                Optional<CategoriaProduto> found = categoriasSaved.stream().filter(i -> ToolMethods.isEquals((Object)esp.getCategoriaPai(), (Object)i)).findFirst();
                                if (found.isPresent()) {
                                    esp.setCategoriaPai(found.get());
                                }
                            }
                            res = webLoja.inserirCategoria((DTOLojaIntegCategoria)dto);
                            esp.setCodigoSincronizacao(String.valueOf(res.getId()));
                            esp.setResourceURI(res.getResource_uri());
                            categoriasSaved.add((CategoriaProduto)this.serviceCategoriaProdutos.saveOrUpdateFlush((InterfaceVO)esp));
                        }
                    }
                    catch (ExceptionIO | ExceptionValidacaoDados ex) {
                        this.logError(ex);
                        result.addError(ex.getErrorCode(), new Object[]{MessagesBaseMentor.getErrorMsg((String)"E.TSK.0021.001", (Object[])new Object[]{esp, ex.getMessage()})});
                        if (++nrErros <= 10) break block9;
                        return;
                    }
                }
                firstRes += maxRegs.intValue();
            }
        } while (categorias != null && categorias.size() > 0);
    }

    private void enviaGrades(WebLojaIntegrada webLoja, Date lastSinc, TabelaPrecoBase tabBase, Integer maxRegs, TaskProcessResult result) throws ExceptionIO, ExceptionValidacaoDados {
        int firstRes = 0;
        List cores = null;
        int nrErros = 0;
        do {
            cores = this.serviceCorImpl.getAltCriaVincProdTabBase(lastSinc, tabBase, firstRes, maxRegs);
            for (Cor cor : cores) {
                try {
                    if (ToolMethods.isStrWithData((String)cor.getCodSincronizacao())) continue;
                    DTOLojaIntegGrade dto = new DTOLojaIntegGrade();
                    dto.setId_externo(cor.getIdentificador());
                    dto.setNome(cor.getNome());
                    dto.setNome_visivel(cor.getNome());
                    if (ToolMethods.isStrWithData((String)cor.getCodSincronizacao())) {
                        dto.setId(Long.valueOf(cor.getCodSincronizacao()));
                    }
                    DTOLojaIntegGradeRes res = webLoja.cadastrarGrade(dto);
                    cor.setCodSincronizacao(String.valueOf(res.getId()));
                    this.serviceCorImpl.saveOrUpdateFlush((InterfaceVO)cor);
                }
                catch (ExceptionIO | ExceptionValidacaoDados ex) {
                    this.logError(ex);
                    result.addError(ex.getErrorCode(), new Object[]{MessagesBaseMentor.getErrorMsg((String)"E.TSK.0021.040", (Object[])new Object[]{cor, ex.getMessage()})});
                    if (++nrErros <= 10) continue;
                    return;
                }
            }
            firstRes += maxRegs.intValue();
        } while (cores != null && cores.size() > 0);
    }

    private void enviaMarcasFabricantes(WebLojaIntegrada webLoja, Date lastSinc, TabelaPrecoBase tabBase, Integer maxRegs, TaskProcessResult result) throws ExceptionIO, ExceptionValidacaoDados {
        int firstRes = 0;
        List fabricantes = null;
        do {
            int nrErros = 0;
            fabricantes = this.serviceFabricante.getAltCriaVincProdTabBase(lastSinc, tabBase, firstRes, maxRegs);
            for (Fabricante fab : fabricantes) {
                try {
                    DTOLojaIntegMarcaRes res;
                    DTOLojaIntegAlterMarca dto;
                    if (ToolMethods.isStrWithData((String)fab.getCodSincronizacao())) {
                        dto = new DTOLojaIntegAlterMarca();
                        dto.setNome(fab.getNome());
                        res = webLoja.alterarMarca(Long.valueOf(fab.getCodSincronizacao()), dto);
                        fab.setCodSincronizacao(String.valueOf(res.getId()));
                        fab.setResourceURI(res.getResource_uri());
                        this.serviceFabricante.saveOrUpdateFlush((InterfaceVO)fab);
                        continue;
                    }
                    dto = new DTOLojaIntegMarca();
                    dto.setDescricao(fab.getDescricaoAdicional());
                    dto.setId_externo(fab.getIdentificador());
                    dto.setNome(fab.getNome());
                    dto.setApelido(fab.getNomeFantasia());
                    res = webLoja.cadastrarMarca((DTOLojaIntegMarca)dto);
                    fab.setCodSincronizacao(String.valueOf(res.getId()));
                    fab.setResourceURI(res.getResource_uri());
                    this.serviceFabricante.saveOrUpdateFlush((InterfaceVO)fab);
                }
                catch (ExceptionIO | ExceptionValidacaoDados ex) {
                    this.logError(ex);
                    result.addError(ex.getErrorCode(), new Object[]{MessagesBaseMentor.getErrorMsg((String)"E.TSK.0021.020", (Object[])new Object[]{fab, ex.getMessage()})});
                    if (++nrErros <= 10) continue;
                    return;
                }
            }
            firstRes += maxRegs.intValue();
        } while (fabricantes != null && fabricantes.size() > 0);
    }

    private void enviaProdutos(WebLojaIntegrada webLoja, Date lastSinc, TabelaPrecoBase tabBase, Integer maxRegs, TaskProcessResult result) throws ExceptionIO, ExceptionValidacaoDados {
        int firstRes = 0;
        List produtos = null;
        do {
            int nrErros = 0;
            produtos = this.serviceTabPrecoBaseProd.getProdutosCriadosAltVincTab(lastSinc, tabBase, firstRes, maxRegs);
            for (TabelaPrecoBaseProduto tab : produtos) {
                Produto pr = tab.getProduto();
                try {
                    DTOLojaIntegProdutoRes res;
                    DTOLojaIntegAlterProduto dto;
                    if (ToolMethods.isStrWithData((String)pr.getCodSincronizacao())) {
                        dto = new DTOLojaIntegAlterProduto();
                        dto.setAltura(this.convertToCentimeters(pr.getAltura()));
                        if (ToolMethods.isStrWithData((String)pr.getNomeAuxiliar())) {
                            dto.setApelido(ToolString.buildStrValidURL((String)pr.getNomeAuxiliar()));
                        } else {
                            dto.setApelido(ToolString.buildStrValidURL((String)pr.getNome()));
                        }
                        dto.setAtivo(Boolean.valueOf(ToolMethods.isAffirmative((Number)pr.getAtivo())));
                        if (!ToolMethods.isAffirmative((Number)pr.getAtivo())) {
                            dto.setAtivo(Boolean.valueOf(false));
                        } else if (!ToolMethods.isAffirmative((Number)tab.getAtivo())) {
                            dto.setAtivo(Boolean.valueOf(false));
                        } else {
                            dto.setAtivo(Boolean.valueOf(true));
                        }
                        dto.setBloqueado(Boolean.valueOf(ToolMethods.isEquals((Object)0, (Object)pr.getAtivo())));
                        dto.setCategorias(this.getCategorias(pr));
                        dto.setData_criacao(this.formatDate(pr.getDataCadastro()));
                        dto.setData_modificacao(this.formatDate(pr.getDataAtualizacao()));
                        dto.setDestaque(Boolean.valueOf(ToolMethods.isAffirmative((Number)pr.getInfoEcommerce().getDestaque())));
                        dto.setGtin(this.getCodigoBarrasPrincipal(pr));
                        dto.setSku(pr.getIdentificador().toString());
                        dto.setLargura(this.convertToCentimeters(pr.getLargura()));
                        if (pr.getFabricante() != null && ToolMethods.isStrWithData((String)pr.getFabricante().getCodSincronizacao())) {
                            dto.setMarca(pr.getFabricante().getResourceURI());
                        }
                        if (pr.getNcm() != null) {
                            dto.setNcm(pr.getNcm().getCodigo());
                        }
                        dto.setNome(pr.getNome());
                        dto.setRemovido(Boolean.valueOf(false));
                        dto.setPeso(pr.getPesoUnitario());
                        dto.setProfundidade(this.convertToCentimeters(pr.getComprimento()));
                        dto.setUsado(Boolean.valueOf(false));
                        res = webLoja.alterarProduto(Long.valueOf(pr.getCodSincronizacao()), dto);
                        pr.setCodSincronizacao(String.valueOf(res.getId()));
                        pr.getInfoEcommerce().setUriResource(res.getResource_uri());
                        this.serviceProduto.saveOrUpdateFlush((InterfaceVO)pr);
                        continue;
                    }
                    dto = new DTOLojaIntegProduto();
                    dto.setAltura(this.convertToCentimeters(pr.getAltura()));
                    if (!ToolMethods.isAffirmative((Number)pr.getAtivo())) {
                        dto.setAtivo(Boolean.valueOf(false));
                    } else if (!ToolMethods.isAffirmative((Number)tab.getAtivo())) {
                        dto.setAtivo(Boolean.valueOf(false));
                    } else {
                        dto.setAtivo(Boolean.valueOf(true));
                    }
                    dto.setCategorias(this.getCategorias(pr));
                    dto.setDescricao_completa(pr.getObservacao());
                    dto.setDestaque(Boolean.valueOf(ToolMethods.isAffirmative((Number)pr.getInfoEcommerce().getDestaque())));
                    dto.setId_externo(pr.getIdentificador());
                    dto.setLargura(this.convertToCentimeters(pr.getLargura()));
                    if (pr.getFabricante() != null && ToolMethods.isStrWithData((String)pr.getFabricante().getCodSincronizacao())) {
                        dto.setMarca(pr.getFabricante().getResourceURI());
                    }
                    if (pr.getNcm() != null) {
                        dto.setNcm(pr.getNcm().getCodigo());
                    }
                    dto.setNome(pr.getNome());
                    dto.setRemovido(Boolean.valueOf(false));
                    dto.setPeso(pr.getPesoUnitario());
                    dto.setProfundidade(this.convertToCentimeters(pr.getComprimento()));
                    dto.setUsado(Boolean.valueOf(false));
                    dto.setTipo("normal");
                    if (ToolMethods.isStrWithData((String)pr.getInfoEcommerce().getSku())) {
                        dto.setSku(pr.getInfoEcommerce().getSku());
                    } else if (ToolMethods.isStrWithData((String)pr.getCodigoAuxiliar())) {
                        dto.setSku(pr.getCodigoAuxiliar());
                    } else {
                        dto.setSku(pr.getIdentificador().toString());
                    }
                    res = webLoja.cadastrarProduto((DTOLojaIntegProduto)dto);
                    pr.setCodSincronizacao(String.valueOf(res.getId()));
                    pr.getInfoEcommerce().setUriResource(res.getResource_uri());
                    this.serviceProduto.saveOrUpdateFlush((InterfaceVO)pr);
                }
                catch (ExceptionInvalidData | ExceptionIO | ExceptionValidacaoDados ex) {
                    this.logError(ex);
                    result.addError(ex.getErrorCode(), new Object[]{MessagesBaseMentor.getErrorMsg((String)"E.TSK.0021.060", (Object[])new Object[]{pr, ex.getMessage()})});
                    if (++nrErros <= 10) continue;
                    return;
                }
            }
            firstRes += maxRegs.intValue();
        } while (produtos != null && produtos.size() > 0);
    }

    private void enviaEstoque(WebLojaIntegrada webLoja, Integer diasEnvio, Integer diasEnvioSemEstoque, Date dataSaldo, Date lastSinc, Long idCentroEstoque, Long idEmpresa, Long idTabPrecoBase, TaskProcessResult result) throws ExceptionIO, ExceptionValidacaoDados {
        List saldos = this.serviceSaldoEstoque.findSaldosProdAltTab(dataSaldo, lastSinc, idCentroEstoque, idEmpresa, idTabPrecoBase);
        int nrErros = 0;
        ServiceProdutoInfoEcommerceImpl service = (ServiceProdutoInfoEcommerceImpl)Context.get(ServiceProdutoInfoEcommerceImpl.class);
        for (SaldoEstoqueGeralBasico saldo : saldos) {
            try {
                ProdutoInfoEcommerce prod = service.getByIdProduto(saldo.getIdProduto());
                if (prod == null) continue;
                DTOLojaIntegEstoque dto = new DTOLojaIntegEstoque();
                dto.setGerenciado(true);
                dto.setQuantidade(Integer.valueOf(((Number)saldo.getQuantidade()).intValue()));
                if (ToolMethods.isWithData((Number)prod.getDiasEnvioEmEstoque())) {
                    dto.setSituacao_em_estoque(prod.getDiasEnvioEmEstoque());
                } else {
                    dto.setSituacao_em_estoque(diasEnvio);
                }
                if (ToolMethods.isWithData((Number)prod.getDiasEnvioEmEstoque())) {
                    dto.setSituacao_sem_estoque(prod.getDiasEnvioSemEstoque());
                } else {
                    dto.setSituacao_em_estoque(diasEnvioSemEstoque);
                }
                if (!ToolMethods.isStrWithData((String)saldo.getCodSincronizacaoProduto())) continue;
                webLoja.alterarEstoque(saldo.getCodSincronizacaoProduto(), dto);
            }
            catch (ExceptionIO | ExceptionValidacaoDados ex) {
                this.logError(ex);
                result.addError(ex.getErrorCode(), new Object[]{MessagesBaseMentor.getErrorMsg((String)"E.TSK.0021.100", (Object[])new Object[]{saldo.getIdProduto(), ex.getMessage()})});
                if (++nrErros <= 10) continue;
                return;
            }
        }
    }

    private void enviaPrecos(WebLojaIntegrada webLoja, Date lastSinc, TabelaPrecoBase tab, Integer maxRes, TaskProcessResult result) throws ExceptionIO, ExceptionValidacaoDados {
        int firstRes = 0;
        List itens = null;
        do {
            int nrErros = 0;
            itens = this.serviceTabPrecoBaseProd.getItensCriadosAltVincTab(lastSinc, tab, Integer.valueOf(firstRes), maxRes);
            for (TabelaPrecoBaseProduto pr : itens) {
                try {
                    DTOLojaIntegTabelaPrecos dto = new DTOLojaIntegTabelaPrecos();
                    dto.setCheio(pr.getValorVendaAnterior());
                    dto.setCusto(pr.getValorCusto());
                    dto.setPromocional(pr.getValorVenda());
                    if (!ToolMethods.isStrWithData((String)pr.getProduto().getCodSincronizacao())) continue;
                    webLoja.cadastrarPrecoProduto(Long.valueOf(pr.getProduto().getCodSincronizacao()), dto);
                }
                catch (ExceptionIO | ExceptionValidacaoDados ex) {
                    this.logError(ex);
                    result.addError(ex.getErrorCode(), new Object[]{MessagesBaseMentor.getErrorMsg((String)"E.TSK.0021.080", (Object[])new Object[]{pr, ex.getMessage()})});
                    if (++nrErros <= 10) continue;
                    return;
                }
            }
            firstRes += maxRes.intValue();
        } while (itens != null && itens.size() > 0);
    }

    private Integer convertToCentimeters(Double comprimento) {
        comprimento = comprimento * 1000.0;
        return ((Number)comprimento).intValue();
    }

    private String formatDate(Date dataCadastro) {
        String DATE_MASK = "yyyy-MM-dd";
        String HOUR_MASK = "HH:mm:ss.SSS";
        return ToolDate.dateToStr((Date)dataCadastro, (String)DATE_MASK) + "T" + ToolDate.dateToStr((Date)dataCadastro, (String)HOUR_MASK);
    }

    private String[] getCategorias(Produto pr) {
        LinkedList<String> casts = new LinkedList<String>();
        for (CategoriaProdProduto cats : pr.getCategoriasProduto()) {
            if (!ToolMethods.isStrWithData((String)cats.getCategoriaProduto().getResourceURI())) continue;
            casts.add(cats.getCategoriaProduto().getResourceURI());
        }
        return casts.toArray(new String[0]);
    }

    private String getCodigoBarrasPrincipal(Produto pr) {
        Optional<CodigoBarras> found = pr.getCodigoBarras().stream().filter(i -> ToolMethods.isEquals((Object)i.getAtivo(), (Object)1) && ToolMethods.isEquals((Object)i.getUsarComoCodPrincTrib(), (Object)1)).findFirst();
        if (found.isPresent()) {
            return found.get().getCodigoBarras();
        }
        found = pr.getCodigoBarras().stream().filter(i -> ToolMethods.isEquals((Object)i.getAtivo(), (Object)1)).findFirst();
        if (found.isPresent()) {
            return found.get().getCodigoBarras();
        }
        return null;
    }

    private Date getLastSinc() {
        LogSincronizacao l = this.serviceLogSincronizacaoImpl.getUltimoLog(EnumConstConfigServicosTerceiros.ECOMMERCE_LOJA_INTEGRADA);
        if (l != null) {
            return l.getDataSincronizacao();
        }
        return ToolDate.strToDate((String)"11/11/1111");
    }
}

