/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.emailagendrelpessoa;

import com.touchcomp.basementor.constants.enums.relacionamentopessoa.EnumConstRelPessoaTpRepEnvioAuto;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaAgEmail;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaAgEmailLog;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.email.builders.CompEmailBuilderRelPessoa;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.modeloemail.ServiceModeloEmailImpl;
import com.touchcomp.basementorservice.service.impl.servidoremail.ServiceServidorEmailImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceOpcoesRelacionamento;
import com.touchcomp.basementorservice.service.interfaces.ServiceRelacionamentoPessoaAgEmailLog;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementorwebtasks.dao.interfaces.DaoTaskEmailAgendRelPessoa;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class AuxEmailAgendRelPessoa {
    DaoTaskEmailAgendRelPessoa daoTaskEnvioEmail = (DaoTaskEmailAgendRelPessoa)ConfApplicationContext.getBean(DaoTaskEmailAgendRelPessoa.class);
    ServiceModeloEmailImpl serviceModeloEmail = (ServiceModeloEmailImpl)ConfApplicationContext.getBean(ServiceModeloEmailImpl.class);
    ServiceServidorEmailImpl serviceServidorEmail = (ServiceServidorEmailImpl)ConfApplicationContext.getBean(ServiceServidorEmailImpl.class);
    ServiceRelacionamentoPessoaAgEmailLog serviceRelacionamentoPessoaAgEmailLog = (ServiceRelacionamentoPessoaAgEmailLog)ConfApplicationContext.getBean(ServiceRelacionamentoPessoaAgEmailLog.class);
    ServiceOpcoesRelacionamento serviceOpcoesRelacionamento = (ServiceOpcoesRelacionamento)ConfApplicationContext.getBean(ServiceOpcoesRelacionamento.class);
    HashMap<Empresa, OpcoesRelacionamento> hashOpcoes = new HashMap();
    final TaskProcessResult result;
    private final TLogger logger = TLogger.get(this.getClass());

    public AuxEmailAgendRelPessoa(TaskProcessResult result) {
        this.result = result;
    }

    public void enviaEmailAgendRelPessoa(Long idServidorEmail, Long idModeloEmail) {
        ServidorEmail serv = (ServidorEmail)this.serviceServidorEmail.get((Serializable)idServidorEmail);
        ModeloEmail mod = (ModeloEmail)this.serviceModeloEmail.get((Serializable)idModeloEmail);
        Date data = new Date();
        List<RelacionamentoPessoaAgEmailLog> relacionamentos = this.getLogsToSend(data);
        for (RelacionamentoPessoaAgEmailLog rel : relacionamentos) {
            OpcoesRelacionamento op = this.getOpcoesRelacionamento(rel.getRelacionamentoPessoaAgEmail().getRelacionamentoPessoa().getEmpresa());
            if (serv == null) {
                serv = op.getServidorEmailMarketing();
            }
            if (mod == null) {
                mod = op.getModeloAgendamentoRel();
            }
            HashSet<String> dest = new HashSet<String>();
            dest.add(rel.getRelacionamentoPessoaAgEmail().getDestinatarios());
            Email em = CompEmailBuilderRelPessoa.get().criarEmail(rel.getRelacionamentoPessoaAgEmail().getRelacionamentoPessoa(), mod, serv, op, dest);
            try {
                ToolSendEmail.sendEmailWithException((Email)em);
                this.result.addDet(EnumConstantsTaskResult.RESULT_OK, "Relacionamento enviado " + String.valueOf(rel));
            }
            catch (ExceptionEmail e) {
                this.logger.error((Throwable)e);
                this.result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "Erro ao enviar o relacionamento " + String.valueOf(rel) + ", erro: " + e.getMessage());
            }
            rel.setDataEnvio(new Date());
            rel.setDestinatarios(rel.getRelacionamentoPessoaAgEmail().getDestinatarios());
            this.serviceRelacionamentoPessoaAgEmailLog.saveOrUpdate((InterfaceVO)rel);
            if (EnumConstRelPessoaTpRepEnvioAuto.NAO_REPETIR.getValue() == rel.getRelacionamentoPessoaAgEmail().getTipoRepeticaoEnvio().shortValue()) continue;
            RelacionamentoPessoaAgEmailLog log = new RelacionamentoPessoaAgEmailLog();
            log.setDataEnvio(null);
            log.setDestinatarios(rel.getRelacionamentoPessoaAgEmail().getDestinatarios());
            log.setRelacionamentoPessoaAgEmail(rel.getRelacionamentoPessoaAgEmail());
            log.setDataProximoEnvio(ToolDate.nextDays((Date)data, (int)this.getFieldType(rel.getRelacionamentoPessoaAgEmail().getTipoRepeticaoEnvio()), (int)rel.getRelacionamentoPessoaAgEmail().getNumeroCicloEnvio().shortValue()));
            this.serviceRelacionamentoPessoaAgEmailLog.saveOrUpdate((InterfaceVO)log);
        }
    }

    private List<RelacionamentoPessoaAgEmailLog> getLogsToSend(Date data) {
        List<RelacionamentoPessoaAgEmail> agendamentosSemLog = this.daoTaskEnvioEmail.getRelacionamentosAptosEnvio(data);
        List<RelacionamentoPessoaAgEmailLog> agendamentoscomLog = this.daoTaskEnvioEmail.getRelacionamentosAptosEnvioLog(data);
        for (RelacionamentoPessoaAgEmail aux : agendamentosSemLog) {
            RelacionamentoPessoaAgEmailLog r = new RelacionamentoPessoaAgEmailLog();
            r.setDataEnvio(null);
            r.setDataProximoEnvio(data);
            r.setDestinatarios(aux.getDestinatarios());
            r.setRelacionamentoPessoaAgEmail(aux);
            r = (RelacionamentoPessoaAgEmailLog)this.serviceRelacionamentoPessoaAgEmailLog.saveOrUpdate((InterfaceVO)r);
            agendamentoscomLog.add(r);
        }
        return agendamentoscomLog;
    }

    private int getFieldType(Short tipoRepeticaoEnvio) {
        EnumConstRelPessoaTpRepEnvioAuto tipo = EnumConstRelPessoaTpRepEnvioAuto.get((Object)tipoRepeticaoEnvio);
        switch (tipo) {
            case HORA: {
                return 10;
            }
            case MES: {
                return 2;
            }
            case DIA: {
                return 5;
            }
            case ANO: {
                return 1;
            }
        }
        throw new ExceptionErroProgramacao("Tipo Envio de relacionamentos nao definido");
    }

    private OpcoesRelacionamento getOpcoesRelacionamento(Empresa empresa) {
        OpcoesRelacionamento op = this.hashOpcoes.get(empresa);
        if (op == null) {
            op = this.serviceOpcoesRelacionamento.get(empresa);
            this.hashOpcoes.put(empresa, op);
        }
        return op;
    }
}

