/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.enviobis;

import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.EnvioEmailBI;
import com.touchcomp.basementor.model.vo.EnvioMensagens;
import com.touchcomp.basementor.model.vo.LogEnvioEmailBI;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.enviomensagens.ServiceBuildMensagensImpl;
import com.touchcomp.basementorservice.service.impl.enviomensagens.ServiceEnviarMensagensImpl;
import com.touchcomp.basementorservice.service.impl.enviomensagens.ServiceEnvioMensagensImpl;
import com.touchcomp.basementorservice.service.impl.logenvioemailbi.ServiceLogEnvioEmailBIImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceEnvioEmailBI;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServiceTASKEnvioBIImpl
extends ServiceGenericImpl {
    private final ServiceEnvioEmailBI serviceEnvioEmailBI;
    private final ServiceLogEnvioEmailBIImpl serviceLogEnvioEmailBI;
    private final ServiceBuildMensagensImpl serviceBuildMensagensImpl;
    private final ServiceEnviarMensagensImpl serviceEnviarMensagensImpl;
    private final ServiceEnvioMensagensImpl serviceEnvioMensagensImpl;
    private final TLogger logger = TLogger.get(((Object)((Object)this)).getClass());

    public ServiceTASKEnvioBIImpl(ServiceEnvioEmailBI serviceEnvioEmailBI, ServiceLogEnvioEmailBIImpl serviceLogEnvioEmailBI, ServiceBuildMensagensImpl serviceBuildMensagensImpl, ServiceEnviarMensagensImpl serviceEnviarMensagensImpl, ServiceEnvioMensagensImpl serviceEnvioMensagensImpl) {
        this.serviceEnvioEmailBI = serviceEnvioEmailBI;
        this.serviceLogEnvioEmailBI = serviceLogEnvioEmailBI;
        this.serviceBuildMensagensImpl = serviceBuildMensagensImpl;
        this.serviceEnviarMensagensImpl = serviceEnviarMensagensImpl;
        this.serviceEnvioMensagensImpl = serviceEnvioMensagensImpl;
    }

    public void consultarEnviarBIs(TaskProcessResult result) throws ExceptionBuildBI {
        List logs = this.serviceEnvioEmailBI.getEnviosEmailBIPendentes();
        this.sendBIInternal(logs, false, result);
    }

    public void enviarBIEmail(Long idEnvioBI, TaskProcessResult result) throws ExceptionBuildBI {
        this.enviarBIEmail((EnvioEmailBI)this.serviceEnvioEmailBI.get((Serializable)idEnvioBI), result);
    }

    public void enviarBIEmail(EnvioEmailBI envio, TaskProcessResult result) throws ExceptionBuildBI {
        this.sendBIInternal(Arrays.asList(envio), true, result);
    }

    public void sendBIInternal(List<EnvioEmailBI> envioEmaisBI, boolean throwEX, TaskProcessResult result) throws ExceptionBuildBI {
        for (EnvioEmailBI l : envioEmaisBI) {
            try {
                EnvioMensagens envio = this.serviceBuildMensagensImpl.buildEnvioMensagens(l.getModeloEnvioMensagens());
                envio = (EnvioMensagens)this.serviceEnvioMensagensImpl.saveOrUpdateFlush((InterfaceVO)envio);
                this.serviceEnviarMensagensImpl.enviarMensagens(envio);
                this.saveLogs(l);
                if (TMethods.isAffirmative((Number)envio.getTodasMsgEnviadas())) {
                    result.addDet(EnumConstantsTaskResult.RESULT_OK, "Contrucao de BI para envio realizado com sucesso. " + l.getIdentificador() + "/" + String.valueOf(l.getModeloEnvioMensagens()));
                    continue;
                }
                result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "Nao foi possivel enviar todas as mensagens. Confira o envio de mensagens. " + String.valueOf(envio));
            }
            catch (ExceptionBuildBI | ExceptionInvalidData | ExceptionInvalidState | ExceptionIO | ExceptionReflection ex) {
                this.logger.error(ex.getClass(), ex);
                result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "Erro ao construir BI referente ao envio: " + l.getIdentificador() + "/" + String.valueOf(l.getModeloEnvioMensagens()));
                if (!throwEX) continue;
                throw new ExceptionBuildBI("E.TSK.000001", ex, new Object[]{l});
            }
        }
    }

    private void saveLogs(EnvioEmailBI envioEmailBusinessIntelligence) {
        LogEnvioEmailBI log = new LogEnvioEmailBI();
        log.setEnvioEmailBI(envioEmailBusinessIntelligence);
        log.setDataHoraEnvio(new Date());
        log.setDataProximoEnvio(this.getDataProximoEnvio(log, envioEmailBusinessIntelligence));
        log.setDescricao("Envio de BI em " + ToolDate.dateToStr((Date)log.getDataHoraEnvio(), (String)"dd/MM/yyyy hh:mm:ss"));
        this.serviceLogEnvioEmailBI.saveOrUpdate((InterfaceVO)log);
    }

    private Date getDataProximoEnvio(LogEnvioEmailBI log, EnvioEmailBI envioEmailBusinessIntelligence) {
        Date next = log.getDataHoraEnvio();
        if (ToolMethods.isStrWithData((String)envioEmailBusinessIntelligence.getIntervalo()) && !ToolString.stringIsANumber((String)envioEmailBusinessIntelligence.getIntervalo()).booleanValue()) {
            next = ToolDate.nextDateCronExp((String)envioEmailBusinessIntelligence.getIntervalo(), (Date)next);
        } else {
            Double intervalo = Double.valueOf(envioEmailBusinessIntelligence.getIntervalo());
            next = ToolDate.nextDays((Date)next, (double)intervalo);
        }
        log.setDataProximoEnvio(next);
        return next;
    }
}

