/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.geracaoarquivosbi;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.constants.enums.geracaoarquivosbi.ConstEnumGeracaoArquivosBI;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GeracaoArquivosBI;
import com.touchcomp.basementor.model.vo.GeracaoArquivosBIItem;
import com.touchcomp.basementor.model.vo.LogGeracaoArquivosBI;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.ServiceBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementorservice.service.impl.geracaoarquivosbi.ServiceGeracaoArquivosBIImpl;
import com.touchcomp.basementorservice.service.impl.loggeracaoarquivosbi.ServiceLogGeracaoArquivosBIImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.converter.CompRestrictionsFactory;
import com.touchcomp.basementortools.tools.converter.impl.OpFinder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.stringformat.ToolStringFormater;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AuxGeracaoArquivosBIs {
    private final ServiceGeracaoArquivosBIImpl serviceGeracaoArquivosBI;
    private final ServiceLogGeracaoArquivosBIImpl serviceLogGeracaoArquivosBI;
    private final CompBIDefaultParams compBIDefaultParams;
    private final TLogger logger = TLogger.get(this.getClass());
    private TaskProcessResult result;

    public AuxGeracaoArquivosBIs(ServiceGeracaoArquivosBIImpl serviceGeracaoArquivosBI, ServiceLogGeracaoArquivosBIImpl serviceLogGeracaoArquivosBI, CompBIDefaultParams compBIDefaultParams, TaskProcessResult result) {
        this.serviceGeracaoArquivosBI = serviceGeracaoArquivosBI;
        this.serviceLogGeracaoArquivosBI = serviceLogGeracaoArquivosBI;
        this.compBIDefaultParams = compBIDefaultParams;
        this.result = result;
    }

    public AuxGeracaoArquivosBIs(ServiceGeracaoArquivosBIImpl serviceGeracaoArquivosBI, ServiceLogGeracaoArquivosBIImpl serviceLogGeracaoArquivosBI, CompBIDefaultParams compBIDefaultParams) {
        this.serviceGeracaoArquivosBI = serviceGeracaoArquivosBI;
        this.serviceLogGeracaoArquivosBI = serviceLogGeracaoArquivosBI;
        this.compBIDefaultParams = compBIDefaultParams;
    }

    public void buildBI() throws ExceptionBuildBI, ExceptionIO {
        List<GeracaoArquivosBI> logs = this.getLogsBI();
        this.buildBIInternal(logs, false);
    }

    public void buildBIInternal(List<GeracaoArquivosBI> logs, boolean throwEX) throws ExceptionBuildBI, ExceptionIO {
        for (GeracaoArquivosBI l : logs) {
            block4: {
                try {
                    this.buildFilesBisInternos(l);
                    this.addDet(EnumConstantsTaskResult.RESULT_OK, "Construcao de BI para envio realizado com sucesso. " + l.getIdentificador() + "/" + l.getDescricao());
                }
                catch (ExceptionBuildBI | ExceptionIO ex) {
                    this.logger.error(ex.getClass(), ex);
                    if (this.result != null) {
                        this.result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "Erro ao construir BI referente ao envio: " + l.getIdentificador() + "/" + l.getDescricao() + ": " + ex.getFormattedMessage());
                    }
                    if (!throwEX) break block4;
                    throw new ExceptionBuildBI(ex.getErrorCode(), ex, new Object[0]);
                }
            }
            System.out.println("salvando log para: " + l.getIdentificador());
            this.saveLogs(l);
        }
    }

    private void buildFilesBisInternos(GeracaoArquivosBI l) throws ExceptionBuildBI, ExceptionIO {
        if (l.getFormaConstrucao() == ConstEnumGeracaoArquivosBI.GERAR_BI_SELECIONADOS.value) {
            this.gerarArquivosItens(l, null);
        } else if (l.getFormaConstrucao() == ConstEnumGeracaoArquivosBI.GERAR_BI_FILTROS.value) {
            this.gerarArquivosItens(l);
        } else {
            throw new ExceptionErroProgramacao("Tipo geracao de arquivo nao implementado.");
        }
    }

    private void gerarArquivosItens(GeracaoArquivosBI l, DefaultBIParamsMap<String, Object> params) throws ExceptionBuildBI, ExceptionIO {
        DefaultBIParamsMap<String, Object> paramsFormatted = this.prepareParamsFormatted(params);
        for (GeracaoArquivosBIItem i : l.getItensEnvio()) {
            if (i.getFormatoGeracao() == null) continue;
            BusinessIntelligence bi = i.getBusinessIntelligence();
            this.compBIDefaultParams.buildDefValuesParams(bi, params);
            DataOutputBI out = ((ServiceBuildBusinessIntelligenceImpl)ConfApplicationContext.getBean(ServiceBuildBusinessIntelligenceImpl.class)).gerarConverterFormatoImpBI(bi, ConstEnumFormImprBI.valueOfByValue((Number)i.getFormatoGeracao().getFormatoGeracaoBI().getTipo().intValue()), EnumConstTipoSistema.WEB, paramsFormatted);
            File in = out.getFile();
            String fileName = i.getNomeArquivo();
            String caminho = i.getCaminhoArquivo();
            caminho = ToolStringFormater.formatObj((String)caminho, paramsFormatted);
            fileName = ToolStringFormater.formatObj((String)fileName, paramsFormatted);
            File dir = new File(caminho);
            dir.mkdirs();
            File outFile = new File(caminho + File.separator + fileName);
            System.out.println("Arquivo " + outFile.getAbsolutePath());
            ToolFile.moveRenameFile((File)in, (File)outFile);
            System.out.println("Arquivo gerado com sucesso: " + outFile.getAbsolutePath());
        }
    }

    private DefaultBIParamsMap<String, Object> prepareParamsFormatted(DefaultBIParamsMap<String, Object> params) {
        DefaultBIParamsMap temp = new DefaultBIParamsMap();
        if (params == null) {
            return temp;
        }
        Set keys = params.keySet();
        for (String k : keys) {
            Object found = params.get((Object)k);
            if (found != null) {
                OpFinder op = CompRestrictionsFactory.getRestrictions(found.getClass(), (String)"dd_MM_yyyy");
                if (found instanceof ArrayList) continue;
                temp.put((Object)k, (Object)op.convertValueToString(found));
                continue;
            }
            temp.put((Object)k, null);
        }
        return temp;
    }

    private void gerarArquivosItens(GeracaoArquivosBI l) throws ExceptionBuildBI, ExceptionIO {
        DataResultBI out = ((ServiceBuildBusinessIntelligenceImpl)ConfApplicationContext.getBean(ServiceBuildBusinessIntelligenceImpl.class)).gerarBI(l.getBusinessIntelligence(), EnumConstTipoSistema.WEB, CompBIDefaultParams.getDefParamsMap((Empresa)l.getEmpresa(), null, null, (Object[])new Object[0]));
        this.gerarArquivosListItens(l, out.getData());
    }

    public void gerarArquivosListItens(GeracaoArquivosBI l, List<Map> dados) throws ExceptionBuildBI, ExceptionIO {
        for (Map m : dados) {
            DefaultBIParamsMap temp = new DefaultBIParamsMap(m);
            this.gerarArquivosItens(l, (DefaultBIParamsMap<String, Object>)temp);
        }
    }

    private List<GeracaoArquivosBI> getLogsBI() {
        return this.serviceGeracaoArquivosBI.getGeracaoArquivosBIPendentes();
    }

    private void saveLogs(GeracaoArquivosBI geracaoArquivoBI) {
        LogGeracaoArquivosBI log = new LogGeracaoArquivosBI();
        log.setGeracaoArquivosBI(geracaoArquivoBI);
        log.setDataHoraEnvio(new Date());
        log.setDataProximoEnvio(ToolDate.nextDays((Date)log.getDataHoraEnvio(), (double)geracaoArquivoBI.getIntervaloConstrucaoHoras()));
        if (geracaoArquivoBI.getConstruirSempreMesmaHora() != null && geracaoArquivoBI.getConstruirSempreMesmaHora() == 1) {
            GregorianCalendar g = new GregorianCalendar();
            g.setTime(geracaoArquivoBI.getDataInicial());
            GregorianCalendar g1 = new GregorianCalendar();
            g1.setTime(log.getDataProximoEnvio());
            g1.set(11, g.get(11));
            g1.set(12, g.get(12));
            g1.set(13, g.get(13));
            log.setDataProximoEnvio(g1.getTime());
        }
        log.setDescricao("Geracao de Arquivos BI em " + ToolDate.dateToStr((Date)log.getDataHoraEnvio(), (String)"dd/MM/yyyy hh:mm:ss"));
        this.serviceLogGeracaoArquivosBI.saveOrUpdate((InterfaceVO)log);
    }

    private void addDet(EnumConstantsTaskResult enumConstantsTaskResult, String string) {
        if (this.result != null) {
            this.result.addDet(enumConstantsTaskResult, string);
        }
    }
}

