/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.geracaoarquivotabelapreco;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.constants.enums.situacaodocumento.EnumConstSituacaoDocumento;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutosSimilaresItens;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseUF;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeFederativaOrigDest;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.calculoimpostos.CalculosImpFiscaisNotaPropria;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.dao.impl.DaoUnidadeFederativaOrigDestImpl;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperItemNotaPropria;
import com.touchcomp.basementorservice.helpers.impl.unidadefatcliente.HelperUnidadeFatCliente;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalImpl;
import com.touchcomp.basementorservice.service.impl.naturezaoperacao.ServiceNaturezaOperacaoImpl;
import com.touchcomp.basementorservice.service.impl.opcoesimpostos.ServiceOpcoesImpostosImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceCfop;
import com.touchcomp.basementorservice.service.interfaces.ServiceEmpresa;
import com.touchcomp.basementorservice.service.interfaces.ServiceEmpresaContabilidade;
import com.touchcomp.basementorservice.service.interfaces.ServiceGradeCor;
import com.touchcomp.basementorservice.service.interfaces.ServiceNotaFiscalPropria;
import com.touchcomp.basementorservice.service.interfaces.ServiceNotaFiscalTerceiros;
import com.touchcomp.basementorservice.service.interfaces.ServiceOpcoesFaturamento;
import com.touchcomp.basementorservice.service.interfaces.ServiceSaldoEstoque;
import com.touchcomp.basementorservice.service.interfaces.ServiceSituacaoDocumento;
import com.touchcomp.basementorservice.service.interfaces.ServiceUnidadeFatCliente;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.ftp.ToolFTP;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorwebtasks.service.impl.geracaoarquivotabelapreco.model.ProdutoXML;
import com.touchcomp.basementorwebtasks.service.impl.geracaoarquivotabelapreco.model.ProdutoXMLGrades;
import com.touchcomp.basementorwebtasks.service.impl.geracaoarquivotabelapreco.model.ProdutoXMLPrecos;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class AuxGeracaoArquivoXMLTabelaPreco {
    private ServiceNotaFiscalPropria serviceNotaPropria = (ServiceNotaFiscalPropria)ConfApplicationContext.getBean(ServiceNotaFiscalPropria.class);
    private ServiceNotaFiscalTerceiros serviceNotaTerceiros = (ServiceNotaFiscalTerceiros)ConfApplicationContext.getBean(ServiceNotaFiscalTerceiros.class);
    private ServiceTabelaPrecoBaseImpl serviceTabelaPrecoBase = (ServiceTabelaPrecoBaseImpl)ConfApplicationContext.getBean(ServiceTabelaPrecoBaseImpl.class);
    private ServiceSaldoEstoque serviceSaldoEstoque = (ServiceSaldoEstoque)ConfApplicationContext.getBean(ServiceSaldoEstoque.class);
    private ServiceGradeCor serviceGradeCor = (ServiceGradeCor)ConfApplicationContext.getBean(ServiceGradeCor.class);
    private ServiceUnidadeFatCliente serviceUnidadeFatCliente = (ServiceUnidadeFatCliente)ConfApplicationContext.getBean(ServiceUnidadeFatCliente.class);
    private ServiceCfop serviceCfop = (ServiceCfop)ConfApplicationContext.getBean(ServiceCfop.class);
    private ServiceModeloFiscalImpl serviceModeloFiscal = (ServiceModeloFiscalImpl)ConfApplicationContext.getBean(ServiceModeloFiscalImpl.class);
    private ServiceSituacaoDocumento serviceSituacaoDocumento = (ServiceSituacaoDocumento)ConfApplicationContext.getBean(ServiceSituacaoDocumento.class);
    private ServiceEmpresa serviceEmpresa = (ServiceEmpresa)ConfApplicationContext.getBean(ServiceEmpresa.class);
    private ServiceNaturezaOperacaoImpl serviceNaturezaOperacao = (ServiceNaturezaOperacaoImpl)ConfApplicationContext.getBean(ServiceNaturezaOperacaoImpl.class);
    private ServiceOpcoesFaturamento serviceOpcoesFaturamento = (ServiceOpcoesFaturamento)ConfApplicationContext.getBean(ServiceOpcoesFaturamento.class);
    private ServiceOpcoesImpostosImpl serviceOpcoesImposto = (ServiceOpcoesImpostosImpl)ConfApplicationContext.getBean(ServiceOpcoesImpostosImpl.class);
    private ServiceEmpresaContabilidade serviceEmpresaContabilidade = (ServiceEmpresaContabilidade)ConfApplicationContext.getBean(ServiceEmpresaContabilidade.class);
    private DaoUnidadeFederativaOrigDestImpl daoUnidadeFederativaOrigDest = (DaoUnidadeFederativaOrigDestImpl)ConfApplicationContext.getBean(DaoUnidadeFederativaOrigDestImpl.class);
    private HashMap hash = new HashMap();
    private final TLogger logger = TLogger.get(this.getClass());

    public boolean gerarArquivoXMLTabelaPreco(String caminhoArquivo, String idsTabelaPreco, Long idEmpresa, Long idNaturezaOperacao, List<Long> idsCentroEstoque, String diretorioFTP, String caminhoFTP, String loginFTP, String senhaFTP, Short gerarArquivoCompleto) throws ExceptionJDom, ExceptionIO {
        Empresa empresa = this.getEmpresa(idEmpresa);
        OpcoesFaturamento opcoesFaturamento = this.getOpcoesFaturamento(empresa);
        OpcoesImpostos opcoesImposto = this.getOpcoesImposto(empresa);
        EmpresaContabilidade empresaContabilidade = this.getEmpresaContabilidade(empresa);
        NaturezaOperacao naturezaOperacao = this.getNaturezaOperacao(idNaturezaOperacao);
        Date dataUltimaAtualizacao = this.getUltimaAtualizacao();
        String[] tabelas = idsTabelaPreco.split(";");
        ArrayList<ProdutoXML> produtosXML = new ArrayList<ProdutoXML>();
        int countTabela = 1;
        for (String idTabela : tabelas) {
            TabelaPrecoBase tabela = this.getTabelaPrecoBase(Long.valueOf(idTabela));
            List<TabelaPrecoBaseProduto> produtos = this.getProdutosAtualizados(tabela, dataUltimaAtualizacao, idEmpresa, gerarArquivoCompleto);
            this.setClientesPorUF(tabela);
            int count = 1;
            for (TabelaPrecoBaseProduto tabProd : produtos) {
                if (count >= 100000) continue;
                Produto produto = tabProd.getProduto();
                ProdutoXML p = null;
                Boolean achou = false;
                for (ProdutoXML produtoXML : produtosXML) {
                    if (!produtoXML.getIdentificador().equals(tabProd.getProduto().getIdentificador())) continue;
                    p = produtoXML;
                    achou = true;
                    System.out.println("\nCONTADOR TABELA: " + countTabela + " CONTADOR PRODUTOS: " + count + " ID PRODUTO: " + produto.getIdentificador());
                    ++count;
                    break;
                }
                if (!achou.booleanValue()) {
                    System.out.println("\nCONTADOR TABELA: " + countTabela + " CONTADOR PRODUTOS: " + count + " ID PRODUTO: " + produto.getIdentificador());
                    ++count;
                    p = new ProdutoXML();
                    p.setIdentificador(produto.getIdentificador());
                    p.setCodigoAuxiliar(produto.getCodigoAuxiliar());
                    p.setNome(TString.removeIllegalXMLChar((String)produto.getNome().trim()));
                    p.setUnidadeMedida(produto.getUnidadeMedida().getSigla());
                    p.setPeso(produto.getPesoUnitario());
                    p.setEspecie(this.getDescricaoProdutosSimilares(produto));
                    p.setSubEspecie(TString.removeIllegalXMLChar((String)produto.getSubEspecie().getNome().trim()));
                    this.setEstoqueProduto(produto, p, idEmpresa, idsCentroEstoque);
                    produtosXML.add(p);
                }
                this.setPrecos(produto, p, tabela, tabProd, naturezaOperacao, empresa, empresaContabilidade, opcoesFaturamento, opcoesImposto);
            }
            ++countTabela;
        }
        System.out.println("\nGerando o arquivo");
        this.gerarArquivoXML(produtosXML, caminhoArquivo, diretorioFTP, caminhoFTP, loginFTP, senhaFTP);
        Object idsStr = "";
        for (Long long1 : idsCentroEstoque) {
            idsStr = (String)idsStr + long1 + ";";
        }
        this.updateDataUltimaSincronizacao(idNaturezaOperacao.toString(), (String)idsStr, idsTabelaPreco);
        return true;
    }

    private TabelaPrecoBase getTabelaPrecoBase(Long idTabelaPreco) {
        return (TabelaPrecoBase)this.serviceTabelaPrecoBase.get((Serializable)idTabelaPreco);
    }

    private Date getUltimaAtualizacao() {
        HashMap hash = this.serviceTabelaPrecoBase.findDataUltimaGeracaoArquivoXML();
        if (hash != null) {
            return (Date)hash.get("DATA");
        }
        return null;
    }

    private List<TabelaPrecoBaseProduto> getProdutosAtualizados(TabelaPrecoBase tabela, Date dataUltimaAtualizacao, Long idEmpresa, Short gerarArquivoCompleto) {
        ArrayList<TabelaPrecoBaseProduto> produtos = new ArrayList<TabelaPrecoBaseProduto>();
        for (TabelaPrecoBaseProduto p : tabela.getProdutos()) {
            if (dataUltimaAtualizacao != null && !p.getDataAtualizacao().after(dataUltimaAtualizacao) && !ToolMethods.isEquals((Object)gerarArquivoCompleto, (Object)1) || !p.getAtivo().equals((short)1) || !p.getProduto().getAtivo().equals((short)1)) continue;
            produtos.add(p);
        }
        if (dataUltimaAtualizacao != null || !ToolMethods.isEquals((Object)gerarArquivoCompleto, (Object)1)) {
            ArrayList<? extends Produto> produtosNotas = new ArrayList<Produto>();
            produtosNotas.addAll(this.getProdutosNotaPropria(dataUltimaAtualizacao));
            produtosNotas.addAll(this.getProdutosNotaTerceiros(dataUltimaAtualizacao));
            produtosNotas.addAll(this.getProdutosTransferencia(dataUltimaAtualizacao));
            block1: for (Produto produto : produtosNotas) {
                for (TabelaPrecoBaseProduto tabProd : tabela.getProdutos()) {
                    if (!tabProd.getProduto().equals((Object)produto)) continue;
                    if (produtos.contains(tabProd)) continue block1;
                    produtos.add(tabProd);
                    continue block1;
                }
            }
        }
        return produtos;
    }

    private void setEstoqueProduto(Produto produto, ProdutoXML produtoXML, Long idEmpresa, List<Long> idsCentroEstoque) {
        HashMap<Long, ProdutoXMLGrades> dados = new HashMap<Long, ProdutoXMLGrades>();
        Double quantidadeTotal = 0.0;
        for (Long idCentroEstoque : idsCentroEstoque) {
            List lista = this.serviceSaldoEstoque.findSaldoIdGradeCorCentroEstoqueLista(produto.getIdentificador(), produto.getIdentificador(), null, null, new Date(), idEmpresa, idEmpresa, idCentroEstoque, idCentroEstoque, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_CENTRO_ESTOQUE, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
            for (SaldoEstoqueGeralBasico saldo : lista) {
                if (ToolMethods.isNull(dados.get(saldo.getIdGradeCor())).booleanValue()) {
                    GradeCor gradeCor = (GradeCor)this.serviceGradeCor.get((Serializable)saldo.getIdGradeCor());
                    ProdutoXMLGrades pg = new ProdutoXMLGrades();
                    pg.setIdGrade(gradeCor.getIdentificador());
                    pg.setQuantidade(saldo.getQuantidade());
                    pg.setIdCor(gradeCor.getCor().getIdentificador());
                    pg.setNomeCor(TString.removeIllegalXMLChar((String)gradeCor.getCor().getNome().trim()));
                    produtoXML.getGrades().add(pg);
                    dados.put(saldo.getIdGradeCor(), pg);
                } else {
                    ProdutoXMLGrades pg = (ProdutoXMLGrades)dados.get(saldo.getIdGradeCor());
                    pg.setQuantidade(saldo.getQuantidade() + pg.getQuantidade());
                }
                quantidadeTotal = quantidadeTotal + saldo.getQuantidade();
            }
        }
        produtoXML.setQuantidadeTotal(quantidadeTotal);
    }

    private void setPrecos(Produto prod, ProdutoXML p, TabelaPrecoBase tabela, TabelaPrecoBaseProduto tabProduto, NaturezaOperacao naturezaOperacao, Empresa empresa, EmpresaContabilidade empresaContabilidade, OpcoesFaturamento opcoesFaturamento, OpcoesImpostos opImpostos) {
        tabela.getUfs().stream().filter(uf -> uf.getAtivo().equals((short)1)).forEachOrdered(itemUF -> {
            UnidadeFatCliente unid = (UnidadeFatCliente)this.hash.get(itemUF.getUnidadeFederativa());
            if (unid != null) {
                ModeloFiscal mod = this.findModeloFiscal(prod, naturezaOperacao, unid, empresa);
                if (mod != null) {
                    try {
                        ItemNotaFiscalPropria it = new ItemNotaFiscalPropria();
                        ItemNotaLivroFiscal il = new ItemNotaLivroFiscal();
                        il.setItemNotaFiscalPropria(it);
                        it.setItemNotaLivroFiscal(il);
                        it.setModeloFiscal(mod);
                        it.setProduto(prod);
                        it.setQuantidadeTotal(Double.valueOf(1.0));
                        it.setValorUnitario(tabProduto.getValorVenda());
                        it.setVrProduto(tabProduto.getValorVenda());
                        it.setPercDesconto(Double.valueOf(0.0));
                        it.setTipoDesconto(Short.valueOf((short)0));
                        it.setIncidenciaIcms(mod.getModeloFiscalIcms().getIncidenciaIcms());
                        it.setIncidenciaIpi(mod.getModeloFiscalIpi().getIncidenciaIpi());
                        it.setIncidenciaPisCofins(mod.getModeloFiscalPisCofins().getIncidenciaPisCofins());
                        it.setModalidadeIcms(mod.getModeloFiscalIcms().getModalidadeIcms());
                        it.setModalidadeIcmsSt(mod.getModeloFiscalIcms().getModalidadeIcmsSt());
                        it.setIssRetido(Short.valueOf(mod.getIssRetido().equals((short)1) ? (short)1 : (short)0));
                        if (naturezaOperacao.getEntradaSaida() == 1) {
                            it.getItemNotaLivroFiscal().setCfop(this.serviceCfop.findCfopSaida(empresa.getPessoa().getEndereco().getCidade().getUf(), unid.getPessoa().getEndereco().getCidade().getUf(), mod, EnumConstNFeIndicadorPresConsumidor.valueOfCodigo((Short)unid.getCliente().getFaturamento().getTipoConsumidor())));
                        } else {
                            it.getItemNotaLivroFiscal().setCfop(this.serviceCfop.findCfopEntrada(empresa.getPessoa().getEndereco().getCidade().getUf(), unid.getPessoa().getEndereco().getCidade().getUf(), mod));
                        }
                        if (mod.getTipoIRRF() != null && mod.getTipoIRRF() == 1) {
                            it.getItemNotaLivroFiscal().setAliquotaIrrf(prod.getAliquotaIrrf());
                            it.getItemNotaLivroFiscal().setPercRedIrrf(prod.getPercRedIrrf());
                        }
                        if (mod.getTipoFunrural() != null && mod.getTipoFunrural() == 1) {
                            it.getItemNotaLivroFiscal().setAliquotaFunrural(prod.getAliquotaFunrural());
                            it.getItemNotaLivroFiscal().setPercRedFunrural(prod.getPercRedFunrural());
                        }
                        if (mod.getTipoLei10833() != null && mod.getTipoLei10833() == 1) {
                            it.getItemNotaLivroFiscal().setAliquotaLei10833(prod.getAliquotaLei10833());
                            it.getItemNotaLivroFiscal().setPercRedLei10833(prod.getPercRedLei10833());
                        }
                        if (mod.getTipoOutros() != null && mod.getTipoOutros() == 1) {
                            it.getItemNotaLivroFiscal().setAliquotaOutros(prod.getAliquotaOutros());
                            it.getItemNotaLivroFiscal().setPercRedOutros(prod.getPercRedOutros());
                        }
                        if (mod.getTipoContSoc() != null && mod.getTipoContSoc() == 1) {
                            it.getItemNotaLivroFiscal().setAliquotaContSoc(prod.getAliquotaContSoc());
                            it.getItemNotaLivroFiscal().setPercRedContSoc(prod.getPercRedContSoc());
                        }
                        if (mod.getModeloFiscalPisCofins().getCalcularPisNormal().equals((short)1)) {
                            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                                it.getItemNotaLivroFiscal().setAliquotaPis(mod.getModeloFiscalPisCofins().getAliquotaPis());
                            } else {
                                it.getItemNotaLivroFiscal().setAliquotaPis(it.getProduto().getAliquotaPis());
                            }
                        } else {
                            it.getItemNotaLivroFiscal().setAliquotaPis(Double.valueOf(0.0));
                        }
                        if (mod.getModeloFiscalPisCofins().getCalcularPisSt().equals((short)1)) {
                            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                                it.getItemNotaLivroFiscal().setAliquotaPisSt(mod.getModeloFiscalPisCofins().getAliquotaPisSt());
                            } else {
                                it.getItemNotaLivroFiscal().setAliquotaPisSt(it.getProduto().getAliquotaPisSt());
                            }
                        } else {
                            it.getItemNotaLivroFiscal().setAliquotaPisSt(Double.valueOf(0.0));
                        }
                        if (mod.getModeloFiscalPisCofins().getCalcularCofinsNormal().equals((short)1)) {
                            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                                it.getItemNotaLivroFiscal().setAliquotaCofins(mod.getModeloFiscalPisCofins().getAliquotaCofins());
                            } else {
                                it.getItemNotaLivroFiscal().setAliquotaCofins(it.getProduto().getAliquotaCofins());
                            }
                        } else {
                            it.getItemNotaLivroFiscal().setAliquotaCofins(Double.valueOf(0.0));
                        }
                        if (mod.getModeloFiscalPisCofins().getCalcularCofinsSt().equals((short)1)) {
                            if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                                it.getItemNotaLivroFiscal().setAliquotaCofinsSt(mod.getModeloFiscalPisCofins().getAliquotaCofinsSt());
                            } else {
                                it.getItemNotaLivroFiscal().setAliquotaCofinsSt(it.getProduto().getAliquotaCofinsSt());
                            }
                        } else {
                            it.getItemNotaLivroFiscal().setAliquotaCofinsSt(Double.valueOf(0.0));
                        }
                        double alICMS = 0.0;
                        alICMS = mod.getModeloFiscalIcms().getTipoAliquotaIcms() == 2 ? mod.getModeloFiscalIcms().getAliquotaIcms().doubleValue() : this.getAliquotaICMS(empresa.getPessoa().getEndereco().getCidade().getUf(), unid.getCliente().getPessoa().getEndereco().getCidade().getUf(), prod).doubleValue();
                        it.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(alICMS));
                        if (ToolMethods.isEquals((Object)mod.getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
                            it.getItemNotaLivroFiscal().setPercReducaoBCIcms(mod.getModeloFiscalIcms().getReducaoBaseCalcIcms());
                        } else {
                            it.getItemNotaLivroFiscal().setPercReducaoBCIcms(prod.getReducaoBaseCalcIcms());
                        }
                        Double aliqIpi = BaseCalculoValores.getAliquotaIpi((Produto)prod, (ModeloFiscalIpi)mod.getModeloFiscalIpi());
                        it.getItemNotaLivroFiscal().setAliquotaIpi(aliqIpi);
                        if (mod.getTipoINSS() != null && mod.getTipoINSS() == 1) {
                            it.getItemNotaLivroFiscal().setAliquotaInss(prod.getAliquotaInss());
                            it.getItemNotaLivroFiscal().setPercRedBcInss(prod.getPercRedBCINSS());
                        }
                        new HelperItemNotaPropria().setParamTribAndParametrosCBSIBSIS(it, empresa, new Date(), naturezaOperacao, unid);
                        it.setCest(it.getProduto().getCest());
                        it.setNcm(it.getProduto().getNcm());
                        new CalculosImpFiscaisNotaPropria().calcularImpostosFiscaisItNotaPropria(it, empresa.getPessoa().getEndereco().getCidade().getUf(), unid, this.getSituacaoDocumentoRegular(), empresa, unid.getCliente().getFaturamento().getTipoConsumidor(), opcoesFaturamento, new Date(), empresaContabilidade, opImpostos);
                        ProdutoXMLPrecos pr = new ProdutoXMLPrecos();
                        pr.setUf(itemUF.getUnidadeFederativa().getSigla());
                        pr.setValor(it.getItemNotaLivroFiscal().getValorTotal());
                        p.getPrecos().add(pr);
                    }
                    catch (Exception ex) {
                        ProdutoXMLPrecos pr = new ProdutoXMLPrecos();
                        pr.setUf(itemUF.getUnidadeFederativa().getSigla());
                        pr.setValor(0.0);
                        p.getPrecos().add(pr);
                    }
                }
            } else {
                ProdutoXMLPrecos pr = new ProdutoXMLPrecos();
                pr.setUf(itemUF.getUnidadeFederativa().getSigla());
                pr.setValor(0.0);
                p.getPrecos().add(pr);
            }
        });
    }

    private void setClientesPorUF(TabelaPrecoBase tabela) {
        for (TabelaPrecoBaseUF uf : tabela.getUfs()) {
            if (!uf.getAtivo().equals((short)1) || this.hash.get(uf.getUnidadeFederativa()) != null) continue;
            this.setUnidadeFatClientePorUF(uf.getUnidadeFederativa());
        }
    }

    private void setUnidadeFatClientePorUF(UnidadeFederativa uf) {
        UnidadeFatCliente unid = this.serviceUnidadeFatCliente.findFirstClienteAtivoPorUF(uf);
        this.hash.put(unid.getPessoa().getEndereco().getCidade().getUf(), unid);
        System.out.println("\nCLIENTE: UF: " + String.valueOf(unid.getPessoa().getEndereco().getCidade().getUf()) + "  NOME: " + unid.getCliente().getIdentificador() + "-" + unid.getCliente().getPessoa().getNome());
    }

    private ModeloFiscal findModeloFiscal(Produto produto, NaturezaOperacao naturezaOperacao, UnidadeFatCliente unidadeFatCliente, Empresa empresa) {
        String cnpjCPF = unidadeFatCliente.getCliente().getPessoa().getComplemento().getCnpj();
        ModeloFiscal modelo = this.serviceModeloFiscal.getFirst(produto, unidadeFatCliente.getCliente().getFaturamento().getCategoriaPessoa(), unidadeFatCliente.getPessoa().getEndereco().getCidade().getUf(), naturezaOperacao, cnpjCPF, this.getContribuinteEstado(unidadeFatCliente), unidadeFatCliente.getCliente().getPessoa().getComplemento().getHabilitarSuframa(), empresa);
        return modelo;
    }

    private Short getContribuinteEstado(UnidadeFatCliente unidade) {
        return ((HelperUnidadeFatCliente)Context.get(HelperUnidadeFatCliente.class)).build(unidade).getContribuinteEstado();
    }

    private Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, Produto prod) throws Exception {
        if (prod == null) {
            return 0.0;
        }
        if (ufDestino.equals((Object)ufOrigem)) {
            return prod.getAliquotaIcms();
        }
        return this.getAliquotaICMS(ufOrigem, ufDestino);
    }

    private Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino) throws Exception {
        UnidadeFederativaOrigDest found = this.daoUnidadeFederativaOrigDest.get(ufOrigem, ufDestino);
        if (found != null) {
            return found.getAliquotaICMS();
        }
        return 0.0;
    }

    private SituacaoDocumento getSituacaoDocumentoRegular() {
        return this.serviceSituacaoDocumento.get(EnumConstSituacaoDocumento.REGULAR);
    }

    private Empresa getEmpresa(Long idEmpresa) {
        return (Empresa)this.serviceEmpresa.get((Serializable)idEmpresa);
    }

    private NaturezaOperacao getNaturezaOperacao(Long idNaturezaOperacao) {
        return (NaturezaOperacao)this.serviceNaturezaOperacao.get((Serializable)idNaturezaOperacao);
    }

    private EmpresaContabilidade getEmpresaContabilidade(Empresa empresa) {
        return this.serviceEmpresaContabilidade.findByEmpresa(empresa);
    }

    private OpcoesFaturamento getOpcoesFaturamento(Empresa emprsea) {
        return this.serviceOpcoesFaturamento.findByEmpresa(emprsea);
    }

    private OpcoesImpostos getOpcoesImposto(Empresa empresa) {
        return this.serviceOpcoesImposto.findByGrupoEmpresa(empresa.getEmpresaDados().getGrupoEmpresa());
    }

    private void gerarArquivoXML(List<ProdutoXML> produtosXML, String caminhoArquivo, String diretorioFTP, String caminhoFTP, String loginFTP, String senhaFTP) throws ExceptionJDom, ExceptionIO {
        String xml = this.getXML(produtosXML);
        String nomeArquivo = this.getNomeArquivo();
        File file = new File(caminhoArquivo + "/" + nomeArquivo);
        ToolFile.writeStringInFile((File)file, (String)xml);
        if (diretorioFTP != null && caminhoFTP != null && loginFTP != null && senhaFTP != null) {
            String diretorio = "/arquivo_tabela_base";
            ToolFTP.useFTP((String)caminhoFTP, (String)"", (String)diretorio, (String)file.getName(), (File)file, (String)loginFTP, (String)senhaFTP);
        }
        System.out.println("XML criado com sucesso!");
    }

    private String getXML(List<ProdutoXML> produtosXML) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>");
        sb.append("<produtos>");
        for (ProdutoXML p : produtosXML) {
            sb.append("<produto>");
            sb.append("<identificador>");
            sb.append(p.getIdentificador());
            sb.append("</identificador>");
            sb.append("<codigoAuxiliar>");
            if (p.getCodigoAuxiliar() != null) {
                sb.append(p.getCodigoAuxiliar());
            }
            sb.append("</codigoAuxiliar>");
            sb.append("<nome>");
            sb.append(p.getNome());
            sb.append("</nome>");
            sb.append("<unidadeMedida>");
            sb.append(p.getUnidadeMedida());
            sb.append("</unidadeMedida>");
            sb.append("<especie>");
            sb.append(p.getEspecie());
            sb.append("</especie>");
            sb.append("<subEspecie>");
            sb.append(p.getSubEspecie());
            sb.append("</subEspecie>");
            sb.append("<peso>");
            sb.append(ToolFormatter.formataNumero((Number)p.getPeso(), (int)2));
            sb.append("</peso>");
            sb.append("<estoqueTotal>");
            sb.append(ToolFormatter.formataNumero((Number)p.getQuantidadeTotal(), (int)2));
            sb.append("</estoqueTotal>");
            sb.append("<grades>");
            for (ProdutoXMLGrades grade : p.getGrades()) {
                sb.append("<gradeProduto>");
                sb.append("<idGrade>");
                sb.append(grade.getIdGrade());
                sb.append("</idGrade>");
                sb.append("<idCor>");
                sb.append(grade.getIdCor());
                sb.append("</idCor>");
                sb.append("<nomeCor>");
                sb.append(grade.getNomeCor());
                sb.append("</nomeCor>");
                sb.append("<estoqueGrade>");
                sb.append(ToolFormatter.formataNumero((Number)grade.getQuantidade(), (int)2));
                sb.append("</estoqueGrade>");
                sb.append("</gradeProduto>");
            }
            sb.append("</grades>");
            sb.append("<precos>");
            for (ProdutoXMLPrecos preco : p.getPrecos()) {
                sb.append("<preco>");
                sb.append("<uf>");
                sb.append(preco.getUf());
                sb.append("</uf>");
                sb.append("<precoAVista>");
                sb.append(ToolFormatter.formataNumero((Number)preco.getValor(), (int)2));
                sb.append("</precoAVista>");
                sb.append("</preco>");
            }
            sb.append("</precos>");
            sb.append("</produto>");
        }
        sb.append("</produtos>");
        return sb.toString();
    }

    private String getNomeArquivo() {
        StringBuilder sb = new StringBuilder();
        sb.append("tabela_base_");
        sb.append(ToolDate.dateToStr((Date)new Date(), (String)"dd-MM-yyyy HH-mm-ss"));
        sb.append(".xml");
        return sb.toString();
    }

    private void updateDataUltimaSincronizacao(String idNatureza, String idCentroEstoque, String idTabelaBase) {
        this.serviceTabelaPrecoBase.insertDataUltimaGeracaoArquivoXML(idNatureza, idCentroEstoque, idTabelaBase);
    }

    private List getProdutosNotaPropria(Date dataUltimaAtualizacao) {
        Date data = ToolDate.dataSemHora((Date)dataUltimaAtualizacao);
        return this.serviceNotaPropria.findProdutosNotas(data);
    }

    private List getProdutosTransferencia(Date dataUltimaAtualizacao) {
        Date data = ToolDate.dataSemHora((Date)dataUltimaAtualizacao);
        return this.serviceNotaPropria.findProdutosNotas(data);
    }

    private Collection<? extends Produto> getProdutosNotaTerceiros(Date dataUltimaAtualizacao) {
        Date data = ToolDate.dataSemHora((Date)dataUltimaAtualizacao);
        return this.serviceNotaTerceiros.findProdutosNotas(data);
    }

    private String getDescricaoProdutosSimilares(Produto produto) {
        for (ProdutosSimilaresItens p : produto.getProdutosSimilaresItens()) {
            if (!p.getProduto().equals((Object)produto)) continue;
            String especie = ToolString.removeIllegalXMLChar((String)p.getProdutosSimilares().getDescricao().trim());
            especie = ToolString.clearMultipleSpaces((String)especie);
            return especie;
        }
        return "";
    }
}

