/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.geracaoarquivoxmlvendas;

import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.LogStatusCooperado;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.impl.especie.ServiceEspecieImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceCooperado;
import com.touchcomp.basementorservice.service.interfaces.ServiceEmpresa;
import com.touchcomp.basementorservice.service.interfaces.ServiceNotaFiscalPropria;
import com.touchcomp.basementorservice.service.interfaces.ServiceNotaFiscalTerceiros;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorwebtasks.service.impl.geracaoarquivoxmlvendas.NotaPropria;
import com.touchcomp.basementorwebtasks.service.impl.geracaoarquivoxmlvendas.NotaPropriaCooperado;
import com.touchcomp.basementorwebtasks.service.impl.geracaoarquivoxmlvendas.NotaPropriaCooperadoSubespecie;
import com.touchcomp.basementorwebtasks.service.impl.geracaoarquivoxmlvendas.NotaPropriaItem;
import com.touchcomp.basementorwebtasks.service.impl.geracaoarquivoxmlvendas.NotaTerceirosCooperado;
import com.touchcomp.basementorwebtasks.service.impl.geracaoarquivoxmlvendas.NotaTerceirosCooperadoSubespecie;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.DOMOutputter;

class AuxGeracaoArquivoXMLVendas {
    private ServiceNotaFiscalPropria serviceNotaPropria = (ServiceNotaFiscalPropria)ConfApplicationContext.getBean(ServiceNotaFiscalPropria.class);
    private ServiceNotaFiscalTerceiros serviceNotaTerceiros = (ServiceNotaFiscalTerceiros)ConfApplicationContext.getBean(ServiceNotaFiscalTerceiros.class);
    private ServiceCooperado serviceCooperado = (ServiceCooperado)ConfApplicationContext.getBean(ServiceCooperado.class);
    private ServiceEmpresa serviceEmpresa = (ServiceEmpresa)ConfApplicationContext.getBean(ServiceEmpresa.class);
    private ServiceEspecieImpl serviceEspecie = (ServiceEspecieImpl)ConfApplicationContext.getBean(ServiceEspecieImpl.class);
    private final TLogger logger = TLogger.get(this.getClass());

    AuxGeracaoArquivoXMLVendas() {
    }

    public void gerarArquivoXMLVendas(String caminhoArquivo, Date dataInicial, Date dataFinal, Long idEmpresa, Long idEspecie, Short vendasCooperativa, Short vendasCooperado) throws Exception {
        Empresa empresa = this.getEmpresa(idEmpresa);
        Especie especie = this.getEspecie(idEspecie);
        List<Cooperado> cooperados = this.findCooperados();
        List<HashMap> notasProprias = this.findNotasProprias(dataInicial, dataFinal, empresa, especie);
        List<NotaPropria> notas = this.gerarNotaPropriaTemp(notasProprias);
        Date dataAnterior = ToolDate.nextMonth((Date)dataInicial, (int)-1);
        Date dataInicialOld = ToolDate.getDateFirstMonthDay((Date)dataAnterior);
        Date dataFinalOld = ToolDate.getDateLastMonthDay((Date)dataAnterior);
        List<HashMap> notasPropriasOld = this.findNotasProprias(dataInicialOld, dataFinalOld, empresa, especie);
        List<NotaPropria> notasOld = this.gerarNotaPropriaTemp(notasPropriasOld);
        List<NotaPropriaCooperado> notasVendas = this.processarNotasVendasComRanking(notas, notasOld, cooperados);
        Integer ano = ToolDate.getYearFromDate((Date)dataFinal);
        String dataInAno = "01/01/" + ano;
        Date dataInicialAno = ToolDate.strToDate((String)dataInAno);
        String dataFinAno = "31/12/" + ano;
        Date dataFimAno = ToolDate.strToDate((String)dataFinAno);
        ArrayList<NotaPropriaCooperado> notasVendasCooperativaAno = new ArrayList();
        if (ToolMethods.isEquals((Object)vendasCooperativa, (Object)1)) {
            List<HashMap> notasPropriasAno = this.findNotasProprias(dataInicialAno, dataFimAno, empresa, especie);
            List<NotaPropria> notasVendasCooperativaAnoTemp = this.gerarNotaPropriaTemp(notasPropriasAno);
            notasVendasCooperativaAno = this.processarNotasVendasSemRanking(notasVendasCooperativaAnoTemp, cooperados);
        }
        ArrayList<NotaPropriaCooperado> notasGeralCooperado = new ArrayList<NotaPropriaCooperado>();
        if (ToolMethods.isEquals((Object)vendasCooperado, (Object)1)) {
            for (NotaPropriaCooperado notasVenda : notasVendas) {
                Cooperado cooperado = notasVenda.getCooperado();
                String dataInGeral = "01/01/1111";
                Date dataInicialGeral = ToolDate.strToDate((String)dataInGeral);
                List<HashMap> notasPropriasGeral = this.findNotasPropriasPorCooperado(dataInicialGeral, dataFinal, empresa, especie, cooperado);
                List<NotaPropria> notasGeralCooperadoTemp = this.gerarNotaPropriaTemp(notasPropriasGeral);
                notasGeralCooperado.addAll(this.processarNotasVendasSemRanking(notasGeralCooperadoTemp, cooperados));
            }
        }
        List<HashMap> notasTerceiros = this.findNotasTerceiros(dataInicial, dataFinal, empresa, especie);
        NotaTerceirosCooperado notasCompras = this.processarNotasCompras(notasTerceiros);
        String xml = this.montarArquivoXML(notasVendas, notasCompras, empresa, dataFinal, notasVendasCooperativaAno, notasGeralCooperado);
        xml = ToolString.clearSpecialCharacXML((String)xml);
        this.gerarArquivoXML(xml, caminhoArquivo, dataFinal);
    }

    private Empresa getEmpresa(Long idEmpresa) {
        return (Empresa)this.serviceEmpresa.get((Serializable)idEmpresa);
    }

    private List<HashMap> findNotasProprias(Date dataInicial, Date dataFinal, Empresa empresa, Especie especie) {
        return this.serviceNotaPropria.findNotaPropriaVendasPorPeriodoAndEmpresa(dataInicial, dataFinal, empresa, especie);
    }

    private List<HashMap> findNotasPropriasPorCooperado(Date dataInicial, Date dataFinal, Empresa empresa, Especie especie, Cooperado cooperado) {
        return this.serviceNotaPropria.findNotaPropriaVendasPorPeriodoAndEmpresaAndCliente(dataInicial, dataFinal, empresa, especie, cooperado.getCliente());
    }

    private List<Cooperado> findCooperados() {
        return this.serviceCooperado.findAll();
    }

    private List<NotaPropriaCooperado> processarNotasVendasComRanking(List<NotaPropria> notasProprias, List<NotaPropria> notasPropriasOld, List<Cooperado> cooperados) {
        List<NotaPropriaCooperado> notasCooperados = this.getNotasCooperados(notasProprias, cooperados);
        this.processarSubEspecies(notasCooperados);
        this.processarRanking(notasCooperados);
        List<NotaPropriaCooperado> notasCooperadosOld = this.getNotasCooperados(notasPropriasOld, cooperados);
        this.processarSubEspecies(notasCooperadosOld);
        this.processarRanking(notasCooperadosOld);
        this.mesclarRanking(notasCooperados, notasCooperadosOld);
        return notasCooperados;
    }

    private List<NotaPropriaCooperado> processarNotasVendasSemRanking(List<NotaPropria> notasProprias, List<Cooperado> cooperados) {
        List<NotaPropriaCooperado> notasCooperados = this.getNotasCooperados(notasProprias, cooperados);
        this.processarSubEspecies(notasCooperados);
        return notasCooperados;
    }

    private List<NotaPropriaCooperado> getNotasCooperados(List<NotaPropria> notasProprias, List<Cooperado> cooperados) {
        LinkedList<NotaPropriaCooperado> notasCooperados = new LinkedList<NotaPropriaCooperado>();
        for (Cooperado cooperado : cooperados) {
            Cliente cliente = cooperado.getCliente();
            for (NotaPropria n : notasProprias) {
                if (!ToolMethods.isEquals((Object)n.getIdCliente(), (Object)cliente.getIdentificador())) continue;
                Boolean achou = false;
                for (NotaPropriaCooperado notaCooperado : notasCooperados) {
                    if (!ToolMethods.isEquals((Object)cooperado, (Object)notaCooperado.getCooperado())) continue;
                    notaCooperado.getNotasProprias().add(n);
                    achou = true;
                    break;
                }
                if (achou.booleanValue()) continue;
                NotaPropriaCooperado notaCooperado = new NotaPropriaCooperado();
                notaCooperado.setCooperado(cooperado);
                notaCooperado.getNotasProprias().add(n);
                notasCooperados.add(notaCooperado);
            }
        }
        return notasCooperados;
    }

    private void processarSubEspecies(List<NotaPropriaCooperado> notasCooperados) {
        for (NotaPropriaCooperado nc : notasCooperados) {
            for (NotaPropria n : nc.getNotasProprias()) {
                for (NotaPropriaItem i : n.getItens()) {
                    Boolean achou = false;
                    for (NotaPropriaCooperadoSubespecie s : nc.getSubEspecies()) {
                        if (!ToolMethods.isEquals((Object)s.getIdSubEspecie(), (Object)i.getIdSubEspecie())) continue;
                        s.setValor(s.getValor() + i.getValorSubEspecie());
                        nc.setValorTotal(nc.getValorTotal() + i.getValorSubEspecie());
                        achou = true;
                        break;
                    }
                    if (achou.booleanValue()) continue;
                    NotaPropriaCooperadoSubespecie ss = new NotaPropriaCooperadoSubespecie();
                    ss.setIdSubEspecie(i.getIdSubEspecie());
                    ss.setNomeSubEspecie(i.getNomeSubEspecie());
                    ss.setValor(i.getValorSubEspecie());
                    nc.setValorTotal(nc.getValorTotal() + i.getValorSubEspecie());
                    nc.getSubEspecies().add(ss);
                }
            }
            List<NotaPropriaCooperadoSubespecie> subEspecies = this.ordenarNotaPropriaSubEspecie(nc.getSubEspecies());
            nc.setSubEspecies(subEspecies);
        }
    }

    private void processarRanking(List<NotaPropriaCooperado> notasCooperados) {
        notasCooperados = this.getAvaliarRanking(notasCooperados);
        Integer cont = 1;
        for (NotaPropriaCooperado n : notasCooperados) {
            n.setRankingAtual(cont);
            Integer n2 = cont;
            cont = cont + 1;
        }
    }

    private List<NotaPropriaCooperado> getAvaliarRanking(List<NotaPropriaCooperado> notasCooperados) {
        if (notasCooperados != null) {
            Collections.sort(notasCooperados, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    NotaPropriaCooperado item1 = (NotaPropriaCooperado)o1;
                    NotaPropriaCooperado item2 = (NotaPropriaCooperado)o2;
                    return item2.getValorTotal().compareTo(item1.getValorTotal());
                }
            });
            return notasCooperados;
        }
        return new LinkedList<NotaPropriaCooperado>();
    }

    private void mesclarRanking(List<NotaPropriaCooperado> notasCooperados, List<NotaPropriaCooperado> notasCooperadosOld) {
        block0: for (NotaPropriaCooperado n1 : notasCooperados) {
            for (NotaPropriaCooperado n2 : notasCooperadosOld) {
                if (!ToolMethods.isEquals((Object)n1.getCooperado(), (Object)n2.getCooperado())) continue;
                n1.setRankingAnterior(n2.getRankingAtual());
                continue block0;
            }
        }
    }

    private List<HashMap> findNotasTerceiros(Date dataInicial, Date dataFinal, Empresa empresa, Especie especie) {
        return this.serviceNotaTerceiros.findNotaTerceirosPorPeriodoAndEmpresa(dataInicial, dataFinal, empresa, especie);
    }

    private NotaTerceirosCooperado processarNotasCompras(List<HashMap> notasTerceiros) {
        return this.processarSubEspeciesNotasCompras(notasTerceiros);
    }

    private NotaTerceirosCooperado processarSubEspeciesNotasCompras(List<HashMap> notasTerceiros) {
        NotaTerceirosCooperado nc = new NotaTerceirosCooperado();
        Double valor = 0.0;
        for (HashMap h : notasTerceiros) {
            String nomeSubEspecie = (String)h.get("NOME_SUBESPECIE");
            Long idSubEspecie = (Long)h.get("ID_SUBESPECIE");
            Double valorSubEspecie = (Double)h.get("VALOR_SUBESPECIE");
            NotaTerceirosCooperadoSubespecie s = new NotaTerceirosCooperadoSubespecie();
            s.setIdSubEspecie(idSubEspecie);
            s.setNomeSubEspecie(nomeSubEspecie);
            s.setValor(valorSubEspecie);
            nc.getSubEspecies().add(s);
            valor = valor + valorSubEspecie;
        }
        nc.setValorTotal(valor);
        List<NotaTerceirosCooperadoSubespecie> subEspecies = this.ordenarNotaTerceirosSubEspecie(nc.getSubEspecies());
        nc.setSubEspecies(subEspecies);
        return nc;
    }

    private String montarArquivoXML(List<NotaPropriaCooperado> notasVendas, NotaTerceirosCooperado notasCompras, Empresa empresa, Date dataFinal, List<NotaPropriaCooperado> dadosVendasCooperativaAno, List<NotaPropriaCooperado> dadosVendasCooperadoGeral) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        sb.append("<DOCUMENTO>");
        sb.append(this.getDadosEmpresa(empresa, dataFinal));
        sb.append(this.getDadosVendasCompras(notasVendas, notasCompras, dataFinal, dadosVendasCooperativaAno, dadosVendasCooperadoGeral));
        sb.append("</DOCUMENTO>");
        return sb.toString();
    }

    private String getDadosEmpresa(Empresa empresa, Date dataFinal) {
        StringBuilder sb = new StringBuilder();
        sb.append("<IDENTIFICACAO>");
        sb.append("<NOME>");
        sb.append(empresa.getPessoa().getNomeFantasia() != null ? empresa.getPessoa().getNomeFantasia() : empresa.getPessoa().getNome());
        sb.append("</NOME>");
        sb.append("<RAZAO>");
        sb.append(empresa.getPessoa().getNome());
        sb.append("</RAZAO>");
        sb.append("<ENDERECO>");
        sb.append(empresa.getPessoa().getEndereco().getLogradouro());
        sb.append(", ");
        sb.append(empresa.getPessoa().getEndereco().getNumero());
        sb.append("</ENDERECO>");
        sb.append("<CNPJ>");
        sb.append(empresa.getPessoa().getComplemento().getCnpj());
        sb.append("</CNPJ>");
        sb.append("<IE>");
        sb.append(empresa.getPessoa().getComplemento().getInscEst());
        sb.append("</IE>");
        sb.append("<RELATORIO>");
        sb.append("EXTRATO DE RELACIONAMENTO");
        sb.append("</RELATORIO>");
        sb.append("<CIDADEDATA>");
        sb.append(empresa.getPessoa().getEndereco().getCidade().getDescricao());
        sb.append(",");
        sb.append(this.getToStringDiaMesAno(dataFinal));
        sb.append("</CIDADEDATA>");
        sb.append("</IDENTIFICACAO>");
        return sb.toString();
    }

    private String getDadosVendasCompras(List<NotaPropriaCooperado> notasVendas, NotaTerceirosCooperado notaCompras, Date dataFinal, List<NotaPropriaCooperado> notasVendasCooperativaAno, List<NotaPropriaCooperado> notasVendaCooperadoGeral) {
        String dadosGerais = this.getDadosVendaCompraTotal(notasVendas, notaCompras);
        String dadosVendasCooperativaAno = this.getDadosVendasCooperativaAno(notasVendasCooperativaAno);
        StringBuilder sb = new StringBuilder();
        sb.append("<EXTRATOS>");
        notasVendas = this.ordenarNotasVendas(notasVendas);
        int cont = 1;
        for (NotaPropriaCooperado n : notasVendas) {
            System.out.println(cont + "-" + n.getCooperado().toString() + "\n\n");
            sb.append("<EXTRATO>");
            sb.append(this.getDadosCooperado(n.getCooperado(), dataFinal));
            sb.append(this.getDadosRanking(n));
            sb.append(this.getCompras10Notas(n));
            sb.append(this.getComprasLinhaPorMatriz(n));
            sb.append(dadosGerais);
            sb.append(dadosVendasCooperativaAno);
            sb.append(this.getDadosVendasCooperadoGeral(notasVendaCooperadoGeral, n.getCooperado()));
            sb.append("</EXTRATO>");
            ++cont;
        }
        sb.append("</EXTRATOS>");
        return sb.toString();
    }

    private String getDadosVendaCompraTotal(List<NotaPropriaCooperado> notasVendas, NotaTerceirosCooperado notaCompra) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getValorComprasTotal(notaCompra));
        sb.append(this.getValorVendasTotal(notasVendas));
        sb.append(this.getComprasPorSubEspecie(notaCompra));
        sb.append(this.getVendasPorSubEspecie(notasVendas));
        sb.append(this.getDestaque());
        return sb.toString();
    }

    private String getValorComprasTotal(NotaTerceirosCooperado notaCompra) {
        StringBuilder sb = new StringBuilder();
        sb.append("<AQUISICAO>");
        sb.append("<VALORAQUISICAO>");
        sb.append(ToolFormatter.formataNumero((Number)notaCompra.getValorTotal(), (int)2));
        sb.append("</VALORAQUISICAO>");
        sb.append("</AQUISICAO>");
        return sb.toString();
    }

    private String getValorVendasTotal(List<NotaPropriaCooperado> notasVendas) {
        Double valor = 0.0;
        for (NotaPropriaCooperado notasVenda : notasVendas) {
            valor = valor + notasVenda.getValorTotal();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<VENDAS>");
        sb.append("<VALORVENDAS>");
        sb.append(ToolFormatter.formataNumero((Number)valor, (int)2));
        sb.append("</VALORVENDAS>");
        sb.append("</VENDAS>");
        return sb.toString();
    }

    private String getComprasPorSubEspecie(NotaTerceirosCooperado notaCompra) {
        StringBuilder sb = new StringBuilder();
        sb.append("<COMPRALINHA>");
        for (NotaTerceirosCooperadoSubespecie s : notaCompra.getSubEspecies()) {
            sb.append("<LINHACOMPRA>");
            sb.append(s.getNomeSubEspecie().trim());
            sb.append("</LINHACOMPRA>");
            sb.append("<VALORLINHACOMPRA>");
            sb.append(ToolFormatter.formataNumero((Number)s.getValor(), (int)2));
            sb.append("</VALORLINHACOMPRA>");
        }
        sb.append("</COMPRALINHA>");
        return sb.toString();
    }

    private String getVendasPorSubEspecie(List<NotaPropriaCooperado> notasVendas) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        for (NotaPropriaCooperado n : notasVendas) {
            for (NotaPropriaCooperadoSubespecie s : n.getSubEspecies()) {
                if (h.get(s.getNomeSubEspecie()) != null) {
                    Double valor = (Double)h.get(s.getNomeSubEspecie());
                    h.put(s.getNomeSubEspecie(), valor + s.getValor());
                    continue;
                }
                h.put(s.getNomeSubEspecie(), s.getValor());
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<VENDALINHA>");
        Set set = h.keySet();
        for (NotaPropriaCooperadoSubespecie ob : set) {
            String subEspecie = (String)((Object)ob);
            Double valor = (Double)h.get(subEspecie);
            sb.append("<LINHAVENDA>");
            sb.append(subEspecie);
            sb.append("</LINHAVENDA>");
            sb.append("<VALORLINHAVENDA>");
            sb.append(ToolFormatter.formataNumero((Number)valor, (int)2));
            sb.append("</VALORLINHAVENDA>");
        }
        sb.append("</VENDALINHA>");
        return sb.toString();
    }

    private String getDestaque() {
        StringBuilder sb = new StringBuilder();
        sb.append("<DESTAQUE>");
        sb.append("<DESCRICAO>");
        sb.append("Este relat\u00f3rio mensal mostra toda sua movimenta\u00e7\u00e3o na Coosuiponte no per\u00edodo acima descrito. Algumas informa\u00e7\u00f5es foram inseridas de acordo com sua informa\u00e7\u00e3o em nosso cadastro, s\u00e3o elas: n\u00famero de matrizes e data de admiss\u00e3o. O limite de cr\u00e9dito \u00e9 definido conforme seu tempo de cadastro e movimenta\u00e7\u00e3o nos \u00faltimos seis meses. O ranking atual mostra seu volume de compras em rela\u00e7\u00e3o aos demais cooperados, por numero de matrizes. E a mobilidade refere-se a sua posi\u00e7\u00e3o atual em rela\u00e7\u00e3o ao per\u00edodo anterior. Os produtos s\u00e3o distribu\u00eddos em 10 grupos de linha. E, para maior transpar\u00eancia entre voc\u00ea e a Cooperativa, apresentamos os volumes de compra e venda da Coosuiponte no mesmo per\u00edodo. Qualquer d\u00favida estamos a disposi\u00e7\u00e3o para atend\u00ea-lo por email, coosuiponte@coosuiponte.com.br, ou telefone, (31) 3819- 3900.");
        sb.append("</DESCRICAO>");
        sb.append("</DESTAQUE>");
        return sb.toString();
    }

    private String getDadosCooperado(Cooperado cooperado, Date dataFinal) {
        StringBuilder sb = new StringBuilder();
        sb.append("<DADOSCOOPERADO>");
        sb.append("<NOME>");
        sb.append(cooperado.getCliente().getPessoa().getNome());
        sb.append("</NOME>");
        sb.append("<CODIGO>");
        sb.append(cooperado.getCodigoCooperado());
        sb.append("</CODIGO>");
        sb.append("<MES>");
        sb.append(this.getToStringMesAno(dataFinal));
        sb.append("</MES>");
        sb.append("</DADOSCOOPERADO>");
        return sb.toString();
    }

    private String getToStringMesAno(Date dataFinal) {
        Integer mes = ToolDate.getMonthFromDate((Date)dataFinal);
        Integer ano = ToolDate.getYearFromDate((Date)dataFinal);
        StringBuilder sb = new StringBuilder();
        sb.append(ToolDate.getMonthDescription((int)mes));
        sb.append("/");
        sb.append(ano);
        return sb.toString();
    }

    private String getDadosRanking(NotaPropriaCooperado n) {
        Cooperado c = n.getCooperado();
        StringBuilder sb = new StringBuilder();
        sb.append("<RANK>");
        sb.append("<MATRIZ>");
        sb.append(c.getNumeroMatrizesCooperado());
        sb.append("</MATRIZ>");
        sb.append("<COMPRAS>");
        sb.append(ToolFormatter.formataNumero((Number)n.getValorTotal(), (int)2));
        sb.append("</COMPRAS>");
        sb.append("<RANKATUAL>");
        sb.append(n.getRankingAtual());
        sb.append("</RANKATUAL>");
        sb.append("<COMPRASMATRIZES>");
        sb.append(ToolFormatter.formataNumero((Number)(n.getValorTotal() / (double)c.getNumeroMatrizesCooperado().shortValue()), (int)2));
        sb.append("</COMPRASMATRIZES>");
        sb.append("<RANKANTERIOR>");
        sb.append(n.getRankingAnterior() > 0 ? n.getRankingAnterior() : "-");
        sb.append("</RANKANTERIOR>");
        sb.append("<MOBILIDADE>");
        sb.append(this.getMobilidadeCooperado(n));
        sb.append("</MOBILIDADE>");
        sb.append("<LIMCREDITO>");
        sb.append(ToolFormatter.formataNumero((Number)c.getCliente().getFinanceiro().getLimiteCredito(), (int)2));
        sb.append("</LIMCREDITO>");
        sb.append("<ADMISSAO>");
        sb.append(this.getAdmissaoCooperado(c));
        sb.append("</ADMISSAO>");
        sb.append("</RANK>");
        return sb.toString();
    }

    private String getMobilidadeCooperado(NotaPropriaCooperado n) {
        if (n.getRankingAtual() > 0 && n.getRankingAnterior() > 0) {
            Integer diferenca = n.getRankingAnterior() - n.getRankingAtual();
            return diferenca.toString();
        }
        return "-";
    }

    private String getAdmissaoCooperado(Cooperado c) {
        for (LogStatusCooperado log : c.getLogStatusCooperado()) {
            if (log.getStatusCooperado().getIdentificador() != 1L) continue;
            return ToolDate.dateToStr((Date)log.getData(), (String)"dd/MM/yyyy");
        }
        return "-";
    }

    private String getCompras10Notas(NotaPropriaCooperado n) {
        StringBuilder sb = new StringBuilder();
        sb.append("<COMPRAS10NOTAS>");
        int contador = 1;
        List<NotaPropria> notasDesc = this.getNotasOrdenadasDesc(n.getNotasProprias());
        for (NotaPropria np : notasDesc) {
            if (contador > 10) break;
            sb.append("<DIAMES>");
            sb.append(this.getToStringDiaMes(np.getDataEmissao()));
            sb.append("</DIAMES>");
            sb.append("<COMPRAVALOR>");
            sb.append(ToolFormatter.formataNumero((Number)np.getValorNota(), (int)2));
            sb.append("</COMPRAVALOR>");
            ++contador;
        }
        sb.append("</COMPRAS10NOTAS>");
        return sb.toString();
    }

    private String getToStringDiaMes(Date dataFinal) {
        Integer dia = ToolDate.dayFromDate((Date)dataFinal);
        Integer mes = ToolDate.getMonthFromDate((Date)dataFinal);
        StringBuilder sb = new StringBuilder();
        sb.append(dia);
        sb.append("/");
        sb.append(ToolDate.getMonthDescription((int)mes));
        return sb.toString();
    }

    private String getToStringDiaMesAno(Date dataFinal) {
        Integer dia = ToolDate.dayFromDate((Date)dataFinal);
        Integer mes = ToolDate.getMonthFromDate((Date)dataFinal);
        Integer ano = ToolDate.getYearFromDate((Date)dataFinal);
        StringBuilder sb = new StringBuilder();
        sb.append(dia);
        sb.append(" de ");
        sb.append(ToolDate.getMonthDescription((int)mes));
        sb.append(" de ");
        sb.append(ano);
        return sb.toString();
    }

    private String getComprasLinhaPorMatriz(NotaPropriaCooperado n) {
        StringBuilder sb = new StringBuilder();
        Short nrMatrizes = n.getCooperado().getNumeroMatrizesCooperado();
        sb.append("<COMPRALINHAPORMATRIZ>");
        for (NotaPropriaCooperadoSubespecie s : n.getSubEspecies()) {
            sb.append("<LINHACOMPRAMATRIZ>");
            sb.append(s.getNomeSubEspecie().trim());
            sb.append("</LINHACOMPRAMATRIZ>");
            sb.append("<CATEGORIAVALOR>");
            sb.append(ToolFormatter.formataNumero((Number)s.getValor(), (int)2));
            sb.append("</CATEGORIAVALOR>");
            sb.append("<VALORPORMATRIZ>");
            sb.append(ToolFormatter.formataNumero((Number)(s.getValor() / (double)nrMatrizes.shortValue()), (int)2));
            sb.append("</VALORPORMATRIZ>");
        }
        sb.append("</COMPRALINHAPORMATRIZ>");
        return sb.toString();
    }

    private void gerarArquivoXML(String xml, String caminhoArquivo, Date dataFinal) throws Exception {
        try {
            System.out.println(xml);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((InputStream)new ByteArrayInputStream(xml.getBytes()));
            org.w3c.dom.Document docOut = new DOMOutputter().output(doc);
            docOut.getDocumentElement();
            String nomeArquivo = this.getNomeArquivo(dataFinal);
            File file = ToolFile.writeStringInFile((String)(caminhoArquivo + "/" + nomeArquivo), (String)xml);
            System.out.println("XML criado com sucesso!");
        }
        catch (ExceptionIO | IOException | JDOMException ex) {
            this.logger.error(ex.getMessage());
            throw new Exception(ex.getMessage());
        }
    }

    private String getNomeArquivo(Date dataFinal) {
        StringBuilder sb = new StringBuilder();
        sb.append("compra_venda_");
        sb.append(ToolDate.dateToStr((Date)dataFinal, (String)"MM-yyyy"));
        sb.append(".xml");
        return sb.toString();
    }

    private Especie getEspecie(Long idEspecie) {
        return (Especie)this.serviceEspecie.get((Serializable)idEspecie);
    }

    private List<NotaPropriaCooperado> ordenarNotasVendas(List<NotaPropriaCooperado> notasVendas) {
        if (notasVendas != null) {
            Collections.sort(notasVendas, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    NotaPropriaCooperado item1 = (NotaPropriaCooperado)o1;
                    NotaPropriaCooperado item2 = (NotaPropriaCooperado)o2;
                    return item1.getCooperado().getCliente().getPessoa().getNome().compareTo(item2.getCooperado().getCliente().getPessoa().getNome());
                }
            });
            return notasVendas;
        }
        return new ArrayList<NotaPropriaCooperado>();
    }

    private List<NotaPropriaCooperadoSubespecie> ordenarNotaPropriaSubEspecie(List<NotaPropriaCooperadoSubespecie> subEspecies) {
        if (subEspecies != null) {
            Collections.sort(subEspecies, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    NotaPropriaCooperadoSubespecie item1 = (NotaPropriaCooperadoSubespecie)o1;
                    NotaPropriaCooperadoSubespecie item2 = (NotaPropriaCooperadoSubespecie)o2;
                    return item1.getNomeSubEspecie().compareTo(item2.getNomeSubEspecie());
                }
            });
            return subEspecies;
        }
        return new ArrayList<NotaPropriaCooperadoSubespecie>();
    }

    private List<NotaTerceirosCooperadoSubespecie> ordenarNotaTerceirosSubEspecie(List<NotaTerceirosCooperadoSubespecie> subEspecies) {
        if (subEspecies != null) {
            Collections.sort(subEspecies, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    NotaTerceirosCooperadoSubespecie item1 = (NotaTerceirosCooperadoSubespecie)o1;
                    NotaTerceirosCooperadoSubespecie item2 = (NotaTerceirosCooperadoSubespecie)o2;
                    return item1.getNomeSubEspecie().compareTo(item2.getNomeSubEspecie());
                }
            });
            return subEspecies;
        }
        return new ArrayList<NotaTerceirosCooperadoSubespecie>();
    }

    private List<NotaPropria> gerarNotaPropriaTemp(List<HashMap> notasProprias) {
        ArrayList<NotaPropria> lista = new ArrayList<NotaPropria>();
        for (HashMap h : notasProprias) {
            Long idNota = (Long)h.get("ID_NOTA");
            Double valorNota = (Double)h.get("VALOR_NOTA");
            Date dataEmissao = (Date)h.get("DATA_EMISSAO");
            Long idCliente = (Long)h.get("ID_CLIENTE");
            String nomeSubEspecie = (String)h.get("NOME_SUBESPECIE");
            Long idSubEspecie = (Long)h.get("ID_SUBESPECIE");
            Double valorSubEspecie = (Double)h.get("VALOR_SUBESPECIE");
            Boolean achou = false;
            for (NotaPropria n : lista) {
                if (!n.getIdNota().equals(idNota)) continue;
                NotaPropriaItem i = new NotaPropriaItem();
                i.setNomeSubEspecie(nomeSubEspecie);
                i.setValorSubEspecie(valorSubEspecie);
                i.setIdSubEspecie(idSubEspecie);
                n.getItens().add(i);
                achou = true;
            }
            if (achou.booleanValue()) continue;
            NotaPropria n = new NotaPropria();
            n.setIdCliente(idCliente);
            n.setIdNota(idNota);
            n.setValorNota(valorNota);
            n.setDataEmissao(dataEmissao);
            NotaPropriaItem i = new NotaPropriaItem();
            i.setNomeSubEspecie(nomeSubEspecie);
            i.setValorSubEspecie(valorSubEspecie);
            i.setIdSubEspecie(idSubEspecie);
            n.getItens().add(i);
            lista.add(n);
        }
        return lista;
    }

    private String getDadosVendasCooperativaAno(List<NotaPropriaCooperado> notasVendasCooperativaAno) {
        if (ToolMethods.isWithData(notasVendasCooperativaAno)) {
            Double valor = 0.0;
            for (NotaPropriaCooperado notasVenda : notasVendasCooperativaAno) {
                valor = valor + notasVenda.getValorTotal();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<VENDASANUAL>");
            sb.append("<VALORVENDASANUAL>");
            sb.append(ToolFormatter.formataNumero((Number)valor, (int)2));
            sb.append("</VALORVENDASANUAL>");
            sb.append("</VENDASANUAL>");
            return sb.toString();
        }
        return "";
    }

    private String getDadosVendasCooperadoGeral(List<NotaPropriaCooperado> notasVendaCooperadoGeral, Cooperado cooperado) {
        if (ToolMethods.isWithData(notasVendaCooperadoGeral)) {
            Double valor = 0.0;
            for (NotaPropriaCooperado notasVenda : notasVendaCooperadoGeral) {
                if (!ToolMethods.isEquals((Object)notasVenda.getCooperado(), (Object)cooperado)) continue;
                valor = valor + notasVenda.getValorTotal();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<VENDASCOOPERADO>");
            sb.append("<VALORVENDASCOOPERADO>");
            sb.append(ToolFormatter.formataNumero((Number)valor, (int)2));
            sb.append("</VALORVENDASCOOPERADO>");
            sb.append("</VENDASCOOPERADO>");
            return sb.toString();
        }
        return "";
    }

    private List<NotaPropria> getNotasOrdenadasDesc(List<NotaPropria> notasProprias) {
        if (notasProprias != null) {
            Collections.sort(notasProprias, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    NotaPropria item1 = (NotaPropria)o1;
                    NotaPropria item2 = (NotaPropria)o2;
                    Date data1 = item1.getDataEmissao();
                    Date data2 = item2.getDataEmissao();
                    return data2.compareTo(data1);
                }
            });
            return notasProprias;
        }
        return new ArrayList<NotaPropria>();
    }
}

