/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.portalcotacaocompras;

import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.obsdinamica.CompOBSDinamica;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.cotacaocompra.ServiceCotacaoCompraImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.opcoescomprasuprimentos.ServiceOpcoesCompraSuprimentosImpl;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.EnumConstRecipientType;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorwebtasks.service.interfaces.ServiceTASKPortalCotacaoCompras;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePortalCotacaoComprasImpl
extends ServiceGenericImpl
implements ServiceTASKPortalCotacaoCompras {
    @Autowired
    private ServiceCotacaoCompraImpl serviceCotacaoCompras;
    @Autowired
    private ServiceEmpresaImpl serviceEmpresa;
    @Autowired
    private ServiceOpcoesCompraSuprimentosImpl serviceOpcoesCompraSuprimentosImpl;
    @Autowired
    private CompOBSDinamica compOBSDinamica;

    @Override
    public void avaliarETratarCotacoes(ServidorEmail server, ModeloEmail modelo, String empresas, TaskProcessResult result) {
        try {
            String[] ids;
            for (String id : ids = ToolString.splitString((String)empresas, (char[])new char[0])) {
                Empresa emp = this.serviceEmpresa.getOrThrowNotExists(id);
                OpcoesCompraSuprimentos op = this.serviceOpcoesCompraSuprimentosImpl.get(emp);
                if (op != null) {
                    this.avaliarEAvisarFornecedores(emp, server, modelo, op, result);
                    this.encerrarCotacoesVencidas(emp, op, result);
                    continue;
                }
                result.addDet(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"E.ERP.0804.001", (Object[])new Object[]{emp}));
            }
        }
        catch (ExceptionObjNotFound ex) {
            throw new ExceptionRuntimeBase(ex.getFormattedMessage());
        }
    }

    private void avaliarEAvisarFornecedores(Empresa emp, ServidorEmail server, ModeloEmail modelo, OpcoesCompraSuprimentos op, TaskProcessResult result) {
        System.out.println("Situacao das Cotacoes liberadas para o portal: " + String.valueOf(op.getSituacaoCotacaoLibPortalForn()));
        System.out.println("Situacao ao Avisar o fornecedor: " + String.valueOf(op.getSituacaoCotacaoAvisoForn()));
        if (op.getSituacaoCotacaoLibPortalForn() == null) {
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"E.TSK.0017.004", (Object[])new Object[]{emp}));
            return;
        }
        if (op.getSituacaoCotacaoAvisoForn() == null) {
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"E.TSK.0017.005", (Object[])new Object[]{emp}));
            return;
        }
        if (op.getSituacaoCotacaoAvisoForn().equals((Object)op.getSituacaoCotacaoLibPortalForn())) {
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"E.TSK.0017.006", (Object[])new Object[]{emp}));
            return;
        }
        if (modelo == null) {
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"E.TSK.0017.001", (Object[])new Object[]{emp}));
            return;
        }
        if (modelo.getModelo() == null) {
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"E.TSK.0017.002", (Object[])new Object[]{emp}));
            return;
        }
        if (server == null) {
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"E.TSK.0017.003", (Object[])new Object[]{emp}));
            return;
        }
        List cotacoes = this.serviceCotacaoCompras.get(emp, op.getSituacaoCotacaoLibPortalForn());
        System.out.println("Cota\u00e7\u00f5es Encontradas: " + cotacoes.size());
        Email em = new Email();
        em.setAssunto(modelo.getTituloEmail());
        em.setDescricao(modelo.getTituloEmail());
        em.setServidor(new Email.ServidorEmail(server.getServidor(), server.getServidorImap(), server.getServidorPop(), server.getEmail(), server.getSenha(), server.getPortaEmail(), server.getNaoAutenticarEmail(), server.getLogin(), server.getServerProperties(), server.getGerarArquivoExtensaoEml(), server.getDebugServer()));
        for (CotacaoCompra cot : cotacoes) {
            try {
                System.out.println("Enviando Email Cota\u00e7\u00e3o " + cot.getIdentificador());
                em.setDestinatarios(this.getDestinatarios(cot, result));
                if (em.getDestinatarios().size() > 0) {
                    String title = this.compOBSDinamica.build((Object)cot, modelo.getTituloEmail());
                    String text = modelo.getObjectObsDinamica() != null ? this.compOBSDinamica.build((Object)cot, modelo.getObjectObsDinamica().getObservacao()) : new String(modelo.getModelo());
                    if (ToolMethods.isStrWithData((String)server.getEmailCopia())) {
                        em.getDestinatarios().add(new Email.Destinatario(server.getEmailCopia(), EnumConstRecipientType.CC));
                    }
                    em.setCorpoMensagem(text);
                    em.setAssunto(title);
                    ToolSendEmail.sendEmailWithException((Email)em);
                    System.out.println("Email enviado: " + cot.getIdentificador());
                } else {
                    result.addDet(EnumConstantsTaskResult.RESULT_ADVERTENCIA, MessagesBaseMentor.getErrorMsg((String)"V.TSK.0017.007", (Object[])new Object[]{cot.getIdentificador()}));
                    System.out.println("Cotacao nao possui destinatarios: " + cot.getIdentificador());
                }
            }
            catch (ExceptionEmail ex) {
                Logger.getLogger(ServicePortalCotacaoComprasImpl.class.getName()).log(Level.SEVERE, null, ex);
                result.addDet(EnumConstantsTaskResult.RESULT_ERRO, ex.getFormattedMessage());
            }
            catch (ExceptionReflection ex) {
                Logger.getLogger(ServicePortalCotacaoComprasImpl.class.getName()).log(Level.SEVERE, null, ex);
                result.addDet(EnumConstantsTaskResult.RESULT_ERRO, ex.getFormattedMessage());
            }
            catch (ExceptionInvalidData ex) {
                Logger.getLogger(ServicePortalCotacaoComprasImpl.class.getName()).log(Level.SEVERE, null, ex);
                result.addDet(EnumConstantsTaskResult.RESULT_ERRO, ex.getFormattedMessage());
            }
            cot.setSituacaoCotacaoCompraAnt(cot.getSituacaoCotacaoCompra());
            cot.setSituacaoCotacaoCompra(op.getSituacaoCotacaoAvisoForn());
            this.serviceCotacaoCompras.saveOrUpdate((InterfaceVO)cot);
        }
    }

    private HashSet<Email.Destinatario> getDestinatarios(CotacaoCompra cot, TaskProcessResult result) {
        HashSet<Email.Destinatario> hash = new HashSet<Email.Destinatario>();
        for (ItemCotacaoCompra item : cot.getItensCotacaoCompra()) {
            for (FornecedorItemCotacaoCompra fornecedor : item.getFornecedoresItemCotacaoCompra()) {
                for (EmailPessoa email : fornecedor.getUnidadeFaturamentoFornecedor().getFornecedor().getPessoa().getComplemento().getEmails()) {
                    if (!Objects.equals(email.getAtivo(), (short)1) || !Objects.equals(email.getEnviarDadosCotacao(), (short)1)) continue;
                    hash.add(new Email.Destinatario(email.getEmail(), EnumConstRecipientType.BCC));
                }
            }
        }
        return hash;
    }

    private void encerrarCotacoesVencidas(Empresa emp, OpcoesCompraSuprimentos op, TaskProcessResult result) {
        if (op.getSituacaoCotacaoFechPortalForn() == null) {
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, MessagesBaseMentor.getErrorMsg((String)"V.TSK.0017.008", (Object[])new Object[]{emp}));
            return;
        }
        List cotacoes = this.serviceCotacaoCompras.getCotacoesVencidas(emp, new Date(), op.getSituacaoCotacaoLibPortalForn(), op.getSituacaoCotacaoAvisoForn());
        for (CotacaoCompra cot : cotacoes) {
            System.out.println("Encerrando Cotacao " + cot.getIdentificador());
            cot.setSituacaoCotacaoCompraAnt(cot.getSituacaoCotacaoCompra());
            cot.setSituacaoCotacaoCompra(op.getSituacaoCotacaoFechPortalForn());
            this.serviceCotacaoCompras.saveOrUpdate((InterfaceVO)cot);
        }
    }
}

