/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.precificacao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.analiseprecovendaproduto.EnumConstAnalisePrecoVendaProduto;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCen;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.OpcoesVendas;
import com.touchcomp.basementor.model.vo.PreTabelaPrecoBase;
import com.touchcomp.basementor.model.vo.PreTabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.PreTabelaPrecoBaseTabBaseVinc;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.engenhariaprodutos.ExceptionEngProdutos;
import com.touchcomp.basementorservice.components.estoque.CompEstoque;
import com.touchcomp.basementorservice.components.tabelapreco.CompCalculosTabelaPreco;
import com.touchcomp.basementorservice.helpers.impl.pretabelaprecos.HelperPreTabelaPrecosProduto;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.analiseprecovenda.ServiceAnalisePrecoVendaImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfaturamento.ServiceOpcoesFaturamentoImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfinanceiras.ServiceOpcoesFinanceirasImpl;
import com.touchcomp.basementorservice.service.impl.opcoespcp.ServiceOpcoesPCPImpl;
import com.touchcomp.basementorservice.service.impl.opcoesvendas.ServiceOpcoesVendasImpl;
import com.touchcomp.basementorservice.service.impl.pretabelaprecobase.ServicePreTabelaPrecoBaseImpl;
import com.touchcomp.basementorservice.service.impl.pretabelaprecobase.ServicePreTabelaPrecoBaseVincImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorwebtasks.tasks.impl.precificacao.constants.EnumConstTipoCustoProd;
import com.touchcomp.basementorwebtasks.tasks.impl.precificacao.constants.EnumConstTipoPrecificacao;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTaskPrecificacao
extends ServiceGenericImpl {
    @Autowired
    ServiceTabelaPrecoBaseImpl serviceTabelaPrecoBase;
    @Autowired
    ServicePreTabelaPrecoBaseVincImpl servicePreTabelaPrecoBaseVincImpl;
    @Autowired
    ServicePreTabelaPrecoBaseImpl servicePreTabelaPrecoBaseVinc;
    @Autowired
    ServiceAnalisePrecoVendaImpl serviceAnalisePrecoVenda;
    @Autowired
    CompEstoque compEstoque;
    @Autowired
    ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    @Autowired
    ServiceOpcoesFinanceirasImpl serviceOpcoesFinanceirasImpl;
    @Autowired
    ServiceOpcoesFaturamentoImpl serviceOpcoesFaturamentoImpl;
    @Autowired
    ServiceOpcoesVendasImpl serviceOpcoesVendasImpl;
    @Autowired
    ServiceOpcoesPCPImpl serviceOpcoesPCPImpl;
    @Autowired
    HelperPreTabelaPrecosProduto helperPreTabPreco;
    CompCalculosTabelaPreco compCalcTabPreco = new CompCalculosTabelaPreco();

    public void analisarGerarPrecificacao(TaskProcessResult result, EnumConstTipoPrecificacao tipoPrecificacao, EnumConstantsMentorSimNao criarAnaliseCustoSenaoExistir, EnumConstantsMentorSimNao atualizarAnaliseConfPadroes, EnumConstantsMentorSimNao analisarPrecosVendaCenarios, EnumConstantsMentorSimNao criarPreTabPrecosAuto, EnumConstantsMentorSimNao pesquisarTodasEmpresas, EnumConstTipoCustoProd tipAnalisePRMedioUltCusto, String tabelasPreco, Date dataBaseUltCusto, Short nrCasasArredondamento, Double percToleranciaGeral) throws ExceptionAvaliadorExpressoes, ExceptionEngProdutos {
        if (nrCasasArredondamento == null) {
            nrCasasArredondamento = 2;
        }
        List<TabelaPrecoBase> tabelas = this.getTabelas(tabelasPreco);
        HashMap<String, Double> cache = new HashMap<String, Double>();
        for (TabelaPrecoBase tabela : tabelas) {
            OpcoesFinanceiras opFinanceiras = this.serviceOpcoesFinanceirasImpl.findByEmpresa(tabela.getEmpresa());
            OpcoesFaturamento opFaturamento = this.serviceOpcoesFaturamentoImpl.findByEmpresa(tabela.getEmpresa());
            OpcoesVendas opVendas = this.serviceOpcoesVendasImpl.findByEmpresa(tabela.getEmpresa());
            OpcoesPCP opcoesPCP = this.serviceOpcoesPCPImpl.getByEmpresa(tabela.getEmpresa());
            LinkedList<PreTabelaPrecoBaseProduto> itens = new LinkedList<PreTabelaPrecoBaseProduto>();
            this.analisarGerarPrecificacao(result, tipoPrecificacao, criarAnaliseCustoSenaoExistir, atualizarAnaliseConfPadroes, criarPreTabPrecosAuto, pesquisarTodasEmpresas, tipAnalisePRMedioUltCusto, tabela, cache, itens, opFinanceiras, opFaturamento, opVendas, opcoesPCP, dataBaseUltCusto, nrCasasArredondamento, percToleranciaGeral);
            this.salvarPreTabPreco(itens, tabela);
            this.serviceTabelaPrecoBase.saveOrUpdate((InterfaceVO)tabela);
        }
    }

    private List<TabelaPrecoBase> getTabelas(String tabelasPreco) {
        if (ToolMethods.isStrWithData((String)tabelasPreco)) {
            String[] found = ToolString.splitString((String)tabelasPreco, (char[])new char[0]);
            LinkedList<TabelaPrecoBase> tabelas = new LinkedList<TabelaPrecoBase>();
            for (String idTabela : found) {
                TabelaPrecoBase t = (TabelaPrecoBase)this.serviceTabelaPrecoBase.get(idTabela);
                if (t == null) continue;
                tabelas.add(t);
            }
            return tabelas;
        }
        return this.serviceTabelaPrecoBase.getAllTabelasAtivas();
    }

    private void analisarGerarPrecificacao(TaskProcessResult result, EnumConstTipoPrecificacao tipoPrecificacao, EnumConstantsMentorSimNao criarAnaliseCustoSenaoExistir, EnumConstantsMentorSimNao atualizarAnaliseConfPadroes, EnumConstantsMentorSimNao criarPreTabPrecosAuto, EnumConstantsMentorSimNao pesquisarTodasEmpresas, EnumConstTipoCustoProd tipAnalisePRMedioUltCusto, TabelaPrecoBase tabela, HashMap<String, Double> cacheCustoProduto, List<PreTabelaPrecoBaseProduto> itens, OpcoesFinanceiras opFinanceiras, OpcoesFaturamento opFaturamento, OpcoesVendas opVendas, OpcoesPCP opcoesPCP, Date dataBaseUltCusto, Short nrCasasArredondamento, Double percToleranciaGeral) throws ExceptionAvaliadorExpressoes, ExceptionEngProdutos {
        for (TabelaPrecoBaseProduto tabProduto : tabela.getProdutos()) {
            this.criarCacheValorCustoItens(pesquisarTodasEmpresas, tipAnalisePRMedioUltCusto, tabela, tabProduto, cacheCustoProduto, dataBaseUltCusto);
            this.calcularPrecificacao(result, tabProduto, tipoPrecificacao, tabela, itens, criarAnaliseCustoSenaoExistir, atualizarAnaliseConfPadroes, criarPreTabPrecosAuto, tabela.getEmpresa(), opFinanceiras, opFaturamento, opVendas, opcoesPCP, cacheCustoProduto, nrCasasArredondamento, percToleranciaGeral);
        }
    }

    private void calcularPrecificacao(TaskProcessResult result, TabelaPrecoBaseProduto tabProduto, EnumConstTipoPrecificacao tipoPrecificacao, TabelaPrecoBase tabela, List<PreTabelaPrecoBaseProduto> itens, EnumConstantsMentorSimNao criarAnaliseCustoSenaoExistir, EnumConstantsMentorSimNao atualizarAnaliseConfPadroes, EnumConstantsMentorSimNao criarPreTabPrecosAuto, Empresa empresa, OpcoesFinanceiras opFinanceiras, OpcoesFaturamento opFaturamento, OpcoesVendas opVendas, OpcoesPCP opcoesPCP, HashMap<String, Double> cache, Short nrCasasArredondamento, Double percToleranciaGeral) throws ExceptionAvaliadorExpressoes, ExceptionEngProdutos {
        if (ToolMethods.isEquals((Object)((Object)EnumConstTipoPrecificacao.BASEADA_CENARIOS), (Object)((Object)tipoPrecificacao))) {
            this.atualizarCenarios(result, tabProduto, cache, tabela, itens, criarAnaliseCustoSenaoExistir, atualizarAnaliseConfPadroes, criarPreTabPrecosAuto, tabela.getEmpresa(), opFinanceiras, opFaturamento, opVendas, opcoesPCP, nrCasasArredondamento, percToleranciaGeral);
        } else {
            this.calcularPrecificacaoSimples(result, tabProduto, tabela, itens, criarPreTabPrecosAuto, cache, nrCasasArredondamento, percToleranciaGeral);
        }
    }

    private void criarCacheValorCustoItens(EnumConstantsMentorSimNao pesquisarTodasEmpresas, EnumConstTipoCustoProd tipAnalisePRMedioUltCusto, TabelaPrecoBase tabela, TabelaPrecoBaseProduto tabProduto, HashMap<String, Double> cache, Date dataBaseUltCusto) {
        this.criarCacheValorCustoItens(tabProduto, tabela.getEmpresa(), pesquisarTodasEmpresas, tipAnalisePRMedioUltCusto, cache, dataBaseUltCusto);
    }

    private void criarCacheValorCustoItens(TabelaPrecoBaseProduto tabProduto, Empresa empresa, EnumConstantsMentorSimNao pesquisarTodasEmpresas, EnumConstTipoCustoProd tipAnalisePRMedioUltCusto, HashMap<String, Double> cache, Date dataBaseUltCusto) {
        if (!ToolMethods.isAffirmative((Number)tabProduto.getAtivo())) {
            return;
        }
        if (tipAnalisePRMedioUltCusto == null) {
            return;
        }
        String key = this.getKey(tabProduto.getProduto(), empresa);
        Double valor = cache.get(key);
        if (valor == null) {
            valor = this.carregarValorCusto(tipAnalisePRMedioUltCusto, pesquisarTodasEmpresas, tabProduto.getProduto(), empresa, dataBaseUltCusto);
            cache.put(key, valor);
        }
    }

    private String getKey(Produto produto, Empresa empresa) {
        return String.valueOf(produto.getIdentificador()) + String.valueOf(empresa.getIdentificador());
    }

    private Double carregarValorCusto(EnumConstTipoCustoProd tipAnalisePRMedioUltCusto, EnumConstantsMentorSimNao pesquisarTodasEmpresas, Produto produto, Empresa empresa, Date dataBaseUltCusto) {
        Double valor = 0.0;
        valor = tipAnalisePRMedioUltCusto == EnumConstTipoCustoProd.CUSTO_MEDIO ? this.compEstoque.getCustoMedioEstoque(produto, empresa) : (ToolMethods.isEquals((Object)pesquisarTodasEmpresas, (Object)EnumConstantsMentorSimNao.SIM) ? this.compEstoque.getUltimoCusto(produto) : (dataBaseUltCusto != null ? this.compEstoque.getUltimoCusto(produto, empresa) : this.compEstoque.getUltimoCusto(produto, empresa)));
        return valor != null ? valor : 0.0;
    }

    private void atualizarCenarios(TaskProcessResult result, TabelaPrecoBaseProduto tabProduto, HashMap<String, Double> cache, TabelaPrecoBase tab, List<PreTabelaPrecoBaseProduto> itens, EnumConstantsMentorSimNao criarAnaliseCustoSenaoExistir, EnumConstantsMentorSimNao atualizarAnaliseConfPadroes, EnumConstantsMentorSimNao criarPreTabPrecosAuto, Empresa emp, OpcoesFinanceiras opFinanceiras, OpcoesFaturamento opFaturamento, OpcoesVendas opVendas, OpcoesPCP opcoesPCP, Short nrCasasArredondamento, Double percToleranciaGeral) throws ExceptionAvaliadorExpressoes, ExceptionEngProdutos {
        if (tabProduto.getAnalisePrecoVendaProd() == null && ToolMethods.isEquals((Object)EnumConstantsMentorSimNao.SIM, (Object)criarAnaliseCustoSenaoExistir)) {
            this.criarAnalisePrecoVenda(tabProduto, tab, emp, opFinanceiras, opFaturamento, opVendas, opcoesPCP, false);
        }
        if (tabProduto.getAnalisePrecoVendaProd() == null) {
            return;
        }
        if (ToolMethods.isEquals((Object)EnumConstantsMentorSimNao.SIM, (Object)atualizarAnaliseConfPadroes)) {
            this.criarAnalisePrecoVenda(tabProduto, tab, emp, opFinanceiras, opFaturamento, opVendas, opcoesPCP, true);
        }
        AnalisePrVendaProd ana = tabProduto.getAnalisePrecoVendaProd();
        ana = this.serviceAnalisePrecoVenda.calcular(ana, emp, opFinanceiras, opFaturamento, opVendas, opcoesPCP);
        this.analisarCriarPreItem(result, tabProduto, tab, cache, criarPreTabPrecosAuto, itens, ana, nrCasasArredondamento, percToleranciaGeral);
        tabProduto.setAnalisePrecoVendaProd(ana);
    }

    private void analisarCriarPreItem(TaskProcessResult result, TabelaPrecoBaseProduto tabProduto, TabelaPrecoBase tabBase, HashMap<String, Double> cache, EnumConstantsMentorSimNao criarPreTabPrecosAuto, List<PreTabelaPrecoBaseProduto> itens, AnalisePrVendaProd ana, Short nrCasasArredondamento, Double percToleranciaGeral) {
        boolean criarDevVlrMax;
        Double vlrMin = null;
        Double vlr = null;
        Double vlrMax = null;
        Double valorCusto = cache.get(this.getKey(tabProduto.getProduto(), tabBase.getEmpresa()));
        if (!ToolMethods.isWithData((Number)valorCusto)) {
            return;
        }
        for (AnalisePrVendaProdCen cenario : ana.getCenarios()) {
            if (ToolMethods.isEquals((Object)cenario.getTipoAnalise(), (Object)EnumConstAnalisePrecoVendaProduto.PRECO_MINIMO.getValue())) {
                vlrMin = cenario.getResultado();
                continue;
            }
            if (ToolMethods.isEquals((Object)cenario.getTipoAnalise(), (Object)EnumConstAnalisePrecoVendaProduto.PRECO_MAXIMO.getValue())) {
                vlrMax = cenario.getResultado();
                continue;
            }
            if ((!ToolMethods.isEquals((Object)cenario.getTipoAnalise(), (Object)EnumConstAnalisePrecoVendaProduto.PRECO_VENDA.getValue()) || !ToolMethods.isEquals((Object)1, (Object)cenario.getCenarioEscolhido())) && (cenario.getTipoAnalise() != null || !ToolMethods.isEquals((Object)1, (Object)cenario.getCenarioEscolhido()))) continue;
            vlr = cenario.getResultado();
        }
        vlr = ToolFormatter.arrredondarNumero(vlr, (int)nrCasasArredondamento.shortValue());
        vlrMin = ToolFormatter.arrredondarNumero(vlrMin, (int)nrCasasArredondamento.shortValue());
        vlrMax = ToolFormatter.arrredondarNumero(vlrMax, (int)nrCasasArredondamento.shortValue());
        double difPerc = ToolNumber.calcPercentual((Double)tabProduto.getValorVenda(), (Double)vlr);
        boolean criarDevVlrMin = Math.abs(difPerc) > ana.getToleranciaPrecoAbaixo();
        boolean bl = criarDevVlrMax = difPerc > ana.getToleranciaPrecoAcima();
        if (!criarDevVlrMax && !criarDevVlrMin) {
            return;
        }
        if (criarPreTabPrecosAuto == EnumConstantsMentorSimNao.SIM) {
            this.atualizarCriarPreTabPreco(result, valorCusto, vlrMin, vlr, vlrMax, tabProduto, itens);
        } else {
            this.atualizarTabDiretamente(result, valorCusto, vlrMin, vlr, vlrMax, tabProduto);
        }
    }

    private void criarAnalisePrecoVenda(TabelaPrecoBaseProduto tabProduto, TabelaPrecoBase tabBase, Empresa emp, OpcoesFinanceiras opFinanceiras, OpcoesFaturamento opFaturamento, OpcoesVendas opVendas, OpcoesPCP opcoesPCP, boolean atualizaParametros) throws ExceptionAvaliadorExpressoes, ExceptionEngProdutos {
        this.serviceAnalisePrecoVenda.calcular(tabBase.getPadroesAnaPreco(), ToolMethods.toList((Object[])new Object[]{tabProduto}), emp, opFinanceiras, opFaturamento, opVendas, tabBase.getToleranciaPrecoAbaixo(), tabBase.getToleranciaPrecoAcima(), atualizaParametros, opcoesPCP);
    }

    private void calcularPrecificacaoSimples(TaskProcessResult result, TabelaPrecoBaseProduto tabProduto, TabelaPrecoBase tabela, List<PreTabelaPrecoBaseProduto> itens, EnumConstantsMentorSimNao criarPreTabPrecosAuto, HashMap<String, Double> cache, Short nrCasasArredondamento, Double percToleranciaGeral) {
        Double valorCusto = cache.get(this.getKey(tabProduto.getProduto(), tabela.getEmpresa()));
        if (!ToolMethods.isWithData((Number)valorCusto)) {
            return;
        }
        Double vlrVenda = ToolFormatter.arrredondarNumero((Double)this.compCalcTabPreco.calcValorVenda(valorCusto, tabProduto.getMargemLucro()), (int)nrCasasArredondamento.shortValue());
        Double vlrMin = ToolFormatter.arrredondarNumero((Double)this.compCalcTabPreco.calcValorMin(vlrVenda, tabProduto.getPercMinimo()), (int)nrCasasArredondamento.shortValue());
        Double vlrMax = ToolFormatter.arrredondarNumero((Double)this.compCalcTabPreco.calcValorMax(vlrVenda, tabProduto.getPercMaximo()), (int)nrCasasArredondamento.shortValue());
        Double dif = ToolNumber.calcDifPercentual((Double)vlrVenda, (Double)tabProduto.getValorVenda());
        if (Math.abs(dif) > percToleranciaGeral) {
            if (ToolMethods.isEquals((Object)EnumConstantsMentorSimNao.SIM, (Object)criarPreTabPrecosAuto)) {
                this.atualizarCriarPreTabPreco(result, valorCusto, vlrMin, vlrVenda, vlrMax, tabProduto, itens);
            } else {
                this.atualizarTabDiretamente(result, valorCusto, vlrMin, vlrVenda, vlrMax, tabProduto);
            }
        }
    }

    private void atualizarTabDiretamente(TaskProcessResult result, Double valorCusto, Double vlrMin, Double vlr, Double vlrMax, TabelaPrecoBaseProduto tabProduto) {
        tabProduto.setValorCustoAnterior(tabProduto.getValorCusto());
        tabProduto.setValorCusto(valorCusto);
        tabProduto.setValorVendaAnterior(tabProduto.getValorVenda());
        tabProduto.setValorVenda(vlr);
        tabProduto.setValorMinimo(vlrMin);
        tabProduto.setValorMaximo(vlrMax);
        this.addMessage(result, tabProduto.getProduto(), tabProduto.getValorVendaAnterior(), tabProduto.getValorVenda());
    }

    private void atualizarCriarPreTabPreco(TaskProcessResult result, Double valorCusto, Double vlrMin, Double vlr, Double vlrMax, TabelaPrecoBaseProduto tabProduto, List<PreTabelaPrecoBaseProduto> itens) {
        if (vlr == null) {
            return;
        }
        PreTabelaPrecoBaseProduto preTab = new PreTabelaPrecoBaseProduto();
        preTab.setMargemLucro(tabProduto.getMargemLucro());
        preTab.setPercComissaoPadrao(tabProduto.getPercComissaoPadrao());
        preTab.setValorVendaAnt(tabProduto.getValorVenda());
        preTab.setProduto(tabProduto.getProduto());
        preTab.setTabelaPrecoBaseProduto(tabProduto);
        preTab.setValorCusto(valorCusto);
        preTab.setValorCustoAnt(tabProduto.getValorCusto());
        preTab.setValorVendaAnt(tabProduto.getValorVenda());
        preTab.setValorVenda(vlr);
        this.helperPreTabPreco.build(preTab);
        if (vlrMax != null) {
            preTab.setVlrMaximo(vlrMax);
            this.helperPreTabPreco.calcPercMax();
        } else {
            this.helperPreTabPreco.calcValorMax();
        }
        if (vlrMin != null) {
            preTab.setVlrMinimo(vlrMin);
            this.helperPreTabPreco.calcPercMin();
        } else {
            this.helperPreTabPreco.calcValorMin();
        }
        this.helperPreTabPreco.calcMargemLucro();
        this.addMessage(result, tabProduto.getProduto(), preTab.getValorVendaAnt(), preTab.getValorVenda());
        itens.add(preTab);
    }

    private void addMessage(TaskProcessResult result, Produto produto, Double vlrAnt, Double vlrAtual) {
        result.addDet(EnumConstantsTaskResult.RESULT_OK, "Valor do produto sofreu altera\u00e7\u00f5es relevantes: " + String.valueOf(produto) + " de " + ToolFormatter.formataNumero((Number)vlrAnt, (int)6) + " para " + ToolFormatter.formataNumero((Number)vlrAtual, (int)6));
    }

    private void salvarPreTabPreco(List<PreTabelaPrecoBaseProduto> itens, TabelaPrecoBase tabBase) {
        if (itens.isEmpty()) {
            return;
        }
        PreTabelaPrecoBaseTabBaseVinc vinc = this.servicePreTabelaPrecoBaseVincImpl.getPreTabelaGeradaAutoNaoVinc(tabBase);
        PreTabelaPrecoBase pre = null;
        if (vinc == null) {
            pre = new PreTabelaPrecoBase();
            pre.setDataCadastro(new Date());
            pre.setDescricao("Tabela Automatica - Modulo Precificacao Autonomo");
            pre.setEmpresa(tabBase.getEmpresa());
            vinc = new PreTabelaPrecoBaseTabBaseVinc();
            vinc.setPreTabelaPrecoBase(pre);
            vinc.setTabReferencia(Short.valueOf((short)1));
            vinc.setTabelaVinculada(tabBase);
            pre.getTabelasVinculadas().add(vinc);
        } else {
            pre = vinc.getPreTabelaPrecoBase();
        }
        pre.setDataHoraGerAuto(new Date());
        for (PreTabelaPrecoBaseProduto item : itens) {
            Optional<PreTabelaPrecoBaseProduto> found = pre.getProdutos().stream().filter(i -> ToolMethods.isEquals((Object)i.getTabelaPrecoBaseProduto(), (Object)item.getTabelaPrecoBaseProduto())).findFirst();
            if (found.isPresent()) {
                pre.getProdutos().remove(found.get());
            }
            item.setPreTabelaPrecoBase(pre);
        }
        pre.getProdutos().addAll(itens);
        this.servicePreTabelaPrecoBaseVinc.saveOrUpdate((InterfaceVO)pre);
    }
}

