/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.profrota;

import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementor.constants.enums.profrota.EnumProFrotaStatusAutorizacao;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LogSincronizacao;
import com.touchcomp.basementor.model.vo.OpcoesCtf;
import com.touchcomp.basementorclientwebservices.components.DocProFrota;
import com.touchcomp.basementorclientwebservices.profrota.model.PesquisaAbastecimento;
import com.touchcomp.basementorclientwebservices.profrota.model.RetornoAbastecimento;
import com.touchcomp.basementorexceptions.exceptions.impl.ctf.ExceptionCTF;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.bderrors.CompBDErrors;
import com.touchcomp.basementorservice.components.consumo.CompConsumoAtivo;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.consumoativo.ServiceConsumoAtivoImpl;
import com.touchcomp.basementorservice.service.impl.logsincronizacao.ServiceLogSincronizacaoImpl;
import com.touchcomp.basementorservice.service.impl.motorista.ServiceMotoristaImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import java.util.Date;

class AuxGeraConsumoAtivoProFrota {
    private final DocProFrota docProFrota;
    private final ServiceConsumoAtivoImpl serviceConsumoAtivoImpl;
    private final CompConsumoAtivo compConsumoAtivo;
    private final ServiceLogSincronizacaoImpl serviceLogSincronizacaoImpl;
    private final InterfaceStaticObjects staticObjects;

    public AuxGeraConsumoAtivoProFrota(InterfaceStaticObjects staticObjects, DocProFrota docProFrota, ServiceConsumoAtivoImpl serviceConsumoAtivo, ServiceConsumoAtivoImpl serviceConsumoAtivoImpl, CompConsumoAtivo compConsumoAtivo, ServiceMotoristaImpl serviceMotoristaImpl, ServiceLogSincronizacaoImpl serviceLogSincronizacaoImpl) {
        this.staticObjects = staticObjects;
        this.docProFrota = docProFrota;
        this.serviceConsumoAtivoImpl = serviceConsumoAtivoImpl;
        this.compConsumoAtivo = compConsumoAtivo;
        this.serviceLogSincronizacaoImpl = serviceLogSincronizacaoImpl;
    }

    public void gerarFornecedorConsumoAtivoProFrota(TaskProcessResult result, Empresa empresa, String token, Date dataInicial, Date dataFinal) throws ExceptionIO, ExceptionCTF, ExceptionParamCtbRequisicao, ExceptionWebService, ExceptionInvalidData, ExceptionObjNotFound {
        this.conexaoWebServiceProFrota(empresa, result, token, dataInicial, dataFinal);
        this.salvarLogSincronizacao(dataFinal);
    }

    private void conexaoWebServiceProFrota(Empresa empresa, TaskProcessResult result, String token, Date dataInicial, Date dataFinal) throws ExceptionIO, ExceptionCTF, ExceptionParamCtbRequisicao, ExceptionWebService, ExceptionInvalidData, ExceptionObjNotFound {
        OpcoesCtf opcoesCtf;
        if (dataFinal == null) {
            dataFinal = new Date();
        }
        if (dataInicial == null) {
            LogSincronizacao log = this.serviceLogSincronizacaoImpl.getUltimoLog(EnumConstConfigServicosTerceiros.INTEGRACAO_PRO_FROTA);
            dataInicial = log != null ? log.getDataSincronizacao() : ToolDate.previousDays((Date)dataInicial, (int)60);
        }
        if ((opcoesCtf = this.staticObjects.getOpcoesCtf(empresa)) == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0981.001"));
        }
        boolean hasData = false;
        Integer pagina = 1;
        do {
            PesquisaAbastecimento pesquisaAbastecimento = this.criarDocProFrota(pagina, dataInicial, dataFinal);
            RetornoAbastecimento retorno = this.docProFrota.conexaoWebServiceProFrota(pesquisaAbastecimento, token);
            this.criarConsumo(retorno, opcoesCtf, result);
            hasData = ToolMethods.isWithData((Collection)retorno.getRegistros());
            Integer n = pagina;
            pagina = pagina + 1;
            System.out.println("Pagina: " + pagina);
        } while (hasData);
    }

    private PesquisaAbastecimento criarDocProFrota(Integer pagina, Date dataInicial, Date dataFinal) throws ExceptionIO {
        PesquisaAbastecimento pesquisaAbastecimento = new PesquisaAbastecimento();
        pesquisaAbastecimento.setDataInicial(this.formatarData(dataInicial));
        pesquisaAbastecimento.setDataFinal(this.formatarData(dataFinal));
        pesquisaAbastecimento.setDataInicialAlteracao(this.formatarData(dataInicial));
        pesquisaAbastecimento.setDataFinalAlteracao(this.formatarData(dataFinal));
        pesquisaAbastecimento.setPagina(pagina);
        return pesquisaAbastecimento;
    }

    private String formatarData(Date date) {
        String data = ToolDate.dateToStr((Date)date, (String)"yyyy-MM-dd");
        String hora = ToolDate.dateToStr((Date)date, (String)"HH:mm:ss");
        return data + "T" + hora + "Z";
    }

    private PesquisaAbastecimento criarDocProFrota(int nrDocOrigem) {
        PesquisaAbastecimento pesquisaAbastecimento = new PesquisaAbastecimento();
        pesquisaAbastecimento.setIdentificador(Integer.valueOf(nrDocOrigem));
        return pesquisaAbastecimento;
    }

    private void criarConsumo(RetornoAbastecimento retornoAbastecimento, OpcoesCtf opcoesCtf, TaskProcessResult result) throws ExceptionCTF, ExceptionParamCtbRequisicao {
        for (RetornoAbastecimento.Registro registros : retornoAbastecimento.getRegistros()) {
            ConsumoAtivo consumo = this.serviceConsumoAtivoImpl.getConsumoAtivoCtf(String.valueOf(registros.getIdentificador()));
            this.criarConsumo(consumo, registros, opcoesCtf, result);
        }
    }

    private void criarConsumo(ConsumoAtivo consumo, RetornoAbastecimento.Registro registros, OpcoesCtf opcoesCtf, TaskProcessResult result) throws ExceptionCTF, ExceptionParamCtbRequisicao {
        if (!ToolMethods.isEquals((Object)registros.getStatusAutorizacao(), (Object)EnumProFrotaStatusAutorizacao.AUTORIZADO.getValue())) {
            result.addDet(EnumConstantsTaskResult.RESULT_OK, "Consumo nao adicionado, pois n\u00e3o est\u00e1 com status autorizado: " + registros.getIdentificador());
            return;
        }
        this.criarConsumoAtivoItem(consumo, registros, opcoesCtf, result);
    }

    private void criarConsumoAtivoItem(ConsumoAtivo consumo, RetornoAbastecimento.Registro registros, OpcoesCtf opcoesCtf, TaskProcessResult result) throws ExceptionCTF, ExceptionParamCtbRequisicao {
        try {
            consumo = this.compConsumoAtivo.criarAtualizarConsumoAtivo(consumo, registros, opcoesCtf, result);
            consumo = (ConsumoAtivo)this.serviceConsumoAtivoImpl.saveOrUpdateFlush((InterfaceVO)consumo);
            result.addDet(EnumConstantsTaskResult.RESULT_OK, "Consumo adicionado: " + consumo.getCodigoCTF());
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "Nao foi possivel salvar o consumo: " + registros.getIdentificador() + " Causa: " + CompBDErrors.getProcessedMessage((Throwable)ex));
        }
    }

    public void atualizarConsumoNrRegistro(ConsumoAtivo consumoAtivo, String token, TaskProcessResult result) throws ExceptionWebService, ExceptionIO, ExceptionCTF {
        RetornoAbastecimento retornoAbastecimento = this.docProFrota.conexaoWebServiceProFrota(this.criarDocProFrota(consumoAtivo.getNrDocOrigem().intValue()), token);
        for (RetornoAbastecimento.Registro registro : retornoAbastecimento.getRegistros()) {
            this.compConsumoAtivo.atualizarConsumoAtivo(consumoAtivo, registro, result);
        }
    }

    public void atualizarConsumosProFrota(Date dataInicial, Date dataFinal, String token, TaskProcessResult result) throws ExceptionIO, ExceptionWebService, ExceptionCTF {
        boolean hasData;
        Integer pagina = 1;
        do {
            RetornoAbastecimento retornoAbastecimento = this.docProFrota.conexaoWebServiceProFrota(this.criarDocProFrota(pagina, dataInicial, dataFinal), token);
            for (RetornoAbastecimento.Registro registro : retornoAbastecimento.getRegistros()) {
                ConsumoAtivo consumoAtivo = this.serviceConsumoAtivoImpl.getConsumoAtivoCtf(String.valueOf(registro.getIdentificador()));
                this.compConsumoAtivo.atualizarConsumoAtivo(consumoAtivo, registro, result);
                this.serviceConsumoAtivoImpl.saveOrUpdateFlush((InterfaceVO)consumoAtivo);
            }
            hasData = ToolMethods.isWithData((Collection)retornoAbastecimento.getRegistros());
            Integer n = pagina;
            pagina = pagina + 1;
        } while (hasData);
    }

    private void salvarLogSincronizacao(Date dataFinal) {
        LogSincronizacao l = new LogSincronizacao();
        l.setChaveSincronizacao(EnumConstConfigServicosTerceiros.INTEGRACAO_PRO_FROTA.getChave());
        l.setDataSincronizacao(dataFinal);
        this.serviceLogSincronizacaoImpl.saveOrUpdate((InterfaceVO)l);
    }
}

