/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.profrota;

import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementor.constants.enums.configservicosterceiros.impl.ConstantsProFrota;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.ConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorclientwebservices.components.DocProFrota;
import com.touchcomp.basementorexceptions.exceptions.impl.ctf.ExceptionCTF;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorservice.components.consumo.CompConsumoAtivo;
import com.touchcomp.basementorservice.helpers.impl.configservicosterceiros.HelperConfigServicosTerceiros;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.configservicosterceiros.ServiceConfigServicosTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.consumoativo.ServiceConsumoAtivoImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.logsincronizacao.ServiceLogSincronizacaoImpl;
import com.touchcomp.basementorservice.service.impl.motorista.ServiceMotoristaImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorwebtasks.service.impl.profrota.AuxGeraConsumoAtivoProFrota;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceTASKProFrotaImpl {
    private final DocProFrota docProFrota;
    private final ServiceConsumoAtivoImpl serviceConsumoAtivo;
    private final ServiceConsumoAtivoImpl serviceConsumoAtivoImpl;
    private final CompConsumoAtivo compConsumoAtivo;
    private final ServiceMotoristaImpl serviceMotoristaImpl;
    private final ServiceLogSincronizacaoImpl serviceLogSincronizacaoImpl;
    private final ServiceConfigServicosTerceirosImpl serviceConfigServicosImpl;
    private final HelperConfigServicosTerceiros helperConfigServTerc;
    private final InterfaceStaticObjects staticObjects;
    private final ServiceEmpresaImpl serviceEmpresa;

    public ServiceTASKProFrotaImpl(DocProFrota docProFrota, ServiceConsumoAtivoImpl serviceConsumoAtivo, ServiceConsumoAtivoImpl serviceConsumoAtivoImpl, CompConsumoAtivo compConsumoAtivo, ServiceMotoristaImpl serviceMotoristaImpl, ServiceLogSincronizacaoImpl serviceLogSincronizacaoImpl, ServiceConfigServicosTerceirosImpl serviceConfigServicosImpl, HelperConfigServicosTerceiros helperConfigServTerc, InterfaceStaticObjects staticObjects, ServiceEmpresaImpl serviceEmpresa) {
        this.docProFrota = docProFrota;
        this.serviceConsumoAtivo = serviceConsumoAtivo;
        this.serviceConsumoAtivoImpl = serviceConsumoAtivoImpl;
        this.compConsumoAtivo = compConsumoAtivo;
        this.serviceMotoristaImpl = serviceMotoristaImpl;
        this.serviceLogSincronizacaoImpl = serviceLogSincronizacaoImpl;
        this.serviceConfigServicosImpl = serviceConfigServicosImpl;
        this.helperConfigServTerc = helperConfigServTerc;
        this.staticObjects = staticObjects;
        this.serviceEmpresa = serviceEmpresa;
    }

    public void consumoProFrota(TaskProcessResult result, Date dataInicial, Date dataFinal) throws ExceptionJDom, ExceptionIO, ExceptionCTF, ExceptionParamCtbRequisicao, ExceptionWebService, ExceptionInvalidData, ExceptionObjNotFound {
        List config;
        if (result == null) {
            result = new TaskProcessResult();
        }
        if ((config = this.serviceConfigServicosImpl.getList(EnumConstConfigServicosTerceiros.INTEGRACAO_PRO_FROTA)).isEmpty()) {
            result.addError("E.ERP.1876.001", new Object[]{EnumConstConfigServicosTerceiros.INTEGRACAO_PRO_FROTA.getDescricao()});
        }
        for (ConfigServicosTerceiros conf : config) {
            String token = this.pesquisarToken(conf);
            Empresa empresa = this.pesquisarEmpresa(conf);
            new AuxGeraConsumoAtivoProFrota(this.staticObjects, this.docProFrota, this.serviceConsumoAtivo, this.serviceConsumoAtivoImpl, this.compConsumoAtivo, this.serviceMotoristaImpl, this.serviceLogSincronizacaoImpl).gerarFornecedorConsumoAtivoProFrota(result, empresa, token, dataInicial, dataFinal);
        }
    }

    public void atualizarConsumoNrRegistro(ConsumoAtivo consumoAtivo, ConfigServicosTerceiros configServicosTerceiros, TaskProcessResult result) throws ExceptionInvalidData, ExceptionWebService, ExceptionIO, ExceptionCTF {
        if (ToolMethods.isNull((Object)result).booleanValue()) {
            result = new TaskProcessResult();
        }
        String token = this.pesquisarToken(configServicosTerceiros);
        new AuxGeraConsumoAtivoProFrota(this.staticObjects, this.docProFrota, this.serviceConsumoAtivo, this.serviceConsumoAtivoImpl, this.compConsumoAtivo, this.serviceMotoristaImpl, this.serviceLogSincronizacaoImpl).atualizarConsumoNrRegistro(consumoAtivo, token, result);
    }

    public void atualizarConsumosProFrota(Date dataInicial, Date dataFinal, ConfigServicosTerceiros configServicosTerceiros, TaskProcessResult result) throws ExceptionInvalidData, ExceptionIO, ExceptionWebService, ExceptionCTF {
        if (ToolMethods.isNull((Object)result).booleanValue()) {
            result = new TaskProcessResult();
        }
        String token = this.pesquisarToken(configServicosTerceiros);
        new AuxGeraConsumoAtivoProFrota(this.staticObjects, this.docProFrota, this.serviceConsumoAtivo, this.serviceConsumoAtivoImpl, this.compConsumoAtivo, this.serviceMotoristaImpl, this.serviceLogSincronizacaoImpl).atualizarConsumosProFrota(dataInicial, dataFinal, token, result);
    }

    private String pesquisarToken(ConfigServicosTerceiros configServicosTerceiros) throws ExceptionInvalidData {
        String token = this.helperConfigServTerc.build(configServicosTerceiros).getValue(ConstantsProFrota.TOKEN.getChave());
        if (!ToolMethods.isStrWithData((String)token)) {
            throw new ExceptionInvalidData("E.ERP.1439.004", new Object[0]);
        }
        return token;
    }

    private Empresa pesquisarEmpresa(ConfigServicosTerceiros configServicosTerceiros) throws ExceptionInvalidData {
        String idEmpresa = this.helperConfigServTerc.build(configServicosTerceiros).getValue(ConstantsProFrota.ID_EMPRESA.getChave());
        if (!ToolMethods.isStrWithData((String)idEmpresa)) {
            throw new ExceptionInvalidData("E.ERP.1439.005", new Object[0]);
        }
        Empresa empresa = (Empresa)this.serviceEmpresa.get(idEmpresa);
        if (empresa == null) {
            throw new ExceptionInvalidData("E.ERP.0049.001", new Object[0]);
        }
        return empresa;
    }
}

