/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.rastreamentokrona;

import com.fasterxml.jackson.core.JsonParser;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CTeNFe;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ConjuntoTranspVeiculo;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Motorista;
import com.touchcomp.basementor.model.vo.PessoaTransporte;
import com.touchcomp.basementorclientwebservices.components.DocKrona;
import com.touchcomp.basementorclientwebservices.rastreamentokrona.model.destinos;
import com.touchcomp.basementorclientwebservices.rastreamentokrona.model.krona;
import com.touchcomp.basementorclientwebservices.rastreamentokrona.model.kronaService;
import com.touchcomp.basementorclientwebservices.rastreamentokrona.model.motorista_1;
import com.touchcomp.basementorclientwebservices.rastreamentokrona.model.origem;
import com.touchcomp.basementorclientwebservices.rastreamentokrona.model.reboque_1;
import com.touchcomp.basementorclientwebservices.rastreamentokrona.model.reboque_2;
import com.touchcomp.basementorclientwebservices.rastreamentokrona.model.retorno_krona;
import com.touchcomp.basementorclientwebservices.rastreamentokrona.model.transportador;
import com.touchcomp.basementorclientwebservices.rastreamentokrona.model.usuario_login;
import com.touchcomp.basementorclientwebservices.rastreamentokrona.model.veiculo;
import com.touchcomp.basementorclientwebservices.rastreamentokrona.model.viagem;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.interfaces.ServiceCte;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class UtilRastreamentoKrona {
    private final TaskProcessResult result;
    private final ServiceCte serviceCte = (ServiceCte)ConfApplicationContext.getBean(ServiceCte.class);
    private final DocKrona docKrona = (DocKrona)ConfApplicationContext.getBean(DocKrona.class);

    public UtilRastreamentoKrona(TaskProcessResult result) {
        this.result = result;
    }

    public void envioRastreamentoKrona(String login, String senha) throws ExceptionIO, ExceptionWebService {
        ArrayList<HashMap> listKrona = new ArrayList<HashMap>();
        List listCte = this.serviceCte.getCtesParaEnviarStratumKrona();
        this.verificarPlacasDuplicadas(listKrona, listCte, login, senha);
        this.enviarArquivoKrona(listKrona);
    }

    private void verificarPlacasDuplicadas(List<HashMap> listKrona, List<Cte> listCte, String login, String senha) {
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        for (Cte cte : listCte) {
            this.agruparPorRemetente(list, cte);
        }
        for (Cte cte : listCte) {
            this.agruparPorConjuntoTransportador(list, cte);
        }
        this.criarArquivoKrona(listKrona, list, login, senha);
    }

    private void agruparPorRemetente(List<HashMap> list, Cte cte) {
        Boolean b = true;
        for (HashMap hRementente : list) {
            if (cte.getUnidadeFatTransporteExpedidor() != null) {
                if (!ToolMethods.isEquals(hRementente.get("REMETENTE"), (Object)cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte())) continue;
                b = false;
                continue;
            }
            if (!ToolMethods.isEquals(hRementente.get("REMETENTE"), (Object)cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte())) continue;
            b = false;
        }
        if (b.booleanValue()) {
            HashMap<String, Object> hRementente = new HashMap<String, Object>();
            if (cte.getUnidadeFatTransporteExpedidor() != null) {
                hRementente.put("REMETENTE", cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte());
            } else {
                hRementente.put("REMETENTE", cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte());
            }
            hRementente.put("LIST_CONJUNTO_TRANSPORTADOR", new ArrayList());
            list.add(hRementente);
        }
    }

    private void agruparPorConjuntoTransportador(List<HashMap> list, Cte cte) {
        PessoaTransporte rementeExpedidor = cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte();
        if (cte.getUnidadeFatTransporteExpedidor() != null) {
            rementeExpedidor = cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte();
        }
        for (HashMap hRemetente : list) {
            HashMap<String, Object> hConjuntoTransportador2;
            if (!ToolMethods.isEquals(hRemetente.get("REMETENTE"), (Object)rementeExpedidor)) continue;
            Boolean b = true;
            for (HashMap<String, Object> hConjuntoTransportador2 : (List)hRemetente.get("LIST_CONJUNTO_TRANSPORTADOR")) {
                if (!ToolMethods.isEquals(hConjuntoTransportador2.get("CONJUNTO_TRANSPORTADOR"), (Object)cte.getConjuntoTransportador())) continue;
                ((List)hConjuntoTransportador2.get("LIST_CTE")).add(cte);
                b = false;
            }
            if (!b.booleanValue()) continue;
            List listConjuntoTransportador = (List)hRemetente.get("LIST_CONJUNTO_TRANSPORTADOR");
            hConjuntoTransportador2 = new HashMap<String, Object>();
            hConjuntoTransportador2.put("CONJUNTO_TRANSPORTADOR", cte.getConjuntoTransportador());
            ArrayList<Cte> listCte = new ArrayList<Cte>();
            listCte.add(cte);
            hConjuntoTransportador2.put("LIST_CTE", listCte);
            listConjuntoTransportador.add(hConjuntoTransportador2);
        }
    }

    private void criarArquivoKrona(List<HashMap> listKrona, List<HashMap> list, String login, String senha) {
        for (HashMap hRemetente : list) {
            for (HashMap hConjuntoTransportador : (List)hRemetente.get("LIST_CONJUNTO_TRANSPORTADOR")) {
                HashMap<String, Object> hKrona = new HashMap<String, Object>();
                hKrona.put("KRONA", this.criarArquivoEnvioCte((ConjuntoTransportador)hConjuntoTransportador.get("CONJUNTO_TRANSPORTADOR"), (List)hConjuntoTransportador.get("LIST_CTE"), (PessoaTransporte)hRemetente.get("REMETENTE"), login, senha));
                hKrona.put("LIST_CTE", hConjuntoTransportador.get("LIST_CTE"));
                listKrona.add(hKrona);
            }
        }
    }

    private krona criarArquivoEnvioCte(ConjuntoTransportador conjuntoTransportador, List<Cte> listCte, PessoaTransporte remetente, String login, String senha) {
        krona krona2 = new krona();
        krona2.setKronaService(this.setKronaService(conjuntoTransportador, listCte, remetente, login, senha));
        return krona2;
    }

    private kronaService setKronaService(ConjuntoTransportador conjuntoTransportador, List<Cte> listCte, PessoaTransporte remetente, String login, String senha) {
        kronaService kronaService2 = new kronaService();
        kronaService2.setUsuario_login(this.setUsuarioLogin(login, senha));
        kronaService2.setTransportador(this.setTransportador(listCte.get(0).getEmpresa()));
        kronaService2.setMotorista_1(this.setMotorista1(conjuntoTransportador.getMotorista()));
        int i = 1;
        for (ConjuntoTranspVeiculo conjuntoTranspVeiculo : conjuntoTransportador.getConjuntoTranspVeiculo()) {
            if (conjuntoTranspVeiculo.getVeiculo().getTipoVeiculo().getTipoVeiculoCte().getCodigo().equals("0")) {
                kronaService2.setVeiculo(this.setVeiculo(conjuntoTranspVeiculo));
                continue;
            }
            if (i == 1) {
                kronaService2.setReboque_1(this.setReboque1(conjuntoTranspVeiculo));
                ++i;
                continue;
            }
            kronaService2.setReboque_2(this.setReboque2(conjuntoTranspVeiculo));
        }
        kronaService2.setOrigem(this.setOrigem(remetente));
        kronaService2.setDestinos(this.setDestinos(listCte));
        kronaService2.setViagem(this.setViagem(listCte));
        return kronaService2;
    }

    private usuario_login setUsuarioLogin(String login, String senha) {
        usuario_login usuarioLogin = new usuario_login();
        usuarioLogin.setLogin(login);
        usuarioLogin.setSenha(senha);
        return usuarioLogin;
    }

    private transportador setTransportador(Empresa empresa) {
        transportador transportador2 = new transportador();
        transportador2.setTipo("TRANSPORTADOR");
        transportador2.setCnpj(this.verificarCpfCnpj(empresa.getPessoa().getComplemento().getCnpj()));
        transportador2.setRazao_social(ToolString.clearSpecialCharacXML((String)empresa.getPessoa().getNome().toUpperCase()));
        if (empresa.getPessoa().getNomeFantasia() != null) {
            transportador2.setNome_fantasia(ToolString.clearSpecialCharacXML((String)empresa.getPessoa().getNomeFantasia().toUpperCase()));
        } else {
            transportador2.setNome_fantasia("");
        }
        transportador2.setUnidade("001");
        transportador2.setCodigo("");
        transportador2.setEnd_rua(ToolString.clearSpecialCharacXML((String)empresa.getPessoa().getEndereco().getLogradouro().toUpperCase()));
        transportador2.setEnd_numero(this.verificarNumeroEndereco(empresa.getPessoa().getEndereco().getNumero()));
        if (empresa.getPessoa().getEndereco().getComplemento() != null) {
            transportador2.setEnd_complemento(ToolString.clearSpecialCharacXML((String)empresa.getPessoa().getEndereco().getComplemento().toUpperCase()));
        } else {
            transportador2.setEnd_complemento("");
        }
        transportador2.setEnd_bairro(ToolString.clearSpecialCharacXML((String)empresa.getPessoa().getEndereco().getBairro().toUpperCase()));
        transportador2.setEnd_cidade(ToolString.clearSpecialCharacXML((String)empresa.getPessoa().getEndereco().getCidade().getDescricao().toUpperCase()));
        transportador2.setEnd_uf(empresa.getPessoa().getEndereco().getCidade().getUf().getSigla().toUpperCase());
        transportador2.setEnd_cep(this.verificarCep(empresa.getPessoa().getEndereco().getCep()));
        transportador2.setLatitude(empresa.getPessoa().getLatitude().toString());
        transportador2.setLongitude(empresa.getPessoa().getLongitude().toString());
        transportador2.setTelefone_1(this.verificarTelefone(empresa.getPessoa().getComplemento().getFone1(), empresa.getPessoa().getComplemento().getFone1()));
        transportador2.setTelefone_2(this.verificarTelefone(empresa.getPessoa().getComplemento().getFone2(), empresa.getPessoa().getComplemento().getFone2()));
        if (empresa.getPessoa().getPessoaContato() != null) {
            transportador2.setResponsavel(ToolString.clearSpecialCharacXML((String)empresa.getPessoa().getPessoaContato().toUpperCase()));
        } else {
            transportador2.setResponsavel("");
        }
        transportador2.setResponsavel_cargo("");
        transportador2.setResponsavel_telefone(this.verificarTelefone(empresa.getPessoa().getComplemento().getFone1(), empresa.getPessoa().getComplemento().getFone2()));
        transportador2.setResponsavel_celular(this.verificarCel(empresa.getPessoa().getComplemento().getCel1(), empresa.getPessoa().getComplemento().getCel2()));
        if (empresa.getPessoa().getComplemento().getEmailPrincipal() != null) {
            transportador2.setResponsavel_email(empresa.getPessoa().getComplemento().getEmailPrincipal().toUpperCase());
        } else {
            transportador2.setResponsavel_email("");
        }
        return transportador2;
    }

    private motorista_1 setMotorista1(Motorista motorista) {
        motorista_1 motorista1 = new motorista_1();
        motorista1.setNome(ToolString.clearSpecialCharacXML((String)motorista.getPessoa().getNome().toUpperCase()));
        motorista1.setCpf(this.verificarCpfCnpj(motorista.getPessoa().getComplemento().getCnpj()));
        motorista1.setRg(motorista.getPessoa().getComplemento().getRg());
        motorista1.setOrgao_emissor(motorista.getPessoa().getComplemento().getOrgaoEmissor().toUpperCase());
        motorista1.setData_nascimento(ToolDate.dateToStr((Date)motorista.getPessoa().getComplemento().getDataNascimento(), (String)"yyyy-MM-dd"));
        motorista1.setNome_mae("");
        motorista1.setEstado_civil("");
        motorista1.setEscolaridade("");
        motorista1.setCnh_numero(motorista.getNumeroCNH());
        motorista1.setCnh_categoria(motorista.getCategoriaCNH());
        motorista1.setCnh_vencimento(ToolDate.dateToStr((Date)motorista.getDataVencimentoCNH(), (String)"yyyy-MM-dd"));
        motorista1.setEnd_rua(ToolString.clearSpecialCharacXML((String)motorista.getPessoa().getEndereco().getLogradouro().toUpperCase()));
        motorista1.setEnd_numero(this.verificarNumeroEndereco(motorista.getPessoa().getEndereco().getNumero()));
        if (motorista.getPessoa().getEndereco().getComplemento() != null) {
            motorista1.setEnd_complemento(ToolString.clearSpecialCharacXML((String)motorista.getPessoa().getEndereco().getComplemento().toUpperCase()));
        } else {
            motorista1.setEnd_complemento("");
        }
        motorista1.setEnd_bairro(ToolString.clearSpecialCharacXML((String)motorista.getPessoa().getEndereco().getBairro().toUpperCase()));
        motorista1.setEnd_cidade(ToolString.clearSpecialCharacXML((String)motorista.getPessoa().getEndereco().getCidade().getDescricao().toUpperCase()));
        motorista1.setEnd_uf(motorista.getPessoa().getEndereco().getCidade().getUf().getSigla().toUpperCase());
        motorista1.setEnd_cep(this.verificarCep(motorista.getPessoa().getEndereco().getCep()));
        motorista1.setTel_fixo(this.verificarTelefone(motorista.getPessoa().getComplemento().getFone1(), motorista.getPessoa().getComplemento().getFone2()));
        motorista1.setTel_celular(this.verificarCel(motorista.getPessoa().getComplemento().getCel1(), motorista.getPessoa().getComplemento().getCel2()));
        motorista1.setNextel("");
        motorista1.setMopp("0000-00-00");
        motorista1.setAso("0000-00-00");
        motorista1.setCdd("0000-00-00");
        motorista1.setCapacitacao("0000-00-00");
        if (motorista.getMotoristaProprio().equals(EnumConstantsMentorSimNao.SIM.value)) {
            motorista1.setVinculo("FROTA");
        } else {
            motorista1.setVinculo("AGREGADO");
        }
        return motorista1;
    }

    private veiculo setVeiculo(ConjuntoTranspVeiculo conjuntoTranspVeiculo) {
        veiculo veiculo2 = new veiculo();
        veiculo2.setPlaca(this.verificarPlaca(conjuntoTranspVeiculo.getVeiculo().getPlaca().toUpperCase()));
        veiculo2.setRenavan(conjuntoTranspVeiculo.getVeiculo().getNumeroRenavan());
        veiculo2.setMarca(conjuntoTranspVeiculo.getVeiculo().getMarcaModelo().toUpperCase());
        veiculo2.setModelo(conjuntoTranspVeiculo.getVeiculo().getMarcaModelo().toUpperCase());
        veiculo2.setCor(conjuntoTranspVeiculo.getVeiculo().getCorPredominante().toUpperCase());
        veiculo2.setAno(conjuntoTranspVeiculo.getVeiculo().getAnoFabricacao());
        if (conjuntoTranspVeiculo.getConjuntoTransportador().getConjuntoTranspVeiculo().size() > 1) {
            veiculo2.setTipo("CAVALO MECANICO");
        } else {
            veiculo2.setTipo("TRUCK");
        }
        veiculo2.setCapacidade("");
        veiculo2.setNumero_antt("");
        veiculo2.setValidade_antt("0000-00-00");
        veiculo2.setNumero_frota("");
        veiculo2.setTransp_frota("");
        veiculo2.setProprietario(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getNome().toUpperCase()));
        veiculo2.setProprietario_cpfcnpj(this.verificarCpfCnpj(conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getComplemento().getCnpj()));
        veiculo2.setEnd_rua(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getLogradouro().toUpperCase()));
        veiculo2.setEnd_numero(this.verificarNumeroEndereco(conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getNumero()));
        if (conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getComplemento() != null) {
            veiculo2.setEnd_complemento(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getComplemento().toUpperCase()));
        } else {
            veiculo2.setEnd_complemento("");
        }
        veiculo2.setEnd_bairro(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getBairro().toUpperCase()));
        veiculo2.setEnd_cidade(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getCidade().getDescricao().toUpperCase()));
        veiculo2.setEnd_uf(conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getCidade().getUf().getSigla().toUpperCase());
        veiculo2.setEnd_cep(this.verificarCep(conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getCep()));
        veiculo2.setTecnologia(conjuntoTranspVeiculo.getVeiculo().getTecnologia());
        veiculo2.setId_rastreador(conjuntoTranspVeiculo.getVeiculo().getIdRastreador());
        veiculo2.setComunicacao(conjuntoTranspVeiculo.getVeiculo().getComunicacao());
        veiculo2.setTecnologia_sec("");
        veiculo2.setId_rastreador_sec("");
        veiculo2.setComunicacao_sec("");
        veiculo2.setFixo("N");
        return veiculo2;
    }

    private reboque_1 setReboque1(ConjuntoTranspVeiculo conjuntoTranspVeiculo) {
        reboque_1 reboque1 = new reboque_1();
        reboque1.setPlaca(this.verificarPlaca(conjuntoTranspVeiculo.getVeiculo().getPlaca().toUpperCase()));
        reboque1.setRenavan(conjuntoTranspVeiculo.getVeiculo().getNumeroRenavan());
        reboque1.setMarca(conjuntoTranspVeiculo.getVeiculo().getMarcaModelo().toUpperCase());
        reboque1.setModelo(conjuntoTranspVeiculo.getVeiculo().getMarcaModelo().toUpperCase());
        reboque1.setCor(conjuntoTranspVeiculo.getVeiculo().getCorPredominante().toUpperCase());
        reboque1.setAno(conjuntoTranspVeiculo.getVeiculo().getAnoFabricacao());
        reboque1.setTipo("CARRETA TANQUE");
        reboque1.setCapacidade("");
        reboque1.setNumero_antt("");
        reboque1.setValidade_antt("");
        reboque1.setNumero_frota("");
        reboque1.setTransp_frota("");
        reboque1.setProprietario(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getNome().toUpperCase()));
        reboque1.setProprietario_cpfcnpj(this.verificarCpfCnpj(conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getComplemento().getCnpj()));
        reboque1.setEnd_rua(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getLogradouro().toUpperCase()));
        reboque1.setEnd_numero(this.verificarNumeroEndereco(conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getNumero().toUpperCase()));
        if (conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getComplemento() != null) {
            reboque1.setEnd_complemento(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getComplemento().toUpperCase()));
        } else {
            reboque1.setEnd_complemento("");
        }
        reboque1.setEnd_bairro(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getBairro().toUpperCase()));
        reboque1.setEnd_cidade(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getCidade().getDescricao().toUpperCase()));
        reboque1.setEnd_uf(conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getCidade().getUf().getSigla().toUpperCase());
        reboque1.setEnd_cep(this.verificarCep(conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getCep()));
        reboque1.setTecnologia(conjuntoTranspVeiculo.getVeiculo().getTecnologia());
        reboque1.setId_rastreador(conjuntoTranspVeiculo.getVeiculo().getIdRastreador());
        reboque1.setComunicacao(conjuntoTranspVeiculo.getVeiculo().getComunicacao());
        reboque1.setTecnologia_sec("");
        reboque1.setId_rastreador_sec("");
        reboque1.setComunicacao_sec("");
        reboque1.setFixo("N");
        return reboque1;
    }

    private reboque_2 setReboque2(ConjuntoTranspVeiculo conjuntoTranspVeiculo) {
        reboque_2 reboque2 = new reboque_2();
        reboque2.setPlaca(this.verificarPlaca(conjuntoTranspVeiculo.getVeiculo().getPlaca().toUpperCase()));
        reboque2.setRenavan(conjuntoTranspVeiculo.getVeiculo().getNumeroRenavan());
        reboque2.setMarca(conjuntoTranspVeiculo.getVeiculo().getMarcaModelo().toUpperCase());
        reboque2.setModelo(conjuntoTranspVeiculo.getVeiculo().getMarcaModelo().toUpperCase());
        reboque2.setCor(conjuntoTranspVeiculo.getVeiculo().getCorPredominante().toUpperCase());
        reboque2.setAno(conjuntoTranspVeiculo.getVeiculo().getAnoFabricacao());
        reboque2.setTipo("CARRETA TANQUE");
        reboque2.setCapacidade("");
        reboque2.setNumero_antt("");
        reboque2.setValidade_antt("");
        reboque2.setNumero_frota("");
        reboque2.setTransp_frota("");
        reboque2.setProprietario(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getNome().toUpperCase()));
        reboque2.setProprietario_cpfcnpj(this.verificarCpfCnpj(conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getComplemento().getCnpj()));
        reboque2.setEnd_rua(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getLogradouro().toUpperCase()));
        reboque2.setEnd_numero(this.verificarNumeroEndereco(conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getNumero()));
        if (conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getComplemento() != null) {
            reboque2.setEnd_complemento(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getComplemento().toUpperCase()));
        } else {
            reboque2.setEnd_complemento("");
        }
        reboque2.setEnd_bairro(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getBairro().toUpperCase()));
        reboque2.setEnd_cidade(ToolString.clearSpecialCharacXML((String)conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getCidade().getDescricao().toUpperCase()));
        reboque2.setEnd_uf(conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getCidade().getUf().getSigla().toUpperCase());
        reboque2.setEnd_cep(this.verificarCep(conjuntoTranspVeiculo.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getEndereco().getCep()));
        reboque2.setTecnologia(conjuntoTranspVeiculo.getVeiculo().getTecnologia());
        reboque2.setId_rastreador(conjuntoTranspVeiculo.getVeiculo().getIdRastreador());
        reboque2.setComunicacao(conjuntoTranspVeiculo.getVeiculo().getComunicacao());
        reboque2.setTecnologia_sec("");
        reboque2.setId_rastreador_sec("");
        reboque2.setComunicacao_sec("");
        reboque2.setFixo("N");
        return reboque2;
    }

    private origem setOrigem(PessoaTransporte remetente) {
        origem origem2 = new origem();
        origem2.setTipo("OUTROS");
        origem2.setCnpj(this.verificarCpfCnpj(remetente.getPessoa().getComplemento().getCnpj()));
        origem2.setRazao_social(ToolString.clearSpecialCharacXML((String)remetente.getPessoa().getNome().toUpperCase()));
        if (remetente.getPessoa().getNomeFantasia() != null) {
            origem2.setNome_fantasia(ToolString.clearSpecialCharacXML((String)remetente.getPessoa().getNomeFantasia().toUpperCase()));
        } else {
            origem2.setNome_fantasia("");
        }
        origem2.setUnidade("001");
        origem2.setCodigo("");
        origem2.setEnd_rua(ToolString.clearSpecialCharacXML((String)remetente.getPessoa().getEndereco().getLogradouro().toUpperCase()));
        origem2.setEnd_numero(this.verificarNumeroEndereco(remetente.getPessoa().getEndereco().getNumero()));
        if (remetente.getPessoa().getEndereco().getComplemento() != null) {
            origem2.setEnd_complemento(ToolString.clearSpecialCharacXML((String)remetente.getPessoa().getEndereco().getComplemento().toUpperCase()));
        } else {
            origem2.setEnd_complemento("");
        }
        origem2.setEnd_bairro(ToolString.clearSpecialCharacXML((String)remetente.getPessoa().getEndereco().getBairro().toUpperCase()));
        origem2.setEnd_cidade(ToolString.clearSpecialCharacXML((String)remetente.getPessoa().getEndereco().getCidade().getDescricao().toUpperCase()));
        origem2.setEnd_uf(remetente.getPessoa().getEndereco().getCidade().getUf().getSigla().toUpperCase());
        origem2.setEnd_cep(this.verificarCep(remetente.getPessoa().getEndereco().getCep()));
        origem2.setLatitude("0");
        origem2.setLongitude("0");
        if (remetente.getPessoa().getComplemento().getFone1() != null) {
            origem2.setTelefone_1(this.verificarTelefone(remetente.getPessoa().getComplemento().getFone1(), remetente.getPessoa().getComplemento().getFone1()));
        } else {
            origem2.setTelefone_1("(00)0000-0000");
        }
        if (remetente.getPessoa().getComplemento().getFone2() != null) {
            origem2.setTelefone_2(this.verificarTelefone(remetente.getPessoa().getComplemento().getFone2(), remetente.getPessoa().getComplemento().getFone2()));
        } else {
            origem2.setTelefone_2("(00)0000-0000");
        }
        if (remetente.getPessoa().getPessoaContato() != null) {
            origem2.setResponsavel(ToolString.clearSpecialCharacXML((String)remetente.getPessoa().getPessoaContato().toUpperCase()));
        } else {
            origem2.setResponsavel("");
        }
        origem2.setResponsavel_cargo("");
        origem2.setResponsavel_telefone(this.verificarTelefone(remetente.getPessoa().getComplemento().getFone1(), remetente.getPessoa().getComplemento().getFone2()));
        origem2.setResponsavel_celular(this.verificarCel(remetente.getPessoa().getComplemento().getCel1(), remetente.getPessoa().getComplemento().getCel2()));
        if (remetente.getPessoa().getComplemento().getEmailPrincipal() != null) {
            origem2.setResponsavel_email(remetente.getPessoa().getComplemento().getEmailPrincipal().toUpperCase());
        } else {
            origem2.setResponsavel_email("");
        }
        return origem2;
    }

    private List<HashMap<Integer, destinos>> setDestinos(List<Cte> listCte) {
        ArrayList<HashMap<Integer, destinos>> listDestinos = new ArrayList<HashMap<Integer, destinos>>();
        int i = 1;
        for (Cte cte : listCte) {
            PessoaTransporte destinatarioRecebedor = cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte();
            if (cte.getUnidadeFatTransporteRecebedor() != null) {
                destinatarioRecebedor = cte.getUnidadeFatTransporteRecebedor().getPessoaTransporte();
            }
            Boolean b = true;
            int n = 1;
            for (HashMap hashMap : listDestinos) {
                if (ToolMethods.isEquals((Object)((destinos)hashMap.get(n)).getCnpj(), (Object)this.verificarCpfCnpj(destinatarioRecebedor.getPessoa().getComplemento().getCnpj()))) {
                    b = false;
                }
                ++n;
            }
            if (!b.booleanValue()) continue;
            HashMap<Integer, destinos> hh = new HashMap<Integer, destinos>();
            destinos destinos2 = new destinos();
            destinos2.setTipo("OUTROS");
            destinos2.setCnpj(this.verificarCpfCnpj(destinatarioRecebedor.getPessoa().getComplemento().getCnpj()));
            destinos2.setRazao_social(ToolString.clearSpecialCharacXML((String)destinatarioRecebedor.getPessoa().getNome().toUpperCase()));
            if (destinatarioRecebedor.getPessoa().getNomeFantasia() != null) {
                destinos2.setNome_fantasia(ToolString.clearSpecialCharacXML((String)destinatarioRecebedor.getPessoa().getNomeFantasia().toUpperCase()));
            } else {
                destinos2.setNome_fantasia("");
            }
            destinos2.setUnidade("001");
            destinos2.setCodigo("");
            destinos2.setEnd_rua(ToolString.clearSpecialCharacXML((String)destinatarioRecebedor.getPessoa().getEndereco().getLogradouro().toUpperCase()));
            destinos2.setEnd_numero(this.verificarNumeroEndereco(destinatarioRecebedor.getPessoa().getEndereco().getNumero()));
            if (destinatarioRecebedor.getPessoa().getEndereco().getComplemento() != null) {
                destinos2.setEnd_complemento(ToolString.clearSpecialCharacXML((String)destinatarioRecebedor.getPessoa().getEndereco().getComplemento().toUpperCase()));
            } else {
                destinos2.setEnd_complemento("");
            }
            destinos2.setEnd_bairro(ToolString.clearSpecialCharacXML((String)destinatarioRecebedor.getPessoa().getEndereco().getBairro().toUpperCase()));
            destinos2.setEnd_cidade(ToolString.clearSpecialCharacXML((String)destinatarioRecebedor.getPessoa().getEndereco().getCidade().getDescricao().toUpperCase()));
            destinos2.setEnd_uf(destinatarioRecebedor.getPessoa().getEndereco().getCidade().getUf().getSigla().toUpperCase());
            destinos2.setEnd_cep(this.verificarCep(destinatarioRecebedor.getPessoa().getEndereco().getCep()));
            destinos2.setLatitude("");
            destinos2.setLongitude("");
            destinos2.setTelefone_1(this.verificarTelefone(destinatarioRecebedor.getPessoa().getComplemento().getFone1(), destinatarioRecebedor.getPessoa().getComplemento().getFone1()));
            destinos2.setTelefone_2(this.verificarTelefone(destinatarioRecebedor.getPessoa().getComplemento().getFone2(), destinatarioRecebedor.getPessoa().getComplemento().getFone2()));
            if (destinatarioRecebedor.getPessoa().getPessoaContato() != null) {
                destinos2.setResponsavel(ToolString.clearSpecialCharacXML((String)destinatarioRecebedor.getPessoa().getPessoaContato().toUpperCase()));
            } else {
                destinos2.setResponsavel("");
            }
            destinos2.setResponsavel_cargo("");
            destinos2.setResponsavel_telefone(this.verificarTelefone(destinatarioRecebedor.getPessoa().getComplemento().getFone1(), destinatarioRecebedor.getPessoa().getComplemento().getFone2()));
            destinos2.setResponsavel_celular(this.verificarCel(destinatarioRecebedor.getPessoa().getComplemento().getCel1(), destinatarioRecebedor.getPessoa().getComplemento().getCel2()));
            if (destinatarioRecebedor.getPessoa().getComplemento().getEmailPrincipal() != null) {
                destinos2.setResponsavel_email(destinatarioRecebedor.getPessoa().getComplemento().getEmailPrincipal().toUpperCase());
            } else {
                destinos2.setResponsavel_email("");
            }
            hh.put(i, destinos2);
            listDestinos.add(hh);
            ++i;
        }
        return listDestinos;
    }

    private viagem setViagem(List<Cte> listCte) {
        viagem viagem2 = new viagem();
        viagem2.setTipo_viagem("ENTREGA UNICA");
        viagem2.setRastreada("S");
        viagem2.setPercurso("RODOVIARIO");
        viagem2.setTipo_cliente("OUTROS");
        viagem2.setFpp("");
        viagem2.setMercadoria_id(Long.valueOf("7").toString());
        Double valorTotalMercadoria = 0.0;
        Object numeroCte = "";
        Object numeroNfe = "";
        ArrayList<Cidade> listCidade = new ArrayList<Cidade>();
        for (Cte cte : listCte) {
            valorTotalMercadoria = valorTotalMercadoria + cte.getCteInfCarga().getValorTotalMercadorias();
            if (((String)numeroCte).length() > 0) {
                numeroCte = (String)numeroCte + " / ";
            }
            numeroCte = (String)numeroCte + cte.getNumero().toString();
            if (cte.getUnidadeFatTransporteExpedidor() != null) {
                if (!listCidade.contains(cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte().getPessoa().getEndereco().getCidade())) {
                    listCidade.add(cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte().getPessoa().getEndereco().getCidade());
                }
            } else if (!listCidade.contains(cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getEndereco().getCidade())) {
                listCidade.add(cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getEndereco().getCidade());
            }
            if (cte.getUnidadeFatTransporteRecebedor() != null) {
                if (!listCidade.contains(cte.getUnidadeFatTransporteRecebedor().getPessoaTransporte().getPessoa().getEndereco().getCidade())) {
                    listCidade.add(cte.getUnidadeFatTransporteRecebedor().getPessoaTransporte().getPessoa().getEndereco().getCidade());
                }
            } else if (!listCidade.contains(cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getEndereco().getCidade())) {
                listCidade.add(cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getEndereco().getCidade());
            }
            for (CTeNFe cteNfe : cte.getCteNfe()) {
                if (((String)numeroNfe).length() > 0) {
                    numeroNfe = (String)numeroNfe + " / ";
                }
                numeroNfe = (String)numeroNfe + cteNfe.getNrNota().toString();
            }
        }
        viagem2.setValor(valorTotalMercadoria.toString());
        viagem2.setDoca_origem((String)numeroCte);
        Object rota = "";
        for (Cidade c : listCidade) {
            if (((String)rota).length() > 0) {
                rota = (String)rota + " / ";
            }
            rota = (String)rota + c.getDescricao().toUpperCase() + " - " + c.getUf().getSigla().toUpperCase();
        }
        viagem2.setRota((String)rota);
        viagem2.setNumero_cliente((String)numeroNfe);
        viagem2.setInicio_previsto(ToolDate.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        viagem2.setFim_previsto(ToolDate.dateToStr((Date)ToolDate.nextDays((Date)new Date(), (int)3), (String)"yyyy-MM-dd HH:mm:ss"));
        viagem2.setLiberacao("LIBERADO");
        viagem2.setObservacao("");
        viagem2.setLocalizador1_1("");
        viagem2.setId_localizador1_1("");
        viagem2.setLocalizador1_2("");
        viagem2.setId_localizador1_2("");
        viagem2.setLocalizador1_3("");
        viagem2.setId_localizador1_3("");
        viagem2.setLocalizador2_1("");
        viagem2.setId_localizador2_1("");
        viagem2.setLocalizador2_2("");
        viagem2.setId_localizador2_2("");
        viagem2.setLocalizador2_3("");
        viagem2.setId_localizador2_3("");
        viagem2.setLocalizador3_1("");
        viagem2.setId_localizador3_1("");
        viagem2.setLocalizador3_2("");
        viagem2.setId_localizador3_2("");
        viagem2.setLocalizador3_3("");
        viagem2.setId_localizador3_3("");
        return viagem2;
    }

    private String verificarCpfCnpj(String cpfCnpj) {
        Object text = "";
        text = cpfCnpj.length() == 14 ? (String)text + cpfCnpj.substring(0, 2) + "." + cpfCnpj.substring(2, 5) + "." + cpfCnpj.substring(5, 8) + "/" + cpfCnpj.substring(8, 12) + "-" + cpfCnpj.substring(12, 14) : (String)text + cpfCnpj.substring(0, 3) + "." + cpfCnpj.substring(3, 6) + "." + cpfCnpj.substring(6, 9) + "-" + cpfCnpj.substring(9, 11);
        return text;
    }

    private String verificarNumeroEndereco(String numero) {
        if (numero != null && numero.length() > 0 && !numero.substring(0, 1).equalsIgnoreCase("S")) {
            return numero;
        }
        return "0";
    }

    private String verificarCep(String cep) {
        return cep.substring(0, 5) + "-" + cep.substring(5, 8);
    }

    private String verificarTelefone(String tel1, String tel2) {
        Object text = "";
        if (tel1 != null && tel1.length() == 10) {
            text = "(" + tel1.substring(0, 2) + ")" + tel1.substring(2, 6) + "-" + tel1.substring(6, 10);
        } else if (tel2 != null && tel2.length() == 10) {
            text = "(" + tel2.substring(0, 2) + ")" + tel2.substring(2, 6) + "-" + tel2.substring(6, 10);
        }
        return text;
    }

    private String verificarCel(String cel1, String cel2) {
        Object text = "";
        if (cel1 != null && cel1.length() == 11) {
            text = "(" + cel1.substring(0, 2) + ")" + cel1.substring(2, 7) + "-" + cel1.substring(7, 11);
        } else if (cel2 != null && cel2.length() == 11) {
            text = "(" + cel2.substring(0, 2) + ")" + cel2.substring(2, 7) + "-" + cel2.substring(7, 11);
        }
        return text;
    }

    private String verificarPlaca(String placa) {
        return placa.substring(0, 3) + "-" + placa.substring(3, 7);
    }

    private void enviarArquivoKrona(List<HashMap> listKrona) throws ExceptionIO, ExceptionWebService {
        for (HashMap h : listKrona) {
            String json = ToolJson.toJson(h.get("KRONA")).replace("[", "").replace("]", "").replace("}},{", "},");
            this.main(json, (List)h.get("LIST_CTE"));
        }
    }

    private void main(String json, List<Cte> listCte) throws ExceptionWebService, ExceptionIO {
        block4: {
            String decodedString = this.docKrona.conexaoKrona(json);
            HashMap<JsonParser.Feature, Boolean> props = new HashMap<JsonParser.Feature, Boolean>();
            props.put(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            retorno_krona retornoKrona = (retorno_krona)ToolJson.readJson((String)decodedString, retorno_krona.class, props);
            if (!this.validarRejeicaoKrona(retornoKrona)) break block4;
            if (retornoKrona.getProtocolo() != null) {
                for (Cte cte : listCte) {
                    cte.setStatusStratum(Short.valueOf((short)1));
                    cte.setProtocoloRastreamento(retornoKrona.getProtocolo());
                    this.serviceCte.saveOrUpdate((InterfaceVO)cte);
                    this.addSuccessResult(cte);
                }
            } else {
                for (Cte cte : listCte) {
                    cte.setStatusStratum(Short.valueOf((short)0));
                    this.serviceCte.saveOrUpdate((InterfaceVO)cte);
                    this.addErrorResult(cte);
                }
            }
        }
    }

    private void addSuccessResult(Cte cte) {
        this.result.addDet(EnumConstantsTaskResult.RESULT_OK, "Dados Enviados com sucesso: " + cte.getNumero().toString() + " Protocolo: " + cte.getProtocoloRastreamento());
    }

    private void addErrorResult(Cte cte) {
        this.result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "Ctes com problema: " + cte.getNumero().toString());
    }

    private boolean validarRejeicaoKrona(retorno_krona retornoKrona) {
        if (retornoKrona.getErro_login_002() != null) {
            this.result.addDet(EnumConstantsTaskResult.RESULT_ERRO, retornoKrona.getErro_login_002());
            return false;
        }
        return true;
    }
}

