/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.service.impl.stratum;

import com.fasterxml.jackson.core.JsonParser;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CTeNFe;
import com.touchcomp.basementor.model.vo.ConjuntoTranspVeiculo;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.PessoaTransporte;
import com.touchcomp.basementorclientwebservices.components.DocStratum;
import com.touchcomp.basementorclientwebservices.stratum.model.retorno_tracking;
import com.touchcomp.basementorclientwebservices.stratum.model.tracking;
import com.touchcomp.basementorclientwebservices.stratum.model.tracking_request;
import com.touchcomp.basementorclientwebservices.stratum.model.tracking_request_destinations_attributes;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.interfaces.ServiceCte;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class UtilSegurancaInteligenteStratum {
    private final TaskProcessResult result;
    private final int NR_MAX_REGISTROS_POR_VEZ = 50;
    private final ServiceCte serviceCte = (ServiceCte)ConfApplicationContext.getBean(ServiceCte.class);
    private final String DATE_FORMAT = "yyyy-MM-dd";
    private final String HORA_FORMAT = "HH:mm:ss";
    private final DocStratum docStratum = (DocStratum)ConfApplicationContext.getBean(DocStratum.class);
    public static final String VEICULO_NAO_ENCONTRADO = "2";
    public static final String MOTORISTA_NAO_ENCONTRADO = "3";
    public static final String DATA_ORIGEM_INVALIDA = "18";
    public static final String DATA_INICIO_MENOR_QUE_DATA_ATUAL = "19";
    public static final String DATA_ENTREGA_INVALIDA = "20";
    public static final String DATA_ENTREGA_MENOR_QUE_DATA_ATUAL = "21";
    public static final String ESTADO_ORIGEM_INVALIDO = "26";
    public static final String ESTADO_DESTINO_INVALIDO = "27";

    public UtilSegurancaInteligenteStratum(TaskProcessResult result) {
        this.result = result;
    }

    public void envioSegurancaInteligenteStratum(String authToken, String clientId) throws ExceptionIO, ExceptionWebService {
        ArrayList<HashMap> listTracking = new ArrayList<HashMap>();
        List listCte = this.serviceCte.getCtesParaEnviarStratumKrona(50);
        this.verificarPlacasDuplicadas(listTracking, listCte, authToken, clientId);
        this.enviarArquivoStratum(listTracking);
    }

    private void verificarPlacasDuplicadas(List<HashMap> listTracking, List<Cte> listCte, String authToken, String clientId) {
        ArrayList<HashMap> lista = new ArrayList<HashMap>();
        for (Cte c : listCte) {
            this.agruparPorRemetente(c, lista);
        }
        for (Cte c : listCte) {
            this.agruparPorConjuntoTransportador(c, lista);
        }
        this.criarArquivoEnvioNfe(listTracking, lista, authToken, clientId);
    }

    private void agruparPorRemetente(Cte c, List<HashMap> lista) {
        Boolean b = true;
        for (HashMap h : lista) {
            if (!h.get("REMETENTE").equals(c.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte())) continue;
            b = false;
        }
        if (b.booleanValue()) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("REMETENTE", c.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte());
            h.put("LIST_CONJUNTO_TRANSPORTADOR", new ArrayList());
            lista.add(h);
        }
    }

    private void agruparPorConjuntoTransportador(Cte c, List<HashMap> lista) {
        for (HashMap h : lista) {
            ArrayList<Cte> listCte;
            if (!h.get("REMETENTE").equals(c.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte())) continue;
            Boolean b = true;
            for (HashMap m : (List)h.get("LIST_CONJUNTO_TRANSPORTADOR")) {
                if (!m.get("CONJUNTO_TRANSPORTADOR").equals(c.getConjuntoTransportador())) continue;
                listCte = (ArrayList<Cte>)m.get("LIST_CTE");
                listCte.add(c);
                b = false;
            }
            if (!b.booleanValue()) continue;
            List listConjuntoTransportador = (List)h.get("LIST_CONJUNTO_TRANSPORTADOR");
            HashMap<String, Object> s = new HashMap<String, Object>();
            s.put("CONJUNTO_TRANSPORTADOR", c.getConjuntoTransportador());
            listCte = new ArrayList<Cte>();
            listCte.add(c);
            s.put("LIST_CTE", listCte);
            listConjuntoTransportador.add(s);
        }
    }

    private void criarArquivoEnvioNfe(List<HashMap> listTracking, List<HashMap> lista, String authToken, String clientId) {
        for (HashMap h : lista) {
            PessoaTransporte remetente = (PessoaTransporte)h.get("REMETENTE");
            for (HashMap m : (List)h.get("LIST_CONJUNTO_TRANSPORTADOR")) {
                HashMap<String, Object> s = new HashMap<String, Object>();
                s.put("TRACKING", this.criarArquivoEnvioCte(m, remetente, authToken, clientId));
                s.put("LIST_CTE", m.get("LIST_CTE"));
                listTracking.add(s);
            }
        }
    }

    private tracking criarArquivoEnvioCte(HashMap m, PessoaTransporte remetente, String authToken, String clientId) {
        ConjuntoTransportador c = (ConjuntoTransportador)m.get("CONJUNTO_TRANSPORTADOR");
        tracking tracking2 = new tracking();
        tracking_request t = new tracking_request();
        t.setAuth_token(authToken);
        t.setClient_id(clientId);
        t.setOrigin_district(this.clearSpecialCharacXML(remetente.getPessoa().getEndereco().getBairro()));
        t.setOrigin_address_complement(this.clearSpecialCharacXML(remetente.getPessoa().getEndereco().getComplemento()));
        t.setOrigin_state(remetente.getPessoa().getEndereco().getCidade().getUf().getSigla());
        t.setOrigin_city_name(this.clearSpecialCharacXML(remetente.getPessoa().getEndereco().getCidade().getDescricao()));
        t.setOrigin_address(this.clearSpecialCharacXML(remetente.getPessoa().getEndereco().getLogradouro() + ", " + remetente.getPessoa().getEndereco().getNumero()));
        t.setOrigin_name(this.clearSpecialCharacXML(remetente.getPessoa().getNome()));
        t.setOrigin_date("");
        t.setTransporter(this.clearSpecialCharacXML(c.getTransportadorAgregado().getPessoa().getNome()));
        t.setTracking_request_type_id(Integer.valueOf("1"));
        t.setMobile_tracker_number(null);
        t.setMobile_equipment_id(null);
        t.setDdr("DERIVADO DE PETROLIO");
        Object placa = "";
        Object placaCarretas = "";
        for (ConjuntoTranspVeiculo v : c.getConjuntoTranspVeiculo()) {
            if (v.getVeiculo().getTipoVeiculo().getTipoVeiculoCte().getCodigo().equals("0")) {
                placa = (String)placa + v.getVeiculo().getPlaca();
                continue;
            }
            if (((String)placaCarretas).length() > 0) {
                placaCarretas = (String)placaCarretas + " ";
            }
            placaCarretas = (String)placaCarretas + v.getVeiculo().getPlaca();
        }
        t.setCarts((String)placaCarretas);
        t.setTravel_id("");
        t.setRoute("");
        t.setMotorista(c.getMotorista().getPessoa().getComplemento().getCnpj());
        t.setVeiculo((String)placa);
        for (Cte cte : (List)m.get("LIST_CTE")) {
            t.getTracking_request_destinations_attributes().add(this.preencherDestinatario(cte, cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte()));
        }
        tracking2.setTrancking_request(t);
        return tracking2;
    }

    private tracking_request_destinations_attributes preencherDestinatario(Cte cte, PessoaTransporte destinatario) {
        tracking_request_destinations_attributes t = new tracking_request_destinations_attributes();
        t.setName(this.clearSpecialCharacXML(destinatario.getPessoa().getNome()));
        t.setCity_name(this.clearSpecialCharacXML(destinatario.getPessoa().getEndereco().getCidade().getDescricao()));
        t.setAddress(this.clearSpecialCharacXML(destinatario.getPessoa().getEndereco().getLogradouro() + ", " + destinatario.getPessoa().getEndereco().getNumero()));
        t.setLatitude(Float.valueOf("0.0"));
        t.setLongitude(Float.valueOf("0.0"));
        t.setState(destinatario.getPessoa().getEndereco().getCidade().getUf().getSigla());
        t.setZip_code(destinatario.getPessoa().getEndereco().getCep());
        Date data = new Date();
        data = ToolDate.nextDays((Date)data, (double)Double.parseDouble(MOTORISTA_NAO_ENCONTRADO));
        t.setDate(ToolDate.dateToStr((Date)data, (String)"yyyy-MM-dd") + "T" + ToolDate.dateToStr((Date)data, (String)"HH:mm:ss"));
        t.setDistrict(this.clearSpecialCharacXML(destinatario.getPessoa().getEndereco().getBairro()));
        Float peso = Float.valueOf(0.0f);
        Object numeroNotas = "";
        for (CTeNFe c : cte.getCteNfe()) {
            peso = Float.valueOf(peso.floatValue() + c.getPesoTotalNf().floatValue());
            if (((String)numeroNotas).length() > 0) {
                numeroNotas = (String)numeroNotas + " ";
            }
            numeroNotas = (String)numeroNotas + c.getNrNota().toString();
        }
        t.setWeight(peso);
        if (cte.getCteInfCarga().getValorTotalMercadorias() != null) {
            t.setValue(Float.valueOf(cte.getCteInfCarga().getValorTotalMercadorias().floatValue()));
        }
        t.setCtrcs("");
        t.setInvoices((String)numeroNotas);
        return t;
    }

    private void enviarArquivoStratum(List<HashMap> listTracking) throws ExceptionIO, ExceptionWebService {
        for (HashMap h : listTracking) {
            String found = ToolJson.toJson(h.get("TRACKING"));
            this.main(found, (List)h.get("LIST_CTE"), (tracking)h.get("TRACKING"));
        }
    }

    private void main(String found, List<Cte> listCte, tracking tracking2) throws ExceptionWebService, ExceptionIO {
        String decodedString = this.docStratum.conexaoStratum(found);
        HashMap<JsonParser.Feature, Boolean> props = new HashMap<JsonParser.Feature, Boolean>();
        props.put(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        retorno_tracking retornoTracking = (retorno_tracking)ToolJson.readJson((String)decodedString, retorno_tracking.class, props);
        if (retornoTracking.getStatus().equals(0)) {
            for (Cte c : listCte) {
                c.setStatusStratum(Short.valueOf((short)1));
                this.serviceCte.saveOrUpdate((InterfaceVO)c);
            }
            this.addSuccessResult(retornoTracking, this.getDadosCte(listCte));
        } else {
            this.addErrorResult(this.getDadosCte(listCte), retornoTracking, tracking2);
        }
    }

    private String getDadosCte(List<Cte> listCte) {
        Object dadosCte = "";
        for (Cte c : listCte) {
            if (((String)dadosCte).length() > 0) {
                dadosCte = (String)dadosCte + "<br>\n";
            }
            dadosCte = (String)dadosCte + "Remetente: " + c.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getNome() + " Id. Cte: " + c.getIdentificador().toString() + " Numero Cte: " + c.getNumero().toString();
        }
        return dadosCte;
    }

    private void addSuccessResult(retorno_tracking t, String dadosCte) {
        this.result.addDet(EnumConstantsTaskResult.RESULT_OK, "Dados Enviados com sucesso: " + dadosCte);
    }

    private void addErrorResult(String dadosCte, retorno_tracking retornoTracking, tracking tracking2) {
        this.result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "Ctes com problema: " + dadosCte);
        this.result.addDet(EnumConstantsTaskResult.RESULT_ERRO, "Detalhes do erro: " + this.mensagemRetorno(retornoTracking, tracking2));
    }

    private String mensagemRetorno(retorno_tracking retornoTracking, tracking tracking2) {
        String mensagemRetorno = "Remetente: " + tracking2.getTracking_request().getOrigin_name();
        block20: for (String codigo : retornoTracking.getCodigo()) {
            if (mensagemRetorno.length() > 0) {
                mensagemRetorno = mensagemRetorno + "<br>\n\n";
            }
            switch (codigo) {
                case "2": {
                    mensagemRetorno = mensagemRetorno + codigo + " - " + UtilSegurancaInteligenteStratum.mensagemRetornoPeloCodigo(codigo) + " <br>\n";
                    mensagemRetorno = mensagemRetorno + " veiculo: " + tracking2.getTracking_request().getVeiculo();
                    continue block20;
                }
                case "3": {
                    mensagemRetorno = mensagemRetorno + codigo + " - " + UtilSegurancaInteligenteStratum.mensagemRetornoPeloCodigo(codigo) + " <br>\n";
                    mensagemRetorno = mensagemRetorno + " motorista: " + tracking2.getTracking_request().getMotorista();
                    continue block20;
                }
                case "18": {
                    mensagemRetorno = mensagemRetorno + codigo + " - " + UtilSegurancaInteligenteStratum.mensagemRetornoPeloCodigo(codigo) + " <br>\n";
                    mensagemRetorno = mensagemRetorno + " origin_date: " + tracking2.getTracking_request().getOrigin_date();
                    continue block20;
                }
                case "19": {
                    mensagemRetorno = mensagemRetorno + codigo + " - " + UtilSegurancaInteligenteStratum.mensagemRetornoPeloCodigo(codigo) + " <br>\n";
                    mensagemRetorno = mensagemRetorno + " origin_date: " + tracking2.getTracking_request().getOrigin_date();
                    continue block20;
                }
                case "20": {
                    mensagemRetorno = mensagemRetorno + codigo + " - " + UtilSegurancaInteligenteStratum.mensagemRetornoPeloCodigo(codigo) + " <br>\n";
                    mensagemRetorno = mensagemRetorno + " date: " + ((tracking_request_destinations_attributes)tracking2.getTracking_request().getTracking_request_destinations_attributes().get(0)).getDate();
                    continue block20;
                }
                case "21": {
                    mensagemRetorno = mensagemRetorno + codigo + " - " + UtilSegurancaInteligenteStratum.mensagemRetornoPeloCodigo(codigo) + " <br>\n";
                    mensagemRetorno = mensagemRetorno + " date: " + ((tracking_request_destinations_attributes)tracking2.getTracking_request().getTracking_request_destinations_attributes().get(0)).getDate();
                    continue block20;
                }
                case "26": {
                    mensagemRetorno = mensagemRetorno + codigo + " - " + UtilSegurancaInteligenteStratum.mensagemRetornoPeloCodigo(codigo) + " <br>\n";
                    mensagemRetorno = mensagemRetorno + " origin_state: " + tracking2.getTracking_request().getOrigin_state();
                    continue block20;
                }
                case "27": {
                    mensagemRetorno = mensagemRetorno + codigo + " - " + UtilSegurancaInteligenteStratum.mensagemRetornoPeloCodigo(codigo) + " <br>\n";
                    mensagemRetorno = mensagemRetorno + " state: " + ((tracking_request_destinations_attributes)tracking2.getTracking_request().getTracking_request_destinations_attributes().get(0)).getState();
                    continue block20;
                }
            }
            mensagemRetorno = mensagemRetorno + codigo + " - " + UtilSegurancaInteligenteStratum.mensagemRetornoPeloCodigo(codigo);
        }
        return mensagemRetorno;
    }

    public static String mensagemRetornoPeloCodigo(String codigo) {
        HashMap<String, String> h = new HashMap<String, String>();
        h.put("1", "Nao autorizado");
        h.put(VEICULO_NAO_ENCONTRADO, "Veiulo nao encontrado");
        h.put(MOTORISTA_NAO_ENCONTRADO, "Motorista nao encontrado");
        h.put("4", "Tracking request type nao informado");
        h.put("5", "Tecnologia de rastreamento nao encontrado");
        h.put("6", "Rastreador movel nao informado");
        h.put("7", "Estado de origem nao informado");
        h.put("8", "Cidade de origem nao informada");
        h.put("9", "Data de inicio nao informada");
        h.put("10", "Nenhum destino informado");
        h.put("11", "Estado de dest nao informado");
        h.put("12", "Cidade de destino nao informada");
        h.put("13", "Data de destino nao informada");
        h.put("14", "Estado de parada nao informado");
        h.put("15", "Cidade de parada nao informada");
        h.put("16", "Data de inicio da parada nao informada");
        h.put("17", "Data de fim da parada nao informada");
        h.put(DATA_ORIGEM_INVALIDA, "Data de origem invalida");
        h.put(DATA_INICIO_MENOR_QUE_DATA_ATUAL, "Data de inicio menor que a data atual");
        h.put(DATA_ENTREGA_INVALIDA, "Data de entrega invalida");
        h.put(DATA_ENTREGA_MENOR_QUE_DATA_ATUAL, "Data de entrega menor que a data atual");
        h.put("22", "Data de inicio da parada invalida");
        h.put("23", "Data de inicio da parada menor que a data atual");
        h.put("24", "Data de fim da parada invalida");
        h.put("25", "Data de fim da parada menor que a data atual");
        h.put(ESTADO_ORIGEM_INVALIDO, "Estado de origem invalido");
        h.put(ESTADO_DESTINO_INVALIDO, "Estado de destino invalido");
        h.put("28", "Estado de parada invalido");
        h.put("99", "Erro inexperado");
        return (String)h.get(codigo);
    }

    private String clearSpecialCharacXML(String str) {
        return ToolString.clearInvalidUTF8Char((String)str);
    }
}

