/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.tasks;

import com.touchcomp.basementor.constants.enums.tasks.EnumConstMentorTask;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.LogExecMentorTask;
import com.touchcomp.basementor.model.vo.MentorTask;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.model.task.TaskProcessResultDetalhe;
import com.touchcomp.basementorservice.model.task.TaskStats;
import com.touchcomp.basementorservice.service.impl.mentortask.ServiceLogExecMentorTaskImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.exception.ToolException;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.system.ToolSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.TriggerKey;

public abstract class TaskDefaultJob
implements Job {
    public String GROUP_NAME = "mentorTask";
    public String JOB_NAME;
    private final TLogger logger = TLogger.get(this.getClass());
    private JobExecutionContext jobContext;
    private TaskProcessResult taskResult;

    public JobKey getJobKey() {
        return new JobKey(this.getJobNameInternal(), this.GROUP_NAME);
    }

    public TriggerKey getTriggerKey() {
        return new TriggerKey(this.getJobNameInternal(), this.GROUP_NAME);
    }

    public SimpleScheduleBuilder getSchedule() {
        return null;
    }

    protected String getJobNameInternal() {
        String jobName = this.getJobName();
        if (jobName == null) {
            jobName = ToolDate.dateToStr((Date)new Date(), (String)"dd-MM-yyyy HH:mm:ss.SSS");
        }
        return jobName;
    }

    public void error(Exception ex) {
        this.logger.error(ex.getClass(), (Throwable)ex);
        this.buildTaskResultError(ex);
    }

    public void info(String str) {
        this.logger.info(str);
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            this.setJobContext(context);
            this.addParams(context);
            this.newTaskResult();
            try {
                this.execute(this.getResult());
            }
            catch (Exception t) {
                this.error(t);
                this.buildTaskResultError(t);
            }
            this.saveLogExec();
            this.sendResult();
        }
        catch (ExceptionIO | ExceptionEmail | IOException ex) {
            this.logger.error(ex.getClass(), ex);
        }
    }

    protected TaskProcessResult getResult() {
        return this.taskResult;
    }

    public abstract void execute(TaskProcessResult var1) throws Exception;

    private void setJobContext(JobExecutionContext context) {
        this.jobContext = context;
    }

    protected JobDataMap getParams() {
        return this.getJobContext().getJobDetail().getJobDataMap();
    }

    public JobExecutionContext getJobContext() {
        return this.jobContext;
    }

    public abstract String getJobName();

    protected String getStringParam(String key) {
        return this.getParams().getString(key);
    }

    public Object getObjectParam(String key) {
        return this.getParams().get((Object)key);
    }

    protected Integer getIntegerParam(String str) {
        if ((str = this.getStringParam(str)) == null || str.isEmpty()) {
            return null;
        }
        return Integer.valueOf(str);
    }

    protected Long getLongParam(String str) {
        if ((str = this.getStringParam(str)) == null || str.isEmpty()) {
            return null;
        }
        return Long.valueOf(str);
    }

    protected Short getShortParam(String str) {
        if ((str = this.getStringParam(str)) == null || str.isEmpty()) {
            return null;
        }
        return Short.valueOf(str);
    }

    protected Date getDateParam(String str) {
        if ((str = this.getStringParam(str)) == null || str.isEmpty()) {
            return null;
        }
        return ToolDate.strToDate((String)str);
    }

    public <T> T getBean(Class<T> aClass) {
        return (T)ConfApplicationContext.getBean(aClass);
    }

    private void sendResult() throws IOException, ExceptionIO, ExceptionEmail {
        TaskProcessResult result = this.getResult();
        if (result == null) {
            return;
        }
        MentorTask mt = (MentorTask)this.getObjectParam("MENTOR.TASK");
        if (mt == null || mt.getEnviarEmailStatus() == null || mt.getDestinatarios() == null) {
            return;
        }
        if (mt.getEnviarEmailStatus() == null) {
            return;
        }
        if (TMethods.isEqualsNumber((Number)mt.getEnviarEmailStatus(), (Number)EnumConstMentorTask.LOG_TASK_NAO_ENVIAR.value)) {
            return;
        }
        if (TMethods.isEqualsNumber((Number)mt.getEnviarEmailStatus(), (Number)EnumConstMentorTask.LOG_TASK_ENVIAR_ERRO.value) && !result.hasErrors()) {
            return;
        }
        if (TMethods.isEqualsNumber((Number)mt.getEnviarEmailStatus(), (Number)EnumConstMentorTask.LOG_TASK_ENVIAR_ADVERTENCIA.value) && !result.hasWarnings()) {
            return;
        }
        String emailContent = ToolFile.getConteudoArquivo((InputStream)this.getClass().getResourceAsStream("/email.html"));
        String observacao = result.getObservacao();
        if (observacao == null) {
            observacao = result.hasErrors() ? "ATENCAO: Ocorreram problemas, verifique abaixo :(" : "A tarefa foi desempenhada com sucesso ;)";
        }
        LinkedList<StringToken> tokens = new LinkedList<StringToken>();
        tokens.add(new StringToken("TASK.NAME", result.getNome()));
        tokens.add(new StringToken("TASK.ID", mt.getIdentificador().toString()));
        tokens.add(new StringToken("TASK.OBS", observacao));
        tokens.add(new StringToken("TASK.DETAILS", this.buildDetails(result)));
        tokens.add(new StringToken("SERVER.NAME", this.getServerName()));
        tokens.add(new StringToken("SERVER.MAC", this.getServerMac()));
        tokens.add(new StringToken("SERVER.IP", this.getServerIp()));
        tokens.add(new StringToken("SERVER.IP.PUBLICO", this.getServerIpPulico()));
        tokens.add(new StringToken("SERVER.USER.NAME", this.getServerUserName()));
        tokens.add(new StringToken("SERVER.SYSTEM", this.getServerSystem()));
        emailContent = ToolString.build((String)emailContent, tokens);
        String titulo = mt.getTituloEmail();
        if (titulo == null || titulo.length() == 0) {
            titulo = "Touch Comp ERP ERP - Tarefas Automaticas";
        }
        Email em = new Email();
        em.setAssunto(titulo);
        em.setCorpoMensagem(emailContent);
        em.setDescricao(mt.getTaskName());
        em.setServidor(new Email.ServidorEmail(mt.getServidorEmail().getServidor(), mt.getServidorEmail().getServidorImap(), mt.getServidorEmail().getServidorPop(), mt.getServidorEmail().getEmail(), mt.getServidorEmail().getSenha(), mt.getServidorEmail().getPortaEmail(), mt.getServidorEmail().getNaoAutenticarEmail(), mt.getServidorEmail().getLogin(), mt.getServidorEmail().getServerProperties(), mt.getServidorEmail().getGerarArquivoExtensaoEml(), mt.getServidorEmail().getDebugServer()));
        em.setRemetente(mt.getServidorEmail().getEmail());
        em.addDestinatarios(new String[]{mt.getDestinatarios()});
        ToolSendEmail.sendEmailWithException((Email)em);
    }

    private String buildDetails(TaskProcessResult result) {
        StringBuilder sb = new StringBuilder();
        for (TaskProcessResultDetalhe detalhe : result.getDetalhes()) {
            String obs = detalhe.getObservacao();
            if (obs != null) {
                obs = obs.replaceAll("\n", "<br>");
            }
            sb.append("<tr>");
            sb.append("<td>");
            sb.append(detalhe.getResult() == EnumConstantsTaskResult.RESULT_ERRO ? "ERRO" : "OK");
            sb.append("</td>");
            sb.append("<td>");
            sb.append("<td>");
            sb.append(detalhe.getCodigo() != null ? detalhe.getCodigo() : "");
            sb.append("</td>");
            sb.append("<td>");
            sb.append(obs);
            sb.append("</td>");
            sb.append("</tr>");
        }
        return sb.toString();
    }

    private void buildTaskResultError(Exception t) {
        if (t instanceof ExceptionBase) {
            ExceptionBase e = (ExceptionBase)t;
            this.getResult().addDet(EnumConstantsTaskResult.RESULT_ERRO, e.getErrorCode(), e.getFormattedMessage());
        }
        this.getResult().addDet(EnumConstantsTaskResult.RESULT_ERRO, ToolException.getFullPrintStrack((Throwable)t));
    }

    private void newTaskResult() {
        MentorTask mt = (MentorTask)this.getObjectParam("MENTOR.TASK");
        this.taskResult = new TaskProcessResult();
        this.taskResult.setNome(mt.getTaskName());
    }

    private void saveLogExec() {
        try {
            TaskProcessResult result = this.getResult();
            ServiceLogExecMentorTaskImpl service = this.getBean(ServiceLogExecMentorTaskImpl.class);
            MentorTask mt = (MentorTask)this.getObjectParam("MENTOR.TASK");
            LogExecMentorTask l = new LogExecMentorTask();
            l.setDataHoraExecucao(this.getJobContext().getFireTime());
            l.setDataProximaExecucao(this.getJobContext().getNextFireTime());
            l.setInfoTask(result.getInfoTask());
            l.setMentorTask(mt);
            if (result.hasErrors()) {
                l.setStatusExecucao(Integer.valueOf(EnumConstantsTaskResult.RESULT_ERRO.getValue()));
                l.setDetalhesUltExec(TString.cut((String)result.getStrErros(), (int)5000));
            } else if (result.hasWarnings()) {
                l.setStatusExecucao(Integer.valueOf(EnumConstantsTaskResult.RESULT_ADVERTENCIA.getValue()));
                l.setDetalhesUltExec(TString.cut((String)result.getStrWarnings(), (int)5000));
            } else {
                l.setStatusExecucao(Integer.valueOf(EnumConstantsTaskResult.RESULT_OK.getValue()));
            }
            service.saveOrUpdate((InterfaceVO)l);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
        }
    }

    private void addParams(JobExecutionContext context) {
        ServiceLogExecMentorTaskImpl service = this.getBean(ServiceLogExecMentorTaskImpl.class);
        LogExecMentorTask l = service.getUltimaExecucao((MentorTask)this.getObjectParam("MENTOR.TASK"));
        TaskStats st = new TaskStats();
        st.setAtualExec(this.getJobContext().getFireTime());
        if (l != null) {
            st.setUltimaExec(l.getDataHoraExecucao());
            st.setDescricaoUltimaExec(l.getDetalhesUltExec());
            st.setStatusUltimaExec(EnumConstantsTaskResult.get((Object)l.getStatusExecucao()));
            st.setInfoUltimaExec(l.getInfoTask());
        }
        this.getParams().put("paramTaskStats", (Object)st);
    }

    private String getServerName() {
        String ret = "NA";
        try {
            ret = ToolSystem.getHostName();
        }
        catch (Throwable ex) {
            TLogger.get(this.getClass()).error(ex);
        }
        return ret;
    }

    private String getServerSystem() {
        String ret = "NA";
        try {
            ret = ToolSystem.getSystemName();
        }
        catch (Throwable ex) {
            TLogger.get(this.getClass()).error(ex);
        }
        return ret;
    }

    private String getServerMac() {
        String ret = "NA";
        try {
            ret = Arrays.toString(ToolSystem.getAllMacAddress());
        }
        catch (Throwable ex) {
            TLogger.get(this.getClass()).error(ex);
        }
        return ret;
    }

    private String getServerIp() {
        String ret = "NA";
        try {
            ret = ToolSystem.getHostAddress();
        }
        catch (Throwable ex) {
            TLogger.get(this.getClass()).error(ex);
        }
        return ret;
    }

    private String getServerUserName() {
        String ret = "NA";
        try {
            ret = ToolSystem.getUserName();
        }
        catch (Throwable ex) {
            TLogger.get(this.getClass()).error(ex);
        }
        return ret;
    }

    private String getServerIpPulico() {
        String ret = "NA";
        try {
            ret = ToolSystem.getIpPublico();
        }
        catch (Throwable ex) {
            TLogger.get(this.getClass()).error(ex);
        }
        return ret;
    }
}

