/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.tasks;

import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.vo.MentorTask;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.smartcomponente.BaseSmartComponenteResult;
import com.touchcomp.basementorservice.service.impl.smartcomponente.ServiceBuildSmartComponentImpl;
import com.touchcomp.basementorservice.tasks.TaskCreator;
import com.touchcomp.basementorwebtasks.tasks.TaskDefaultJob;
import java.util.Map;
import org.quartz.DisallowConcurrentExecution;

@DisallowConcurrentExecution
public class TaskDefaultJobSmartComponent
extends TaskDefaultJob {
    @Override
    public void execute(TaskProcessResult result) throws ExceptionBuildBI {
        MentorTask mt = (MentorTask)this.getObjectParam("MENTOR.TASK");
        if (mt.getSmartComponentPref() == null) {
            throw new ExceptionBuildBI("E.ERP.1673.001", new Object[]{mt});
        }
        ServiceBuildSmartComponentImpl service = this.getBean(ServiceBuildSmartComponentImpl.class);
        DefaultBIParamsMap params = new DefaultBIParamsMap();
        params.put((Object)"paramTaskResult", (Object)this.getResult());
        params.putAll((Map)this.getParams());
        BaseSmartComponenteResult res = service.buildSC(mt.getSmartComponentPref(), params, new TaskCreator.TaskProgress());
        if (res.getStatus().isOk()) {
            return;
        }
        if (res.getStatus().isErro()) {
            this.getResult().addDet(EnumConstantsTaskResult.RESULT_ERRO, res.getMensagem());
            return;
        }
        if (res.getStatus().isAdvertencia()) {
            this.getResult().addDet(EnumConstantsTaskResult.RESULT_ADVERTENCIA, res.getMensagem());
        }
    }

    @Override
    public String getJobName() {
        return this.getJobNameInternal();
    }
}

