/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.tasks;

import com.touchcomp.basementor.constants.enums.tasks.EnumConstMentorTaskType;
import com.touchcomp.basementor.model.vo.MentorTask;
import com.touchcomp.basementor.model.vo.MentorTaskParameter;
import com.touchcomp.basementor.model.vo.OpcoesSistema;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.hardware.ExceptionHardware;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.impl.mentortask.ServiceLogExecMentorTaskImpl;
import com.touchcomp.basementorservice.service.impl.mentortask.ServiceMentorTaskImpl;
import com.touchcomp.basementorservice.service.impl.opcoessistema.ServiceOpcoesSistemaImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.system.ToolSystem;
import com.touchcomp.basementorwebtasks.constants.EnumTaskStatus;
import com.touchcomp.basementorwebtasks.model.TaskModel;
import com.touchcomp.basementorwebtasks.tasks.TaskDefaultJobSmartComponent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

public class TaskScheduler {
    private Scheduler scheduler = null;
    private static final TLogger logger = TLogger.get(TaskScheduler.class);
    private static TaskScheduler instance;
    private final ServiceMentorTaskImpl serviceMentorTask = (ServiceMentorTaskImpl)ConfApplicationContext.getBean(ServiceMentorTaskImpl.class);
    private final ServiceOpcoesSistemaImpl serviceOpcoesSistema = (ServiceOpcoesSistemaImpl)ConfApplicationContext.getBean(ServiceOpcoesSistemaImpl.class);
    private final List<TaskModel> tasks = new LinkedList<TaskModel>();

    private TaskScheduler() {
    }

    public synchronized void startIt() throws SchedulerException, ClassNotFoundException, ExceptionInvalidState {
        if (!this.isPermittedTasksOrThrow(true)) {
            return;
        }
        StdSchedulerFactory sf = new StdSchedulerFactory();
        this.setScheduler(sf.getScheduler());
        this.buildTasks();
        this.scheduleTasks();
        this.getScheduler().startDelayed(60);
        ServiceLogExecMentorTaskImpl service = (ServiceLogExecMentorTaskImpl)Context.get(ServiceLogExecMentorTaskImpl.class);
        service.deleteOlderLogs(5);
    }

    public void contextDestroyed() {
        if (this.getScheduler() == null) {
            return;
        }
        try {
            this.getScheduler().shutdown();
        }
        catch (SchedulerException ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    private void buildTasks() {
        List jobs = this.serviceMentorTask.getActiveTasks();
        this.tasks.clear();
        for (MentorTask m : jobs) {
            String[] intervalos = ToolString.splitString((String)m.getIntervaloExecucao(), (char[])new char[]{' ', ',', '-'});
            int countIntervalos = 1;
            for (String intervaloSTR : intervalos) {
                TaskModel tm = new TaskModel(EnumConstMentorTaskType.get((Object)m.getTipoTask()));
                tm.setDescricao(m.getTaskName());
                tm.setTaskSourceId(m.getIdentificador());
                tm.setTaskId(m.getIdentificador().toString() + "-" + countIntervalos);
                tm.setTaskClass(m.getTaskClass());
                tm.setTaskInterval(intervaloSTR);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.putAll(this.getParameters(m.getParamConf()));
                params.put("MENTOR.TASK", m);
                tm.setParams(params);
                this.tasks.add(tm);
            }
        }
    }

    private Map getParameters(List<MentorTaskParameter> parameters) {
        HashMap<String, MentorTaskParameter> ret = new HashMap<String, MentorTaskParameter>();
        if (parameters != null) {
            for (MentorTaskParameter p : parameters) {
                ret.put(p.getNomeParametro(), p);
            }
        }
        return ret;
    }

    private void scheduleTasks() throws SchedulerException, ClassNotFoundException {
        for (TaskModel m : this.tasks) {
            System.out.println("Criando task: " + m.getDescricao() + " Intervalo: " + m.getTaskInterval());
            Class c = null;
            switch (m.getTipoTask()) {
                case CLASSE: {
                    c = Class.forName(m.getTaskClass());
                    break;
                }
                case SMART_COMPONENT: {
                    c = TaskDefaultJobSmartComponent.class;
                }
            }
            if (c == null) {
                throw new ExceptionRuntimeBase("E.ERP.1673.002");
            }
            JobDetail job = JobBuilder.newJob(c).usingJobData(this.getJobData(m)).withIdentity(m.getTaskId(), this.getDefaultGroupName()).storeDurably().build();
            this.getScheduler().scheduleJob(job, this.getTrigger(m, m.getTaskInterval()));
        }
    }

    private JobDataMap getJobData(TaskModel m) {
        Map<String, Object> paramConf = m.getParams();
        JobDataMap j = new JobDataMap();
        Set<String> keys = paramConf.keySet();
        for (String key : keys) {
            Object mt = paramConf.get(key);
            if (mt instanceof MentorTask) {
                j.put("MENTOR.TASK", mt);
                continue;
            }
            if (mt == null) continue;
            MentorTaskParameter o = (MentorTaskParameter)mt;
            j.put(o.getNomeParametro(), o.getValorParametro());
        }
        return j;
    }

    public static TaskScheduler getInstance() throws ExceptionInvalidState {
        if (instance == null) {
            instance = new TaskScheduler();
        }
        return instance;
    }

    public List<TaskModel> getAllTasks() throws ExceptionInvalidState {
        this.isPermittedTasksOrThrow();
        return this.getAllTasksInternal();
    }

    private List<TaskModel> getAllTasksInternal() throws ExceptionInvalidState {
        try {
            if (this.getScheduler() == null) {
                return new LinkedList<TaskModel>();
            }
            Set jobKeys = this.getScheduler().getJobKeys(GroupMatcher.groupEquals((String)this.getDefaultGroupName()));
            for (JobKey jobKey : jobKeys) {
                String idTask = jobKey.getName();
                TaskModel tm = this.tasks.stream().filter(i -> i.getTaskId().equals(idTask)).findFirst().get();
                this.completeInfoTask(tm);
            }
            return this.tasks;
        }
        catch (SchedulerException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    public TaskModel getTasks(String taskClass) throws ExceptionInvalidState {
        try {
            this.isPermittedTasksOrThrow();
        }
        catch (ExceptionInvalidState ex) {
            return null;
        }
        List<TaskModel> tasks = this.getAllTasksInternal();
        Optional<TaskModel> found = tasks.stream().filter(i -> TMethods.isEquals((Object)i.getTaskClass(), (Object)taskClass)).findFirst();
        return found.isPresent() ? found.get() : null;
    }

    public void restartAllTasks() throws ExceptionInvalidState {
        this.isPermittedTasksOrThrow();
        try {
            this.getScheduler().shutdown(true);
            instance = null;
            this.startIt();
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw new ExceptionInvalidState("E.TSK.000001", new Object[]{ex.getMessage()});
        }
    }

    public List<JobExecutionContext> getRunningTasks() throws ExceptionInvalidState {
        try {
            return this.getScheduler().getCurrentlyExecutingJobs();
        }
        catch (SchedulerException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionInvalidState("E.TSK.000001", new Object[]{ex.getMessage()});
        }
    }

    public void restartTask(String taskId) throws ExceptionInvalidState {
        this.isPermittedTasksOrThrow();
        try {
            TaskModel task = this.getTask(taskId);
            if (task == null) {
                return;
            }
            this.shutdownTask(taskId);
            this.resumeTask(taskId);
            this.updateParams(task);
            this.executeNowTask(taskId);
        }
        catch (SchedulerException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionInvalidState("E.TSK.000001", new Object[]{ex.getMessage()});
        }
    }

    public void pauseTask(String taskId) throws ExceptionInvalidState {
        this.isPermittedTasksOrThrow();
        try {
            this.getScheduler().pauseJob(this.getJobKey(taskId));
        }
        catch (SchedulerException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionInvalidState("E.TSK.000001", new Object[]{ex.getMessage()});
        }
    }

    public void resumeTask(String taskId) throws ExceptionInvalidState {
        this.isPermittedTasksOrThrow();
        try {
            this.getScheduler().resumeJob(this.getJobKey(taskId));
        }
        catch (SchedulerException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionInvalidState("E.TSK.000001", new Object[]{ex.getMessage()});
        }
    }

    public void shutdownTask(String taskId) throws ExceptionInvalidState {
        this.isPermittedTasksOrThrow();
        try {
            boolean res = this.getScheduler().deleteJob(this.getJobKey(taskId));
            if (res) {
                this.tasks.remove(this.getTask(taskId));
            }
        }
        catch (SchedulerException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionInvalidState("E.TSK.000001", new Object[]{ex.getMessage()});
        }
    }

    public void interruptTask(String taskId) throws ExceptionInvalidState {
        this.isPermittedTasksOrThrow();
        try {
            this.getScheduler().interrupt(this.getJobKey(taskId));
        }
        catch (SchedulerException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionInvalidState("E.TSK.000001", new Object[]{ex.getMessage()});
        }
    }

    public void executeNowTask(String taskId) throws ExceptionInvalidState {
        this.isPermittedTasksOrThrow();
        try {
            this.getScheduler().triggerJob(this.getJobKey(taskId));
        }
        catch (SchedulerException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionInvalidState("E.TSK.000001", new Object[]{ex.getMessage()});
        }
    }

    private JobKey getJobKey(TaskModel m) {
        return this.getJobKey(m.getTaskId());
    }

    private JobKey getJobKey(String taskId) {
        return new JobKey(taskId, this.getDefaultGroupName());
    }

    private String getDefaultGroupName() {
        return "DEFAULT.GROUP.JOB";
    }

    private void completeInfoTask(TaskModel m) throws ExceptionInvalidState {
        try {
            JobKey jobKey = this.getJobKey(m);
            JobDetail jobDetail = this.getScheduler().getJobDetail(jobKey);
            List triggers = this.getScheduler().getTriggersOfJob(jobDetail.getKey());
            Iterator iterator = triggers.iterator();
            if (iterator.hasNext()) {
                Trigger trigger = (Trigger)iterator.next();
                Trigger.TriggerState triggerState = this.getScheduler().getTriggerState(trigger.getKey());
                m.setTaskStatus(this.converStatus(triggerState));
                m.setPreviousExecution(trigger.getPreviousFireTime());
                m.setNextExecution(trigger.getNextFireTime());
                return;
            }
            m.setTaskStatus(this.converStatus(Trigger.TriggerState.NONE));
        }
        catch (SchedulerException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionInvalidState("E.TSK.000001", new Object[]{ex.getMessage()});
        }
    }

    private void updateParams(TaskModel task) throws SchedulerException {
        MentorTask m = (MentorTask)this.serviceMentorTask.get(task.getTaskId());
        if (m == null) {
            return;
        }
        task.setParams(this.getParameters(m.getParamConf()));
        JobDetail j = this.getScheduler().getJobDetail(this.getJobKey(task));
        j.getJobDataMap().clear();
        j.getJobDataMap().putAll((Map)this.getJobData(task));
    }

    private Trigger getTrigger(TaskModel m, String intervaloSTR) {
        Trigger trigger;
        if (ToolString.stringIsANumberInteger((String)intervaloSTR).booleanValue()) {
            Integer intervalo = Integer.valueOf(intervaloSTR);
            trigger = TriggerBuilder.newTrigger().withIdentity(m.getTaskId(), this.getDefaultGroupName()).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMinutes(intervalo.intValue())).build();
        } else {
            CronScheduleBuilder cs = CronScheduleBuilder.cronSchedule((String)intervaloSTR);
            trigger = TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)cs).build();
        }
        return trigger;
    }

    private EnumTaskStatus converStatus(Trigger.TriggerState triggerState) {
        switch (triggerState) {
            case BLOCKED: {
                return EnumTaskStatus.BLOCKED;
            }
            case ERROR: {
                return EnumTaskStatus.ERROR;
            }
            case COMPLETE: {
                return EnumTaskStatus.COMPLETE;
            }
            case NORMAL: {
                return EnumTaskStatus.RUNNING;
            }
            case PAUSED: {
                return EnumTaskStatus.PAUSED;
            }
            case NONE: {
                return EnumTaskStatus.UNKNOWN;
            }
        }
        return EnumTaskStatus.UNKNOWN;
    }

    private TaskModel getTask(String taskId) {
        Optional<TaskModel> tm = this.tasks.stream().filter(i -> i.getTaskId().equals(taskId)).findFirst();
        return tm.isPresent() ? tm.get() : null;
    }

    public void rebuildScheduler() throws ExceptionInvalidState {
        this.isPermittedTasksOrThrow();
        try {
            if (this.getScheduler() != null) {
                this.getScheduler().shutdown();
                this.setScheduler(null);
            }
            this.startIt();
        }
        catch (SchedulerException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionInvalidState("E.TSK.000001", new Object[]{ex.getMessage()});
        }
        catch (ClassNotFoundException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionInvalidState("E.TSK.000001", new Object[]{ex.getMessage()});
        }
    }

    public void resumeAllTask() throws ExceptionInvalidState {
        this.isPermittedTasksOrThrow();
        try {
            this.getScheduler().resumeAll();
        }
        catch (SchedulerException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionInvalidState("E.TSK.000001", new Object[]{ex.getMessage()});
        }
    }

    public void pauseAllTask() throws ExceptionInvalidState {
        this.isPermittedTasksOrThrow();
        try {
            this.getScheduler().pauseAll();
        }
        catch (SchedulerException ex) {
            logger.error((Throwable)ex);
            throw new ExceptionInvalidState("E.TSK.000001", new Object[]{ex.getMessage()});
        }
    }

    private boolean isPermittedTasksOrThrow(boolean throwEx) throws ExceptionInvalidState {
        if (!this.isMacLiberadoExecutarTarefas()) {
            if (throwEx) {
                throw new ExceptionInvalidState("E.ERP.0493.008", new Object[0]);
            }
            return false;
        }
        return true;
    }

    private boolean isPermittedTasksOrThrow() throws ExceptionInvalidState {
        return this.isPermittedTasksOrThrow(true);
    }

    private boolean isMacLiberadoExecutarTarefas() {
        try {
            OpcoesSistema op = (OpcoesSistema)this.serviceOpcoesSistema.getFirst();
            if (op == null || !TMethods.isStrWithData((String)op.getMacAddressLibTasks())) {
                return false;
            }
            String[] macs = ToolSystem.getAllMacAddress();
            String[] macsOP = ToolString.splitString((String)op.getMacAddressLibTasks(), (char[])new char[]{'-', ':'});
            for (String mac : macs) {
                mac = String.valueOf(mac).toUpperCase();
                for (String macOp : macsOP) {
                    if (!TMethods.isEquals((Object)mac, (Object)(macOp = String.valueOf(macOp).toUpperCase()))) continue;
                    return true;
                }
            }
        }
        catch (ExceptionHardware ex) {
            ex.printStackTrace();
            TLogger.get(this.getClass()).error((Throwable)ex);
        }
        return false;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public boolean isStarted() {
        return this.scheduler != null;
    }
}

