/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorwebtasks.tasks.impl.importarnotaterceiros;

import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.interfaces.ServiceNotaFiscalTerceiros;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorwebtasks.tasks.TaskDefaultJob;
import java.util.Date;
import org.quartz.DisallowConcurrentExecution;

@DisallowConcurrentExecution
public class TaskImportarNotaTerceiros
extends TaskDefaultJob {
    @Override
    public void execute(TaskProcessResult result) {
        try {
            String naturezasOperacao = this.getStringParam("natureza_operacao");
            String dataInicial = this.getStringParam("data_inicial");
            String dataFinal = this.getStringParam("data_final");
            Date dataIn = null;
            Date dataFin = null;
            if (ToolMethods.isStrWithData((String)dataInicial)) {
                dataIn = ToolDate.strToDate((String)dataInicial);
            }
            if (ToolMethods.isStrWithData((String)dataFinal)) {
                dataFin = ToolDate.strToDate((String)dataFinal);
            }
            ServiceNotaFiscalTerceiros service = this.getBean(ServiceNotaFiscalTerceiros.class);
            service.importarNotaTerceirosPorXML(naturezasOperacao, dataIn, dataFin, result);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            this.error(ex);
        }
    }

    @Override
    public String getJobName() {
        return "Importar Notas Terceiros";
    }
}

