/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorxml.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.constants.ConstantsEnumXML;
import com.touchcomp.basementorxml.constants.XMLNFeCteConstants;
import com.touchcomp.basementorxml.dao.DaoXMLGenericEntityImpl;
import com.touchcomp.basementorxml.dao.interfaces.DaoXMLNFeCTe;
import com.touchcomp.basementorxml.model.XMLNFeCTe;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class DaoXMLNFeCTeImpl
extends DaoXMLGenericEntityImpl<XMLNFeCTe, Long>
implements DaoXMLNFeCTe {
    @Override
    public boolean existXMLNFeCte(String chaveNFe) {
        Criteria c = this.criteria();
        c.add(this.eq("chaveNFe", chaveNFe));
        c.setProjection(Projections.rowCount());
        Long r = (Long)c.uniqueResult();
        return r != null && r > 0L;
    }

    @Override
    public List<XMLNFeCTe> findXMLNFeCTeEnvioStratum(int nrMaxRegistros) {
        Criteria crit = this.criteria();
        crit.add((Criterion)Restrictions.eq((String)"envioStratum", (Object)ConstantsEnumXML.NAO.value()));
        crit.addOrder(Order.asc((String)"dataChegada"));
        crit.setMaxResults(nrMaxRegistros);
        return crit.list();
    }

    @Override
    public XMLNFeCTe getXMlNfeCTeChaveNFe(String chaveNFe) {
        Criteria c = this.criteria();
        c.add(this.eq("chaveNFe", chaveNFe));
        return (XMLNFeCTe)this.toUnique(c);
    }

    private Date getMaxDate(Date dataFim) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataFim);
        g.set(12, g.getMaximum(12));
        g.set(11, g.getMaximum(11));
        g.set(13, g.getMaximum(13));
        return g.getTime();
    }

    @Override
    public List<XMLNFeCTe> findXMlNfeCTeFiltrosCondicoes(Date dataIn, Date dataFim, XMLNFeCteConstants tipo, int start, int size, Short filtrarCnpjGeracaoCte, String cnpj, Short buscarXmlEmpresaTransp) {
        Criteria crit = this.criteria();
        dataFim = this.getMaxDate(dataFim);
        crit.add(Restrictions.between((String)"dataChegada", (Object)dataIn, (Object)dataFim));
        if (tipo == XMLNFeCteConstants.XML_NFE_CTE_FATURADOS) {
            crit.add((Criterion)Restrictions.eq((String)"flag", (Object)tipo.value()));
        } else if (tipo == XMLNFeCteConstants.XML_NFE_CTE_NAO_FATURADOS) {
            crit.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"flag", (Object)tipo.value()), (Criterion)Restrictions.isNull((String)"flag")));
        } else if (tipo == XMLNFeCteConstants.XML_NFE_CTE_BLOQUEADOS) {
            crit.add((Criterion)Restrictions.eq((String)"flag", (Object)tipo.value()));
        }
        if (ToolMethods.isEquals((Object)filtrarCnpjGeracaoCte, (Object)EnumConstantsMentorSimNao.SIM.value)) {
            crit.add((Criterion)Restrictions.eq((String)"cnpjTranspAgregado", (Object)cnpj));
        }
        if (ToolMethods.isEquals((Object)buscarXmlEmpresaTransp, (Object)EnumConstantsMentorSimNao.SIM.value)) {
            crit.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"cnpjTransportador", (Object)cnpj), (Criterion)Restrictions.isNull((String)"cnpjTransportador")));
        }
        crit.setFirstResult(start);
        crit.setMaxResults(size);
        crit.addOrder(Order.asc((String)"dataChegada"));
        return crit.list();
    }

    @Override
    public List<XMLNFeCTe> findXMlNfeCTeNumeroDoc(Long nrInicio, Long nrFim, Short filtrarCnpjGeracaoCte, String cnpj, Short buscarXmlEmpresaTransp) {
        Criteria crit = this.criteria();
        crit.add(Restrictions.sqlRestriction((String)(" cast(substring(chave_nfe from 26 for 9) as integer) between " + nrInicio + " and " + nrFim)));
        if (ToolMethods.isEquals((Object)filtrarCnpjGeracaoCte, (Object)EnumConstantsMentorSimNao.SIM.value)) {
            crit.add((Criterion)Restrictions.eq((String)"cnpjTranspAgregado", (Object)cnpj));
        }
        if (ToolMethods.isEquals((Object)buscarXmlEmpresaTransp, (Object)EnumConstantsMentorSimNao.SIM.value)) {
            crit.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"cnpjTransportador", (Object)cnpj), (Criterion)Restrictions.isNull((String)"cnpjTransportador")));
        }
        crit.addOrder(Order.asc((String)"dataChegada"));
        return crit.list();
    }

    @Override
    public List<XMLNFeCTe> findXMlNfeChaveNFe(String chaveNFe, Short filtrarCnpjGeracaoCte, String cnpj, Short buscarXmlEmpresaTransp) {
        Criteria crit = this.criteria();
        crit.add((Criterion)Restrictions.eq((String)"chaveNFe", (Object)chaveNFe));
        if (ToolMethods.isEquals((Object)filtrarCnpjGeracaoCte, (Object)EnumConstantsMentorSimNao.SIM.value)) {
            crit.add((Criterion)Restrictions.eq((String)"cnpjTranspAgregado", (Object)cnpj));
        }
        if (ToolMethods.isEquals((Object)buscarXmlEmpresaTransp, (Object)EnumConstantsMentorSimNao.SIM.value)) {
            crit.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"cnpjTransportador", (Object)cnpj), (Criterion)Restrictions.isNull((String)"cnpjTransportador")));
        }
        crit.addOrder(Order.asc((String)"dataChegada"));
        return crit.list();
    }

    @Override
    public XMLNFeCTe findXMlNfeChaveNFe(Integer nrDoc, String cnpj) {
        Criteria crit = this.criteria();
        crit.add(Restrictions.sqlRestriction((String)(" cast(substring(chave_nfe from 26 for 9) as integer) = " + nrDoc)));
        crit.add(Restrictions.sqlRestriction((String)(" substring(chave_nfe from 7 for 14) = " + cnpj)));
        crit.addOrder(Order.asc((String)"id"));
        return (XMLNFeCTe)this.toUnique(crit);
    }

    @Override
    public List<XMLNFeCTe> findXMLNfeCTeCnpjEmitenteDataInicialFinal(String cnpjEmitente, Short filtrarData, Date dataInicial, Date dataFinal) {
        Criteria crit = this.criteria();
        if (ToolMethods.isEquals((Object)filtrarData, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            crit.add(Restrictions.between((String)"dataChegada", (Object)dataInicial, (Object)this.getMaxDate(dataFinal)));
        }
        if (cnpjEmitente != null) {
            crit.add((Criterion)Restrictions.eq((String)"cnpjEmitente", (Object)cnpjEmitente));
        }
        crit.add((Criterion)Restrictions.eq((String)"importado", (Object)EnumConstantsMentorSimNao.NAO.getValue()));
        crit.addOrder(Order.asc((String)"dataChegada"));
        return crit.list();
    }
}

