/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.comunicadorconsultapreco;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basenativeequipments.comunicadorconsultapreco.InterfaceConsultaDadosProduto;
import com.touchcomp.basenativeequipments.comunicadorconsultapreco.model.DadosConsultaProduto;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class ComunicadorConsultaPrecoResposta
extends Thread {
    private final Socket socket;
    private final int temp;
    private final int size;
    private final InterfaceConsultaDadosProduto consultaPrecoProduto;

    ComunicadorConsultaPrecoResposta(Socket socket, int temp, int size, InterfaceConsultaDadosProduto consultaPrecoProduto) {
        this.socket = socket;
        this.temp = temp;
        this.size = size;
        this.consultaPrecoProduto = consultaPrecoProduto;
    }

    private DataOutputStream getOutputStream() throws IOException {
        return new DataOutputStream(this.socket.getOutputStream());
    }

    private DataInputStream getInputStream() throws IOException {
        return new DataInputStream(this.socket.getInputStream());
    }

    @Override
    public void run() {
        try {
            this.confirmConect();
            this.waitComand();
            this.startThreadAlwaysLive();
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
        }
    }

    private void confirmConect() throws Exception {
        this.getOutputStream().write("#ok".getBytes());
        ComunicadorConsultaPrecoResposta.sleep(1000L);
        this.readSocket();
    }

    private void waitComand() {
        Runnable run = () -> {
            while (true) {
                try {
                    while (true) {
                        if (this.getInputStream().available() <= 0) {
                            continue;
                        }
                        String comand = this.readSocket();
                        String com = comand.substring(0, 1);
                        String data = comand.substring(1);
                        if (!com.equals("#") || !TString.isAIntegerNumber((String)TString.onlyNumbers((String)data))) continue;
                        this.readProduto(TString.onlyNumbers((String)data));
                    }
                }
                catch (IOException ex) {
                    TLogger.get(this.getClass()).error((Throwable)ex);
                    continue;
                }
                break;
            }
        };
        new Thread(run).start();
    }

    private void readProduto(String comand) throws IOException {
        try {
            DadosConsultaProduto dados = this.consultaPrecoProduto.consultaProduto(comand);
            if (ToolMethods.isNotNull((Object)dados).booleanValue()) {
                this.sendComand(dados.getCodigoBarras(), dados.getValorProduto());
            } else {
                this.sendComand("Produto n\u00e3o encontrado", null);
            }
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            this.sendComand("Erro ao pesquisar produto", null);
        }
    }

    private void startThreadAlwaysLive() {
        Runnable run = () -> {
            while (true) {
                try {
                    while (true) {
                        ComunicadorConsultaPrecoResposta.sleep(15000L);
                        this.getOutputStream().write("#live?".getBytes());
                    }
                }
                catch (IOException | InterruptedException ex) {
                    TLogger.get(this.getClass()).error((Throwable)ex);
                    continue;
                }
                break;
            }
        };
        new Thread(run).start();
    }

    private String readSocket() throws IOException {
        int qtd = this.getInputStream().available();
        byte[] vector = new byte[qtd];
        this.getInputStream().read(vector);
        String comand = new String(vector);
        return comand.substring(0, qtd);
    }

    private void sendComand(String nomeProduto, Double valorUnitario) throws IOException {
        String linha1 = "";
        Object linha2 = "";
        if (ToolMethods.isStrWithDataLengthG((String)nomeProduto, (int)this.size)) {
            linha1 = nomeProduto.substring(0, this.size);
        }
        if (ToolMethods.isWithData((Number)valorUnitario)) {
            linha2 = "R$ " + ToolFormatter.formataNumero((Number)valorUnitario, (int)2);
        }
        int reservado = 48;
        Object comandoCompleto = "#mesg";
        int tamanho1 = linha1.length() + 48;
        int tamanho2 = ((String)linha2).length() + 48;
        int tempoDisplay = this.temp + 48;
        comandoCompleto = (String)comandoCompleto + (char)tamanho1;
        comandoCompleto = (String)comandoCompleto + linha1;
        comandoCompleto = (String)comandoCompleto + (char)tamanho2;
        comandoCompleto = (String)comandoCompleto + (String)linha2;
        comandoCompleto = (String)comandoCompleto + (char)tempoDisplay;
        comandoCompleto = (String)comandoCompleto + (char)reservado;
        this.getOutputStream().write(((String)comandoCompleto).getBytes());
    }
}

