/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec;

import com.touchcomp.basementorexceptions.exceptions.impl.comunicadorpostoscombustiveis.EnumComunicadorPostosCombustiveis;
import com.touchcomp.basementorexceptions.exceptions.impl.comunicadorpostoscombustiveis.ExceptionComunicadorPostosCombustiveis;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.socket.EnumExcepSocket;
import com.touchcomp.basementorexceptions.exceptions.impl.socket.ExceptionSocket;
import com.touchcomp.basementortools.constants.EnumConstantsStatus;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.ComunicadorBaseTCPSocket;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.ComunicadorResposta;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumAutorizacao;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumCodControle;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumCodIdentificador;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumCodPermissoes;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumEquipamentos;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumModoLeitura;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumModos;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumModosListaNegraCartoes;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumStatus;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumTipoPreco;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumTipoPreset;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.ComunicadorTipoEquipamento;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.GravacaoIdTag;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraAbastecimento;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraAbastecimentoByRegistro;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraAbastecimentoSimples;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraIdTag;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraIdTagAbastecimento;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraStatusBombas;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraTag;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComunicadorCompanytec
extends ComunicadorBaseTCPSocket {
    private final String AJUSTA_RELOGIO_EXTENDIDO = "&KW1";
    private final String LEITURA_RELOGIO_EXTENDIDO = "&KR1";
    private final String AJUSTA_RELOGIO = "&H";
    private final String LEITURA_RELOGIO = "&R";
    private final String ALTERACAO_PRECO = "&U";
    private final String LEITURA_TOTAIS_ESTENDIDOS = "&T";
    private final String LEITURA_TOTAIS = "&T";
    private final String PRE_DETERMINACAO_VALOR_IDENTIFICADO = "&F";
    private final String PRE_DETERMINACAO_VALOR = "&P";
    private final String GERENCIAMENTO_CARTOES = "&M99";
    private final String COMANDO_MODO_BOMBA = "&M";
    private final String COMANDO_STATUS_BOMBA = "&S";
    private final String COMANDO_LEITURA_ABASTECIMENTOS = "&VKK";
    private final String COMANDO_ABASTECIMENTO = "&A";
    private final String COMANDO_ABASTECIMENTO_DUPLO_IDENTIFICADO = "@KK";
    private final String COMANDO_ABASTECIMENTO_ANDAMENTO = "&V";
    private final String COMANDO_LEITURA_IDENTIFICADORES_MEMORIA = "?LF";
    private final String COMANDO_IDENTIFICADORES_ABASTECIMENTO = "&T";
    private final String COMANDO_MANIPULACAO_ID_TAGS = "?F";
    private final String COMANDO_LEITURA_ID_TAGS = "?A";
    private final String COMANDO_INCREMENTAR_IDENTIFICADOR = "?I";
    private final String COMANDO_INCREMENTAR = "&I";
    private final String COMANDO_LEITURA_REGISTRO = "&LR";
    public final String RETORNO_VAZIO = "0";
    public final String INTEGRIDADE_MEMORIA = "00";
    private final ComunicadorTipoEquipamento equipamento;

    public ComunicadorCompanytec(ComunicadorTipoEquipamento equipamento) {
        this.equipamento = equipamento;
    }

    public ComunicadorResposta ajustaRelogio(Date dataAtual) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_02) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            SimpleDateFormat sd = new SimpleDateFormat("ddHHmm");
            String aux = sd.format(dataAtual);
            String ret = this.sendCommand(this.preparaComando("&H" + aux));
            if ((ret = this.retiraParenteses(ret)).endsWith("&H")) {
                return new ComunicadorResposta(EnumConstantsStatus.SUCESSO, "&H", aux, ret);
            }
            return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&H", aux, ret, "Erro ao ajustar o Relogio.");
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta ajustaRelogioExtendido(Date dataAtual) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            SimpleDateFormat sd = new SimpleDateFormat("yyMMddwwHHmmss");
            String aux = sd.format(dataAtual);
            String ret = this.sendCommand(this.preparaComandoCheckSum("&KW1" + aux));
            return new ComunicadorResposta(this.assertStatus("&KW1" + aux, ret), "&KW1", aux, ret);
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<Date> leituraRelogioExtendido() throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String ret = this.sendCommand(this.preparaComandoCheckSum("&KR1"));
            if (ret == null || ret.isEmpty()) {
                throw new ExceptionSocket(EnumExcepSocket.COMANDO_INVALIDO, new Object[]{ret});
            }
            SimpleDateFormat sd = new SimpleDateFormat("yyMMddHHmmss");
            ret = ret.substring(4);
            String data = ret.substring(0, 6);
            String dia = ret.substring(8, 14);
            ComunicadorResposta<Date> com = new ComunicadorResposta<Date>(EnumConstantsStatus.SUCESSO, "&KR1", "", ret);
            try {
                com.setResultado(sd.parse(data + dia));
                return com;
            }
            catch (ParseException ex) {
                Logger.getLogger(ComunicadorCompanytec.class.getName()).log(Level.SEVERE, null, ex);
                throw new ExceptionErroProgramacao("Erro ao converter data " + data + dia + " formato: " + sd.toString());
            }
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<Date> leituraRelogio() throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_02) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String ret = this.sendCommand(this.preparaComando("&R"));
            if (ret == null || ret.isEmpty()) {
                throw new ExceptionSocket(EnumExcepSocket.COMANDO_INVALIDO, new Object[]{ret});
            }
            SimpleDateFormat sd = new SimpleDateFormat("HH:mm:ss dd/MM/yy");
            String data = ret.substring(5);
            ComunicadorResposta<Date> com = new ComunicadorResposta<Date>(EnumConstantsStatus.SUCESSO, "&R", "", ret);
            try {
                com.setResultado(sd.parse(data));
                return com;
            }
            catch (ParseException ex) {
                Logger.getLogger(ComunicadorCompanytec.class.getName()).log(Level.SEVERE, null, ex);
                throw new ExceptionErroProgramacao("Erro ao converter data " + data + " formato: " + sd.toString());
            }
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta alterarPreco(String codBico, ConstEnumTipoPreco tipoPreco, Double valor) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            this.validarCodigoBico(codBico);
            String inp = ToolFormatter.formataNumero((Number)valor, (int)2);
            inp = ToolString.onlyNumbers((String)inp);
            inp = ToolString.completaZeros((String)inp, (int)4, (boolean)true);
            System.out.println("\n\n\nPRECO ENVIADO (2 casas decimais pro preco ficar 7.69 tem que enviar 0769):  " + inp);
            String aux = codBico + tipoPreco.getCodigo() + "0" + inp;
            String ret = this.sendCommand(this.preparaComandoCheckSum("&U" + aux), 1000);
            ret = this.retiraParenteses(ret);
            Object commandoEBico = "&U" + codBico;
            commandoEBico = ((String)commandoEBico).substring(1);
            if (ret.contains((CharSequence)commandoEBico)) {
                return new ComunicadorResposta(EnumConstantsStatus.SUCESSO, "&U", aux, ret);
            }
            if (ret.endsWith("t")) {
                return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&U", aux, ret, "Timeout da Bomba");
            }
            if (ret.endsWith("b")) {
                return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&U", aux, ret, "Codigo do Bico Invalido");
            }
            if (ret.endsWith("r")) {
                return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&U", aux, ret, "Erro de Resposta da Bomba");
            }
            return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&U", aux, ret, "Erro nao identificado");
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<Double> leituraTotaisExtendidos(String codBico) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            this.validarCodigoBico(codBico);
            String aux = "&T" + codBico + ConstEnumModoLeitura.LITROS.getCodigo();
            String ret = this.sendCommand(this.preparaComandoCheckSum(aux), 2000);
            ret = this.retiraParenteses(ret);
            Object temp = "&T" + ConstEnumModoLeitura.LITROS.getCodigo() + codBico;
            temp = ((String)temp).substring(1);
            if (ret.startsWith((String)temp)) {
                String valor = ret.substring(((String)temp).length(), ((String)temp).length() + 10);
                ComunicadorResposta<Double> com = new ComunicadorResposta<Double>(EnumConstantsStatus.SUCESSO, "&T", aux, ret);
                com.setResultado(this.toDouble(valor, 2));
                return com;
            }
            return new ComunicadorResposta<Double>(EnumConstantsStatus.ERRO, "&T", aux, ret, "Erro nao identificado");
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<Double> leituraTotaisEncerrantes(String codBico, ConstEnumModoLeitura modo) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            StringBuilder sb = new StringBuilder();
            String aux = "&T" + codBico + modo.getCodigo();
            sb.append("\n\nComando Enviado: " + aux);
            String ret = this.sendCommand(this.preparaComandoCheckSum(aux));
            sb.append("\nRETORNO 1: Cod Bico: " + codBico + " Modo: " + modo.getCodigo() + " VALOR: " + ret);
            ret = this.retiraParenteses(ret);
            sb.append("\nRETORNO 2: Cod Bico: " + codBico + " Modo: " + modo.getCodigo() + " VALOR: " + ret);
            Object temp = "&T" + modo.getCodigo() + codBico;
            temp = ((String)temp).substring(1);
            if (ret.startsWith((String)temp)) {
                String valor = "";
                valor = ret.length() == 14 ? ret.substring(((String)temp).length(), ((String)temp).length() + 8) : ret.substring(((String)temp).length(), ret.length() - 2);
                sb.append("\nRETORNO 3: Cod Bico: " + codBico + " Modo: " + modo.getCodigo() + " VALOR: " + valor);
                ComunicadorResposta<Double> com = new ComunicadorResposta<Double>(EnumConstantsStatus.SUCESSO, "&T", aux, ret);
                com.setResultado(this.toDouble(valor, 2));
                sb.append("\nRETORNO 4: Cod Bico: " + codBico + " Modo: " + modo.getCodigo() + " VALOR: " + this.toDouble(valor, 2));
                this.writeTempFileEncerrantes(aux, sb.toString());
                return com;
            }
            return new ComunicadorResposta<Double>(EnumConstantsStatus.ERRO, "&T", aux, ret, "Erro nao identificado");
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta preDeterminaValorAbastecimentoComIdentificacao(String codBico, String codTicketTag, ConstEnumCodIdentificador identificador, ConstEnumAutorizacao tipoAut, ConstEnumTipoPreset valorOuVolume, Double valor, int tempoAteRetirarBico) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            this.validarCodigoBico(codBico);
            String valorStr = ToolFormatter.formataNumero((Number)valor, (int)2);
            valorStr = ToolString.onlyNumbers((String)valorStr);
            valorStr = ToolString.completaZeros((String)valorStr, (int)6, (boolean)true);
            String comando = "&F" + codBico + ConstEnumTipoPreco.A_VISTA.getCodigo() + codTicketTag + identificador.getCodigo() + tipoAut.getCodigo() + valorStr + ToolString.completaZeros((String)String.valueOf(tempoAteRetirarBico), (int)2, (boolean)true) + valorOuVolume.getCodigo() + "00000";
            String ret = this.sendCommand(this.preparaComandoCheckSum(comando));
            ret = this.retiraParenteses(ret);
            if (ret.startsWith("&F" + codBico)) {
                return new ComunicadorResposta(EnumConstantsStatus.SUCESSO, "&F", comando, ret);
            }
            if (ret.endsWith("t")) {
                return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&F", comando, ret, "Bomba abastecendo");
            }
            if (ret.endsWith("b")) {
                return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&F", comando, ret, "Codigo bico Invalido");
            }
            return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&P", comando, ret, "Erro indeterminado");
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta preDeterminaValorAbastecimento(String codBico, Double valor) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            this.validarCodigoBico(codBico);
            String valorStr = ToolFormatter.formataNumero((Number)valor, (int)2);
            valorStr = ToolString.onlyNumbers((String)valorStr);
            valorStr = ToolString.completaZeros((String)valorStr, (int)6, (boolean)true);
            String comando = "&P" + codBico + valorStr;
            String ret = this.sendCommand(this.preparaComandoCheckSum(comando));
            ret = this.retiraParenteses(ret);
            Object aux = "&P" + codBico;
            aux = ((String)aux).substring(1);
            if (ret.startsWith((String)aux)) {
                return new ComunicadorResposta(EnumConstantsStatus.SUCESSO, "&P", comando, ret);
            }
            if (ret.endsWith("t")) {
                return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&P", comando, ret, "Timeout da Bomba");
            }
            if (ret.endsWith("b")) {
                return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&P", comando, ret, "Codigo bico Invalido");
            }
            if (ret.endsWith("r")) {
                return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&P", comando, ret, "Erro de Resposta da Bomba");
            }
            return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&P", comando, ret, "Erro indeterminado");
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta gerenciamentoListaNegraCartoes(ConstEnumModosListaNegraCartoes modo, String cartao) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String ret;
            String comando = "&M99" + modo.getCodigo();
            if (modo.equals((Object)ConstEnumModosListaNegraCartoes.LIBERA_TODOS_CARTOES)) {
                ret = this.sendCommand(this.preparaComandoCheckSum(comando));
            } else {
                comando = comando + cartao;
                ret = this.sendCommand(this.preparaComandoCheckSum(comando));
            }
            ret = this.retiraParenteses(ret);
            String tmp = "&M99".substring(1);
            if (ret.startsWith(tmp)) {
                return new ComunicadorResposta(EnumConstantsStatus.SUCESSO, "&M99", comando, ret);
            }
            if (ret.endsWith("f")) {
                return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&M99", comando, ret, "Erro quando \u00c3\u00a9 mandado bloqueio e a\nlista est\u00c3\u00a1 cheia");
            }
            return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&M99", comando, ret, "Erro indeterminado");
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta comandoModoBomba(String codBico, ConstEnumModos modo) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            this.validarCodigoBico(codBico);
            String comando = "&M" + codBico + modo.getCodigo();
            String comandoChekSum = this.preparaComandoCheckSum(comando);
            StringBuilder sb = new StringBuilder();
            sb.append("Comando enviado: ");
            sb.append(comandoChekSum);
            String ret = this.sendCommand(comandoChekSum);
            sb.append("\nComando retornado: ");
            sb.append(ret);
            StringBuilder nomeArquivo = new StringBuilder();
            nomeArquivo.append("BLOQ_");
            nomeArquivo.append(comando);
            this.writeTempFileEncerrantes(nomeArquivo.toString(), sb.toString());
            ret = this.retiraParenteses(ret);
            Object temp = "&M" + codBico;
            temp = ((String)temp).substring(1);
            if (ret.startsWith((String)temp)) {
                return new ComunicadorResposta(EnumConstantsStatus.SUCESSO, "&M", comando, ret);
            }
            if (ret.endsWith("t")) {
                return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&M", comando, ret, "Timeout da bomba");
            }
            if (ret.endsWith("b")) {
                return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&M", comando, ret, "C\u00c3\u00b3digo de bico inv\u00c3\u00a1lido");
            }
            if (ret.endsWith("m")) {
                return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&M", comando, ret, "Caractere de modo inv\u00c3\u00a1lido");
            }
            if (ret.endsWith("r")) {
                return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&M", comando, ret, "Erro de resposta da bomba");
            }
            return new ComunicadorResposta(EnumConstantsStatus.ERRO, "&M", comando, ret, "Erro indeterminado");
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<LeituraStatusBombas> comandoStatusBomba() throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String comando = "&S";
            String ret = this.sendCommand(this.preparaComando(comando), 1000);
            ret = this.retiraParenteses(ret);
            LeituraStatusBombas lei = new LeituraStatusBombas();
            lei.setTipoEquipamento(this.equipamento);
            if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_01)) {
                bicoSeq = 1;
                char[] status = ret.substring(1).toCharArray();
                for (int i = 0; i < status.length; ++i) {
                    lei.getStatusBicos().add(new LeituraStatusBombas.StatusBico(bicoSeq, ConstEnumStatus.get(Character.valueOf(status[i]))));
                }
            } else if (ret.length() >= 48) {
                bicoSeq = 1;
                char[] status = ret.substring(1, 33).toCharArray();
                for (int i = 0; i < status.length; ++i) {
                    lei.getStatusBicos().add(new LeituraStatusBombas.StatusBico(bicoSeq, ConstEnumStatus.get(Character.valueOf(status[i]))));
                    ++bicoSeq;
                }
                lei.setStatusDIP(ret.substring(35, 37));
                if (ret.length() >= 48) {
                    lei.setStatusAC(ret.substring(35, 48));
                }
                if (ret.length() >= 50) {
                    lei.setTensaoBateria(ret.substring(48, 50));
                }
                if (ret.length() >= 42) {
                    lei.setVersaoFirmware(ret.substring(38, 42));
                }
                if (ret.length() >= 46) {
                    lei.setVersaoSoftMonitor(ret.substring(42, 46));
                }
            }
            System.out.println("\nComando Status Bomba: " + comando);
            System.out.println("Ret: " + ret);
            System.out.println("\n");
            ComunicadorResposta<LeituraStatusBombas> com = new ComunicadorResposta<LeituraStatusBombas>(EnumConstantsStatus.SUCESSO, "&M", comando, ret);
            com.setResultado(lei);
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<LeituraAbastecimento> comandoLeituraAbastecimentos() throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) && this.equipamento.isDipSwitch3Ligado() || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) && this.equipamento.isDipSwitch3Ligado() || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) && this.equipamento.isDipSwitch3Ligado() || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String ret = this.sendCommand(this.preparaComando("&A"), 1000);
            ret = this.retiraParenteses(ret);
            LeituraAbastecimento lei = new LeituraAbastecimento();
            if (Objects.equals("0", ret)) {
                lei.setAbastecimentoMemoria(false);
                ComunicadorResposta<LeituraAbastecimento> com = new ComunicadorResposta<LeituraAbastecimento>(EnumConstantsStatus.SUCESSO, "&A", this.preparaComando("&A"), ret);
                com.setResultado(lei);
                return com;
            }
            Double valorTotalAPagar = this.toDouble(ret.substring(0, 6), 2);
            ret = ret.substring(6);
            String volume = ret.substring(0, 6);
            String precoUnit = ret.substring(6, 10);
            String tempoAbastecimento = ret.substring(12, 16);
            String codBico = ret.substring(16, 18);
            String data = ret.substring(18, 26);
            String nrAbastecimento = ret.substring(26, 30);
            String encerrante = ret.substring(30, 40);
            String status = ret.substring(40, 42);
            if (!Objects.equals("00", status)) {
                throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.PROBLEMA_INTEGRIDADE_MEMORIA_ABASTECIMENTOS, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
            }
            lei.setAbastecimentoMemoria(true);
            lei.setDataAbastecimento(ToolDate.strToDate((String)data, (String)"ddHHmmMM"));
            lei.setNrEncerramenteBico(this.toDouble(encerrante, 2));
            lei.setNumeroAbastecimento(Integer.valueOf(nrAbastecimento));
            lei.setTempoAbastecimento(Integer.valueOf(tempoAbastecimento));
            lei.setValorUnitario(this.toDouble(precoUnit, 2));
            lei.setVolumeAbastecido(this.toDouble(volume, 2));
            if (valorTotalAPagar != null && valorTotalAPagar > 0.0) {
                lei.setTotalAPagar(valorTotalAPagar);
            } else {
                lei.setTotalAPagar(this.truncarValorTotalPagar(lei.getValorUnitario() * lei.getVolumeAbastecido()));
            }
            lei.setCodBico(codBico);
            ComunicadorResposta<LeituraAbastecimento> com = new ComunicadorResposta<LeituraAbastecimento>(EnumConstantsStatus.SUCESSO, "&A", this.preparaComando("&A"), ret);
            com.setResultado(lei);
            return com;
        }
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) && !this.equipamento.isDipSwitch3Ligado() || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) && !this.equipamento.isDipSwitch3Ligado() || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) && !this.equipamento.isDipSwitch3Ligado() || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_02)) {
            String ret = this.sendCommand(this.preparaComando("&VKK"), 1000);
            ret = this.retiraParenteses(ret);
            LeituraAbastecimento lei = new LeituraAbastecimento();
            if (Objects.equals("0", ret)) {
                lei.setAbastecimentoMemoria(false);
                ComunicadorResposta<LeituraAbastecimento> com = new ComunicadorResposta<LeituraAbastecimento>(EnumConstantsStatus.SUCESSO, "&VKK", this.preparaComando("&VKK"), ret);
                com.setResultado(lei);
                return com;
            }
            ret = ret.substring(6);
            String volume = ret.substring(1, 7);
            String precoUnit = ret.substring(7, 11);
            String tempoAbastecimento = ret.substring(13, 17);
            String codBico = ret.substring(17, 19);
            String data = ret.substring(19, 25);
            lei.setAbastecimentoMemoria(true);
            lei.setDataAbastecimento(ToolDate.strToDate((String)data, (String)"ddHHmm"));
            lei.setTempoAbastecimento(Integer.valueOf(tempoAbastecimento));
            lei.setValorUnitario(this.toDouble(precoUnit, 2));
            lei.setVolumeAbastecido(this.toDouble(volume, 2));
            lei.setTotalAPagar(this.truncarValorTotalPagar(lei.getValorUnitario() * lei.getVolumeAbastecido()));
            lei.setCodBico(codBico);
            ComunicadorResposta<LeituraAbastecimento> com = new ComunicadorResposta<LeituraAbastecimento>(EnumConstantsStatus.SUCESSO, "&VKK", this.preparaComando("&VKK"), ret);
            com.setResultado(lei);
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<LeituraAbastecimento> comandoLeituraAbastecimentoIdentificado() throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String ret = this.sendCommand(this.preparaComandoCheckSum("&VKK"), 1000);
            ret = this.retiraParenteses(ret);
            LeituraAbastecimento lei = new LeituraAbastecimento();
            if (Objects.equals("0", ret)) {
                lei.setAbastecimentoMemoria(false);
                ComunicadorResposta<LeituraAbastecimento> com = new ComunicadorResposta<LeituraAbastecimento>(EnumConstantsStatus.SUCESSO, "&VKK", this.preparaComando("&VKK"), ret);
                com.setResultado(lei);
                return com;
            }
            ret = ret.substring(8);
            String volume = ret.substring(1, 7);
            String precoUnit = ret.substring(7, 11);
            String tempoAbastecimento = ret.substring(13, 17);
            String codBico = ret.substring(17, 19);
            String data = ret.substring(19, 27);
            String nrAbastecimento = ret.substring(27, 31);
            String encerrante = ret.substring(31, 41);
            String codCartao = ret.substring(43, 59);
            String nrLeitura = ret.substring(59, 63);
            String status = ret.substring(63, 65);
            if (Objects.equals("00", status)) {
                throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.PROBLEMA_INTEGRIDADE_MEMORIA_ABASTECIMENTOS, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
            }
            lei.setAbastecimentoMemoria(true);
            lei.setDataAbastecimento(ToolDate.strToDate((String)data, (String)"ddHHmmMM"));
            lei.setNrEncerramenteBico(this.toDouble(encerrante, 2));
            lei.setNumeroAbastecimento(Integer.valueOf(nrAbastecimento));
            lei.setTempoAbastecimento(Integer.valueOf(tempoAbastecimento));
            lei.setValorUnitario(this.toDouble(precoUnit, 2));
            lei.setVolumeAbastecido(this.toDouble(volume, 2));
            lei.setTotalAPagar(this.truncarValorTotalPagar(lei.getValorUnitario() * lei.getVolumeAbastecido()));
            lei.setCodBico(codBico);
            lei.setCodCartao(codCartao);
            lei.setNrLeituraIdentificacao(nrLeitura);
            ComunicadorResposta<LeituraAbastecimento> com = new ComunicadorResposta<LeituraAbastecimento>(EnumConstantsStatus.SUCESSO, "&VKK", this.preparaComando("&VKK"), ret);
            com.setResultado(lei);
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<LeituraAbastecimento> comandoAbastecimento52() throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) && this.equipamento.isDipSwitch3Ligado() || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) && this.equipamento.isDipSwitch3Ligado() || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) && this.equipamento.isDipSwitch3Ligado() || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String ret = this.sendCommand(this.preparaComando("&A"), 2000);
            ret = this.retiraParenteses(ret);
            LeituraAbastecimento lei = new LeituraAbastecimento();
            if (Objects.equals("0", ret)) {
                lei.setAbastecimentoMemoria(false);
                ComunicadorResposta<LeituraAbastecimento> com = new ComunicadorResposta<LeituraAbastecimento>(EnumConstantsStatus.SUCESSO, "&VKK", this.preparaComando("&VKK"), ret);
                com.setResultado(lei);
                return com;
            }
            if (ret.length() >= 44) {
                Double valorTotalAPagar = this.toDouble(ret.substring(0, 6), 2);
                ret = ret.substring(6);
                String volume = ret.substring(0, 6);
                String precoUnit = ret.substring(6, 10);
                String tempoAbastecimento = ret.substring(12, 16);
                String codBico = ret.substring(16, 18);
                String data = ToolDate.getYearFromDate((Date)new Date()) + ret.substring(18, 26);
                String nrAbastecimento = ret.substring(26, 30);
                String encerrante = ret.substring(30, 40);
                String statusMemoriaAbastecimento = ret.substring(40, 42);
                if (!Objects.equals("00", statusMemoriaAbastecimento)) {
                    throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.PROBLEMA_INTEGRIDADE_MEMORIA_ABASTECIMENTOS, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
                }
                lei.setAbastecimentoMemoria(true);
                lei.setDataAbastecimento(ToolDate.strToDate((String)data, (String)"yyyyddHHmmMM"));
                lei.setNrEncerramenteBico(this.toDouble(encerrante, 2));
                lei.setNumeroAbastecimento(Integer.valueOf(nrAbastecimento) - 1);
                lei.setTempoAbastecimento(Integer.parseInt(tempoAbastecimento, 16));
                lei.setValorUnitario(this.toDouble(precoUnit, 2));
                lei.setVolumeAbastecido(this.toDouble(volume, 2));
                if (valorTotalAPagar != null && valorTotalAPagar > 0.0) {
                    lei.setTotalAPagar(valorTotalAPagar);
                } else {
                    lei.setTotalAPagar(this.truncarValorTotalPagar(lei.getValorUnitario() * lei.getVolumeAbastecido()));
                }
                lei.setCodBico(codBico);
                Integer.parseInt(codBico, 16);
            }
            ComunicadorResposta<LeituraAbastecimento> com = new ComunicadorResposta<LeituraAbastecimento>(EnumConstantsStatus.SUCESSO, "&VKK", this.preparaComando("&VKK"), ret);
            com.setResultado(lei);
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<LeituraAbastecimentoByRegistro> comandoLeituraAbastecimentoByRegistro(Integer numeroRegistro) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String comando = "&LR" + numeroRegistro;
            String ret = this.sendCommand(this.preparaComandoCheckSum(comando), 1000);
            ret = this.retiraParenteses(ret);
            LeituraAbastecimentoByRegistro lei = new LeituraAbastecimentoByRegistro();
            ret = ret.substring(6);
            String volume = ret.substring(0, 6);
            String precoUnit = ret.substring(6, 10);
            String tempoAbastecimento = ret.substring(12, 16);
            String codBico = ret.substring(16, 18);
            String data = ToolDate.getYearFromDate((Date)new Date()) + ret.substring(18, 26);
            String nrAbastecimento = ret.substring(26, 30);
            String encerrante = ret.substring(30, 40);
            String tagIdentificador = ret.substring(40, 56);
            String numeroRegistroLido = ret.substring(56, 60);
            String statusMemoriaAbastecimento = ret.substring(60, 62);
            if (!Objects.equals("00", statusMemoriaAbastecimento)) {
                throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.PROBLEMA_INTEGRIDADE_MEMORIA_ABASTECIMENTOS, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
            }
            lei.setDataAbastecimento(ToolDate.strToDate((String)data, (String)"yyyyddHHmmMM"));
            lei.setNrEncerramenteBico(this.toDouble(encerrante, 2));
            lei.setNumeroAbastecimento(Integer.valueOf(nrAbastecimento) - 1);
            lei.setTempoAbastecimento(Integer.parseInt(tempoAbastecimento, 16));
            lei.setValorUnitario(this.toDouble(precoUnit, 2));
            lei.setVolumeAbastecimento(this.toDouble(volume, 2));
            lei.setTotalAPagar(this.truncarValorTotalPagar(lei.getValorUnitario() * lei.getVolumeAbastecimento()));
            lei.setCodigoBico(codBico);
            lei.setTagIdentificador(tagIdentificador);
            lei.setNrRegistroLido(Integer.parseInt(numeroRegistroLido));
            ComunicadorResposta<LeituraAbastecimentoByRegistro> com = new ComunicadorResposta<LeituraAbastecimentoByRegistro>(EnumConstantsStatus.SUCESSO, "&LR", this.preparaComando("&LR"), ret);
            com.setResultado(lei);
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<LeituraAbastecimento> comandoAbastecimento34() throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) && !this.equipamento.isDipSwitch3Ligado() || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) && !this.equipamento.isDipSwitch3Ligado() || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) && !this.equipamento.isDipSwitch3Ligado() || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_02)) {
            String ret = this.sendCommand(this.preparaComando("&A"), 2000);
            ret = this.retiraParenteses(ret);
            LeituraAbastecimento lei = new LeituraAbastecimento();
            if (Objects.equals("0", ret)) {
                lei.setAbastecimentoMemoria(false);
                ComunicadorResposta<LeituraAbastecimento> com = new ComunicadorResposta<LeituraAbastecimento>(EnumConstantsStatus.SUCESSO, "&VKK", this.preparaComando("&VKK"), ret);
                com.setResultado(lei);
                return com;
            }
            ret = ret.substring(6);
            String volume = ret.substring(0, 6);
            String precoUnit = ret.substring(6, 10);
            String tempoAbastecimento = ret.substring(12, 16);
            String codBico = ret.substring(16, 18);
            String data = ret.substring(18, 26);
            String nrAbastecimento = ret.substring(26, 30);
            String encerrante = ret.substring(30, 40);
            String statusMemoriaAbastecimento = ret.substring(40, 42);
            if (!Objects.equals("00", statusMemoriaAbastecimento)) {
                throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.PROBLEMA_INTEGRIDADE_MEMORIA_ABASTECIMENTOS, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
            }
            lei.setAbastecimentoMemoria(true);
            lei.setDataAbastecimento(ToolDate.strToDate((String)data, (String)"ddHHmmMM"));
            lei.setNrEncerramenteBico(this.toDouble(encerrante, 2));
            lei.setNumeroAbastecimento(Integer.valueOf(nrAbastecimento));
            lei.setTempoAbastecimento(Integer.valueOf(tempoAbastecimento));
            lei.setValorUnitario(this.toDouble(precoUnit, 2));
            lei.setVolumeAbastecido(this.toDouble(volume, 2));
            lei.setTotalAPagar(this.truncarValorTotalPagar(lei.getValorUnitario() * lei.getVolumeAbastecido()));
            lei.setCodBico(codBico);
            ComunicadorResposta<LeituraAbastecimento> com = new ComunicadorResposta<LeituraAbastecimento>(EnumConstantsStatus.SUCESSO, "&VKK", this.preparaComando("&VKK"), ret);
            com.setResultado(lei);
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<LeituraAbastecimento> comandoLeituraAbastecimentoDuploIdentificado() throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String ret = this.sendCommand(this.preparaComando("@KK"), 1000);
            ret = this.retiraParenteses(ret);
            LeituraAbastecimento lei = new LeituraAbastecimento();
            if (Objects.equals("0", ret)) {
                lei.setAbastecimentoMemoria(false);
                ComunicadorResposta<LeituraAbastecimento> com = new ComunicadorResposta<LeituraAbastecimento>(EnumConstantsStatus.SUCESSO, "&VKK", this.preparaComando("&VKK"), ret);
                com.setResultado(lei);
                return com;
            }
            ret = ret.substring(8);
            String volume = ret.substring(1, 7);
            String precoUnit = ret.substring(7, 11);
            String tempoAbastecimento = ret.substring(13, 17);
            String codBico = ret.substring(17, 19);
            String data = ret.substring(19, 27);
            String nrAbastecimento = ret.substring(27, 31);
            String encerrante = ret.substring(31, 41);
            String codCartao = ret.substring(43, 59);
            String codCartao2 = ret.substring(59, 75);
            String statusMemoriaIdentificadores = ret.substring(75, 77);
            String statusMemoriaAbastecimento = ret.substring(41, 43);
            if (Objects.equals("00", statusMemoriaIdentificadores)) {
                throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.PROBLEMA_INTEGRIDADE_MEMORIA_IDENTIFICACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
            }
            if (Objects.equals("00", statusMemoriaAbastecimento)) {
                throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.PROBLEMA_INTEGRIDADE_MEMORIA_ABASTECIMENTOS, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
            }
            lei.setAbastecimentoMemoria(true);
            lei.setDataAbastecimento(ToolDate.strToDate((String)data, (String)"ddHHmmMM"));
            lei.setNrEncerramenteBico(this.toDouble(encerrante, 2));
            lei.setNumeroAbastecimento(Integer.valueOf(nrAbastecimento));
            lei.setTempoAbastecimento(Integer.valueOf(tempoAbastecimento));
            lei.setValorUnitario(this.toDouble(precoUnit, 2));
            lei.setVolumeAbastecido(this.toDouble(volume, 2));
            lei.setTotalAPagar(this.truncarValorTotalPagar(lei.getValorUnitario() * lei.getVolumeAbastecido()));
            lei.setCodBico(codBico);
            lei.setCodCartao(codCartao);
            lei.setCodCartao2(codCartao2);
            ComunicadorResposta<LeituraAbastecimento> com = new ComunicadorResposta<LeituraAbastecimento>(EnumConstantsStatus.SUCESSO, "&VKK", this.preparaComando("&VKK"), ret);
            com.setResultado(lei);
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<List<LeituraAbastecimentoSimples>> comandoVisualizacaoAbastecimentoAndamento() throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_02) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String tmp = this.sendCommand(this.preparaComando("&V"), 1000);
            String ret = this.retiraParenteses(tmp);
            LinkedList<LeituraAbastecimentoSimples> temp = new LinkedList<LeituraAbastecimentoSimples>();
            if (!Objects.equals("0", ret)) {
                do {
                    String bico = ret.substring(0, 2);
                    String vlr = ret.substring(2, 8);
                    temp.add(new LeituraAbastecimentoSimples(this.toDouble(vlr, 2), bico));
                } while ((ret = ret.length() > 8 ? ret.substring(8) : null) != null);
            }
            ComunicadorResposta<List<LeituraAbastecimentoSimples>> com = new ComunicadorResposta<List<LeituraAbastecimentoSimples>>(EnumConstantsStatus.SUCESSO, "&V", "&V", tmp);
            com.setResultado(temp);
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<LeituraTag> comandoLeituraIdTagMemoria(int posicao) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String comando = "?LF" + ToolString.completaZeros((String)String.valueOf(posicao), (int)6, (boolean)true);
            String ret = this.sendCommand(this.preparaComandoCheckSum(comando), 2000);
            ret = this.retiraParenteses(ret).substring(2);
            int posicaoAtual = Integer.valueOf(ret.substring(0, 6));
            int qtdTags = Integer.valueOf(ret.substring(6, 12));
            String codTag = ret.substring(12, 28);
            String turnoInicialA = ret.substring(28, 32);
            String turnoFinalA = ret.substring(32, 36);
            String turnoInicialB = ret.substring(36, 40);
            String turnoFinalB = ret.substring(40, 44);
            String tipoTag = ret.substring(44, 46);
            LeituraTag l = new LeituraTag();
            l.setCodTag(codTag);
            l.setPosicaoAtual(posicaoAtual);
            l.setQtdTags(qtdTags);
            l.setTipoTag(tipoTag);
            l.setTurnoFinalA(turnoFinalA);
            l.setTurnoFinalB(turnoFinalB);
            l.setTurnoInicialA(turnoInicialA);
            l.setTurnoInicialB(turnoInicialB);
            l.setCodControle(ConstEnumCodControle.get(tipoTag.substring(1)));
            l.setPermissao(ConstEnumCodPermissoes.get(tipoTag.substring(0, 1)));
            ComunicadorResposta<LeituraTag> com = new ComunicadorResposta<LeituraTag>(EnumConstantsStatus.SUCESSO, "?LF", comando, ret);
            com.setResultado(l);
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<LeituraIdTagAbastecimento> comandoLeituraIdTagAbastecimento(String nrBico, ConstEnumCodIdentificador tpIdentificador) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String comando = "&T" + nrBico + tpIdentificador.getCodigo();
            String ret = this.sendCommand(this.preparaComandoCheckSum(comando), 2000);
            ret = this.retiraParenteses(ret).substring(2);
            String codBico = ret.substring(0, 2);
            String codigoFrentista = ret.substring(2, 18);
            String codigoCliente = ret.substring(19, 35);
            LeituraIdTagAbastecimento l = new LeituraIdTagAbastecimento();
            l.setCodBico(codBico);
            l.setCodigoCliente(codigoCliente);
            l.setCodigoFrentista(codigoFrentista);
            ComunicadorResposta<LeituraIdTagAbastecimento> com = new ComunicadorResposta<LeituraIdTagAbastecimento>(EnumConstantsStatus.SUCESSO, "&T", comando, ret);
            com.setResultado(l);
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta comandoLimpezaTodosIdTags() throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String comando = "?F";
            String ret = this.sendCommand(this.preparaComando(comando), 2000, false);
            ComunicadorResposta com = new ComunicadorResposta(EnumConstantsStatus.SUCESSO, "?F", comando, ret);
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<String> comandoApagarIdTag(String codIdTag, String posicaoRegistro) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String comando = "?FFFA" + codIdTag + "00" + ToolString.completaZeros((String)posicaoRegistro, (int)6, (boolean)true) + "00000000";
            String ret = this.sendCommand(this.preparaComandoCheckSum(comando), 1000);
            ret = this.retiraParenteses(ret);
            ret = ret.substring(2);
            String nrRegApg = ret.substring(0, 6);
            String nrRegReq = ret.substring(6, 12);
            String tag = ret.substring(13, 29);
            if (Objects.equals(nrRegReq, nrRegApg)) {
                ComunicadorResposta<String> com = new ComunicadorResposta<String>(EnumConstantsStatus.SUCESSO, "?F", comando, ret, "Registro Apagado");
                return com;
            }
            ComunicadorResposta<String> com = new ComunicadorResposta<String>(EnumConstantsStatus.ERRO, "?F", comando, ret, "Registro no Local difere o enviado.");
            com.setResultado(tag);
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<GravacaoIdTag> comandoGravarIdTag(ConstEnumCodControle tipoControle, ConstEnumCodPermissoes permissao, String codIdTag, String turnoInicialA, String turnoFinalA, String turnoInicialB, String turnoFinalB) throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        this.validaCodIdTag(codIdTag);
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String comando = "?F" + permissao.getCodigo() + tipoControle.getCodigo() + "G" + codIdTag + ToolString.completaZeros((String)turnoInicialA, (int)4, (boolean)true) + ToolString.completaZeros((String)turnoFinalA, (int)4, (boolean)true) + ToolString.completaZeros((String)turnoInicialB, (int)4, (boolean)true) + ToolString.completaZeros((String)turnoFinalB, (int)4, (boolean)true);
            String ret = this.sendCommand(this.preparaComandoCheckSum(comando), 1000);
            ret = this.retiraParenteses(ret);
            ret = ret.substring(2);
            String posicao = ret.substring(0, 6);
            String qtdIdMemoria = ret.substring(6, 12);
            String codigoIdTagGravado = ret.substring(12, 28);
            GravacaoIdTag g = new GravacaoIdTag();
            g.setCodigoIdTagGravado(codigoIdTagGravado);
            g.setPosicao(posicao);
            g.setQtdIdMemoria(qtdIdMemoria);
            g.setTag(codigoIdTagGravado);
            if (Objects.equals(codigoIdTagGravado, codIdTag)) {
                ComunicadorResposta<GravacaoIdTag> com = new ComunicadorResposta<GravacaoIdTag>(EnumConstantsStatus.SUCESSO, "?F", comando, ret, "Registro gravado");
                com.setResultado(g);
                return com;
            }
            ComunicadorResposta<GravacaoIdTag> com = new ComunicadorResposta<GravacaoIdTag>(EnumConstantsStatus.ERRO, "?F", comando, ret, "Erro ao gravar a TAG.");
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta<GravacaoIdTag> comandoLeituraIdTag() throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String comando = "?A80";
            String ret = this.sendCommand(this.preparaComando(comando), 1000);
            if (Objects.equals("0", ret = this.retiraParenteses(ret))) {
                ComunicadorResposta<GravacaoIdTag> com = new ComunicadorResposta<GravacaoIdTag>(EnumConstantsStatus.SUCESSO, "?A", comando, ret, "Nenhuma tag no historico.");
                return com;
            }
            ret = ret.substring(1);
            String codigoIdTagGravado = ret.substring(0, 16);
            String nrSensor = ret.substring(17, 19);
            String data = ret.substring(19, 27);
            String nrRegistroLeitura = ret.substring(27, 31);
            String integridadeMemoria = ret.substring(31, 33);
            if (!Objects.equals("00", integridadeMemoria)) {
                ComunicadorResposta<GravacaoIdTag> com = new ComunicadorResposta<GravacaoIdTag>(EnumConstantsStatus.ERRO, "?A", comando, ret, "Memoria apresenta problemas.");
                return com;
            }
            LeituraIdTag g = new LeituraIdTag();
            g.setCodigoIdTagGravado(codigoIdTagGravado);
            g.setNrRegistroLeitura(nrRegistroLeitura);
            g.setNrSensor(nrSensor);
            g.setData(ToolDate.strToDate((String)data, (String)"ddHHmmMM"));
            ComunicadorResposta<GravacaoIdTag> com = new ComunicadorResposta<GravacaoIdTag>(EnumConstantsStatus.SUCESSO, "?A", comando, ret, "Registro gravado");
            com.setResultado((GravacaoIdTag)((Object)g));
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta incrementarIdentificador() throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_02) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String comando = "?I";
            String ret = this.sendCommand(this.preparaComando(comando), 500, false);
            ret = this.retiraParenteses(ret);
            ComunicadorResposta com = new ComunicadorResposta(EnumConstantsStatus.SUCESSO, "?I", comando, ret, "Registro gravado");
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    public ComunicadorResposta incrementarAbastecimento() throws ExceptionIO, ExceptionSocket, ExceptionComunicadorPostosCombustiveis {
        if (this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.IMS_02) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_01) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_03) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_04) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_05) || this.equipamento.getTipoEquipamento().equals((Object)ConstEnumEquipamentos.CBC_06_HORUSTECH)) {
            String comando = "&I";
            String ret = this.sendCommand(this.preparaComando(comando), 500, false);
            ret = this.retiraParenteses(ret);
            ComunicadorResposta com = new ComunicadorResposta(EnumConstantsStatus.SUCESSO, "&I", comando, ret, "Registro gravado");
            return com;
        }
        throw new ExceptionComunicadorPostosCombustiveis(EnumComunicadorPostosCombustiveis.METODO_INVALIDO_PARA_EQUIPAMENTO_OU_CONFIGURACOES, new Object[]{this.equipamento.getTipoEquipamento().getDescricao()});
    }

    private EnumConstantsStatus assertStatus(String expected, String ret) {
        if (Objects.equals(ret, "(" + expected + ")")) {
            return EnumConstantsStatus.SUCESSO;
        }
        return EnumConstantsStatus.ERRO;
    }

    private void validarCodigoBico(String codBico) {
        if (codBico == null || codBico.length() != 2) {
            throw new ExceptionErroProgramacao("Codigo do Bico deve conter 2 caracteres");
        }
    }

    private String retiraParenteses(String ret) {
        if (ret.startsWith("(")) {
            ret = ret.substring(1);
        }
        if (ret.endsWith(")")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    @Override
    public String preparaComando(String comando) {
        if (!((String)comando).startsWith("(")) {
            comando = "(" + (String)comando;
        }
        if (!((String)comando).endsWith(")")) {
            comando = (String)comando + ")";
        }
        return comando;
    }

    @Override
    public String preparaComandoCheckSum(String st) {
        int ac = 0;
        for (int a = 0; a < st.length(); ++a) {
            ac += st.codePointAt(a);
        }
        Object check = Integer.toHexString(ac);
        if (((String)(check = ((String)check).toUpperCase())).length() < 2) {
            check = "0" + (String)check;
        } else if (((String)check).length() > 2) {
            check = (String)((String)check).subSequence(((String)check).length() - 2, ((String)check).length());
        }
        String ret = "(" + st + (String)check + ")";
        return ret;
    }

    private void validaCodIdTag(String codIdTag) {
        if (codIdTag == null || codIdTag.length() != 16) {
            throw new ExceptionErroProgramacao("Codigo da TAG deve conter 16 caracteres");
        }
    }

    public void writeTempFileEncerrantes(String fileName, String toString) {
    }
}

