/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.dao;

import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.NamedColor;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.Palette;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc.JdbcConnection;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc.JdbcResultSet;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.util.jdbc.JdbcStatment;
import java.util.Objects;
import java.util.regex.Pattern;

public class ExhibitionParam {
    private static final int PROPERTY_COL_X = 0;
    private static final int PROPERTY_COL_Y = 1;
    private static final int PROPERTY_COL_FONT = 2;
    private static final int PROPERTY_COL_FONT_SIZE = 3;
    private static final int PROPERTY_COL_FG_COLOR = 4;
    private static final int PROPERTY_COL_BG_COLOR = 5;
    private static final String PROPERTY_DELIMITER = ";";
    static final String TABLE_EXHIB_PARAMS = "EXHIB_PARAMS";
    static final String COL_PK_EPARAMS_ID = "EPARAMS_ID";
    static final String COL_X = "X";
    static final String COL_Y = "Y";
    static final String COL_FONT = "FONT";
    static final String COL_FONT_SIZE = "FONTSIZE";
    static final String COL_FG_COLOR = "FG_COLOR";
    static final String COL_BG_COLOR = "BG_COLOR";
    private static ExhibitionParamDao currentDao = null;
    private final boolean readOnly;
    private boolean modified;
    private boolean linked;
    private Integer id;
    private Short x;
    private Short y;
    private String font;
    private Short fontSize;
    private NamedColor fgColor;
    private NamedColor bgColor;

    public static synchronized H2ExhibitionParamDao getCurrentDao() {
        if (currentDao == null) {
            throw new IllegalStateException("There is no DAO");
        }
        return (H2ExhibitionParamDao)currentDao;
    }

    public static synchronized void setCurrentDao(H2ExhibitionParamDao dao) {
        if (dao == null) {
            throw new IllegalArgumentException("DAO cannot be null");
        }
        currentDao = dao;
        currentDao.init();
    }

    public static synchronized ExhibitionParam get(Integer id) {
        return ExhibitionParam.getCurrentDao().get(id);
    }

    public static synchronized ExhibitionParam combine(ExhibitionParam reference, ExhibitionParam exhibitionParam) {
        ExhibitionParam result = new ExhibitionParam();
        result.setX(exhibitionParam.getX() == null ? reference.getX() : exhibitionParam.getX());
        result.setY(exhibitionParam.getY() == null ? reference.getY() : exhibitionParam.getY());
        result.setFont(exhibitionParam.getFont() == null ? reference.getFont() : exhibitionParam.getFont());
        result.setFontSize(exhibitionParam.getFontSize() == null ? reference.getFontSize() : exhibitionParam.getFontSize());
        result.setFgColor(exhibitionParam.getFgColor() == null ? reference.getFgColor() : exhibitionParam.getFgColor());
        result.setBgColor(exhibitionParam.getBgColor() == null ? reference.getBgColor() : exhibitionParam.getBgColor());
        return result;
    }

    public ExhibitionParam(short x, short y, String font, short fontSize, NamedColor fgColor, NamedColor bgColor) {
        this.readOnly = true;
        this.x = x;
        this.y = y;
        this.font = font;
        this.fontSize = fontSize;
        this.fgColor = fgColor;
        this.bgColor = bgColor;
    }

    public ExhibitionParam() {
        this.readOnly = false;
        this.setModified(true);
        this.setLinked(false);
    }

    public ExhibitionParam(String propertyString) {
        this();
        String[] tokens = propertyString.split(Pattern.quote(PROPERTY_DELIMITER));
        block8: for (int i = 0; i <= 5; ++i) {
            String token = tokens[i];
            switch (i) {
                case 0: {
                    this.x = token.isEmpty() ? null : Short.valueOf(Short.parseShort(token));
                    continue block8;
                }
                case 1: {
                    this.y = token.isEmpty() ? null : Short.valueOf(Short.parseShort(token));
                    continue block8;
                }
                case 2: {
                    this.font = token.isEmpty() ? null : token;
                    continue block8;
                }
                case 3: {
                    this.fontSize = token.isEmpty() ? null : Short.valueOf(Short.parseShort(token));
                    continue block8;
                }
                case 4: {
                    this.fgColor = token.isEmpty() ? null : NamedColor.fromId(Short.parseShort(token));
                    continue block8;
                }
                case 5: {
                    this.bgColor = token.isEmpty() ? null : NamedColor.fromId(Short.parseShort(token));
                }
            }
        }
    }

    ExhibitionParam(JdbcResultSet rs) {
        this.readOnly = false;
        this.id = rs.getInt(COL_PK_EPARAMS_ID);
        this.x = rs.getShort(COL_X);
        this.y = rs.getShort(COL_Y);
        this.font = rs.getString(COL_FONT);
        this.fontSize = rs.getShort(COL_FONT_SIZE);
        this.fgColor = Palette.getInstance().getColor(rs.getShort(COL_FG_COLOR));
        this.bgColor = Palette.getInstance().getColor(rs.getShort(COL_BG_COLOR));
        this.setModified(false);
        this.setLinked(true);
    }

    private void throwIfReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Instance is read-only");
        }
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    public Integer getId() {
        return this.id;
    }

    private void setId(Integer id) {
        this.throwIfReadOnly();
        this.id = id;
    }

    public boolean isModified() {
        return this.modified;
    }

    private void setModified(boolean modified) {
        this.throwIfReadOnly();
        this.modified = modified;
    }

    public boolean isLinked() {
        return this.linked;
    }

    private void setLinked(boolean linked) {
        this.throwIfReadOnly();
        this.linked = linked;
    }

    public Short getX() {
        return this.x;
    }

    public ExhibitionParam setX(Short x) {
        this.throwIfReadOnly();
        if (!Objects.equals(this.x, x)) {
            this.x = x;
            this.setModified(true);
        }
        return this;
    }

    public Short getY() {
        return this.y;
    }

    public ExhibitionParam setY(Short y) {
        this.throwIfReadOnly();
        if (!Objects.equals(this.y, y)) {
            this.y = y;
            this.setModified(true);
        }
        return this;
    }

    public String getFont() {
        return this.font;
    }

    public ExhibitionParam setFont(String font) {
        this.throwIfReadOnly();
        if (!Objects.equals(this.font, font)) {
            this.font = font;
            this.setModified(true);
        }
        return this;
    }

    public Short getFontSize() {
        return this.fontSize;
    }

    public ExhibitionParam setFontSize(Short fontSize) {
        this.throwIfReadOnly();
        if (!Objects.equals(this.fontSize, fontSize)) {
            this.fontSize = fontSize;
            this.setModified(true);
        }
        return this;
    }

    public NamedColor getFgColor() {
        return this.fgColor;
    }

    public ExhibitionParam setFgColor(NamedColor fgColor) {
        this.throwIfReadOnly();
        if (!Objects.equals((Object)this.fgColor, (Object)fgColor)) {
            this.fgColor = fgColor;
            this.setModified(true);
        }
        return this;
    }

    public NamedColor getBgColor() {
        return this.bgColor;
    }

    public ExhibitionParam setBgColor(NamedColor bgColor) {
        this.throwIfReadOnly();
        if (!Objects.equals((Object)this.bgColor, (Object)bgColor)) {
            this.bgColor = bgColor;
            this.setModified(true);
        }
        return this;
    }

    public boolean equals(Object obj) {
        try {
            ExhibitionParam other = (ExhibitionParam)obj;
            return Objects.equals(this.getId(), other.getId());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public void save() {
        this.throwIfReadOnly();
        ExhibitionParam.getCurrentDao().save(this);
    }

    public void delete() {
        this.throwIfReadOnly();
        if (this.isLinked()) {
            ExhibitionParam.getCurrentDao().delete(this);
        }
    }

    public ExhibitionParam clone() {
        ExhibitionParam ep = new ExhibitionParam();
        ep.setX(this.getX());
        ep.setY(this.getY());
        ep.setFont(this.getFont());
        ep.setFontSize(this.getFontSize());
        ep.setFgColor(this.getFgColor());
        ep.setBgColor(this.getBgColor());
        return ep;
    }

    public String getPropertyString() {
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i <= 5; ++i) {
            if (i > 0) {
                sb.append(PROPERTY_DELIMITER);
            }
            switch (i) {
                case 0: {
                    sb.append(this.getX() == null ? "" : this.getX());
                    continue block8;
                }
                case 1: {
                    sb.append(this.getY() == null ? "" : this.getY());
                    continue block8;
                }
                case 2: {
                    sb.append(this.getFont() == null ? "" : this.getFont());
                    continue block8;
                }
                case 3: {
                    sb.append(this.getFontSize() == null ? "" : this.getFontSize());
                    continue block8;
                }
                case 4: {
                    sb.append(this.getFgColor() == null ? "" : this.getFgColor().getId());
                    continue block8;
                }
                case 5: {
                    sb.append(this.getBgColor() == null ? "" : this.getBgColor().getId());
                }
            }
        }
        return sb.toString();
    }

    private static interface ExhibitionParamDao {
        public ExhibitionParam get(Integer var1);

        public void save(ExhibitionParam var1);

        public void delete(ExhibitionParam var1);

        public void init();
    }

    public static class H2ExhibitionParamDao
    implements ExhibitionParamDao {
        private final JdbcConnection connection;

        public H2ExhibitionParamDao(JdbcConnection connection) {
            if (connection == null) {
                throw new IllegalArgumentException("null connection");
            }
            this.connection = connection;
        }

        public final JdbcConnection getConnection() {
            return this.connection;
        }

        @Override
        public ExhibitionParam get(Integer id) {
            JdbcConnection connection = this.getConnection();
            if (id == null) {
                return null;
            }
            String sql = String.format("SELECT * FROM %s WHERE %s = ?", ExhibitionParam.TABLE_EXHIB_PARAMS, ExhibitionParam.COL_PK_EPARAMS_ID);
            JdbcStatment stmt = connection.prepareStatement(sql);
            stmt.set(1, id);
            JdbcResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                return null;
            }
            ExhibitionParam instance = new ExhibitionParam(rs);
            rs.close();
            stmt.close();
            return instance;
        }

        private void create(ExhibitionParam exhibitionParam) {
            JdbcConnection connection = this.getConnection();
            if (exhibitionParam.getId() != null) {
                throw new IllegalArgumentException("Given bean has an ID");
            }
            if (exhibitionParam.isLinked()) {
                throw new IllegalArgumentException("Instance is linked");
            }
            String sql = "INSERT INTO EXHIB_PARAMS (X,Y,FONT,FONTSIZE,FG_COLOR,BG_COLOR) VALUES (?,?,?,?,?,?)";
            JdbcStatment stmt = connection.prepareStatement(sql);
            stmt.set(1, exhibitionParam.getX());
            stmt.set(2, exhibitionParam.getY());
            stmt.set(3, exhibitionParam.getFont());
            stmt.set(4, exhibitionParam.getFontSize());
            stmt.set(5, Palette.getInstance().getColorId(exhibitionParam.getFgColor()));
            stmt.set(6, Palette.getInstance().getColorId(exhibitionParam.getBgColor()));
            stmt.execute();
            JdbcResultSet keyRs = stmt.getGeneratedKeys();
            keyRs.next();
            Integer generatedId = keyRs.getInt(1);
            keyRs.close();
            stmt.close();
            exhibitionParam.setId(generatedId);
            exhibitionParam.setModified(false);
            exhibitionParam.setLinked(true);
        }

        @Override
        public void save(ExhibitionParam exhibitionParam) {
            JdbcConnection connection = this.getConnection();
            if (!exhibitionParam.isModified()) {
                return;
            }
            if (!exhibitionParam.isLinked()) {
                this.create(exhibitionParam);
            }
            StringBuilder sqlFormat = new StringBuilder("UPDATE %s SET ").append("%s = ?").append(", ").append("%s = ?").append(", ").append("%s = ?").append(", ").append("%s = ?").append(", ").append("%s = ?").append(", ").append("%s = ? ").append("WHERE %s = ?");
            String sql = String.format(sqlFormat.toString(), ExhibitionParam.TABLE_EXHIB_PARAMS, ExhibitionParam.COL_X, ExhibitionParam.COL_Y, ExhibitionParam.COL_FONT, ExhibitionParam.COL_FONT_SIZE, ExhibitionParam.COL_FG_COLOR, ExhibitionParam.COL_BG_COLOR, ExhibitionParam.COL_PK_EPARAMS_ID);
            JdbcStatment stmt = connection.prepareStatement(sql);
            stmt.set(1, exhibitionParam.getX());
            stmt.set(2, exhibitionParam.getY());
            stmt.set(3, exhibitionParam.getFont());
            stmt.set(4, exhibitionParam.getFontSize());
            stmt.set(5, Palette.getInstance().getColorId(exhibitionParam.getFgColor()));
            stmt.set(6, Palette.getInstance().getColorId(exhibitionParam.getBgColor()));
            stmt.set(7, exhibitionParam.getId());
            stmt.execute();
            stmt.close();
            exhibitionParam.setModified(false);
        }

        @Override
        public void init() {
            if (!this.getConnection().getTableNames().contains(ExhibitionParam.TABLE_EXHIB_PARAMS)) {
                StringBuilder sqlFormat = new StringBuilder("CREATE TABLE %s (").append("%s INT PRIMARY KEY AUTO_INCREMENT, ").append("%s SMALLINT, ").append("%s SMALLINT, ").append("%s VARCHAR(100), ").append("%s SMALLINT, ").append("%s SMALLINT, ").append("%s SMALLINT)");
                String sql = String.format(sqlFormat.toString(), ExhibitionParam.TABLE_EXHIB_PARAMS, ExhibitionParam.COL_PK_EPARAMS_ID, ExhibitionParam.COL_X, ExhibitionParam.COL_Y, ExhibitionParam.COL_FONT, ExhibitionParam.COL_FONT_SIZE, ExhibitionParam.COL_FG_COLOR, ExhibitionParam.COL_BG_COLOR);
                JdbcStatment stmt = this.getConnection().prepareStatement(sql);
                stmt.execute();
                stmt.close();
            }
        }

        @Override
        public void delete(ExhibitionParam exhibitionParam) {
            if (!exhibitionParam.isLinked()) {
                throw new IllegalArgumentException("Instance is not linked");
            }
            String sql = String.format("DELETE FROM %s WHERE %s = ?", ExhibitionParam.TABLE_EXHIB_PARAMS, ExhibitionParam.COL_PK_EPARAMS_ID);
            JdbcStatment stmt = this.getConnection().prepareStatement(sql);
            stmt.set(1, exhibitionParam.getId());
            stmt.execute();
            exhibitionParam.setId(null);
            exhibitionParam.setModified(true);
            exhibitionParam.setLinked(false);
            stmt.close();
        }
    }
}

