/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.gertec.org.reconcavo.event;

import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.Event;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.EventCaller;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.EventLoop;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.Listener;
import java.util.Date;

public class Timer
extends EventCaller<TimerListener> {
    private static final String DEFAULT_TIMER_NAME = "timer";
    public static final Event EVT_TIMEOUT = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((TimerListener)listener).onTimeout((Timer)args[0]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((Timer)args[0]).onTimeout();
        }
    };
    private final String name;
    private volatile long delay = 0L;
    private volatile long interval = 0L;
    private volatile boolean singleshot = false;
    private TimerThread timerThread;

    public static Timer startSingleshot(EventLoop eventLoop, long delay, String timerName, TimerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        final TimerListener fListener = listener;
        Timer timer = new Timer(eventLoop, timerName);
        TimerListener listenerWrapper = new TimerListener(){

            @Override
            public void onTimeout(Timer timer) {
                fListener.onTimeout(timer);
                timer.stop();
            }
        };
        timer.addListener(listenerWrapper);
        timer.startSingleshot(delay);
        return timer;
    }

    public static Timer startSingleshot(EventLoop eventLoop, long delay, TimerListener listener) {
        return Timer.startSingleshot(eventLoop, delay, DEFAULT_TIMER_NAME, listener);
    }

    public Timer(EventLoop eventLoop) {
        this(eventLoop, DEFAULT_TIMER_NAME);
    }

    public Timer(EventLoop eventLoop, String name) {
        super(eventLoop);
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Null/Empty name");
        }
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    protected void onEventLoopStop() {
        this.stop();
    }

    protected void onTimeout() {
    }

    public final boolean isActive() {
        return this.timerThread != null && this.timerThread.isAlive();
    }

    public final boolean isPaused() {
        return this.isActive() && this.timerThread.isPaused();
    }

    public final long getDelay() {
        return this.delay;
    }

    public final void setDelay(long delay) {
        if (delay < 0L) {
            throw new IllegalStateException("invalid delay: " + delay);
        }
        this.delay = delay;
    }

    public final long getInterval() {
        return this.interval;
    }

    public final void setInterval(long interval) {
        if (interval < 0L) {
            throw new IllegalStateException("Invalid interval: " + interval);
        }
        this.interval = interval;
    }

    public final boolean isSingleshot() {
        return this.singleshot;
    }

    public final void setSingleshot(boolean singleshot) {
        if (this.isActive()) {
            throw new IllegalStateException("Timer is already running");
        }
        this.singleshot = singleshot;
    }

    private void start(boolean singleshot, long delay, long interval) {
        if (!this.getEventLoop().isRunning()) {
            throw new IllegalStateException("Event-loop is not running");
        }
        this.singleshot = singleshot;
        this.delay = delay;
        this.interval = interval;
        this.stop();
        this.timerThread = new TimerThread();
        this.timerThread.setName(this.getName());
        this.timerThread.start();
    }

    protected void onStart() {
    }

    public final void start() {
        this.start(this.singleshot, this.delay, this.interval);
    }

    public final void start(long delay, long interval) {
        this.start(false, delay, interval);
    }

    public final void start(long interval) {
        this.start(0L, interval);
    }

    public final void startSingleshot(long delay) {
        this.start(true, delay, 0L);
    }

    public final void stop() {
        if (this.isActive()) {
            this.timerThread.stopThread();
            this.onStop();
        }
    }

    protected void onStop() {
    }

    public final void pause() {
        if (this.isActive() && !this.isPaused()) {
            this.timerThread.pause();
        }
    }

    public final void resume() {
        if (this.isPaused()) {
            this.timerThread.resumeTimer();
        }
    }

    public static interface TimerListener
    extends Listener {
        public void onTimeout(Timer var1);
    }

    private class TimerThread
    extends Thread {
        private final Object mutex = new Object();
        private volatile boolean stop = false;
        private volatile boolean pause = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopThread() {
            Object object = this.mutex;
            synchronized (object) {
                this.stop = true;
                this.mutex.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPaused() {
            Object object = this.mutex;
            synchronized (object) {
                return this.pause;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pause() {
            Object object = this.mutex;
            synchronized (object) {
                if (!this.isPaused()) {
                    this.pause = true;
                    this.mutex.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeTimer() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.isPaused()) {
                    this.pause = false;
                    this.mutex.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            Timer.this.getEventLoop().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Timer.this.onStart();
                }
            });
            if (Timer.this.delay > 0L) {
                object = this.mutex;
                synchronized (object) {
                    try {
                        long delayTimestamp;
                        if (this.pause) {
                            this.mutex.wait();
                        }
                        for (long elapsedDelay = 0L; !this.stop && elapsedDelay < Timer.this.delay; elapsedDelay += new Date().getTime() - delayTimestamp) {
                            delayTimestamp = new Date().getTime();
                            this.mutex.wait(Timer.this.delay - elapsedDelay);
                            if (!this.pause) continue;
                            this.mutex.wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        Timer.this.getEventLoop().throwError(ex);
                    }
                }
            }
            if (!this.stop) {
                Timer.this.notifyEvent(EVT_TIMEOUT, this);
            }
            while (!this.stop && !Timer.this.singleshot) {
                object = this.mutex;
                synchronized (object) {
                    block17: {
                        try {
                            long intervalTimestamp;
                            if (this.pause) {
                                this.mutex.wait();
                            }
                            for (long elapsedInterval = 0L; !this.stop && elapsedInterval < Timer.this.interval; elapsedInterval += new Date().getTime() - intervalTimestamp) {
                                intervalTimestamp = new Date().getTime();
                                this.mutex.wait(Timer.this.interval - elapsedInterval);
                                if (!this.pause) continue;
                                this.mutex.wait();
                            }
                            if (this.stop) break block17;
                            Timer.this.notifyEvent(EVT_TIMEOUT, this);
                        }
                        catch (InterruptedException ex) {
                            Timer.this.getEventLoop().throwError(ex);
                            break;
                        }
                    }
                }
            }
        }

        private TimerThread() {
        }
    }
}

