/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.socket;

import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.ConnectionChannel;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.DataBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class SocketChannel
implements ConnectionChannel {
    private static final byte[] EMPTY_DATA = new byte[0];
    private static final int TEST_BUFFER_SIZE = 128;
    private static final int BUFFER_MAX_SIZE = 4096;
    private static final int SO_TIMEOUT = 1;
    private final Socket socket;
    private final byte[] testBuffer = new byte[128];
    private int lastReadCount = 0;

    private static int min(int ... values) {
        if (values.length < 1) {
            throw new IllegalArgumentException("Function requires at least one value");
        }
        int min = values[0];
        for (int i = 1; i < values.length; ++i) {
            int val = values[i];
            if (val >= min) continue;
            min = val;
        }
        return min;
    }

    public SocketChannel(Socket socket) {
        if (socket == null) {
            throw new IllegalArgumentException("Socket cannot be null");
        }
        try {
            socket.setSoTimeout(1);
            this.socket = socket;
        }
        catch (SocketException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final Socket getSocket() {
        return this.socket;
    }

    @Override
    public void close() throws IOException {
        this.getSocket().close();
    }

    @Override
    public byte[] read() throws IOException {
        if (this.lastReadCount > 0) {
            byte[] arrayOfByte = new DataBuffer().put(this.testBuffer, 0, this.lastReadCount).readBytes();
            this.lastReadCount = 0;
            return arrayOfByte;
        }
        int numBytes = SocketChannel.min(this.getAvailableRead(), 4096);
        if (numBytes == 0) {
            return EMPTY_DATA;
        }
        byte[] data = new byte[numBytes];
        int read = this.getSocket().getInputStream().read(data);
        if (read == data.length) {
            return data;
        }
        return new DataBuffer().put(data, 0, read).readBytes();
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.getSocket().getOutputStream().write(data);
        this.getSocket().getOutputStream().flush();
    }

    @Override
    public boolean isOpen() {
        return !this.getSocket().isClosed();
    }

    @Override
    public int getAvailableRead() throws IOException {
        Socket mSocket = this.getSocket();
        if (mSocket.isClosed()) {
            return -1;
        }
        InputStream is = mSocket.getInputStream();
        int available = is.available();
        if (available > 0) {
            return available;
        }
        try {
            this.lastReadCount = is.read(this.testBuffer);
        }
        catch (SocketTimeoutException ex) {
            this.lastReadCount = 0;
        }
        return this.lastReadCount;
    }
}

