/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.format;

import br.com.caelum.stella.format.Formatter;

public class LeftSideZerosFormatter
implements Formatter {
    private final int formattedLength;

    public LeftSideZerosFormatter(int formattedLength) {
        this.formattedLength = formattedLength;
    }

    @Override
    public String format(String value) {
        if (!this.canBeFormatted(value)) {
            throw new IllegalArgumentException("Argument value must have only " + this.formattedLength + " digits at most.");
        }
        String formated = value;
        while (formated.length() < this.formattedLength) {
            formated = "0" + formated;
        }
        return formated;
    }

    @Override
    public String unformat(String value) {
        Integer integer = Integer.valueOf(value);
        String formated = integer.toString();
        return formated;
    }

    @Override
    public boolean isFormatted(String value) {
        return value.matches("\\d{" + this.formattedLength + "}");
    }

    @Override
    public boolean canBeFormatted(String value) {
        return value.matches("\\d{0," + this.formattedLength + "}");
    }
}

