/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.tinytype;

import br.com.caelum.stella.format.CPFFormatter;
import br.com.caelum.stella.validation.CPFValidator;

public final class CPF {
    private final String numero;
    private final String numeroFormatado;

    public CPF(String numero) {
        CPFFormatter formatador = new CPFFormatter();
        if (formatador.isFormatted(numero)) {
            this.numero = formatador.unformat(numero);
            this.numeroFormatado = numero;
        } else if (formatador.canBeFormatted(numero)) {
            this.numero = numero;
            this.numeroFormatado = formatador.format(numero);
        } else {
            this.numero = this.numeroFormatado = numero;
        }
    }

    public String getNumero() {
        return this.numero;
    }

    public String getNumeroFormatado() {
        return this.numeroFormatado;
    }

    public boolean isValido() {
        return new CPFValidator().invalidMessagesFor(this.numero).isEmpty();
    }

    public String toString() {
        return this.getNumeroFormatado();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.numero == null ? 0 : this.numero.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CPF other = (CPF)obj;
        return !(this.numero == null ? other.numero != null : !this.numero.equals(other.numero));
    }
}

