/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.SimpleMessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.validation.CNPJValidator;
import br.com.caelum.stella.validation.CPFValidator;
import br.com.caelum.stella.validation.InvalidStateException;
import br.com.caelum.stella.validation.Validator;
import java.util.ArrayList;
import java.util.List;

public class AcceptAnyValidator
implements Validator<String> {
    private List<Validator<String>> validators = new ArrayList<Validator<String>>();

    public AcceptAnyValidator(Documento ... documentos) {
        this(true, documentos);
    }

    public AcceptAnyValidator(boolean isFormatted, Documento ... documentos) {
        this(new SimpleMessageProducer(), isFormatted, documentos);
    }

    public AcceptAnyValidator(MessageProducer messageProducer, boolean isFormatted, Documento ... documentos) {
        for (Documento documento : documentos) {
            this.validators.add(documento.getValidator(messageProducer, isFormatted));
        }
    }

    @Override
    public void assertValid(String value) {
        List<ValidationMessage> invalidMessages = this.invalidMessagesFor(value);
        if (!invalidMessages.isEmpty()) {
            throw new InvalidStateException(invalidMessages);
        }
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String value) {
        ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
        for (Validator<String> validator : this.validators) {
            List<ValidationMessage> messages = validator.invalidMessagesFor(value);
            if (messages.isEmpty()) {
                result.clear();
                break;
            }
            result.addAll(messages);
        }
        return result;
    }

    @Override
    public boolean isEligible(String object) {
        boolean result = false;
        for (Validator<String> validator : this.validators) {
            result |= validator.isEligible(object);
        }
        return result;
    }

    @Override
    public String generateRandomValid() {
        return this.validators.iterator().next().generateRandomValid();
    }

    public static enum Documento {
        CPF{

            @Override
            public Validator<String> getValidator(MessageProducer messageProducer, boolean isFormatted) {
                return new CPFValidator(messageProducer, isFormatted);
            }
        }
        ,
        CNPJ{

            @Override
            public Validator<String> getValidator(MessageProducer messageProducer, boolean isFormatted) {
                return new CNPJValidator(messageProducer, isFormatted);
            }
        };


        public abstract Validator<String> getValidator(MessageProducer var1, boolean var2);
    }
}

