/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.xml.InternalContext;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.exolab.castor.xml.util.ResolverStrategy;
import org.exolab.castor.xml.util.resolvers.ResolveHelpers;

public class XMLClassDescriptorResolverImpl
implements XMLClassDescriptorResolver {
    private static final Log LOG = LogFactory.getLog(XMLClassDescriptorResolverImpl.class);
    private DescriptorCacheImpl _descriptorCache = new DescriptorCacheImpl();
    private MappingLoader _mappingLoader;
    private ClassLoader _classLoader;
    private Boolean _useIntrospector;
    private Boolean _loadPackageMappings;
    private Introspector _introspector;
    private ResolverStrategy _resolverStrategy;

    @Override
    public void setInternalContext(InternalContext internalContext) {
        this._mappingLoader = internalContext.getMappingLoader();
        this._classLoader = internalContext.getClassLoader();
        this._useIntrospector = internalContext.getUseIntrospector();
        this._loadPackageMappings = internalContext.getLoadPackageMapping();
        this._introspector = internalContext.getIntrospector();
        this._resolverStrategy = internalContext.getResolverStrategy();
    }

    @Override
    public MappingLoader getMappingLoader() {
        return this._mappingLoader;
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        this._classLoader = loader;
    }

    @Override
    public void setUseIntrospection(boolean enable) {
        this._useIntrospector = enable;
    }

    @Override
    public void setLoadPackageMappings(boolean loadPackageMappings) {
        this._loadPackageMappings = loadPackageMappings;
    }

    @Override
    public void setMappingLoader(MappingLoader mappingLoader) {
        this._mappingLoader = mappingLoader;
        if (mappingLoader != null) {
            for (ClassDescriptor classDescriptor : mappingLoader.getDescriptors()) {
                this._descriptorCache.addDescriptor(classDescriptor.getJavaClass().getName(), (XMLClassDescriptor)classDescriptor);
            }
        }
    }

    @Override
    public void setIntrospector(Introspector introspector) {
        this._introspector = introspector;
    }

    @Override
    public void setResolverStrategy(ResolverStrategy resolverStrategy) {
        this._resolverStrategy = resolverStrategy;
    }

    private ResolverStrategy getResolverStrategy() {
        this.setAttributesIntoStrategy();
        return this._resolverStrategy;
    }

    @Override
    public ClassDescriptor resolve(Class<?> type) throws ResolverException {
        if (type == null) {
            String message = "Type argument must not be null for resolve";
            LOG.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        if (this._descriptorCache.isMissingDescriptor(type.getName())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Descriptor for " + type.getName() + " already marked as *MISSING*."));
            }
            return null;
        }
        if (this._descriptorCache.getDescriptor(type.getName()) != null) {
            return this._descriptorCache.getDescriptor(type.getName());
        }
        ClassLoader l = this._classLoader;
        if (l == null) {
            l = type.getClassLoader();
        }
        if (l == null) {
            l = Thread.currentThread().getContextClassLoader();
        }
        return this.resolve(type.getName(), l);
    }

    @Override
    public XMLClassDescriptor resolve(String className) throws ResolverException {
        if (className == null || className.length() == 0) {
            String message = "Cannot resolve a null or zero-length class name.";
            LOG.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        if (this._descriptorCache.isMissingDescriptor(className)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Descriptor for " + className + " already marked as *MISSING*."));
            }
            return null;
        }
        if (this._descriptorCache.getDescriptor(className) != null) {
            return this._descriptorCache.getDescriptor(className);
        }
        ClassLoader l = this._classLoader;
        if (l == null) {
            l = Thread.currentThread().getContextClassLoader();
        }
        return this.resolve(className, l);
    }

    @Override
    public XMLClassDescriptor resolve(String className, ClassLoader loader) throws ResolverException {
        if (className == null || className.length() == 0) {
            String message = "Cannot resolve a null or zero-length class name.";
            LOG.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        if (this._descriptorCache.isMissingDescriptor(className)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Descriptor for " + className + " already marked as *MISSING*."));
            }
            return null;
        }
        if (this._descriptorCache.getDescriptor(className) != null) {
            return this._descriptorCache.getDescriptor(className);
        }
        ClassLoader l = loader;
        if (l == null) {
            l = this._classLoader;
        }
        if (l == null) {
            l = Thread.currentThread().getContextClassLoader();
        }
        this.getResolverStrategy().setProperty("org.exolab.castor.xml.util.ResolverStrategy.ClassLoader", l);
        return (XMLClassDescriptor)this.getResolverStrategy().resolveClass(this._descriptorCache, className);
    }

    @Override
    public XMLClassDescriptor resolveByXMLName(String xmlName, String namespaceURI, ClassLoader loader) {
        if (xmlName == null || xmlName.length() == 0) {
            String message = "Cannot resolve a null or zero-length class name.";
            LOG.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        List<ClassDescriptor> possibleMatches = this._descriptorCache.getDescriptors(xmlName);
        if (possibleMatches.isEmpty()) {
            return null;
        }
        if (possibleMatches.size() == 1) {
            return (XMLClassDescriptor)possibleMatches.get(0);
        }
        for (XMLClassDescriptor xMLClassDescriptor : possibleMatches) {
            if (!ResolveHelpers.namespaceEquals(namespaceURI, xMLClassDescriptor.getNameSpaceURI())) continue;
            return xMLClassDescriptor;
        }
        return null;
    }

    @Override
    public Iterator<ClassDescriptor> resolveAllByXMLName(String xmlName, String namespaceURI, ClassLoader loader) {
        if (xmlName == null || xmlName.length() == 0) {
            String message = "Cannot resolve a null or zero-length xml name.";
            LOG.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        return this._descriptorCache.getDescriptors(xmlName).iterator();
    }

    @Override
    public void addClass(String className) throws ResolverException {
        this.resolve(className);
    }

    @Override
    public void addClasses(String[] classNames) throws ResolverException {
        for (int i = 0; i < classNames.length; ++i) {
            String className = classNames[i];
            this.addClass(className);
        }
    }

    @Override
    public void addClass(Class<?> clazz) throws ResolverException {
        this.resolve(clazz);
    }

    @Override
    public void addClasses(Class<?>[] clazzes) throws ResolverException {
        for (int i = 0; i < clazzes.length; ++i) {
            Class<?> clazz = clazzes[i];
            this.addClass(clazz);
        }
    }

    @Override
    public void addPackage(String packageName) throws ResolverException {
        if (packageName == null || packageName.length() == 0) {
            String message = "Cannot resolve a null or zero-length package name.";
            LOG.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        this.getResolverStrategy().resolvePackage(this._descriptorCache, packageName);
    }

    @Override
    public void addPackages(String[] packageNames) throws ResolverException {
        for (int i = 0; i < packageNames.length; ++i) {
            String packageName = packageNames[i];
            this.addPackage(packageName);
        }
    }

    @Override
    public void loadClassDescriptors(String packageName) throws ResolverException {
        String message = "Already deprecated in the interface!";
        LOG.warn((Object)message);
        throw new UnsupportedOperationException();
    }

    private void setAttributesIntoStrategy() {
        ResolverStrategy strategy = this._resolverStrategy;
        strategy.setProperty("org.exolab.castor.xml.util.ResolverStrategy.LoadPackageMappings", this._loadPackageMappings);
        strategy.setProperty("org.exolab.castor.xml.util.ResolverStrategy.useIntrospection", this._useIntrospector);
        strategy.setProperty("org.exolab.castor.xml.util.ResolverStrategy.MappingLoader", this._mappingLoader);
        strategy.setProperty("org.exolab.castor.xml.util.ResolverStrategy.Introspector", this._introspector);
    }

    @Override
    public void cleanDescriptorCache() {
        this._descriptorCache = new DescriptorCacheImpl();
    }

    private static class DescriptorCacheImpl
    implements ResolverStrategy.ResolverResults {
        private static final Log LOG2 = LogFactory.getLog(DescriptorCacheImpl.class);
        private static final String INTERNAL_CONTAINER_NAME = "-error-if-this-is-used-";
        private final List<String> _missingTypes;
        private final Map<String, ClassDescriptor> _typeMap;
        private final Map<String, List<ClassDescriptor>> _xmlNameMap;
        private final ReentrantReadWriteLock _lock;

        public DescriptorCacheImpl() {
            LOG2.debug((Object)"New instance!");
            this._typeMap = new HashMap<String, ClassDescriptor>();
            this._xmlNameMap = new HashMap<String, List<ClassDescriptor>>();
            this._missingTypes = new ArrayList<String>();
            this._lock = new ReentrantReadWriteLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addDescriptor(String className, XMLClassDescriptor descriptor) {
            if (className == null || className.length() == 0) {
                String message = "Class name to insert ClassDescriptor must not be null";
                LOG2.warn((Object)message);
                throw new IllegalArgumentException(message);
            }
            this._lock.writeLock().lock();
            try {
                if (descriptor == null) {
                    if (LOG2.isDebugEnabled()) {
                        LOG2.debug((Object)("Adding class name to missing classes: " + className));
                    }
                    this._missingTypes.add(className);
                    return;
                }
                if (LOG2.isDebugEnabled()) {
                    LOG2.debug((Object)("Adding descriptor class for: " + className + " descriptor: " + descriptor));
                }
                this._typeMap.put(className, descriptor);
                String xmlName = descriptor.getXMLName();
                if (xmlName == null || xmlName.length() == 0) {
                    return;
                }
                if (INTERNAL_CONTAINER_NAME.equals(xmlName)) {
                    return;
                }
                List<ClassDescriptor> descriptorList = this._xmlNameMap.get(xmlName);
                if (descriptorList == null) {
                    descriptorList = new ArrayList<ClassDescriptor>();
                    this._xmlNameMap.put(xmlName, descriptorList);
                }
                if (!descriptorList.contains(descriptor)) {
                    descriptorList.add(descriptor);
                }
                this._missingTypes.remove(className);
            }
            finally {
                this._lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XMLClassDescriptor getDescriptor(String className) {
            this._lock.readLock().lock();
            try {
                if (className == null || "".equals(className) || this._missingTypes.contains(className)) {
                    XMLClassDescriptor xMLClassDescriptor = null;
                    return xMLClassDescriptor;
                }
                XMLClassDescriptor ret = (XMLClassDescriptor)this._typeMap.get(className);
                if (LOG2.isDebugEnabled()) {
                    LOG2.debug((Object)("Get descriptor for: " + className + " found: " + ret));
                }
                XMLClassDescriptor xMLClassDescriptor = ret;
                return xMLClassDescriptor;
            }
            finally {
                this._lock.readLock().unlock();
            }
        }

        public List<ClassDescriptor> getDescriptors(String xmlName) {
            this._lock.readLock().lock();
            List<ClassDescriptor> list = this._xmlNameMap.get(xmlName);
            this._lock.readLock().unlock();
            list = list == null ? new ArrayList<ClassDescriptor>() : new ArrayList<ClassDescriptor>(list);
            return list;
        }

        public boolean isMissingDescriptor(String className) {
            this._lock.readLock().lock();
            try {
                boolean bl = this._missingTypes.contains(className);
                return bl;
            }
            finally {
                this._lock.readLock().unlock();
            }
        }

        @Override
        public void addAllDescriptors(Map descriptors) {
            if (descriptors == null || descriptors.isEmpty()) {
                LOG2.debug((Object)"Called addAllDescriptors with null or empty descriptor map");
                return;
            }
            for (String clsName : descriptors.keySet()) {
                this.addDescriptor(clsName, (XMLClassDescriptor)descriptors.get(clsName));
            }
        }
    }
}

