/*
 * Decompiled with CFR 0.152.
 */
package com.lilittlecat.chatgpt.offical;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.lilittlecat.chatgpt.offical.entity.ChatCompletionRequestBody;
import com.lilittlecat.chatgpt.offical.entity.ChatCompletionResponseBody;
import com.lilittlecat.chatgpt.offical.entity.Constant;
import com.lilittlecat.chatgpt.offical.entity.Message;
import com.lilittlecat.chatgpt.offical.entity.Model;
import com.lilittlecat.chatgpt.offical.exception.BizException;
import com.lilittlecat.chatgpt.offical.exception.Error;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Collections;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatGPT {
    private static final Logger log = LoggerFactory.getLogger(ChatGPT.class);
    private final String apiKey;
    private String apiHost = "https://api.openai.com/v1/chat/completions";
    protected OkHttpClient client;
    private ObjectMapper objectMapper = Constant.DEFAULT_OBJECT_MAPPER;

    public ChatGPT(String apiKey) {
        this.apiKey = apiKey;
        this.client = new OkHttpClient();
    }

    public ChatGPT(String apiKey, OkHttpClient client) {
        this.apiKey = apiKey;
        this.client = client;
    }

    public ChatGPT(String apiKey, Proxy proxy) {
        this.apiKey = apiKey;
        this.client = new OkHttpClient.Builder().proxy(proxy).build();
    }

    public ChatGPT(String apiKey, String proxyHost, int proxyPort) {
        this.apiKey = apiKey;
        this.client = new OkHttpClient.Builder().proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort))).build();
    }

    public ChatGPT(String apiHost, String apiKey) {
        this.apiHost = apiHost;
        this.apiKey = apiKey;
        this.client = new OkHttpClient();
    }

    public ChatGPT(String apiHost, String apiKey, OkHttpClient client, ObjectMapper objectMapper) {
        this.apiHost = apiHost;
        this.apiKey = apiKey;
        this.client = client;
        this.objectMapper = objectMapper;
    }

    public ChatGPT(String apiHost, String apiKey, Proxy proxy) {
        this.apiHost = apiHost;
        this.apiKey = apiKey;
        this.client = new OkHttpClient.Builder().proxy(proxy).build();
    }

    public ChatGPT(String apiHost, String apiKey, String proxyHost, int proxyPort) {
        this.apiHost = apiHost;
        this.apiKey = apiKey;
        this.client = new OkHttpClient.Builder().proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort))).build();
    }

    public String ask(String input) {
        return this.ask(Constant.DEFAULT_MODEL.getName(), "user", input);
    }

    public String ask(String user, String input) {
        return this.ask(Constant.DEFAULT_MODEL.getName(), user, input);
    }

    public String ask(Model model, String input) {
        return this.ask(model.getName(), "user", input);
    }

    public String ask(List<Message> messages) {
        return this.ask(Constant.DEFAULT_MODEL.getName(), messages);
    }

    public String ask(Model model, List<Message> messages) {
        return this.ask(model.getName(), messages);
    }

    public String ask(String model, List<Message> message) {
        ChatCompletionResponseBody chatCompletionResponseBody = this.askOriginal(model, message);
        List<ChatCompletionResponseBody.Choice> choices = chatCompletionResponseBody.getChoices();
        StringBuilder result = new StringBuilder();
        for (ChatCompletionResponseBody.Choice choice : choices) {
            result.append(choice.getMessage().getContent());
        }
        return result.toString();
    }

    public String ask(Model model, String user, String input) {
        return this.ask(model.getName(), user, input);
    }

    private String buildRequestBody(String model, List<Message> messages) {
        try {
            ChatCompletionRequestBody requestBody = ChatCompletionRequestBody.builder().model(model).messages(messages).build();
            return this.objectMapper.writeValueAsString((Object)requestBody);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public ChatCompletionResponseBody askOriginal(String model, String role, String input) {
        return this.askOriginal(model, Collections.singletonList(Message.builder().role(role).content(input).build()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChatCompletionResponseBody askOriginal(String model, List<Message> messages) {
        RequestBody body = RequestBody.create((String)this.buildRequestBody(model, messages), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(this.apiHost).header("Authorization", "Bearer " + this.apiKey).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                if (response.body() == null) {
                    log.error("Request failed: {}, please try again", (Object)response.message());
                    throw new BizException(response.code(), "Request failed");
                }
                log.error("Request failed: {}, please try again", (Object)response.body().string());
                throw new BizException(response.code(), response.body().string());
            }
            assert (response.body() != null);
            String bodyString = response.body().string();
            ChatCompletionResponseBody chatCompletionResponseBody = (ChatCompletionResponseBody)this.objectMapper.readValue(bodyString, ChatCompletionResponseBody.class);
            return chatCompletionResponseBody;
        }
        catch (IOException e) {
            log.error("Request failed: {}", (Object)e.getMessage());
            throw new BizException(Error.SERVER_HAD_AN_ERROR.getCode(), e.getMessage());
        }
    }

    public String ask(String model, String role, String content) {
        ChatCompletionResponseBody chatCompletionResponseBody = this.askOriginal(model, Collections.singletonList(Message.builder().role(role).content(content).build()));
        List<ChatCompletionResponseBody.Choice> choices = chatCompletionResponseBody.getChoices();
        StringBuilder result = new StringBuilder();
        for (ChatCompletionResponseBody.Choice choice : choices) {
            result.append(choice.getMessage().getContent());
        }
        return result.toString();
    }

    public static ChatGPTBuilder builder() {
        return new ChatGPTBuilder();
    }

    public static class ChatGPTBuilder {
        private String apiKey;
        private String apiHost;
        private OkHttpClient client;
        private ObjectMapper objectMapper;

        ChatGPTBuilder() {
        }

        public ChatGPTBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public ChatGPTBuilder apiHost(String apiHost) {
            this.apiHost = apiHost;
            return this;
        }

        public ChatGPTBuilder client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public ChatGPTBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public ChatGPT build() {
            return new ChatGPT(this.apiKey, this.apiHost, this.client, this.objectMapper);
        }

        public String toString() {
            return "ChatGPT.ChatGPTBuilder(apiKey=" + this.apiKey + ", apiHost=" + this.apiHost + ", client=" + this.client + ", objectMapper=" + this.objectMapper + ")";
        }
    }
}

