/*
 * Decompiled with CFR 0.152.
 */
package com.lilittlecat.chatgpt.unoffical;

import cn.hutool.core.text.CharSequenceUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import net.jodah.expiringmap.ExpiringMap;

@Deprecated
public class UnofficialChatGPT {
    private String sessionToken;
    private String conversationId;
    private String parentMessageId;
    private String accessTokenString = "accessToken";
    private String conversationUrl = "https://chat.openai.com/backend-api/conversation";
    private String sessionUrl = "https://chat.openai.com/api/auth/session";
    private String cookieName = "__Secure-next-auth.session-token";
    private String userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.1 Safari/605.1.15";
    private final Map<String, String> accessTokenCache = ExpiringMap.builder().expiration(60L, TimeUnit.SECONDS).build();
    private final Gson gson = new Gson();

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public UnofficialChatGPT(String sessionToken, String conversationId, boolean useProxy, String proxy, Integer port, String username, String password) {
        this.sessionToken = sessionToken;
        this.conversationId = conversationId == null ? UUID.randomUUID().toString() : conversationId;
        this.parentMessageId = UUID.randomUUID().toString();
        if (useProxy) {
            Unirest.config().proxy(proxy, port.intValue(), username, password);
        }
        this.refreshAndGetAccessToken();
    }

    public UnofficialChatGPT(String sessionToken) {
        this(sessionToken, null, false, null, null, null, null);
    }

    public UnofficialChatGPT(String sessionToken, String conversationId) {
        this(sessionToken, conversationId, false, null, null, null, null);
    }

    public UnofficialChatGPT(String sessionToken, boolean useProxy, String proxy, Integer port) {
        this(sessionToken, null, useProxy, proxy, port, null, null);
    }

    public String ask(String input) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)this.conversationUrl).header("Authorization", "Bearer " + this.refreshAndGetAccessToken())).header("Accept", "text/event-stream")).header("Content-Type", "application/json")).header("User-Agent", this.userAgent)).header("X-Openai-Assistant-App-Id", "")).header("Connection", "close")).header("Accept-Language", "en-US,en;q=0.9")).header("Referer", "https://chat.openai.com/chat")).body(this.buildRequestBody(this.parentMessageId, this.conversationId, input)).asString();
        if (response.isSuccess()) {
            String[] strings = CharSequenceUtil.subBetweenAll((CharSequence)((CharSequence)response.getBody()), (CharSequence)"data: {", (CharSequence)"}\n");
            if (strings.length == 0) {
                throw new RuntimeException("Couldn't get correct response, please try again.");
            }
            String data = "{" + strings[strings.length - 1] + "}";
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(data, JsonObject.class);
            this.conversationId = jsonObject.get("conversation_id").toString();
            this.parentMessageId = jsonObject.getAsJsonObject("message").get("id").toString();
            return jsonObject.getAsJsonObject("message").getAsJsonObject("content").getAsJsonArray("parts").get(0).toString();
        }
        throw new RuntimeException("Looks like the server is either overloaded or down. Try again later.");
    }

    private String buildRequestBody(String parentMessageId, String conversationId, String input) {
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("action", "variant");
        requestBody.addProperty("parent_message_id", parentMessageId);
        requestBody.addProperty("model", "text-davinci-002-render");
        JsonArray jsonArray = new JsonArray();
        JsonObject message = new JsonObject();
        message.addProperty("id", conversationId);
        message.addProperty("role", "user");
        JsonObject content = new JsonObject();
        content.addProperty("content_type", "text");
        JsonArray parts = new JsonArray();
        parts.add(input);
        content.add("parts", (JsonElement)parts);
        message.add("content", (JsonElement)content);
        requestBody.add("messages", (JsonElement)jsonArray);
        return requestBody.toString();
    }

    private String refreshAndGetAccessToken() {
        if (this.accessTokenCache.isEmpty() || this.accessTokenCache.get(this.accessTokenString) == null) {
            if (this.sessionToken == null) {
                throw new RuntimeException("Please set session token!");
            }
            HttpResponse response = ((GetRequest)((GetRequest)Unirest.get((String)this.sessionUrl).cookie(this.cookieName, this.sessionToken)).header("User-Agent", this.userAgent)).asJson();
            if (response.isSuccess()) {
                String accessToken = (String)((JsonNode)response.getBody()).getObject().get(this.accessTokenString);
                this.accessTokenCache.put(this.accessTokenString, accessToken);
                return accessToken;
            }
            throw new RuntimeException("Session token may have expired");
        }
        return this.accessTokenCache.get(this.accessTokenString);
    }
}

