/*
 * Decompiled with CFR 0.152.
 */
package contatocore.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ContatoFileUtilities {
    public static void copyFile(File source, File destination) throws IOException {
        ContatoFileUtilities.copyFile(new FileInputStream(source), new FileOutputStream(destination));
    }

    public static void copyFile(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    public static String getCurrentDirectory() {
        String path = null;
        try {
            path = new File(".").getCanonicalPath();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return path;
    }

    public static void removeFile(String filePath) {
        File file = new File(filePath);
        file.delete();
    }

    public static Boolean hasWritePermission(String directory) {
        File file = new File(directory);
        if (file.canWrite()) {
            return true;
        }
        return false;
    }

    public static Boolean hasWritePermission(File directory) {
        if (directory.canWrite()) {
            return true;
        }
        return false;
    }

    public static Boolean hasReadPermission(String directory) {
        File file = new File(directory);
        if (file.canRead()) {
            return true;
        }
        return false;
    }

    public static Boolean hasReadPermission(File directory) {
        if (directory.canRead()) {
            return true;
        }
        return false;
    }

    public static Boolean hasReadWritePermission(File directory) {
        if (ContatoFileUtilities.hasReadPermission(directory).booleanValue() && ContatoFileUtilities.hasWritePermission(directory).booleanValue()) {
            return true;
        }
        return false;
    }

    public static Boolean hasReadWritePermission(String directory) {
        if (ContatoFileUtilities.hasReadPermission(directory).booleanValue() && ContatoFileUtilities.hasWritePermission(directory).booleanValue()) {
            return true;
        }
        return false;
    }
}

