/*
 * Decompiled with CFR 0.152.
 */
package contatocore.util;

import com.touchcomp.basementortools.tools.downloadweb.ToolDownloadWeb;
import com.touchcomp.basementortools.tools.file.ToolFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class CoreDownloadFile {
    private static InputStream downloadFileToServerInternal(String path, InternalProxy pr) throws MalformedURLException, IOException {
        File f = ToolFile.createTempFile((String)"temp", (String)".file");
        ToolDownloadWeb.InternalProxy i = null;
        if (pr != null) {
            i = pr.authenticate ? new ToolDownloadWeb.InternalProxy(pr.host, pr.porta, pr.usuario, pr.senha) : new ToolDownloadWeb.InternalProxy(pr.host, pr.porta);
        }
        byte[] data = ToolDownloadWeb.downloadFileToServerByteArray((File)f, (String)path, i);
        return new ByteArrayInputStream(data);
    }

    public static void downloadFileToServer(File fileTo, String path) throws MalformedURLException, IOException {
        InputStream in = CoreDownloadFile.downloadFileToServerInternal(path, null);
        CoreDownloadFile.writeToFile(in, fileTo);
    }

    public static void downloadFileToServer(File fileTo, String path, InternalProxy p) throws MalformedURLException, IOException {
        InputStream in = CoreDownloadFile.downloadFileToServerInternal(path, p);
        CoreDownloadFile.writeToFile(in, fileTo);
    }

    public static byte[] downloadFileToServerByteArray(String path) throws MalformedURLException, IOException {
        InputStream in = CoreDownloadFile.downloadFileToServerInternal(path, null);
        return CoreDownloadFile.writeByteArray(in);
    }

    public static byte[] downloadFileToServerByteArray(File fileTo, String path, InternalProxy p) throws MalformedURLException, IOException {
        InputStream in = CoreDownloadFile.downloadFileToServerInternal(path, p);
        return CoreDownloadFile.writeByteArray(in);
    }

    public static byte[] writeByteArray(InputStream in) throws MalformedURLException, IOException {
        int n;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((n = in.read(buf)) >= 0) {
            baos.write(buf, 0, n);
        }
        byte[] data = baos.toByteArray();
        return data;
    }

    private static void writeToFile(InputStream in, File fileTo) throws IOException {
        Files.copy(in, fileTo.toPath(), StandardCopyOption.REPLACE_EXISTING);
        in.close();
    }

    public static class InternalProxy {
        private String host;
        private int porta;
        private String usuario;
        private String senha;
        private boolean authenticate = false;

        public InternalProxy(String host, int porta) {
            this.host = host;
            this.porta = porta;
        }

        public InternalProxy(String host, int porta, String usuario, String senha) {
            this.host = host;
            this.porta = porta;
            this.usuario = usuario;
            this.senha = senha;
            this.authenticate = true;
        }
    }
}

