/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.dialog.ContatoDialogsHelper;
import contato.exception.ContatoInvalidValueException;
import contato.swing.ContatoFormattedTextField;
import contatocore.util.ContatoMaskFactory;
import java.awt.event.FocusEvent;
import java.math.BigInteger;
import java.text.NumberFormat;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class ContatoBigIntegerTextField
extends ContatoFormattedTextField {
    private boolean verifyValor = true;

    public ContatoBigIntegerTextField(int integerDigits) {
        this.setHorizontalAlignment(4);
        this.setFormatterFactory(ContatoMaskFactory.getIntegerFormatterDigits((int)integerDigits));
        this.setValue(0);
        this.setToolTipText("Campo inteiro: ");
    }

    public ContatoBigIntegerTextField() {
        this.setHorizontalAlignment(4);
        this.setFormatterFactory(ContatoBigIntegerTextField.getIntegerFormatterDigits(15));
        this.setToolTipText("Campo inteiro: ");
    }

    public static DefaultFormatterFactory getIntegerFormatterDigits(int integerDigits) {
        DefaultFormatterFactory aux = new DefaultFormatterFactory();
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setMaximumFractionDigits(0);
        format.setMinimumFractionDigits(0);
        format.setMaximumIntegerDigits(integerDigits);
        format.setMinimumIntegerDigits(0);
        format.setParseIntegerOnly(true);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(BigInteger.class);
        aux.setDefaultFormatter(formatter);
        aux.setDisplayFormatter(formatter);
        aux.setEditFormatter(formatter);
        aux.setNullFormatter(formatter);
        return aux;
    }

    public BigInteger getInteger() {
        return this.getText() != null ? new BigInteger(this.getText().replaceAll("\\.", "")) : null;
    }

    public void setInteger(BigInteger number) {
        if (number != null) {
            this.setValue(number);
        } else {
            this.setValue(new BigInteger("0"));
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (this.isVerifyValor() && this.getInteger() != null && this.getInteger().intValue() < 0) {
            ContatoDialogsHelper.showError("Valor inv\u00e1lido!");
            this.setInteger(new BigInteger("0"));
        }
    }

    @Override
    public void clear() {
        this.setValue(0);
    }

    @Override
    public void setValue(Object value) {
        BigInteger newValue = null;
        if (value != null) {
            try {
                if (!(value instanceof BigInteger)) {
                    throw new ContatoInvalidValueException("Invalid value: " + String.valueOf(value.getClass()) + " expected: BigInteger");
                }
                newValue = (BigInteger)value;
            }
            catch (ContatoInvalidValueException ex) {
                ex.printStackTrace();
            }
        }
        super.setValue(newValue);
    }

    public boolean isVerifyValor() {
        return this.verifyValor;
    }

    public void setVerifyValor(boolean verifyValor) {
        this.verifyValor = verifyValor;
    }
}

