/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.interfaces.ContatoClearComponent;
import contato.interfaces.ContatoComponent120x27Size;
import contato.interfaces.ContatoControllerComponent;
import contato.swing.ColorFocus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;

public class ContatoCheckBox
extends JCheckBox
implements ContatoControllerComponent,
ContatoClearComponent,
ColorFocus,
ItemListener,
ContatoComponent120x27Size {
    Color def = null;
    private List<ComponentController> components;
    private List<ComponentController> componentsEnable;

    public ContatoCheckBox() {
        this.setReadWrite();
        this.def = this.getBackground();
        this.initListeners();
    }

    public ContatoCheckBox(Action a) {
        super(a);
        this.setReadWrite();
        this.def = this.getBackground();
        this.initListeners();
    }

    public ContatoCheckBox(Icon icon) {
        super(icon);
        this.setReadWrite();
        this.def = this.getBackground();
        this.initListeners();
    }

    public ContatoCheckBox(String text) {
        super(text);
        this.setReadWrite();
        this.def = this.getBackground();
        this.initListeners();
    }

    public ContatoCheckBox(Icon icon, boolean selected) {
        super(icon, selected);
        this.setReadWrite();
        this.def = this.getBackground();
        this.initListeners();
    }

    public ContatoCheckBox(String text, Icon icon) {
        super(text, icon);
        this.setReadWrite();
        this.def = this.getBackground();
        this.initListeners();
    }

    public ContatoCheckBox(String text, boolean selected) {
        super(text, selected);
        this.setReadWrite();
        this.def = this.getBackground();
        this.initListeners();
    }

    public ContatoCheckBox(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.setReadWrite();
        this.def = this.getBackground();
        this.initListeners();
    }

    public void addComponentToControlVisibility(Component c) {
        if (this.components == null) {
            this.components = new ArrayList<ComponentController>();
        }
        this.components.add(new ComponentController(this, c));
        this.updateVisibility();
    }

    public void addComponentToControlEnable(Component c) {
        if (this.componentsEnable == null) {
            this.componentsEnable = new ArrayList<ComponentController>();
        }
        this.componentsEnable.add(new ComponentController(this, c));
        this.updateEnable();
    }

    public void addComponentToControlVisibility(Component c, Boolean clear) {
        if (this.components == null) {
            this.components = new ArrayList<ComponentController>();
        }
        this.components.add(new ComponentController(this, c, clear));
        this.updateVisibility();
    }

    public void addComponentToControlEnable(Component c, Boolean clear) {
        if (this.componentsEnable == null) {
            this.componentsEnable = new ArrayList<ComponentController>();
        }
        this.componentsEnable.add(new ComponentController(this, c, clear));
        this.updateEnable();
    }

    public void updateVisibility() {
        Boolean state = this.isSelected();
        if (this.components != null) {
            for (ComponentController c : this.components) {
                if (c.getClear().booleanValue() && c.getComponent() instanceof ContatoClearComponent) {
                    ((ContatoClearComponent)((Object)c.getComponent())).clear();
                }
                c.getComponent().setVisible(state);
            }
        }
    }

    public void updateEnable() {
        Boolean state = this.isSelected();
        if (this.componentsEnable != null) {
            for (ComponentController c : this.componentsEnable) {
                if (c.getClear().booleanValue() && c.getComponent() instanceof ContatoClearComponent) {
                    ((ContatoClearComponent)((Object)c.getComponent())).clear();
                }
                this.updateEnable(c.getComponent(), state);
            }
        }
    }

    @Override
    public void setReadOnly() {
        this.putClientProperty("ACCESS", 0);
    }

    @Override
    public void setReadWrite() {
        this.putClientProperty("ACCESS", 1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        this.putClientProperty("ACCESS", 2);
    }

    @Override
    public void clear() {
        this.setSelected(false);
    }

    @Override
    public String getToolTipText() {
        Object text = null;
        if (super.getToolTipText() == null) {
            return this.getText();
        }
        text = "";
        text = (String)text + "<html><b>" + super.getToolTipText();
        text = (String)text + "</b>" + (String)(this.getText() != null && this.getText().trim().length() > 0 ? "<br>" + this.getText() : "");
        text = (String)text + "</html>";
        return text;
    }

    @Override
    public void setDontController() {
        this.putClientProperty("ACCESS", -10);
    }

    public Short isSelectedFlag() {
        return (short)(this.isSelected() ? 1 : 0);
    }

    public void setSelectedFlag(Short flag) {
        this.setSelected(flag != null && flag == 1);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            this.changeCollorFocusGained();
        } else if (e.getID() == 1005) {
            this.changeCollorFocusLost();
        }
    }

    @Override
    public void changeCollorFocusGained() {
        this.setBackground(COLOR_FOCUS_GAINED);
    }

    @Override
    public void changeCollorFocusLost() {
        this.setBackground(this.def);
    }

    private void initListeners() {
        this.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateVisibility();
        this.updateEnable();
    }

    private void updateEnable(Component c, boolean state) {
        c.setEnabled(state);
        if (c instanceof Container) {
            for (Component comp : ((Container)c).getComponents()) {
                this.updateEnable(comp, state);
            }
        }
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        Dimension d = this.checkMinimunDimension(preferredSize);
        super.setPreferredSize(d);
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        Dimension d = this.checkMinimunDimension(minimumSize);
        super.setMinimumSize(d);
    }

    private Dimension checkMinimunDimension(Dimension d) {
        int height = d.height;
        int width = d.width;
        if (height < MIN_HEIGHT) {
            height = MIN_HEIGHT;
        }
        if (width < MIN_WIDHT) {
            width = MIN_WIDHT;
        }
        return new Dimension(width, height);
    }

    private class ComponentController {
        private Component component;
        private Boolean clear;

        ComponentController(ContatoCheckBox contatoCheckBox) {
            this.clear = false;
        }

        public ComponentController(ContatoCheckBox contatoCheckBox, Component c) {
            this.clear = false;
            this.component = c;
        }

        public ComponentController(ContatoCheckBox contatoCheckBox, Component c, Boolean clear) {
            this.clear = clear;
            this.component = c;
        }

        public Component getComponent() {
            return this.component;
        }

        public void setComponent(Component component) {
            this.component = component;
        }

        public Boolean getClear() {
            return this.clear;
        }

        public void setClear(Boolean clear) {
            this.clear = clear;
        }
    }
}

