/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import com.github.lgooddatepicker.components.DatePicker;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.optionalusertools.DateHighlightPolicy;
import com.github.lgooddatepicker.zinternaltools.HighlightInformation;
import com.touchcomp.basementortools.tools.date.TDate;
import contato.interfaces.ContatoClearComponent;
import contato.interfaces.ContatoComponent30x30Size;
import contato.interfaces.ContatoControllerComponent;
import contato.swing.ColorFocus;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ContatoDateTextField
extends DatePicker
implements ContatoControllerComponent,
ContatoClearComponent,
ColorFocus,
ContatoComponent30x30Size {
    private int currentState;

    public ContatoDateTextField() {
        this.setDateSettings();
        this.setFocusEvent();
        this.setKeyEvent();
        this.setReadWrite();
        this.setActionListener();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ContatoDateTextField.this.transferFocus();
                }
            }
        });
    }

    private void setActionListener() {
        this.getComponentToggleCalendarButton().addActionListener(e -> this.getComponentDateTextField().requestFocus());
    }

    private void setDateSettings() {
        DatePickerSettings dateSettings = new DatePickerSettings();
        dateSettings.setAllowKeyboardEditing(true);
        dateSettings.setAllowEmptyDates(true);
        dateSettings.setHighlightPolicy((DateHighlightPolicy)new SampleHighlightPolicy());
        dateSettings.setFormatForDatesCommonEra("dd/MM/yyyy");
        dateSettings.setColor(DatePickerSettings.DateArea.TextFieldBackgroundDisabled, Color.white);
        this.setSettings(dateSettings);
    }

    private void setKeyEvent() {
        this.getComponentDateTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ContatoDateTextField.this.formatDateDinamically(ContatoDateTextField.this.getComponentDateTextField(), e);
            }
        });
    }

    private void setFocusEvent() {
        FocusListener[] focus;
        FocusAdapter fa = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ContatoDateTextField.this.getComponentDateTextField().select(0, ContatoDateTextField.this.getComponentDateTextField().getText().length());
            }

            @Override
            public void focusLost(FocusEvent e) {
                ContatoDateTextField.this.checkCompleteDate(ContatoDateTextField.this.getComponentDateTextField());
            }
        };
        for (FocusListener focu : focus = this.getComponentDateTextField().getFocusListeners()) {
            this.getComponentDateTextField().removeFocusListener(focu);
        }
        this.getComponentDateTextField().addFocusListener(fa);
        for (FocusListener focu : focus) {
            this.getComponentDateTextField().addFocusListener(focu);
        }
    }

    private void checkCompleteDate(JTextField componentDateTextField) {
        String text = componentDateTextField.getText();
        if (text == null || text.length() == 0) {
            return;
        }
        char[] dataValor = text.toCharArray();
        char[] dataCorrente = TDate.dateToStr((Date)new Date()).toCharArray();
        char[] arrayDate = new char[dataCorrente.length];
        for (int i = 0; i < arrayDate.length; ++i) {
            int ch1 = 32;
            if (i < dataValor.length) {
                ch1 = dataValor[i];
            }
            int ch2 = dataCorrente[i];
            arrayDate[i] = ch1 == 32 ? ch2 : ch1;
        }
        this.getComponentDateTextField().setText(new String(arrayDate));
    }

    private void formatDateDinamically(JTextField componentDateTextField, KeyEvent e) {
        if (e.getKeyCode() == 8 || e.getKeyCode() == 127) {
            return;
        }
        Object text = componentDateTextField.getText();
        if (text == null) {
            return;
        }
        if (((String)text).length() == 2) {
            text = (String)text + "/";
        }
        if (((String)text).length() == 5) {
            text = (String)text + "/";
        }
        if (((String)text).length() == 8 && !((String)text).contains("/")) {
            text = (String)text + new SimpleDateFormat("dd/MM/yyyy").format(text);
        }
        componentDateTextField.setText((String)text);
    }

    private void putClientProperty(int type) {
        this.putClientProperty("ACCESS", type);
    }

    public static void main(String[] args) {
        JPanel j = new JPanel();
        j.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        ContatoDateTextField cd = new ContatoDateTextField();
        j.add((Component)((Object)cd), gb);
        gb.gridx = 1;
        gb.gridy = 0;
        ContatoDateTextField cd2 = new ContatoDateTextField();
        j.add((Component)((Object)cd2), gb);
        JDialog d = new JDialog();
        d.setContentPane(j);
        d.setSize(300, 200);
        d.setLocationRelativeTo(null);
        d.setVisible(true);
    }

    @Override
    public void setReadOnly() {
        this.putClientProperty(0);
    }

    @Override
    public void setReadWrite() {
        this.putClientProperty(1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        this.putClientProperty(2);
    }

    @Override
    public void setDontController() {
        this.putClientProperty(-10);
    }

    @Override
    public void changeCollorFocusGained() {
    }

    @Override
    public void changeCollorFocusLost() {
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.getComponentDateTextField().addFocusListener(l);
    }

    public void setEditable(boolean editable) {
        this.getComponentDateTextField().setEditable(editable);
        this.getComponentToggleCalendarButton().setEnabled(editable);
    }

    public void setCurrentDate(Date value) {
        super.setDate(TDate.formatarLocalDate((Date)value));
    }

    public Date getCurrentDate() {
        return TDate.asDate((LocalDate)super.getDate());
    }

    private static class SampleHighlightPolicy
    implements DateHighlightPolicy {
        private SampleHighlightPolicy() {
        }

        public HighlightInformation getHighlightInformationOrNull(LocalDate date) {
            if (date.getDayOfWeek() == DayOfWeek.SATURDAY || date.getDayOfWeek() == DayOfWeek.SUNDAY) {
                return new HighlightInformation(Color.orange, Color.yellow, "Final de semana");
            }
            return null;
        }
    }
}

