/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import com.touchcomp.basementormedia.ImageProviderFact;
import contato.dialog.ContatoDialogsHelper;
import contato.interfaces.ContatoClearComponent;
import contato.interfaces.ContatoControllerComponent;
import contato.swing.ContatoButton;
import contato.swing.ContatoCheckBox;
import contato.swing.ContatoLabel;
import contato.swing.ContatoTextField;
import contato.util.contatofilechooser.ContatoFileChooserUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ContatoFileChooserFrame
extends JPanel
implements ContatoControllerComponent,
ContatoClearComponent {
    private byte[] bytesArquivo;
    private ContatoButton btnCarregar;
    private ContatoButton btnLimpar;
    private ContatoCheckBox chcArquivoCarregado;
    private ContatoLabel contatoLabel1;
    private ContatoTextField txtCaminhoArquivo;

    public ContatoFileChooserFrame() {
        this.initComponents();
        this.txtCaminhoArquivo.setReadOnly();
        this.txtCaminhoArquivo.setEnabled(false);
        this.chcArquivoCarregado.setReadOnly();
    }

    private void initComponents() {
        this.btnLimpar = new ContatoButton();
        this.btnCarregar = new ContatoButton();
        this.contatoLabel1 = new ContatoLabel();
        this.txtCaminhoArquivo = new ContatoTextField();
        this.chcArquivoCarregado = new ContatoCheckBox();
        this.setLayout(new GridBagLayout());
        this.btnLimpar.setIcon(new ImageIcon(ImageProviderFact.get().getImageDelete()));
        this.btnLimpar.setText("Limpar");
        this.btnLimpar.setMinimumSize(new Dimension(110, 20));
        this.btnLimpar.setPreferredSize(new Dimension(110, 20));
        this.btnLimpar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContatoFileChooserFrame.this.btnLimparActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.btnLimpar, gridBagConstraints);
        this.btnCarregar.setIcon(new ImageIcon(ImageProviderFact.get().getImageFind()));
        this.btnCarregar.setText("Carregar");
        this.btnCarregar.setMinimumSize(new Dimension(110, 20));
        this.btnCarregar.setPreferredSize(new Dimension(110, 20));
        this.btnCarregar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContatoFileChooserFrame.this.btnCarregarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        this.add((Component)this.btnCarregar, gridBagConstraints);
        this.contatoLabel1.setText("Caminho do Arquivo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.contatoLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.txtCaminhoArquivo, gridBagConstraints);
        this.chcArquivoCarregado.setText("Arquivo Carregado");
        this.chcArquivoCarregado.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.chcArquivoCarregado, gridBagConstraints);
    }

    private void btnLimparActionPerformed(ActionEvent evt) {
        this.setPathFile(null);
        this.txtCaminhoArquivo.clear();
        this.setBytesArquivo(this.bytesArquivo);
    }

    private void btnCarregarActionPerformed(ActionEvent evt) {
        try {
            File f = ContatoFileChooserUtilities.getFileToLoad();
            if (f.isDirectory()) {
                ContatoDialogsHelper.showError("Arquivo n\u00e3o pode ser diret\u00f3rio.");
            }
            if (f != null) {
                this.txtCaminhoArquivo.setText(f.getAbsolutePath());
                this.setBytesArquivo(ContatoFileChooserUtilities.getBytesOfFile(f.getAbsolutePath()));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ContatoFileChooserFrame.class.getName()).log(Level.SEVERE, null, ex);
            ContatoDialogsHelper.showError("Erro ao acessar o arquivo.");
        }
    }

    @Override
    public void setReadOnly() {
        this.putClientProperty("ACCESS", 0);
    }

    @Override
    public void setReadWrite() {
        this.putClientProperty("ACCESS", 1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        this.putClientProperty("ACCESS", 2);
    }

    @Override
    public void setDontController() {
        this.putClientProperty("ACCESS", -10);
    }

    @Override
    public void clear() {
        this.setPathFile(null);
        this.txtCaminhoArquivo.clear();
    }

    public String getPathFile() {
        return this.txtCaminhoArquivo.getText();
    }

    public void setPathFile(String dados) {
        this.txtCaminhoArquivo.setText(dados);
    }

    public void currentObjectToScreen() {
    }

    public byte[] getBytesArquivo() {
        return this.bytesArquivo;
    }

    public void setBytesArquivo(byte[] bytesArquivo) {
        this.bytesArquivo = bytesArquivo;
        this.showCheck();
    }

    private void showCheck() {
        if (this.getBytesArquivo() == null) {
            this.chcArquivoCarregado.setSelected(false);
        } else {
            this.chcArquivoCarregado.setSelected(true);
        }
    }
}

