/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.dialog.ContatoDialogsHelper;
import contato.exception.ContatoInvalidValueException;
import contato.swing.ContatoCepTextField;
import contato.swing.ContatoFormattedTextField;
import contatocore.util.ContatoFormatterUtil;
import contatocore.util.ContatoMaskFactory;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContatoFloatTextField
extends ContatoFormattedTextField {
    int decimalSize;
    private boolean verifyValor = true;

    public ContatoFloatTextField() {
        this.setFormatterFactory(ContatoMaskFactory.getDefaultFloatFormatter());
        this.setValue(Float.valueOf(0.0f));
        this.setHorizontalAlignment(4);
        this.decimalSize = 2;
    }

    public ContatoFloatTextField(int decimalSize) {
        this.setFormatterFactory(ContatoFormatterUtil.getFloatFormatterDecimalSize((int)decimalSize));
        this.setValue(Float.valueOf(0.0f));
        this.decimalSize = decimalSize;
        this.setHorizontalAlignment(4);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            super.processFocusEvent(e);
            this.selectAll();
        } else if (e.getID() == 1005) {
            String text = this.getText();
            super.processFocusEvent(e);
            try {
                this.commitEdit();
                if (this.isVerifyValor() && this.getFloat().floatValue() < 0.0f) {
                    ContatoDialogsHelper.showError("Valor inv\u00e1lido!");
                    this.setFloat(Float.valueOf(0.0f));
                }
            }
            catch (ParseException ex) {
                this.setValue(Float.valueOf(0.0f));
            }
        }
    }

    public boolean isVerifyValor() {
        return this.verifyValor;
    }

    public void setVerifyValor(boolean verifyValor) {
        this.verifyValor = verifyValor;
    }

    public Float getFloat() {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCepTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (Float)this.getValue();
    }

    @Override
    public String getText() {
        return super.getText();
    }

    public void setFloat(Float value) {
        value = Float.valueOf(value == null ? 0.0f : value.floatValue());
        this.setValue(Float.valueOf(value.toString()));
    }

    @Override
    public void clear() {
        this.setFloat(Float.valueOf(0.0f));
    }

    @Override
    public void setValue(Object value) {
        Float newValue = null;
        if (value != null) {
            try {
                if (!(value instanceof Float)) {
                    throw new ContatoInvalidValueException("Invalid value: " + String.valueOf(value.getClass()) + " expected: java.util.Float");
                }
                newValue = (Float)value;
            }
            catch (ContatoInvalidValueException ex) {
                ex.printStackTrace();
            }
        }
        super.setValue(newValue);
    }
}

