/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.exception.ContatoInscricaoEstadualException;
import contato.swing.ContatoCPFTextField;
import contato.swing.ContatoCepTextField;
import contato.swing.ContatoFormattedTextField;
import contatocore.util.ContatoIsValid;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContatoInscricaoEstadualTextField
extends ContatoFormattedTextField {
    private String uf;

    public ContatoInscricaoEstadualTextField() {
        this.setHorizontalAlignment(0);
    }

    public boolean validar() throws ContatoInscricaoEstadualException {
        Object value = this.getValue();
        if (value != null) {
            if (!((String)value).toUpperCase().equals("ISENTO")) {
                return ContatoIsValid.testUfInscricaoEstadual((String)((String)value), (String)this.getUf());
            }
            return true;
        }
        return false;
    }

    public String getValidValue() throws ContatoInscricaoEstadualException {
        try {
            super.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCPFTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        String value = this.getText();
        if (value != null && !value.toUpperCase().equals("ISENTO") && ContatoIsValid.testUfInscricaoEstadual((String)value, (String)this.getUf())) {
            throw new ContatoInscricaoEstadualException();
        }
        return value;
    }

    public String getUf() {
        return this.uf;
    }

    public void setUf(String uf) {
        this.uf = uf;
    }

    @Override
    public String getString() {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCepTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (String)this.getValue();
    }
}

