/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.dialog.ContatoDialogsHelper;
import contato.exception.ContatoInvalidValueException;
import contato.swing.ContatoFormattedTextField;
import contatocore.util.ContatoMaskFactory;
import java.awt.event.FocusEvent;
import java.text.ParseException;

public class ContatoLongTextField
extends ContatoFormattedTextField {
    private boolean verifyValor;

    public ContatoLongTextField() {
        this.setFormatterFactory(ContatoMaskFactory.getDefaultLongFormatter());
        this.setValue(0L);
        this.setHorizontalAlignment(4);
    }

    public ContatoLongTextField(int integerDigits) {
        this.setFormatterFactory(ContatoMaskFactory.getDefaultLongFormatter((int)integerDigits));
        this.setValue(0L);
        this.setHorizontalAlignment(4);
    }

    public Long getLong() {
        try {
            this.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return (Long)this.getValue();
    }

    public void setLong(Long number) {
        this.setValue(number);
    }

    @Override
    public void setValue(Object value) {
        Long newValue = null;
        if (value != null) {
            try {
                if (!(value instanceof Long)) {
                    throw new ContatoInvalidValueException("Invalid value: " + String.valueOf(value.getClass()) + " expected: java.util.Long");
                }
                newValue = (Long)value;
            }
            catch (ContatoInvalidValueException ex) {
                ex.printStackTrace();
            }
        }
        super.setValue(newValue);
    }

    @Override
    public void clear() {
        this.setValue(0L);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (this.isVerifyValor() && this.getLong() < 0L) {
            ContatoDialogsHelper.showError("Valor inv\u00e1lido!");
            this.setLong(0L);
        }
    }

    public boolean isVerifyValor() {
        return this.verifyValor;
    }

    public void setVerifyValor(boolean verifyValor) {
        this.verifyValor = verifyValor;
    }
}

