/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import com.touchcomp.basementorai.InputModelFactory;
import com.touchcomp.basementorai.model.InputAIModel;
import com.touchcomp.basementorai.model.OutputAIModel;
import com.touchcomp.basementorai.openai.AIOpenaAIBuilder;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import contato.dialog.ContatoDialogsHelper;
import contato.swing.ContatoDialog;
import contato.util.ContatoTextUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class ContatoPanelAI
extends JPanel {
    private List<OutputAIModel> respostas = new LinkedList<OutputAIModel>();
    private OutputAIModel respostaUsar = null;
    private JTextComponent txtComponente;
    private Date lastUse;
    private Listener listener;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblStatus;
    private JList<InputAIModel> listOpcoes;
    private JTextArea txtDados;
    private JTextArea txtResposta;

    public ContatoPanelAI() {
        this.initComponents();
        this.initFields();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.txtResposta = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.txtDados = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.listOpcoes = new JList();
        this.lblStatus = new JLabel();
        this.setPreferredSize(new Dimension(855, 491));
        this.setLayout(new GridBagLayout());
        this.txtResposta.setEditable(false);
        this.txtResposta.setBackground(new Color(255, 255, 255));
        this.txtResposta.setColumns(20);
        this.txtResposta.setLineWrap(true);
        this.txtResposta.setRows(5);
        this.txtResposta.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.txtResposta);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(400, 70));
        this.jPanel1.setLayout(new GridBagLayout());
        this.txtDados.setColumns(20);
        this.txtDados.setRows(5);
        this.jScrollPane2.setViewportView(this.txtDados);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.jPanel1.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jScrollPane3.setMinimumSize(new Dimension(150, 19));
        this.listOpcoes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ContatoPanelAI.this.listOpcoesValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.listOpcoes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel1.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.lblStatus.setText("Me pergunte algo!");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.lblStatus, gridBagConstraints);
    }

    private void listOpcoesValueChanged(ListSelectionEvent evt) {
        this.selectItem();
    }

    private void initFields() {
        JPopupMenu popUpMenu = ContatoTextUtilities.initBasicPopupTextMenu(this.txtResposta, false);
        JMenuItem item = new JMenuItem();
        item.setText("Limpar");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContatoPanelAI.this.txtResposta.setText("");
            }
        });
        popUpMenu.add(item);
        item = new JMenuItem();
        item.setText("Usar Resposta");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContatoPanelAI.this.respostaUsar = (OutputAIModel)ContatoDialogsHelper.showInputDialog("Selecione uma resposta", "", ContatoPanelAI.this.respostas.toArray());
                if (ContatoPanelAI.this.txtComponente != null) {
                    ContatoPanelAI.this.txtComponente.setText(ContatoPanelAI.this.respostaUsar.getResponse());
                }
            }
        });
        popUpMenu.add(item);
        List aux = new InputModelFactory().getInputs();
        DefaultListModel model = new DefaultListModel();
        for (Object object : aux) {
            model.addElement(object);
        }
        this.listOpcoes.setModel(model);
        this.txtDados.requestFocus();
    }

    public static OutputAIModel openDialog(JTextComponent jTextComponent) {
        ContatoDialog cd = new ContatoDialog();
        cd.setModal(false);
        cd.setLocationRelativeTo(null);
        final ContatoPanelAI a = new ContatoPanelAI();
        a.txtDados.setText(jTextComponent.getText());
        a.txtComponente = jTextComponent;
        cd.setContentPane(a);
        cd.setSize(a.getPreferredSize());
        cd.setPreferredSize(a.getPreferredSize());
        cd.setTitle("Assistente de Inteligencia Artificial");
        cd.setVisible(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                a.txtDados.requestFocus();
            }
        });
        return a.respostaUsar;
    }

    private void selectItem() {
        int sel = this.listOpcoes.getSelectedIndex();
        if (sel < 0) {
            return;
        }
        final InputAIModel aux = this.listOpcoes.getSelectedValue();
        this.listOpcoes.clearSelection();
        if (this.lastUse != null && ToolDate.difBetweenDatesInSeconds((Date)this.lastUse, (Date)new Date()) < 3L) {
            return;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                new ThreadInternal(aux).start();
            }
        };
        t.start();
        this.lastUse = new Date();
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public static interface Listener {
        public void onResponse(OutputAIModel var1);
    }

    public class ThreadInternal
    extends Thread {
        InputAIModel aux;

        public ThreadInternal(InputAIModel aux) {
            this.aux = aux;
        }

        @Override
        public void run() {
            try {
                ContatoPanelAI.this.lblStatus.setText("Aguarde...");
                OutputAIModel resp = AIOpenaAIBuilder.get().askInput(this.aux.getId(), ContatoPanelAI.this.txtDados.getText());
                ContatoPanelAI.this.txtResposta.append(resp.getResQuestion());
                ContatoPanelAI.this.txtResposta.append("\n");
                ContatoPanelAI.this.txtResposta.append(resp.getResponse());
                ContatoPanelAI.this.respostas.add(resp);
                ContatoPanelAI.this.txtResposta.append("\n\n");
                ContatoPanelAI.this.lblStatus.setText("Me pergunte algo!");
                if (ContatoPanelAI.this.listener != null) {
                    ContatoPanelAI.this.listener.onResponse(resp);
                }
            }
            catch (ExceptionInvalidState ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                ContatoDialogsHelper.showError(ex.getFormattedMessage());
            }
        }
    }
}

