/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.dialog.ContatoDialogsHelper;
import contato.interfaces.ContatoClearComponent;
import contato.swing.ContatoDateTimeTextField;
import contato.swing.ContatoLabel;
import contatocore.util.ContatoDateUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import java.util.Locale;
import javax.swing.JPanel;

public class ContatoRangeDateTimeField
extends JPanel
implements FocusListener,
ContatoClearComponent {
    private Object currentObjectInicial;
    private Object currentObjectFinal;
    public static final String DD_MM_YYYY_CLASSIC = "dd/MM/yyyy";
    public static final Locale PT_BR_LOCALE = new Locale("pt", "BR", "ISO8859-1");
    private ContatoLabel contatoLabel1;
    private ContatoLabel contatoLabel2;
    private ContatoDateTimeTextField txtDateFinal;
    private ContatoDateTimeTextField txtDateInicial;

    public ContatoRangeDateTimeField() {
        this.initComponents();
        this.initEvent();
        this.initDate();
    }

    private void initComponents() {
        this.contatoLabel1 = new ContatoLabel();
        this.contatoLabel2 = new ContatoLabel();
        this.txtDateInicial = new ContatoDateTimeTextField();
        this.txtDateFinal = new ContatoDateTimeTextField();
        this.setLayout(new GridBagLayout());
        this.contatoLabel1.setText("Data Inicial");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        this.add((Component)this.contatoLabel1, gridBagConstraints);
        this.contatoLabel2.setText("Data Final");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.contatoLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 19;
        this.add((Component)((Object)this.txtDateInicial), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)((Object)this.txtDateFinal), gridBagConstraints);
    }

    @Override
    public void focusGained(FocusEvent fe) {
    }

    @Override
    public void focusLost(FocusEvent fe) {
        if (fe.getSource().equals(this.txtDateInicial)) {
            this.validarData();
        } else if (fe.getSource().equals(this.txtDateFinal)) {
            this.validarData();
        }
    }

    private void validarData() {
        if (this.txtDateFinal.getCurrentDate() != null && this.txtDateInicial.getCurrentDate() != null) {
            if (this.txtDateFinal.getCurrentDate().before(this.txtDateInicial.getCurrentDate())) {
                ContatoDialogsHelper.showError("Data Final n\u00e3o pode ser menor que a Data Inicial");
                this.txtDateFinal.requestFocus();
            } else {
                this.setCurrentObjectInicial(this.txtDateInicial.getCurrentDate());
                this.setCurrentObjectFinal(this.txtDateFinal.getCurrentDate());
            }
        }
    }

    public Date getDataInicial() {
        return this.txtDateInicial.getCurrentDate();
    }

    public void setCurrentObjectInicial(Date dataInicial) {
        this.txtDateInicial.setCurrentDate(dataInicial);
    }

    public Object getDataFinal() {
        return this.txtDateFinal.getCurrentDate();
    }

    public void setCurrentObjectFinal(Date dataFinal) {
        this.txtDateFinal.setCurrentDate(dataFinal);
    }

    private void initEvent() {
        this.txtDateFinal.addFocusListener(this);
        this.txtDateInicial.addFocusListener(this);
    }

    private void initDate() {
        this.setCurrentObjectInicial(this.txtDateInicial.getCurrentDate());
        this.setCurrentObjectFinal(this.txtDateFinal.getCurrentDate());
    }

    public static Date strToDate(String strDate, String mask) {
        return ContatoDateUtil.strToDate((String)strDate, (String)mask);
    }

    @Override
    public void clear() {
        this.txtDateFinal.clear();
        this.txtDateInicial.clear();
    }
}

