/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.dialog.ContatoDialogsHelper;
import contato.exception.ContatoInvalidValueException;
import contato.swing.ContatoFormattedTextField;
import contatocore.util.ContatoMaskFactory;
import java.awt.event.FocusEvent;
import java.text.ParseException;

public class ContatoShortTextField
extends ContatoFormattedTextField {
    private boolean verifyValor = true;

    public ContatoShortTextField(int integerDigits) {
        this.setHorizontalAlignment(4);
        this.setFormatterFactory(ContatoMaskFactory.getShortFormatterDigits((int)integerDigits));
        this.setValue(0);
        this.setToolTipText("Campo inteiro: ");
    }

    public ContatoShortTextField() {
        this.setHorizontalAlignment(4);
        this.setFormatterFactory(ContatoMaskFactory.getShortFormatterDigits((int)9));
        this.setToolTipText("Campo inteiro: ");
    }

    public Short getShort() {
        try {
            this.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return (Short)this.getValue();
    }

    public void setShort(Short number) {
        this.setValue(number);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (this.isVerifyValor() && this.getShort() != null && this.getShort() < 0) {
            ContatoDialogsHelper.showError("Valor inv\u00e1lido!");
            this.setShort((short)0);
        }
    }

    @Override
    public void clear() {
        this.setValue((short)0);
    }

    @Override
    public void setValue(Object value) {
        Short newValue = null;
        if (value != null) {
            try {
                if (!(value instanceof Short)) {
                    throw new ContatoInvalidValueException("Invalid value: " + String.valueOf(value.getClass()) + " expected: java.util.Short");
                }
                newValue = (Short)value;
            }
            catch (ContatoInvalidValueException ex) {
                ex.printStackTrace();
            }
        }
        super.setValue(newValue);
    }

    public boolean isVerifyValor() {
        return this.verifyValor;
    }

    public void setVerifyValor(boolean verifyValor) {
        this.verifyValor = verifyValor;
    }
}

