/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JPanel;

public class ContatoStarRating
extends JPanel {
    private List<StarListener> listeners = new ArrayList<StarListener>();
    private int stars;
    private float rating;
    private int selection;
    private int rollover;
    private boolean done;
    private static final Image STAR_BACKGROUND_IMAGE = ContatoStarRating.compressedByteArrayToImage(new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0, -99, -110, -69, 75, -126, 81, 24, -121, -113, -110, 77, 13, 46, -75, 54, 4, 65, 84, -48, 86, 17, -76, 52, 53, 52, -44, -48, 18, -124, -11, 23, 72, -96, -43, 90, 107, 68, 75, -34, 9, 17, 19, -46, -8, -16, -53, 72, -3, 68, 16, 19, 69, 4, 69, -63, -5, 109, 15, -94, -74, -68, -27, -23, 119, 68, -63, 74, -65, -80, -31, 89, -50, 121, 31, -34, -9, -68, -25, 119, -1, 74, 100, -57, 99, 68, 78, -28, -86, 35, 34, -35, -37, -36, 18, 20, -77, -22, -105, -121, 91, 41, 33, 39, 74, 66, 36, -124, 104, 52, -102, 97, -84, -128, 105, -111, -5, -65, -32, -63, -23, 63, -35, 117, 64, 121, -98, 127, 119, 56, 28, -109, 35, -70, 18, 16, 53, -103, 76, -51, 92, 46, -41, -118, -57, -29, 23, 35, -6, -5, -84, -73, 32, 8, -76, 90, -83, -46, 74, -91, 66, 57, -114, 91, 28, 82, 43, 7, 75, 93, -25, 74, -85, -43, 62, 27, -115, 70, 106, -73, -37, -21, -59, 98, -79, -29, -106, -53, -27, 70, 42, -107, -86, 89, -83, -42, 39, -125, -63, 112, -122, -102, 29, -44, -50, -127, 9, -96, 0, 109, -44, -45, 80, 40, -12, -111, 76, 38, -103, -41, -18, -11, -123, 75, 75, -91, 18, -93, 93, 40, 20, 106, -23, 116, -70, 17, -115, 70, -87, -49, -25, 123, -77, 88, 44, -53, -35, -73, -22, 109, 54, 27, 13, -121, -61, -99, 121, 127, -70, 108, 14, 6, 124, -102, -49, -25, 41, 118, 66, 61, 30, -49, -95, -39, 108, -18, 127, -121, 6, 115, -79, 25, 126, -71, -52, -21, 119, -35, 110, -9, -63, -128, 61, 72, -127, 77, -81, -41, 127, -78, -7, -6, 93, -26, -11, 92, -65, -33, -81, 20, -39, -5, 54, -37, 59, 106, 126, -51, -53, -56, 102, -77, 45, -105, -53, 53, 37, -30, -85, 64, 51, 18, -119, 124, 115, -31, 117, -56, 100, 50, 45, -81, -41, -69, 38, -30, 95, 99, -2, 102, 34, -111, 96, 110, 61, 22, -117, -79, 127, 103, 25, -84, 33, 67, 20, -69, 111, 5, 2, -127, 93, 17, -1, 17, -103, -93, -63, 96, -80, -119, -52, -34, -24, 116, -70, 5, -100, 109, 0, 1, -1, 78, -99, 78, 39, -53, -108, 26, 61, 6, -71, -29, -128, 3, -105, 96, 102, -64, -3, 42, -72, 3, -25, 67, 122, -53, -70, 57, -108, -118, -52, -57, -78, 58, -33, -51, 76, -17, -20, 11, -73, 63, -72, 38, 33, 4, 0, 0});
    private static final Image STAR_FOREGROUND_IMAGE = ContatoStarRating.compressedByteArrayToImage(new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0, -99, -110, -55, 75, 91, 81, 20, -121, -49, -67, 111, -56, 123, -23, 91, 100, -93, -37, 46, 4, 65, -76, -48, 93, 45, 5, 55, -82, 92, -72, -48, 69, 55, -126, 88, -1, 2, 17, -100, -80, -74, -59, 108, -70, 16, 17, 106, -30, 4, 98, 41, 42, 106, 84, 34, 14, 16, -60, -87, 1, 7, 74, -85, 54, -119, 113, 90, 72, 107, -115, 67, -80, 59, 19, 19, 115, 60, 47, 68, 99, 49, 121, 98, 23, -33, -26, -34, -13, -15, -69, -25, -36, -29, 8, -126, 84, 39, -126, 5, 44, 53, -43, -64, -53, -118, -118, 93, 21, -39, -75, 39, 19, -3, 28, -96, -66, 10, -128, 1, 124, 106, 76, 75, 62, -15, -44, -32, -2, 33, -100, 68, -61, 127, -70, 5, 4, 78, -10, 74, 127, 71, -19, 98, -58, 35, 93, 70, -84, 118, 91, 89, -28, 112, 67, -117, -6, -35, 106, -53, 35, -3, 114, 61, 123, 126, 88, -58, -32, -114, -122, 103, -124, -77, 91, 124, -106, -90, -42, 66, 60, 79, 56, 109, -19, 77, -16, -75, -85, -103, -95, -61, 38, -122, 3, -34, 39, 120, -74, 29, -25, 114, 127, 85, 9, -11, -73, -14, -23, -50, 15, -48, -36, -2, 22, 74, -87, 54, -121, -48, -120, 10, 34, 70, -11, -8, 109, 70, -67, -40, 91, 49, -121, -113, 125, 90, 44, -98, 75, -18, -23, -74, 25, 79, -3, 102, 60, -39, 82, 99, 1, -81, 18, 58, -8, 46, 95, 122, -26, 37, 92, 26, 21, -50, -65, -76, -80, 23, -119, 94, -69, 6, -37, 4, -4, -31, 82, 49, -72, -85, -31, -83, -85, 123, 126, 85, 119, -15, -40, -89, 96, -64, 107, -62, 35, -113, -116, 127, 126, 74, 56, 55, 36, 84, -10, 125, 100, 119, -5, -80, -37, -102, -128, -34, -96, 36, 93, -35, -37, 82, -18, -71, -77, -125, -4, 77, -118, 57, 112, 98, -64, -2, 14, -82, 54, -25, 76, -55, 76, -97, -23, 31, -41, 61, -50, -85, 12, -26, 94, -94, -49, -35, 61, 46, 37, 51, -67, -14, -83, 123, -72, 41, 70, 103, 62, -77, 76, 3, -65, -122, -120, -84, -49, -54, -55, 76, -113, 116, -29, -30, -17, 13, 33, -70, 48, -62, 94, 25, -8, -74, -114, -9, 16, -39, 93, -114, 103, -122, 125, 75, 34, 58, 123, 24, 78, -9, -15, -48, -50, -78, -128, -65, -42, 121, 116, 109, -118, -67, 54, -16, 39, 123, -84, 12, -41, -90, -60, -56, 88, 39, -17, -91, 121, -26, -47, 89, 33, -31, -94, 127, -89, 93, 6, 92, 116, -80, 90, -54, 72, -27, -54, -60, 24, -47, 74, 100, -91, -72, 127, 73, 12, 17, -42, 52, -39, 82, 98, 15, -71, -63, -5, -12, 93, -51, 77, -20, -52, -51, -39, 53, -48, -100, 38, -27, 33, 4, 0, 0});
    private static final Image STAR_ROLLOVER_IMAGE = ContatoStarRating.compressedByteArrayToImage(new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0, 91, -13, -106, -127, -75, -100, -123, 65, -128, 65, -96, -76, -120, -127, 41, -38, -45, 119, 87, -126, 90, -39, -85, 77, 75, -103, 24, 24, 42, 10, 24, 24, 24, 25, 24, -2, -77, -77, -30, -62, 50, 64, 44, -128, 71, -98, 16, -114, 4, 98, 91, 50, -11, -54, 3, 113, 3, 16, -105, 2, 49, 55, -119, 122, 25, -127, 56, 25, -120, 115, -127, -72, 18, -120, -35, 72, -44, -81, 15, -75, 91, 14, -120, -83, -96, 108, 113, 28, 106, 57, -128, 88, 2, -86, -57, 3, -120, 19, -96, -22, -93, -96, -14, 108, 64, 92, 8, -60, -43, 80, 49, 71, 32, -42, 4, 98, 81, -88, -100, 1, 16, -41, 67, -11, -28, 67, -61, 12, -92, 70, 16, 45, 30, -36, -127, 56, 14, 26, 30, 32, -75, 101, 80, 113, -112, 95, 93, -95, 98, 102, 68, -8, -51, 31, -86, 86, 7, 77, -36, 27, -121, 56, 114, -104, 58, 66, -43, 24, -30, -112, 15, 2, -30, 90, 32, 22, -63, 34, -81, 5, -43, 107, -127, -57, 109, -102, -48, -80, 16, -59, 34, 103, 0, 53, 27, 95, 90, -80, 6, -30, 42, -92, 112, 55, -125, -6, -121, 17, 26, 127, 53, -48, 56, -59, -91, -33, 19, -120, 75, -128, -40, 14, -120, -117, -96, -18, 5, -31, -116, -1, -112, 116, 12, -46, -81, -115, 71, 127, 4, 84, 61, -56, -99, 126, 64, 44, 6, -60, 74, 64, 28, -125, 100, -106, 21, 14, -67, -52, 64, 28, 14, -115, 103, 33, 44, -14, -78, 64, 28, 10, -60, 78, 120, -12, 75, 64, -3, -118, -53, 125, 28, 80, 55, 33, -85, 1, 0, 54, 100, -49, 83, 33, 4, 0, 0});
    private static final Image STAR_SELECTION_IMAGE = ContatoStarRating.compressedByteArrayToImage(new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0, -99, -109, -37, 107, 19, 65, 20, -58, 39, -101, 57, -77, -77, -69, 105, 19, -59, 75, -68, -95, -11, 82, -123, 42, 22, 124, 40, -15, 86, -87, -120, 105, -119, -79, 54, 26, 35, 77, 78, 54, 105, -126, 34, 8, 34, 120, -7, -121, 124, -13, -55, 71, -1, 26, 41, 73, -38, -35, 53, 23, 19, -117, 86, -38, 93, -49, 14, 62, 88, -102, 84, -12, -31, 123, 57, -52, -17, -52, 55, -25, 59, -13, -95, -51, -32, 45, 103, 9, -106, 120, -3, -118, 105, -53, -13, -9, 62, -39, -109, 111, -36, -113, -17, 53, -58, -34, -67, 100, 44, -62, 88, -96, -61, 40, -103, -127, 0, 65, -38, -21, -52, 94, 58, 69, -20, -63, -1, -28, -115, 64, -125, -71, 31, -105, -27, -52, -49, 115, 82, 11, -94, -1, -56, 115, -104, -12, -29, 80, -20, -108, 99, -7, 94, -50, 74, -86, -38, -33, 124, -120, -33, -30, 48, 22, 48, 72, 111, 92, 53, -48, 123, 30, 67, -17, -103, 117, -29, -5, -108, -50, -87, -58, 2, -40, -43, 39, 74, -110, 84, -113, -109, -114, 4, 6, -100, -35, 30, -121, -44, -26, 121, -67, -40, -74, 45, -12, -22, 22, -70, 117, -77, -48, 46, 24, 87, 54, 79, -118, 9, -33, -126, -61, -127, -92, -2, 28, 116, -22, -93, 17, -69, -113, -72, -103, -83, -92, -56, 14, -46, 86, -66, -9, -56, 42, 117, 48, -122, 95, -22, 116, 111, -115, -8, -86, -119, 110, 69, -94, -77, 98, -32, -70, -83, 23, -99, -126, -2, -48, -53, -118, 76, -9, 58, 76, 111, 37, 84, 62, -95, -89, 99, 126, 12, 22, 7, 11, 38, 122, 47, 66, -42, 82, -84, 27, -78, 85, 3, 29, 91, 42, -83, -107, 5, -74, 108, -127, -115, 58, 79, -9, 82, 60, -31, -53, 63, -34, 66, 61, -56, -41, -3, 126, -38, 64, -9, -87, -87, 88, -89, 66, 44, -35, -67, 94, -42, -107, 90, 8, -40, -88, 64, -56, -58, -55, -1, -18, 121, 2, -100, -16, 13, 88, -22, 102, -120, -87, -123, 126, 101, -24, 25, -41, 80, 40, 53, 109, -98, -23, -52, -14, -3, -118, -123, -95, 25, 88, -108, -7, -62, -41, -101, -60, -44, -55, 47, -22, -54, 115, -77, -60, -79, 85, 2, 92, -83, -14, 91, -125, -117, -100, -87, 28, -122, -25, 119, -128, -34, -112, 107, 103, -56, -21, -118, -114, -51, 10, 40, 53, 108, -114, 13, -116, -30, -86, -83, -51, 119, 83, 92, -114, -36, 37, 65, 115, -76, 96, -39, 121, 76, 119, -42, 32, -17, 102, -7, -20, -73, 41, -72, -35, -97, -26, 79, 90, 75, 81, -4, 92, -43, 30, 56, 119, -75, -15, -111, -69, 36, -32, 12, 101, -97, 107, -33, -127, 107, 27, 23, -32, 56, -51, 2, -126, -120, -38, -29, -45, -37, 99, 48, -41, -65, -60, 23, -67, 89, -19, -112, 111, 14, -27, 35, -22, -65, 72, 56, 74, -30, -60, -20, 60, 3, 16, -6, -98, -96, -98, -55, 64, 14, -11, 31, 81, 127, 70, 31, 57, -37, 80, -102, -22, -77, -77, -10, 11, -18, 54, 30, -4, 33, 4, 0, 0});

    public ContatoStarRating() {
        this(5);
    }

    public ContatoStarRating(int stars) {
        this(stars, 0.0f);
    }

    public ContatoStarRating(int stars, float rating) {
        this(stars, rating, 0);
    }

    public ContatoStarRating(int stars, float rating, int selection) {
        this.stars = stars;
        this.rating = rating;
        this.selection = selection;
        this.rollover = 0;
        this.done = false;
        this.setOpaque(false);
        this.setLayout(null);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                if (ContatoStarRating.this.isEnabled() && !ContatoStarRating.this.done) {
                    ContatoStarRating.this.rollover = 1 + event.getX() / STAR_BACKGROUND_IMAGE.getWidth(null);
                    ContatoStarRating.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent event) {
                if (ContatoStarRating.this.isEnabled()) {
                    ContatoStarRating.this.rollover = 0;
                    ContatoStarRating.this.done = false;
                    ContatoStarRating.this.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent event) {
                if (ContatoStarRating.this.isEnabled()) {
                    ContatoStarRating.this.rollover = 0;
                    ContatoStarRating.this.done = true;
                    ContatoStarRating.this.selection = 1 + event.getX() / STAR_BACKGROUND_IMAGE.getWidth(null);
                    for (int i = 0; i < ContatoStarRating.this.listeners.size(); ++i) {
                        ContatoStarRating.this.listeners.get(i).handleSelection(ContatoStarRating.this, ContatoStarRating.this.selection);
                    }
                    ContatoStarRating.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (ContatoStarRating.this.isEnabled() && !ContatoStarRating.this.done) {
                    ContatoStarRating.this.rollover = 1 + event.getX() / STAR_BACKGROUND_IMAGE.getWidth(null);
                    ContatoStarRating.this.repaint();
                }
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.rollover = 0;
            this.repaint();
        }
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float rating) {
        this.rating = rating;
        this.repaint();
    }

    public int getSelection() {
        return this.selection;
    }

    public void setSelection(int selection) {
        this.selection = selection;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.stars * STAR_BACKGROUND_IMAGE.getWidth(null), STAR_BACKGROUND_IMAGE.getHeight(null));
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = STAR_BACKGROUND_IMAGE.getWidth(null);
        int h = STAR_BACKGROUND_IMAGE.getHeight(null);
        int x = 0;
        for (int i = 0; i < this.stars; ++i) {
            g.drawImage(STAR_BACKGROUND_IMAGE, x, 0, null);
            if (this.getRating() > (float)i) {
                int dw = this.getRating() >= (float)(i + 1) ? w : Math.round((this.getRating() - (float)i) * (float)w);
                g.drawImage(STAR_FOREGROUND_IMAGE, x, 0, x + dw, h, 0, 0, dw, h, null);
            }
            if (this.selection > i) {
                g.drawImage(STAR_SELECTION_IMAGE, x, 0, null);
            }
            if (this.rollover > i) {
                g.drawImage(STAR_ROLLOVER_IMAGE, x, 0, null);
            }
            x += w;
        }
    }

    public void addStarListener(StarListener listener) {
        this.listeners.add(listener);
    }

    public void removeStarListener(StarListener listener) {
        this.listeners.remove(listener);
    }

    public byte[] imageToCompressedByteArray(Image image) throws IOException {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        try {
            int[] imageSource = new int[width * height];
            PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, imageSource, 0, width);
            pg.grabPixels();
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            GZIPOutputStream zippedStream = new GZIPOutputStream(byteStream);
            ObjectOutputStream objectStream = new ObjectOutputStream(zippedStream);
            objectStream.writeShort(width);
            objectStream.writeShort(height);
            objectStream.writeObject(imageSource);
            objectStream.flush();
            objectStream.close();
            return byteStream.toByteArray();
        }
        catch (Exception e) {
            throw new IOException("Error storing image in object: " + String.valueOf(e));
        }
    }

    public static Image compressedByteArrayToImage(byte[] data) {
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
            GZIPInputStream zippedStream = new GZIPInputStream(byteStream);
            ObjectInputStream objectStream = new ObjectInputStream(zippedStream);
            short width = objectStream.readShort();
            short height = objectStream.readShort();
            int[] imageSource = (int[])objectStream.readObject();
            objectStream.close();
            MemoryImageSource mis = new MemoryImageSource(width, height, imageSource, 0, width);
            return Toolkit.getDefaultToolkit().createImage(mis);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static interface StarListener {
        public void handleSelection(ContatoStarRating var1, int var2);
    }
}

