/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.dialog.ContatoDialogsHelper;
import contato.interfaces.ContatoClearComponent;
import contato.interfaces.ContatoControllerComponent;
import contato.swing.ContatoBigIntegerTextField;
import contato.swing.ContatoButton;
import contato.swing.ContatoDialog;
import contato.swing.ContatoDoubleTextField;
import contato.swing.ContatoFloatTextField;
import contato.swing.ContatoIntegerTextField;
import contato.swing.ContatoLongTextField;
import contato.swing.ContatoPanel;
import contato.swing.ContatoScrollPane;
import contato.swing.ContatoShortTextField;
import contato.swing.ContatoTableDateTextField;
import contato.swing.ContatoTextArea;
import contato.swing.ContatoTextField;
import contato.swing.table.SearchPopup;
import contato.swing.table.column.ContatoBooleanColumnHeader;
import contato.swing.table.column.ContatoTableColumn;
import contato.swing.table.edit.ContatoTableCellEditor;
import contato.swing.table.footer.ContatoTableFooterPanel;
import contato.swing.table.model.ContatoTableModel;
import contato.swing.table.renderer.ContatoBigIntegerRenderer;
import contato.swing.table.renderer.ContatoBooleanTableCellRenderer;
import contato.swing.table.renderer.ContatoDateRenderer;
import contato.swing.table.renderer.ContatoDecimalRenderer;
import contato.swing.table.renderer.ContatoFloatRenderer;
import contato.swing.table.renderer.ContatoIntegerRenderer;
import contato.swing.table.renderer.ContatoShortRenderer;
import contato.swing.table.renderer.ContatoTableCellRenderer;
import contato.swing.table.sorter.ContatoTableRowSorter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.FocusManager;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class ContatoTable
extends JTable
implements ContatoControllerComponent,
ContatoClearComponent,
ActionListener,
AncestorListener,
MouseListener {
    private AddObjectsToTableKeyEvent addObjectsToTable;
    private KeyListener keyPressed;
    private boolean processFocusFirstCell = true;
    private int lastFocusableRow = -1;
    private boolean getOutTableLastCell = true;
    private List<ContatoButton> deleteButtons = new ArrayList<ContatoButton>();
    private boolean flagTotalCreated = false;
    private boolean enabledFlag = true;
    private ContatoDialog dialogSetText;
    private boolean exibirTotalizadores = true;
    private ContatoTableFooterPanel footer;

    public ContatoTable(boolean autoCreateRowSorter, AddObjectsToTableKeyEvent addObjectsToTable) {
        ContatoIntegerRenderer integerRenderer = new ContatoIntegerRenderer();
        ContatoBigIntegerRenderer bigIntegerRenderer = new ContatoBigIntegerRenderer();
        ContatoShortRenderer shortRenderer = new ContatoShortRenderer();
        ContatoDecimalRenderer decimalRenderer = new ContatoDecimalRenderer();
        ContatoFloatRenderer floatRenderer = new ContatoFloatRenderer();
        ContatoDateRenderer dateRenderer = new ContatoDateRenderer();
        ContatoTableCellRenderer defaultRenderer = new ContatoTableCellRenderer();
        ContatoBooleanTableCellRenderer booleanRenderer = new ContatoBooleanTableCellRenderer();
        ContatoIntegerTextField integerTextField = new ContatoIntegerTextField();
        integerTextField.setHorizontalAlignment(4);
        ContatoDoubleTextField numericTextField = new ContatoDoubleTextField();
        numericTextField.setHorizontalAlignment(4);
        ContatoTableDateTextField dateTextField = new ContatoTableDateTextField();
        ContatoTextField textField = new ContatoTextField();
        ContatoBigIntegerTextField bigTextField = new ContatoBigIntegerTextField();
        dateTextField.setHorizontalAlignment(0);
        ContatoShortTextField sh = new ContatoShortTextField();
        ContatoFloatTextField cf = new ContatoFloatTextField();
        ContatoTableCellEditor integerEditor = new ContatoTableCellEditor(integerTextField);
        ContatoTableCellEditor longEditor = new ContatoTableCellEditor(new ContatoLongTextField());
        ContatoTableCellEditor floatEditor = new ContatoTableCellEditor(cf);
        ContatoTableCellEditor decimalEditor = new ContatoTableCellEditor(numericTextField);
        ContatoTableCellEditor dateEditor = new ContatoTableCellEditor(dateTextField);
        ContatoTableCellEditor shortEditor = new ContatoTableCellEditor(sh);
        ContatoTableCellEditor defaultEditor = new ContatoTableCellEditor(textField);
        ContatoTableCellEditor bigTextFieldEditor = new ContatoTableCellEditor(bigTextField);
        this.setDefaultRenderer(Date.class, dateRenderer);
        this.setDefaultRenderer(Long.class, integerRenderer);
        this.setDefaultRenderer(Integer.class, integerRenderer);
        this.setDefaultRenderer(Double.class, decimalRenderer);
        this.setDefaultRenderer(Float.class, floatRenderer);
        this.setDefaultRenderer(String.class, defaultRenderer);
        this.setDefaultRenderer(Short.class, shortRenderer);
        this.setDefaultRenderer(Object.class, defaultRenderer);
        this.setDefaultRenderer(BigInteger.class, bigIntegerRenderer);
        this.setDefaultRenderer(Boolean.class, booleanRenderer);
        this.setDefaultEditor(Date.class, dateEditor);
        this.setDefaultEditor(Long.class, longEditor);
        this.setDefaultEditor(Integer.class, integerEditor);
        this.setDefaultEditor(Double.class, decimalEditor);
        this.setDefaultEditor(Float.class, floatEditor);
        this.setDefaultEditor(String.class, defaultEditor);
        this.setDefaultEditor(Short.class, shortEditor);
        this.setDefaultEditor(BigInteger.class, bigTextFieldEditor);
        this.setDefaultEditor(Object.class, defaultEditor);
        this.setAutoResizeMode(4);
        this.addObjectsToTable = addObjectsToTable;
        this.setReadOnly();
        this.initProperties();
    }

    @Override
    protected void configureEnclosingScrollPane() {
        JViewport port;
        Container gp;
        Container parent = SwingUtilities.getUnwrappedParent(this);
        if (parent instanceof JViewport && (gp = (port = (JViewport)parent).getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || SwingUtilities.getUnwrappedView(viewport) != this) {
                return;
            }
            scrollPane.setColumnHeaderView(this.getTableHeader());
            this.configureEnclosingScrollPaneUI();
        }
    }

    private void configureEnclosingScrollPaneUI() {
        JViewport port;
        Container gp;
        Container parent = SwingUtilities.getUnwrappedParent(this);
        if (parent instanceof JViewport && (gp = (port = (JViewport)parent).getParent()) instanceof JScrollPane) {
            Component corner;
            Border scrollPaneBorder;
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || SwingUtilities.getUnwrappedView(viewport) != this) {
                return;
            }
            Border border = scrollPane.getBorder();
            if ((border == null || border instanceof UIResource) && (scrollPaneBorder = UIManager.getBorder("Table.scrollPaneBorder")) != null) {
                scrollPane.setBorder(scrollPaneBorder);
            }
            if ((corner = scrollPane.getCorner("UPPER_TRAILING_CORNER")) == null || corner instanceof UIResource) {
                corner = null;
                try {
                    corner = (Component)UIManager.get("Table.scrollPaneCornerComponent");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                scrollPane.setCorner("UPPER_TRAILING_CORNER", corner);
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        boolean b;
        super.processFocusEvent(e);
        boolean bl = b = e.getID() == 1004;
        if (b && this.isEnabled()) {
            if (this.getSelectedRow() == -1 && this.getRowCount() > 0 && this.processFocusFirstCell) {
                this.setSelectRows(0, 0);
                this.changeSelection(0, 0, false, true);
                this.lastFocusableRow = 0;
            }
        } else {
            this.lastFocusableRow = -1;
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    public void moveDownSelectedRow() {
        ContatoTableModel m;
        int row = this.getSelectedRow();
        if (row < (m = (ContatoTableModel)this.getModel()).getRowCount() - 1) {
            List list = m.getObjects();
            Object o = list.remove(row);
            list.add(row + 1, o);
            this.clearSelection();
            this.setSelectRows(row + 1, row + 1);
        }
    }

    public void moveUpSelectedRow() {
        int row = this.getSelectedRow();
        ContatoTableModel m = (ContatoTableModel)this.getModel();
        if (row > 0) {
            List list = m.getObjects();
            Object o = list.remove(row);
            list.add(row - 1, o);
            this.clearSelection();
            this.setSelectRows(row - 1, row - 1);
        }
    }

    public void setAutoKeyEventListener(boolean allow) {
        if (allow) {
            this.keyPressed = new KeyPressed();
            this.addKeyListener(this.keyPressed);
        } else {
            this.removeKeyListener(this.keyPressed);
        }
    }

    public ContatoTable(AddObjectsToTableKeyEvent addObjectsToTableKeyEvent) {
        this(false, addObjectsToTableKeyEvent);
        this.initProperties();
    }

    public ContatoTable() {
        this(true, null);
        this.putRowFilterAction();
        this.initProperties();
    }

    private void initProperties() {
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setRowHeight(30);
        this.addAncestorListener(this);
        this.addMouseListener(this);
    }

    public Object getSelectedObject() {
        if (this.getSelectedRow() > -1) {
            try {
                int row = this.convertRowIndexToModel(this.getSelectedRow());
                if (row > -1) {
                    ContatoTableModel m = (ContatoTableModel)this.getModel();
                    return m.getObject(row);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component comp = super.prepareEditor(editor, row, column);
        if (comp instanceof JTextComponent) {
            ((JTextComponent)comp).selectAll();
        }
        return comp;
    }

    public List getSelectedObjects() {
        ArrayList<Object> aux = new ArrayList<Object>();
        int[] rows = this.getSelectedRows();
        if (rows.length > 0) {
            ContatoTableModel m = (ContatoTableModel)this.getModel();
            for (int i = 0; i < rows.length; ++i) {
                Integer j = this.convertRowIndexToModel(rows[i]);
                aux.add(m.getObject(j));
            }
        }
        return aux;
    }

    public void setSelectRows(int begin, int end) {
        ListSelectionModel listSelection = this.getSelectionModel();
        if (listSelection == null) {
            listSelection = new DefaultListSelectionModel();
        }
        listSelection.addSelectionInterval(begin, end);
        this.setSelectionModel(listSelection);
        this.scrollRectToVisible(this.getCellRect(this.getSelectedRow(), 0, true));
    }

    public void addColumn(String fieldName, String title, int charQuantity, int index, boolean isEditable) {
        int contentSize;
        JLabel l = new JLabel();
        FontMetrics fm = l.getFontMetrics(l.getFont());
        int titleSize = title.length() * fm.stringWidth("0") / 3 * 2;
        if (titleSize > (contentSize = charQuantity * fm.stringWidth("0") / 3 * 2)) {
            contentSize = titleSize;
        }
        ContatoTableColumn column = new ContatoTableColumn(fieldName, index, isEditable);
        column.setPreferredWidth(contentSize);
        this.addColumn(column);
    }

    public void deleteSelectedRowsFromStandardTableModel() {
        this.deleteSelectedRowsFromStandardTableModel(false);
    }

    public void deleteSelectedRowsFromStandardTableModel(boolean showMessage) {
        int[] rows = this.getSelectedRows();
        if (this.getModel() instanceof ContatoTableModel) {
            ContatoTableModel model = (ContatoTableModel)this.getModel();
            if (rows.length > 0) {
                if (showMessage && 0 != ContatoDialogsHelper.showQuestion("Remover itens?")) {
                    return;
                }
                for (int i = rows.length - 1; i >= 0; --i) {
                    if (rows[i] >= model.getRowCount()) continue;
                    model.delete(this.convertRowIndexToModel(rows[i]));
                }
                model.refresh();
                this.repaint();
            }
        }
        if (this.getRowCount() > 0) {
            this.setSelectRows(this.getRowCount() - 1, this.getRowCount() - 1);
        }
    }

    public void addRowsToStandardTableModel(List newObjects) {
        if (this.getModel() instanceof ContatoTableModel) {
            this.processInitializeObjects(newObjects);
            ContatoTableModel model = (ContatoTableModel)this.getModel();
            model.addRows(newObjects);
            model.refresh();
            this.repaint();
        }
    }

    public AddObjectsToTableKeyEvent getAddObjectsToTable() {
        return this.addObjectsToTable;
    }

    public void setAddObjectsToTable(AddObjectsToTableKeyEvent addObjectsToTable) {
        this.addObjectsToTable = addObjectsToTable;
    }

    @Override
    public void setDontController() {
        this.putClientProperty("ACCESS", -10);
        this.putClientProperty(-11, -10);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabledFlag = enabled;
        if (this.getModel() instanceof ContatoTableModel && !enabled) {
            ((ContatoTableModel)this.getModel()).setReadOnly(true);
        } else if (this.getModel() instanceof ContatoTableModel && enabled) {
            ((ContatoTableModel)this.getModel()).setReadOnly(false);
        } else {
            super.setEnabled(enabled);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (!this.enabledFlag && this.getModel() instanceof ContatoTableModel) {
            return !((ContatoTableModel)this.getModel()).isReadOnly();
        }
        return this.getModel().isCellEditable(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column));
    }

    public boolean isProcessFocusFirstCell() {
        return this.processFocusFirstCell;
    }

    public void setProcessFocusFirstCell(boolean processFocusFirstCell) {
        this.processFocusFirstCell = processFocusFirstCell;
    }

    private void putRowFilterAction() {
        AbstractAction a = new AbstractAction("filter"){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SearchPopup(ContatoTable.this).showPopup();
            }
        };
        a.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 128));
        this.getInputMap().put(KeyStroke.getKeyStroke(70, 128), "filter");
        this.getActionMap().put("filter", a);
    }

    public boolean isGetOutTableLastCell() {
        return this.getOutTableLastCell;
    }

    public void setGetOutTableLastCell(boolean getOutTableLastCell) {
        this.getOutTableLastCell = getOutTableLastCell;
    }

    private void processInternalFocus(int row, int col, boolean toggle, boolean expand) {
        if (this.lastFocusableRow == this.getRowCount() - 1 && row == 0 && this.isGetOutTableLastCell()) {
            FocusManager.getCurrentManager().focusNextComponent();
        }
        if (!this.getModel().isCellEditable(row, col)) {
            int curRow = this.getEditingRow();
            int curCol = this.getEditingColumn();
            if (curRow == -1) {
                curRow = this.getSelectedRow();
            }
            if (curCol == -1) {
                curCol = this.getSelectedColumn();
            }
            int nRows = this.getRowCount();
            int nCols = this.getColumnCount();
            int nextRow = row;
            int nextCol = col;
            if (col == curCol) {
                int direction = row - curRow;
                if (direction > 1) {
                    direction = 1;
                }
                if (direction < -1) {
                    direction = -1;
                }
                nextRow = this.findNextEditableRow(row, col, direction, nRows, nCols);
            } else if (row == curRow) {
                int direction = col - curCol;
                if (direction > 1) {
                    direction = 1;
                }
                if (direction < -1) {
                    direction = -1;
                }
                int[] nextCell = this.findNextEditableCell(row, col, direction, nRows, nCols);
                nextRow = nextCell[0];
                nextCol = nextCell[1];
            } else {
                int direction = row - curRow;
                if (direction > 1) {
                    direction = 1;
                }
                if (direction < -1) {
                    direction = -1;
                }
                if (row == 0 && curRow == nRows - 1) {
                    direction = 1;
                }
                int[] nextCell = this.findNextEditableCell(row, col, direction, nRows, nCols);
                nextRow = nextCell[0];
                nextCol = nextCell[1];
            }
            super.changeSelection(nextRow, nextCol, toggle, expand);
        } else {
            super.changeSelection(row, col, toggle, expand);
        }
        this.lastFocusableRow = row;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.deleteButtons.contains(ae.getSource())) {
            this.deleteSelectedRowsFromStandardTableModel(true);
        }
    }

    public void addRemoveButton(ContatoButton deleteButton) {
        if (deleteButton != null) {
            deleteButton.addActionListener(this);
            this.deleteButtons.add(deleteButton);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            this.showDialogSetText(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void showDialogSetText(MouseEvent e) {
        int column;
        int row = this.rowAtPoint(e.getPoint());
        if (!this.isCellEditable(row, column = this.columnAtPoint(e.getPoint()))) {
            return;
        }
        Class<?> cl = this.getColumnClass(column);
        if (cl.equals(String.class)) {
            String value = (String)this.getValueAt(row, column);
            this.showDialog(value, row, column);
        }
    }

    private void showDialog(String value, int row, int column) {
        if (ContatoTableTextDialog.get().isVisible()) {
            return;
        }
        ContatoTableTextDialog.get().updateData(value, row, column, this);
    }

    public void clearTable() {
        if (this.getModel() instanceof ContatoTableModel) {
            ((ContatoTableModel)this.getModel()).clear();
        }
    }

    public void addRows(List objects, boolean append) {
        this.processInitializeObjects(objects);
        if (this.getModel() instanceof ContatoTableModel) {
            ((ContatoTableModel)this.getModel()).addRows(objects, append);
        }
    }

    private void processInitializeObjects(List objects) {
        if (objects != null) {
            for (Object object : objects) {
                try {
                    Method method = object.getClass().getDeclaredMethod("getIdentificador", null);
                    if (method == null) continue;
                    method.invoke(object, (Object[])null);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void addRow(Object object) {
        if (this.getModel() instanceof ContatoTableModel) {
            ((ContatoTableModel)this.getModel()).addRow(object);
        }
    }

    public void removeRow(Object object) {
        if (this.getModel() instanceof ContatoTableModel) {
            ((ContatoTableModel)this.getModel()).delete(object);
        }
    }

    public void removeRow(int row) {
        if (this.getModel() instanceof ContatoTableModel) {
            ((ContatoTableModel)this.getModel()).delete(row);
        }
    }

    public Object getValorTotalFromColumn(int column) {
        ContatoTableModel model = (ContatoTableModel)this.getModel();
        Class<?> classe = model.getColumnClass(column);
        if (classe == Float.class) {
            float valorTotal = 0.0f;
            for (int i = 0; i < this.getRowCount(); ++i) {
                valorTotal += ((Float)this.getValueAt(i, column)).floatValue();
            }
            return Float.valueOf(valorTotal);
        }
        if (classe == Double.class) {
            double valorTotal = 0.0;
            for (int i = 0; i < this.getRowCount(); ++i) {
                valorTotal += ((Double)this.getValueAt(i, column)).doubleValue();
            }
            return valorTotal;
        }
        if (classe == Integer.class) {
            Integer valorTotal = 0;
            for (int i = 0; i < this.getRowCount(); ++i) {
                valorTotal = valorTotal + (Integer)this.getValueAt(i, column);
            }
            return valorTotal;
        }
        if (classe == Long.class) {
            Long valorTotal = 0L;
            for (int i = 0; i < this.getRowCount(); ++i) {
                valorTotal = valorTotal + (Long)this.getValueAt(i, column);
            }
            return valorTotal;
        }
        return 0.0;
    }

    public List getObjects() {
        if (this.getModel() instanceof ContatoTableModel) {
            return ((ContatoTableModel)this.getModel()).getObjects();
        }
        return new ArrayList();
    }

    public Object getObject(int index) {
        if (this.getModel() instanceof ContatoTableModel) {
            return ((ContatoTableModel)this.getModel()).getObject(index);
        }
        return null;
    }

    @Override
    public void setReadOnly() {
        this.putClientProperty("ACCESS", 0);
    }

    @Override
    public void setReadWrite() {
        this.putClientProperty("ACCESS", 1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        this.putClientProperty("ACCESS", 2);
    }

    @Override
    public void clear() {
        this.clearTable();
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        super.setRowSorter(new ContatoTableRowSorter(dataModel));
    }

    @Override
    public void changeSelection(int row, int col, boolean toggle, boolean expand) {
        if (!this.isGetOutTableLastCell()) {
            super.changeSelection(row, col, toggle, expand);
        } else {
            this.processInternalFocus(row, col, toggle, expand);
        }
    }

    int[] findNextEditableCell(int row, int col, int direction, int nRows, int nCols) {
        int origRow = row;
        int origCol = col;
        do {
            if ((col += direction) >= nCols) {
                col = 0;
                row += direction;
            }
            if (col < 0) {
                col = nCols - 1;
                row += direction;
            }
            if (row >= nRows) {
                row = 0;
            }
            if (row < 0) {
                row = nRows - 1;
            }
            if (!this.isCellEditable(row, col)) continue;
            return new int[]{row, col};
        } while (row != origRow || col != origCol);
        return new int[]{origRow, origCol};
    }

    int findNextEditableRow(int row, int col, int direction, int nRows, int nCols) {
        int origRow = row;
        do {
            if ((row += direction) < 0) {
                row = nRows - 1;
            }
            if (row >= nRows) {
                row = 0;
            }
            if (!this.isCellEditable(row, col)) continue;
            return row;
        } while (row != origRow);
        return origRow;
    }

    @Override
    public void setColumnModel(TableColumnModel columnModel) {
        try {
            for (int i = 0; i < ((DefaultTableColumnModel)columnModel).getColumnCount(); ++i) {
                if (this.getColumnClass(i) == null || !this.getColumnClass(i).equals(Boolean.class)) continue;
                columnModel.getColumn(i).setHeaderRenderer(new ContatoBooleanColumnHeader(this, i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setColumnModel(columnModel);
    }

    private void buildView(JScrollPane scrollPanel) {
        if (this.isExibirTotalizadores()) {
            JViewport viewPort = scrollPanel.getViewport();
            ContatoTable table = (ContatoTable)viewPort.getView();
            this.footer = new ContatoTableFooterPanel(scrollPanel);
            this.getSelectionModel().addListSelectionListener(this.footer);
            ContatoPanel host = ContatoTable.buildPanel();
            Dimension dimension = scrollPanel.getPreferredSize();
            host.add((Component)ContatoTable.buildTable(table, dimension), ContatoTable.buildGridBagLayout(0, 0, 1, 1, 1, 23));
            host.add((Component)this.footer, ContatoTable.buildGridBagLayout(0, 1, 0, 0, 2, 20));
            scrollPanel.setPreferredSize(dimension);
            scrollPanel.getViewport().setView(host);
        }
    }

    private static ContatoScrollPane buildTable(ContatoTable table, Dimension dimension) {
        ContatoScrollPane statusBar = ContatoTable.buildScrollPanel(table, dimension);
        return statusBar;
    }

    private static ContatoScrollPane buildScrollPanel(ContatoTable table, Dimension dimension) {
        ContatoScrollPane scroll = new ContatoScrollPane();
        table.setFillsViewportHeight(true);
        scroll.setPreferredSize(new Dimension(0, 0));
        scroll.setViewportView(table);
        return scroll;
    }

    private static GridBagConstraints buildGridBagLayout(Integer gridX, Integer gridY, Integer weightX, Integer weightY, Integer fill, Integer anchor) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridX;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.weightx = weightX.intValue();
        gridBagConstraints.weighty = weightY.intValue();
        gridBagConstraints.anchor = anchor;
        gridBagConstraints.fill = fill;
        return gridBagConstraints;
    }

    private static ContatoPanel buildPanel() {
        ContatoPanel host = new ContatoPanel();
        host.setLayout(new GridBagLayout());
        return host;
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        if (!this.flagTotalCreated) {
            this.flagTotalCreated = true;
            JViewport j = (JViewport)this.getParent();
            this.buildView((JScrollPane)j.getParent());
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public boolean isExibirTotalizadores() {
        return this.exibirTotalizadores;
    }

    public void setExibirTotalizadores(boolean exibirTotalizadores) {
        this.exibirTotalizadores = exibirTotalizadores;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
        this.footer.recalcularValores();
    }

    public static interface AddObjectsToTableKeyEvent {
        public void addObjects();
    }

    class KeyPressed
    extends KeyAdapter {
        KeyPressed() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (ContatoTable.this.isEnabled()) {
                if (e.getKeyCode() == 68) {
                    ContatoTable.this.deleteSelectedRowsFromStandardTableModel(true);
                } else if (e.getKeyCode() == 65) {
                    if (ContatoTable.this.getAddObjectsToTable() != null) {
                        ContatoTable.this.getAddObjectsToTable().addObjects();
                        if (ContatoTable.this.getRowCount() > 0) {
                            ContatoTable.this.setSelectRows(ContatoTable.this.getRowCount() - 1, ContatoTable.this.getRowCount());
                        }
                    }
                } else {
                    super.keyPressed(e);
                }
            }
        }
    }

    static class ContatoTableTextDialog
    extends ContatoDialog {
        private int row;
        private int column;
        final ContatoTextArea txt = new ContatoTextArea();
        private JTable table;
        private static ContatoTableTextDialog INSTANCE;

        private ContatoTableTextDialog() {
            this.setContentPane(this.txt);
            this.setSize(600, 400);
            this.setLocationRelativeTo(null);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    try {
                        table.setValueAt(txt.getText(), row, column);
                        table.repaint();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }

        public static ContatoTableTextDialog get() {
            if (INSTANCE == null) {
                INSTANCE = new ContatoTableTextDialog();
            }
            return INSTANCE;
        }

        void updateData(String text, int row, int column, JTable table) {
            this.txt.setText(text);
            this.row = row;
            this.column = column;
            this.table = table;
            this.setVisible(true);
        }
    }
}

