/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.constants.ContatoConstants;
import contato.interfaces.ContatoClearComponent;
import contato.interfaces.ContatoControllerComponent;
import contato.swing.dictionary.JTextCompSpellChecker;
import contato.util.ContatoTextUtilities;
import java.awt.event.FocusEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.dts.spell.swing.utils.ErrorPopUpMenu;

public class ContatoTextPane
extends JTextPane
implements ContatoClearComponent,
ContatoControllerComponent {
    private boolean spellCheckStarted = false;

    public ContatoTextPane(StyledDocument doc) {
        super(doc);
    }

    public ContatoTextPane() {
        ContatoTextUtilities.initBasicPopupTextMenu(this);
        super.setDocument(new DefaultStyledDocument());
    }

    @Override
    public void setDocument(Document doc) {
        super.setDocument(doc);
    }

    @Override
    public void setReadWrite() {
        this.putClientProperty("ACCESS", 1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        this.putClientProperty("ACCESS", 2);
    }

    @Override
    public void clear() {
        this.setText(ContatoConstants.EMPTY);
    }

    @Override
    public void setReadOnly() {
        this.putClientProperty("ACCESS", 0);
    }

    @Override
    public void setDontController() {
        this.putClientProperty("ACCESS", -10);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            JTextCompSpellChecker.getInstance().startSpellCheck(this);
            ErrorPopUpMenu.cleanErrorPopupMenu((JPopupMenu)this.getComponentPopupMenu());
        } else if (e.getID() == 1005) {
            JTextCompSpellChecker.getInstance().stopSpellCheck(this);
        }
        super.processFocusEvent(e);
    }

    public boolean isSpellCheckStarted() {
        return this.spellCheckStarted;
    }

    public void setSpellCheckStarted(boolean spellCheckStarted) {
        this.spellCheckStarted = spellCheckStarted;
    }
}

