/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import com.touchcomp.basementormedia.ImageProviderFact;
import contato.controller.ContatoBasePanelInterface;
import contato.swing.ContatoButton;
import contato.swing.ContatoToolbar;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;

public class ContatoToolbarNavigator
extends ContatoToolbar {
    private ContatoButton btnFirst;
    private ContatoButton btnLast;
    private ContatoButton btnPrior;
    private ContatoButton btnNext;
    private ContatoBasePanelInterface basePanel;

    public ContatoToolbarNavigator() {
        this.initButtons();
    }

    private void initButtons() {
        this.putClientProperty("ACCESS", 1);
        this.add(this.getBtnFirst());
        this.add(this.getBtnPrior());
        this.add(this.getBtnNext());
        this.add(this.getBtnLast());
    }

    public ContatoButton getBtnFirst() {
        if (this.btnFirst == null) {
            this.btnFirst = new ContatoButton();
            this.btnFirst.setPreferredSize(this.getPrefSize());
            this.btnFirst.setMinimumSize(this.getPrefSize());
            this.btnFirst.setIcon(new ImageIcon(ImageProviderFact.get().getImageFirstL()));
            this.btnFirst.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContatoToolbarNavigator.this.getBasePanel().prior();
                    ContatoToolbarNavigator.this.manageItemNavigationButtons();
                }
            });
        }
        return this.btnFirst;
    }

    public ContatoButton getBtnLast() {
        if (this.btnLast == null) {
            this.btnLast = new ContatoButton();
            this.btnLast.setPreferredSize(this.getPrefSize());
            this.btnLast.setMinimumSize(this.getPrefSize());
            this.btnLast.setIcon(new ImageIcon(ImageProviderFact.get().getImageLastL()));
            this.btnLast.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContatoToolbarNavigator.this.getBasePanel().last();
                    ContatoToolbarNavigator.this.manageItemNavigationButtons();
                }
            });
        }
        return this.btnLast;
    }

    public ContatoButton getBtnPrior() {
        if (this.btnPrior == null) {
            this.btnPrior = new ContatoButton();
            this.btnPrior.setPreferredSize(this.getPrefSize());
            this.btnPrior.setMinimumSize(this.getPrefSize());
            this.btnPrior.setIcon(new ImageIcon(ImageProviderFact.get().getImagePriorL()));
            this.btnPrior.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContatoToolbarNavigator.this.getBasePanel().prior();
                    ContatoToolbarNavigator.this.manageItemNavigationButtons();
                }
            });
        }
        return this.btnPrior;
    }

    public ContatoButton getBtnNext() {
        if (this.btnNext == null) {
            this.btnNext = new ContatoButton();
            this.btnNext.setIcon(new ImageIcon(ImageProviderFact.get().getImageNextL()));
            this.btnNext.setDontController();
            this.btnNext.setPreferredSize(this.getPrefSize());
            this.btnNext.setMinimumSize(this.getPrefSize());
            this.btnNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContatoToolbarNavigator.this.getBasePanel().next();
                    ContatoToolbarNavigator.this.manageItemNavigationButtons();
                }
            });
        }
        return this.btnNext;
    }

    private Dimension getPrefSize() {
        return new Dimension(48, 40);
    }

    public void manageItemNavigationButtons() {
        this.manageItemNavigationButtons(0);
    }

    public void manageItemNavigationButtons(int state) {
        if (!(this.getBasePanel() == null || state != 0 || this.basePanel.isFirst() && this.basePanel.isLast())) {
            if (this.getBasePanel().isFirst()) {
                this.getBtnFirst().setEnabled(false);
                this.getBtnPrior().setEnabled(false);
                this.getBtnNext().setEnabled(true);
                this.getBtnLast().setEnabled(true);
            } else if (this.getBasePanel().isLast()) {
                this.getBtnFirst().setEnabled(true);
                this.getBtnPrior().setEnabled(true);
                this.getBtnNext().setEnabled(false);
                this.getBtnLast().setEnabled(false);
            } else if (this.getBasePanel().isListEmpty()) {
                this.getBtnFirst().setEnabled(false);
                this.getBtnPrior().setEnabled(false);
                this.getBtnNext().setEnabled(false);
                this.getBtnLast().setEnabled(false);
            } else {
                this.getBtnFirst().setEnabled(true);
                this.getBtnFirst().setEnabled(true);
                this.getBtnPrior().setEnabled(true);
                this.getBtnNext().setEnabled(true);
                this.getBtnLast().setEnabled(true);
            }
        } else {
            this.getBtnFirst().setEnabled(false);
            this.getBtnPrior().setEnabled(false);
            this.getBtnNext().setEnabled(false);
            this.getBtnLast().setEnabled(false);
        }
    }

    public ContatoBasePanelInterface getBasePanel() {
        return this.basePanel;
    }

    public void setBasePanel(ContatoBasePanelInterface basePanel) {
        this.basePanel = basePanel;
    }
}

