/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.swing.CloseTabIcon;
import contato.swing.listeners.TabRemoveException;
import contato.swing.listeners.TabRemovedListener;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class JTabbedPaneWithCloseIcons
extends JTabbedPane
implements MouseListener {
    private TabRemovedListener tabListener;

    public JTabbedPaneWithCloseIcons() {
        this.addMouseListener(this);
    }

    @Override
    public void addTab(String title, Component component) {
        this.addTab(title, component, null);
    }

    public void addTab(String title, Component component, Icon extraIcon) {
        super.addTab(title, new CloseTabIcon(extraIcon), component);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int tabNumber = this.getUI().tabForCoordinate(this, e.getX(), e.getY());
        if (tabNumber < 0) {
            return;
        }
        Component c = this.getTabComponentAt(tabNumber);
        Rectangle rect = ((CloseTabIcon)this.getIconAt(tabNumber)).getBounds();
        if (rect.contains(e.getX(), e.getY())) {
            try {
                this.tabListener.beforeRemove(tabNumber);
                if (this.tabListener != null) {
                    this.tabListener.removeTab(tabNumber);
                }
                this.removeTabAt(tabNumber);
                if (this.tabListener != null) {
                    this.tabListener.afterRemove(tabNumber);
                }
            }
            catch (TabRemoveException ex) {
                Logger.getLogger(JTabbedPaneWithCloseIcons.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public TabRemovedListener getTabListener() {
        return this.tabListener;
    }

    public void setTabListener(TabRemovedListener tabListener) {
        this.tabListener = tabListener;
    }
}

